/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.util.Arrays;
import java.util.List;
import org.sonar.api.config.Configuration;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.scanner.ScannerSide;
import org.sonar.plugins.dotnet.tests.UnitTestConfiguration;
import org.sonar.plugins.dotnet.tests.UnitTestResultsAggregator;
import org.sonar.plugins.dotnet.tests.UnitTestResultsImportSensor;
import org.sonarsource.dotnet.shared.plugins.PluginMetadata;

@ScannerSide
public class UnitTestResultsProvider {
    private static final String SUBCATEGORY = "Unit Tests";
    private final PluginMetadata pluginMetadata;
    private final UnitTestConfiguration unitTestConfiguration;

    public UnitTestResultsProvider(PluginMetadata pluginMetadata) {
        this.pluginMetadata = pluginMetadata;
        this.unitTestConfiguration = new UnitTestConfiguration(this.propertyKey("vstest"), this.propertyKey("nunit"), this.propertyKey("xunit"));
    }

    private String propertyKey(String testType) {
        return "sonar." + this.pluginMetadata.languageKey() + "." + testType + ".reportsPaths";
    }

    public List<Object> extensions() {
        String category = this.pluginMetadata.languageName();
        return Arrays.asList(this, DotNetUnitTestResultsAggregator.class, UnitTestResultsImportSensor.class, PropertyDefinition.builder((String)this.unitTestConfiguration.visualStudioTestResultsFilePropertyKey()).name("Visual Studio Test Reports Paths").description("Example: \"report.trx\", \"report1.trx,report2.trx\" or \"C:/report.trx\"").category(category).subCategory(SUBCATEGORY).onlyOnConfigScopes(List.of(PropertyDefinition.ConfigScope.PROJECT)).multiValues(true).build(), PropertyDefinition.builder((String)this.unitTestConfiguration.nunitTestResultsFilePropertyKey()).name("NUnit Test Reports Paths").description("Example: \"TestResult.xml\", \"TestResult1.xml,TestResult2.xml\" or \"C:/TestResult.xml\"").category(category).subCategory(SUBCATEGORY).onlyOnConfigScopes(List.of(PropertyDefinition.ConfigScope.PROJECT)).multiValues(true).build(), PropertyDefinition.builder((String)this.unitTestConfiguration.xunitTestResultsFilePropertyKey()).name("xUnit Test Reports Paths").description("Example: \"TestResult.xml\", \"TestResult1.xml,TestResult2.xml\" or \"C:/TestResult.xml\"").category(category).subCategory(SUBCATEGORY).onlyOnConfigScopes(List.of(PropertyDefinition.ConfigScope.PROJECT)).multiValues(true).build());
    }

    public class DotNetUnitTestResultsAggregator
    extends UnitTestResultsAggregator {
        public DotNetUnitTestResultsAggregator(Configuration configuration) {
            super(UnitTestResultsProvider.this.unitTestConfiguration, configuration);
        }
    }
}

