/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.sonar.api.server.ServerSide;
import org.sonarsource.api.sonarlint.SonarLintSide;
import org.sonarsource.dotnet.shared.plugins.PluginMetadata;

@ServerSide
@SonarLintSide
public class RoslynRules {
    private static final Gson GSON = new Gson();
    private final PluginMetadata metadata;
    private List<Rule> rules;

    public RoslynRules(PluginMetadata metadata) {
        this.metadata = metadata;
    }

    public List<Rule> rules() {
        if (this.rules == null) {
            Type ruleListType = new TypeToken<List<Rule>>(){}.getType();
            this.rules = (List)GSON.fromJson(this.readResource("Rules.json"), ruleListType);
        }
        return this.rules;
    }

    private String readResource(String name) {
        InputStream stream = this.getResourceAsStream(this.metadata.resourcesDirectory() + "/" + name);
        if (stream == null) {
            throw new IllegalStateException("Resource does not exist: " + name);
        }
        try {
            return new String(stream.readAllBytes(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to read: " + name, e);
        }
    }

    InputStream getResourceAsStream(String name) {
        return this.getClass().getResourceAsStream(name);
    }

    public static final class RuleParameter {
        String key;
        String description;
        String type;
        String defaultValue;
    }

    public static final class Rule {
        String id;
        RuleParameter[] parameters;

        public String getId() {
            return this.id;
        }
    }
}

