/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.util.Optional;
import org.sonar.api.scanner.ScannerSide;
import org.sonarsource.dotnet.shared.StringUtils;

@ScannerSide
public class ProjectTypeCollector {
    private static final String PROJECT = "project";
    private int onlyMain = 0;
    private int onlyTest = 0;
    private int mixed = 0;
    private int noFiles = 0;

    public void addProjectInfo(boolean hasMainFiles, boolean hasTestFiles) {
        if (hasMainFiles && hasTestFiles) {
            ++this.mixed;
        } else if (hasMainFiles) {
            ++this.onlyMain;
        } else if (hasTestFiles) {
            ++this.onlyTest;
        } else {
            ++this.noFiles;
        }
    }

    public boolean hasProjects() {
        return this.countProjects() > 0;
    }

    public Optional<String> getSummary(String languageName) {
        int projectsCount = this.countProjects();
        if (projectsCount == 0) {
            return Optional.empty();
        }
        StringBuilder stringBuilder = new StringBuilder(String.format("Found %d MSBuild %s %s:", projectsCount, languageName, StringUtils.pluralize(PROJECT, projectsCount)));
        if (this.onlyMain > 0) {
            stringBuilder.append(String.format(" %d MAIN %s.", this.onlyMain, StringUtils.pluralize(PROJECT, this.onlyMain)));
        }
        if (this.onlyTest > 0) {
            stringBuilder.append(String.format(" %d TEST %s.", this.onlyTest, StringUtils.pluralize(PROJECT, this.onlyTest)));
        }
        if (this.mixed > 0) {
            stringBuilder.append(String.format(" %d with both MAIN and TEST files.", this.mixed));
        }
        if (this.noFiles > 0) {
            stringBuilder.append(String.format(" %d with no MAIN nor TEST files.", this.noFiles));
        }
        return Optional.of(stringBuilder.toString());
    }

    private int countProjects() {
        return this.onlyMain + this.onlyTest + this.mixed + this.noFiles;
    }
}

