/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.util.ArrayList;
import java.util.List;
import org.sonar.api.PropertyType;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.utils.ManifestUtils;
import org.sonarsource.dotnet.shared.plugins.PluginMetadata;

public abstract class AbstractPropertyDefinitions {
    private static final String EXTERNAL_ANALYZERS_CATEGORY = "External Analyzers";
    private static final String LEGACY_PROP_PREFIX = "sonaranalyzer-";
    protected static final String PROP_PREFIX = "sonar.";
    public static final String PROJECT_KEY_PROPERTY = "sonar.projectKey";
    public static final String PROJECT_NAME_PROPERTY = "sonar.projectName";
    public static final String PROJECT_BASE_DIR_PROPERTY = "sonar.projectBaseDir";
    protected final PluginMetadata metadata;

    protected AbstractPropertyDefinitions(PluginMetadata metadata) {
        this.metadata = metadata;
    }

    public List<PropertyDefinition> create() {
        String languageKey = this.metadata.languageKey();
        String languageName = this.metadata.languageName();
        String version = AbstractPropertyDefinitions.projectVersion();
        ArrayList<PropertyDefinition> result = new ArrayList<PropertyDefinition>();
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.roslynJsonReportPathProperty(languageKey)).multiValues(true).hidden().build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.analyzerWorkDirProperty(languageKey)).multiValues(true).hidden().build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.pluginKeyScannerPropertyKey(languageKey)).defaultValue(this.metadata.pluginKey()).hidden().build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.pluginVersionScannerPropertyKey(languageKey)).defaultValue(version).hidden().build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.staticResourceNameScannerPropertyKey(languageKey)).defaultValue("SonarAnalyzer-" + this.metadata.pluginKey() + "-" + version + ".zip").hidden().build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.fileSuffixProperty(languageKey)).category(languageName).defaultValue(this.metadata.fileSuffixesDefaultValue()).name("File suffixes").description("List of suffixes for files to analyze.").multiValues(true).onQualifiers("TRK", new String[0]).build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.ignoreHeaderCommentsProperty(languageKey)).category(languageName).defaultValue("true").name("Ignore header comments").description("If set to \"true\", the file headers (that are usually the same on each file: licensing information for example) are not considered as comments. Thus metrics such as \"Comment lines\" do not get incremented. If set to \"false\", those file headers are considered as comments and metrics such as \"Comment lines\" get incremented.").onQualifiers("TRK", new String[0]).type(PropertyType.BOOLEAN).build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.analyzeGeneratedCode(languageKey)).category(languageName).defaultValue("false").name("Analyze generated code").description("If set to \"true\", the files containing generated code are analyzed. If set to \"false\", the files containing generated code are ignored.").onQualifiers("TRK", new String[0]).type(PropertyType.BOOLEAN).build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.ignoreIssuesProperty(languageKey)).type(PropertyType.BOOLEAN).category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(languageName).index(0).defaultValue("false").name("Ignore issues from external Roslyn analyzers").description("If set to 'true', issues reported by external Roslyn analyzers won't be imported.").onQualifiers("TRK", new String[0]).build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.bugCategoriesProperty(languageKey)).type(PropertyType.STRING).multiValues(true).category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(languageName).index(1).name("Rule categories associated with Bugs").description("External rule categories to be treated as Bugs.").onQualifiers("TRK", new String[0]).build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.vulnerabilityCategoriesProperty(languageKey)).type(PropertyType.STRING).multiValues(true).category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(languageName).index(2).name("Rule categories associated with Vulnerabilities").description("External rule categories to be treated as Vulnerabilities.").onQualifiers("TRK", new String[0]).build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.codeSmellCategoriesProperty(languageKey)).type(PropertyType.STRING).multiValues(true).category(EXTERNAL_ANALYZERS_CATEGORY).subCategory(languageName).index(3).name("Rule categories associated with Code Smells").description("External rule categories to be treated as Code Smells. By default, external issues are Code Smells, or Bugs when the severity is error.").onQualifiers("TRK", new String[0]).build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.pluginKeyLegacyScannerPropertyKey(languageKey)).defaultValue(this.metadata.pluginKey()).hidden().build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.pluginVersionLegacyScannerPropertyKey(languageKey)).defaultValue(version).hidden().build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.staticResourceNameLegacyScannerPropertyKey(languageKey)).defaultValue("SonarAnalyzer-" + this.metadata.pluginKey() + "-" + version + ".zip").hidden().build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.analyzerIdLegacyScannerPropertyKey(languageKey)).defaultValue(this.metadata.analyzerProjectName()).hidden().build());
        result.add(PropertyDefinition.builder((String)AbstractPropertyDefinitions.ruleNamespaceLegacyScannerPropertyKey(languageKey)).defaultValue(this.metadata.analyzerProjectName()).hidden().build());
        return result;
    }

    public static String ignoreHeaderCommentsProperty(String languageKey) {
        return PROP_PREFIX + languageKey + ".ignoreHeaderComments";
    }

    public static String analyzeGeneratedCode(String languageKey) {
        return PROP_PREFIX + languageKey + ".analyzeGeneratedCode";
    }

    public static String fileSuffixProperty(String languageKey) {
        return PROP_PREFIX + languageKey + ".file.suffixes";
    }

    public static String roslynJsonReportPathProperty(String languageKey) {
        return PROP_PREFIX + languageKey + ".roslyn.reportFilePaths";
    }

    public static String telemetryJsonReportPathProperty(String languageKey) {
        return PROP_PREFIX + languageKey + ".scanner.telemetry";
    }

    public static String analyzerWorkDirProperty(String languageKey) {
        return PROP_PREFIX + languageKey + ".analyzer.projectOutPaths";
    }

    public static String ignoreIssuesProperty(String languageKey) {
        return PROP_PREFIX + languageKey + ".roslyn.ignoreIssues";
    }

    public static String bugCategoriesProperty(String languageKey) {
        return PROP_PREFIX + languageKey + ".roslyn.bugCategories";
    }

    public static String codeSmellCategoriesProperty(String languageKey) {
        return PROP_PREFIX + languageKey + ".roslyn.codeSmellCategories";
    }

    public static String vulnerabilityCategoriesProperty(String languageKey) {
        return PROP_PREFIX + languageKey + ".roslyn.vulnerabilityCategories";
    }

    public static String pullRequestCacheBasePath() {
        return "sonar.pullrequest.cache.basepath";
    }

    public static String pullRequestBase() {
        return "sonar.pullrequest.base";
    }

    public static String pluginKeyScannerPropertyKey(String languageKey) {
        return AbstractPropertyDefinitions.scannerForDotNetProperty(languageKey, "pluginKey");
    }

    public static String pluginVersionScannerPropertyKey(String languageKey) {
        return AbstractPropertyDefinitions.scannerForDotNetProperty(languageKey, "pluginVersion");
    }

    public static String staticResourceNameScannerPropertyKey(String languageKey) {
        return AbstractPropertyDefinitions.scannerForDotNetProperty(languageKey, "staticResourceName");
    }

    private static String scannerForDotNetProperty(String languageKey, String name) {
        return PROP_PREFIX + languageKey + ".analyzer.dotnet." + name;
    }

    private static String pluginKeyLegacyScannerPropertyKey(String languageKey) {
        return LEGACY_PROP_PREFIX + languageKey + ".pluginKey";
    }

    private static String pluginVersionLegacyScannerPropertyKey(String languageKey) {
        return LEGACY_PROP_PREFIX + languageKey + ".pluginVersion";
    }

    private static String staticResourceNameLegacyScannerPropertyKey(String languageKey) {
        return LEGACY_PROP_PREFIX + languageKey + ".staticResourceName";
    }

    private static String analyzerIdLegacyScannerPropertyKey(String languageKey) {
        return LEGACY_PROP_PREFIX + languageKey + ".analyzerId";
    }

    private static String ruleNamespaceLegacyScannerPropertyKey(String languageKey) {
        return LEGACY_PROP_PREFIX + languageKey + ".ruleNamespace";
    }

    static String projectVersion() {
        List propertyValues = ManifestUtils.getPropertyValues((ClassLoader)AbstractPropertyDefinitions.class.getClassLoader(), (String)"Plugin-Version");
        return propertyValues.isEmpty() ? "Version-N/A" : (String)propertyValues.iterator().next();
    }
}

