/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.dotnet.shared.plugins;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.sonar.api.config.Configuration;
import org.sonar.api.scanner.ScannerSide;
import org.sonarsource.dotnet.shared.plugins.AbstractPropertyDefinitions;
import org.sonarsource.dotnet.shared.plugins.PluginMetadata;

@ScannerSide
public abstract class AbstractLanguageConfiguration {
    private static final String SUFFIX = ".sonar";
    protected final PluginMetadata metadata;
    protected final Configuration configuration;

    protected AbstractLanguageConfiguration(Configuration configuration, PluginMetadata metadata) {
        this.configuration = configuration;
        this.metadata = metadata;
    }

    public boolean ignoreThirdPartyIssues() {
        return this.configuration.getBoolean(AbstractPropertyDefinitions.ignoreIssuesProperty(this.metadata.languageKey())).orElse(false);
    }

    public Set<String> bugCategories() {
        return new HashSet<String>(Arrays.asList(this.configuration.getStringArray(AbstractPropertyDefinitions.bugCategoriesProperty(this.metadata.languageKey()))));
    }

    public Set<String> codeSmellCategories() {
        return new HashSet<String>(Arrays.asList(this.configuration.getStringArray(AbstractPropertyDefinitions.codeSmellCategoriesProperty(this.metadata.languageKey()))));
    }

    public Set<String> vulnerabilityCategories() {
        return new HashSet<String>(Arrays.asList(this.configuration.getStringArray(AbstractPropertyDefinitions.vulnerabilityCategoriesProperty(this.metadata.languageKey()))));
    }

    public boolean analyzeGeneratedCode() {
        return this.configuration.getBoolean(AbstractPropertyDefinitions.analyzeGeneratedCode(this.metadata.languageKey())).orElse(false);
    }

    public Optional<Path> outputDir() {
        return this.configuration.get("sonar.working.directory").filter(s -> s.endsWith(SUFFIX)).map(AbstractLanguageConfiguration::outputDir);
    }

    private static Path outputDir(String workingDirectory) {
        return Paths.get(workingDirectory, new String[0]).getParent();
    }
}

