/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.dotnet.tests;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.InputComponent;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.SensorDescriptor;
import org.sonar.api.config.Configuration;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.api.notifications.AnalysisWarnings;
import org.sonar.api.scanner.sensor.ProjectSensor;
import org.sonar.plugins.dotnet.tests.UnitTestResults;
import org.sonar.plugins.dotnet.tests.UnitTestResultsAggregator;
import org.sonar.plugins.dotnet.tests.WildcardPatternFileProvider;
import org.sonarsource.dotnet.protobuf.SonarAnalyzer;
import org.sonarsource.dotnet.shared.plugins.MethodDeclarationsCollector;
import org.sonarsource.dotnet.shared.plugins.PluginMetadata;
import org.sonarsource.dotnet.shared.plugins.RealPathProvider;
import org.sonarsource.dotnet.shared.plugins.SensorContextUtils;

public class UnitTestResultsImportSensor
implements ProjectSensor {
    private static final Logger LOG = LoggerFactory.getLogger(UnitTestResultsImportSensor.class);
    private final WildcardPatternFileProvider wildcardPatternFileProvider = new WildcardPatternFileProvider(new File("."));
    private final UnitTestResultsAggregator unitTestResultsAggregator;
    private final String languageKey;
    private final String languageName;
    private final AnalysisWarnings analysisWarnings;
    private final RealPathProvider realPathProvider;
    private final MethodDeclarationsCollector collector;

    public UnitTestResultsImportSensor(MethodDeclarationsCollector collector, UnitTestResultsAggregator unitTestResultsAggregator, PluginMetadata pluginMetadata, AnalysisWarnings analysisWarnings, RealPathProvider realPathProvider) {
        this.collector = collector;
        this.unitTestResultsAggregator = unitTestResultsAggregator;
        this.languageKey = pluginMetadata.languageKey();
        this.languageName = pluginMetadata.languageName();
        this.analysisWarnings = analysisWarnings;
        this.realPathProvider = realPathProvider;
    }

    public void describe(SensorDescriptor descriptor) {
        String name = String.format("%s Unit Test Results Import", this.languageName);
        descriptor.name(name);
        descriptor.onlyOnLanguage(this.languageKey);
        descriptor.onlyWhenConfiguration(c -> this.unitTestResultsAggregator.hasUnitTestResultsProperty(arg_0 -> ((Configuration)c).hasKey(arg_0)));
    }

    public void execute(SensorContext context) {
        if (this.unitTestResultsAggregator.hasUnitTestResultsProperty()) {
            try {
                this.addTestMetrics(context);
            }
            catch (Exception e) {
                LOG.warn("Could not import unit test report: '{}'", (Object)e.getMessage());
                this.analysisWarnings.addUnique(String.format("Could not import unit test report for '%s'. Please check the logs for more details.", this.languageName));
            }
        } else {
            LOG.debug("No unit test results property. Skip Sensor");
        }
    }

    private void addTestMetrics(SensorContext context) {
        Collection<SonarAnalyzer.MethodDeclarationsInfo> methodDeclarations = this.collector.getMethodDeclarations();
        Map<String, UnitTestResults> aggregatedResultsPerFile = this.unitTestResultsAggregator.aggregate(this.wildcardPatternFileProvider, methodDeclarations);
        this.addMeasures(context, aggregatedResultsPerFile);
    }

    private void addMeasures(SensorContext context, Map<String, UnitTestResults> aggregatedResultsPerFile) {
        for (Map.Entry<String, UnitTestResults> entry : aggregatedResultsPerFile.entrySet()) {
            String path = this.realPathProvider.getRealPath(entry.getKey());
            InputFile inputFile = SensorContextUtils.toInputFile(context.fileSystem(), path);
            if (inputFile == null) {
                LOG.debug("Cannot find the file '{}'. No test results will be imported. Mapped path is '{}'.", (Object)entry.getKey(), (Object)path);
                continue;
            }
            UnitTestResults results = entry.getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding test metrics for file '{}'. Tests: '{}', Errors: `{}`, Failures: '{}'", new Object[]{inputFile.filename(), results.tests(), results.errors(), results.failures()});
            }
            UnitTestResultsImportSensor.addMeasure(context, (InputComponent)inputFile, CoreMetrics.TESTS, results.tests());
            UnitTestResultsImportSensor.addMeasure(context, (InputComponent)inputFile, CoreMetrics.TEST_ERRORS, results.errors());
            UnitTestResultsImportSensor.addMeasure(context, (InputComponent)inputFile, CoreMetrics.TEST_FAILURES, results.failures());
            UnitTestResultsImportSensor.addMeasure(context, (InputComponent)inputFile, CoreMetrics.SKIPPED_TESTS, results.skipped());
            if (results.executionTime() == null) continue;
            UnitTestResultsImportSensor.addMeasure(context, (InputComponent)inputFile, CoreMetrics.TEST_EXECUTION_TIME, results.executionTime());
        }
    }

    private static <T extends Serializable> void addMeasure(SensorContext context, InputComponent inputComponent, Metric<T> metric, T value) {
        context.newMeasure().forMetric(metric).on(inputComponent).withValue(value).save();
    }
}

