/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import java.io.File;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.AbstractSvnUpdate;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnExport
extends AbstractSvnUpdate<Long> {
    private boolean force;
    private boolean expandKeywords;
    private String eolStyle;
    private SvnTarget source;

    protected SvnExport(SvnOperationFactory factory) {
        super(factory);
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean isExpandKeywords() {
        return this.expandKeywords;
    }

    public String getEolStyle() {
        return this.eolStyle;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setExpandKeywords(boolean expandKeywords) {
        this.expandKeywords = expandKeywords;
    }

    public void setEolStyle(String eolStyle) {
        this.eolStyle = eolStyle;
    }

    public SvnTarget getSource() {
        return this.source;
    }

    public void setSource(SvnTarget source2) {
        this.source = source2;
    }

    @Override
    protected void ensureArgumentsAreValid() throws SVNException {
        SVNErrorMessage err;
        if (this.getFirstTarget() == null || !this.getFirstTarget().isLocal()) {
            err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Destination path is required for export.");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (this.getSource() == null) {
            err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Source is required for export.");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (this.getDepth() == null || this.getDepth() == SVNDepth.UNKNOWN) {
            this.setDepth(SVNDepth.INFINITY);
        }
        if (this.getRevision() == SVNRevision.UNDEFINED) {
            this.setRevision(this.getSource().getResolvedPegRevision());
        }
        super.ensureArgumentsAreValid();
    }

    @Override
    protected void initDefaults() {
        super.initDefaults();
        this.setExpandKeywords(true);
        this.setDepth(SVNDepth.INFINITY);
    }

    @Override
    protected File getOperationalWorkingCopy() {
        if (this.getSource().isLocal()) {
            return this.getSource().getFile();
        }
        return null;
    }

    @Override
    public boolean isChangesWorkingCopy() {
        return true;
    }
}

