/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc2;

import java.io.File;
import java.io.OutputStream;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffGenerator;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNewDiffGenerator;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnOldDiffGenerator;
import org.tmatesoft.svn.core.wc.ISVNDiffGenerator;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnOperation;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnDiff
extends SvnOperation<Void> {
    private ISvnDiffGenerator diffGenerator;
    private SVNDiffOptions diffOptions;
    private OutputStream output;
    private SvnTarget source;
    private SvnTarget firstSource;
    private SvnTarget secondSource;
    private SVNRevision startRevision;
    private SVNRevision endRevision;
    private boolean ignoreAncestry;
    private boolean noDiffDeleted;
    private boolean showCopiesAsAdds;
    private boolean ignoreContentType;
    private File relativeToDirectory;
    private boolean useGitDiffFormat;
    private boolean recurseIntoDeletedDirectories;

    protected SvnDiff(SvnOperationFactory factory) {
        super(factory);
        this.setIgnoreAncestry(true);
        this.setRecurseIntoDeletedDirectories(true);
    }

    public void setSource(SvnTarget source2, SVNRevision start, SVNRevision end) {
        this.source = source2;
        this.startRevision = start;
        this.endRevision = end;
        if (source2 != null) {
            this.setSources(null, null);
        }
    }

    public void setSources(SvnTarget source1, SvnTarget source2) {
        this.firstSource = source1;
        this.secondSource = source2;
        if (this.firstSource != null) {
            this.setSource(null, null, null);
        }
    }

    public SvnTarget getSource() {
        return this.source;
    }

    public SVNRevision getStartRevision() {
        return this.startRevision;
    }

    public SVNRevision getEndRevision() {
        return this.endRevision;
    }

    public SvnTarget getFirstSource() {
        return this.firstSource;
    }

    public SvnTarget getSecondSource() {
        return this.secondSource;
    }

    public void setRelativeToDirectory(File relativeToDirectory) {
        this.relativeToDirectory = relativeToDirectory;
    }

    public File getRelativeToDirectory() {
        return this.relativeToDirectory;
    }

    public ISvnDiffGenerator getDiffGenerator() {
        return this.diffGenerator;
    }

    public void setDiffGenerator(ISVNDiffGenerator diffGenerator) {
        if (diffGenerator == null) {
            this.setDiffGenerator((ISvnDiffGenerator)null);
        } else if (diffGenerator instanceof SvnNewDiffGenerator) {
            this.setDiffGenerator(((SvnNewDiffGenerator)diffGenerator).getDelegate());
        } else {
            this.setDiffGenerator(new SvnOldDiffGenerator(diffGenerator));
        }
    }

    public void setDiffGenerator(ISvnDiffGenerator diffGenerator) {
        this.diffGenerator = diffGenerator;
    }

    public SVNDiffOptions getDiffOptions() {
        return this.diffOptions;
    }

    public void setDiffOptions(SVNDiffOptions diffOptions) {
        this.diffOptions = diffOptions;
    }

    public OutputStream getOutput() {
        return this.output;
    }

    public void setOutput(OutputStream output) {
        this.output = output;
    }

    public boolean isIgnoreAncestry() {
        return this.ignoreAncestry;
    }

    public void setIgnoreAncestry(boolean ignoreAncestry) {
        this.ignoreAncestry = ignoreAncestry;
    }

    public boolean isNoDiffDeleted() {
        return this.noDiffDeleted;
    }

    public void setNoDiffDeleted(boolean noDiffDeleted) {
        this.noDiffDeleted = noDiffDeleted;
    }

    public boolean isShowCopiesAsAdds() {
        return this.showCopiesAsAdds;
    }

    public void setShowCopiesAsAdds(boolean showCopiesAsAdds) {
        this.showCopiesAsAdds = showCopiesAsAdds;
    }

    public boolean isIgnoreContentType() {
        return this.ignoreContentType;
    }

    public void setIgnoreContentType(boolean ignoreContentType) {
        this.ignoreContentType = ignoreContentType;
    }

    public boolean isUseGitDiffFormat() {
        return this.useGitDiffFormat;
    }

    public void setUseGitDiffFormat(boolean useGitDiffFormat) {
        this.useGitDiffFormat = useGitDiffFormat;
    }

    public boolean isRecurseIntoDeletedDirectories() {
        return this.recurseIntoDeletedDirectories;
    }

    public void setRecurseIntoDeletedDirectories(boolean recurseIntoDeletedDirectories) {
        this.recurseIntoDeletedDirectories = recurseIntoDeletedDirectories;
    }

    @Override
    protected int getMinimumTargetsCount() {
        return super.getMinimumTargetsCount();
    }

    @Override
    protected int getMaximumTargetsCount() {
        return Integer.MAX_VALUE;
    }

    @Override
    protected void ensureArgumentsAreValid() throws SVNException {
        SVNErrorMessage err;
        if (this.getRelativeToDirectory() != null && this.hasRemoteTargets()) {
            err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Relative directory cannot be specified with remote targets");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
        if (this.getOutput() == null) {
            err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "No output is specified.");
            SVNErrorManager.error(err, SVNLogType.CLIENT);
        }
    }

    @Override
    protected File getOperationalWorkingCopy() {
        if (this.getSource() != null && this.getSource().isFile()) {
            return this.getSource().getFile();
        }
        if (this.getFirstSource() != null && this.getFirstSource().isFile()) {
            return this.getFirstSource().getFile();
        }
        if (this.getSecondSource() != null && this.getSecondSource().isFile()) {
            return this.getSecondSource().getFile();
        }
        return null;
    }

    @Override
    public boolean isChangesWorkingCopy() {
        return false;
    }
}

