/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.wc;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.wc.ISVNChangelistHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNBasicClient;
import org.tmatesoft.svn.core.wc2.SvnGetChangelistPaths;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnSetChangelist;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SVNChangelistClient
extends SVNBasicClient {
    public SVNChangelistClient(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
    }

    public SVNChangelistClient(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
    }

    public SVNChangelistClient(SvnOperationFactory of) {
        super(of);
    }

    public void getChangeLists(File path, Collection<String> changeLists, SVNDepth depth, ISVNChangelistHandler handler) throws SVNException {
        this.doGetChangeLists(path, changeLists, depth, handler);
    }

    public void getChangeListPaths(Collection<String> changeLists, Collection<File> targets, SVNDepth depth, ISVNChangelistHandler handler) throws SVNException {
        this.doGetChangeListPaths(changeLists, targets, depth, handler);
    }

    public void addToChangelist(File[] paths, SVNDepth depth, String changelist, String[] changelists) throws SVNException {
        this.doAddToChangelist(paths, depth, changelist, changelists);
    }

    public void removeFromChangelist(File[] paths, SVNDepth depth, String[] changelists) throws SVNException {
        this.doRemoveFromChangelist(paths, depth, changelists);
    }

    public void doAddToChangelist(File[] paths, SVNDepth depth, String changelist, String[] changelists) throws SVNException {
        SvnSetChangelist cl = this.getOperationsFactory().createSetChangelist();
        for (int i2 = 0; i2 < paths.length; ++i2) {
            cl.addTarget(SvnTarget.fromFile(paths[i2]));
        }
        cl.setDepth(depth);
        cl.setChangelistName(changelist);
        if (changelists != null) {
            cl.setApplicalbeChangelists(Arrays.asList(changelists));
        }
        cl.run();
    }

    public void doRemoveFromChangelist(File[] paths, SVNDepth depth, String[] changelists) throws SVNException {
        SvnSetChangelist cl = this.getOperationsFactory().createSetChangelist();
        for (int i2 = 0; i2 < paths.length; ++i2) {
            cl.addTarget(SvnTarget.fromFile(paths[i2]));
        }
        cl.setDepth(depth);
        if (changelists != null) {
            cl.setApplicalbeChangelists(Arrays.asList(changelists));
        }
        cl.setRemove(true);
        cl.run();
    }

    public void doGetChangeListPaths(Collection<String> changeLists, Collection<File> targets, SVNDepth depth, ISVNChangelistHandler handler) throws SVNException {
        SvnGetChangelistPaths gp = this.getOperationsFactory().createGetChangelistPaths();
        for (File file : targets) {
            gp.addTarget(SvnTarget.fromFile(file));
        }
        gp.setReceiver(SvnCodec.changelistReceiver(handler));
        gp.setDepth(depth);
        if (changeLists != null) {
            gp.setApplicalbeChangelists(changeLists);
        }
        gp.run();
    }

    public void doGetChangeLists(File path, Collection<String> changeLists, SVNDepth depth, ISVNChangelistHandler handler) throws SVNException {
        SvnGetChangelistPaths gp = this.getOperationsFactory().createGetChangelistPaths();
        gp.addTarget(SvnTarget.fromFile(path));
        gp.setReceiver(SvnCodec.changelistReceiver(handler));
        gp.setDepth(depth);
        if (changeLists != null) {
            gp.setApplicalbeChangelists(changeLists);
        }
        gp.run();
    }
}

