/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.io.diff;

import java.nio.ByteBuffer;

public class SVNDiffInstruction {
    public static final int COPY_FROM_SOURCE = 0;
    public static final int COPY_FROM_TARGET = 1;
    public static final int COPY_FROM_NEW_DATA = 2;
    public int type;
    public int length;
    public int offset;

    public SVNDiffInstruction(int t, int l, int o) {
        this.type = t;
        this.length = l;
        this.offset = o;
    }

    public SVNDiffInstruction() {
        this(0, 0, 0);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        switch (this.type) {
            case 0: {
                b.append("S->");
                break;
            }
            case 1: {
                b.append("T->");
                break;
            }
            case 2: {
                b.append("D->");
            }
        }
        if (this.type == 0 || this.type == 1) {
            b.append(this.offset);
        } else {
            b.append(this.offset);
        }
        b.append(":");
        b.append(this.length);
        return b.toString();
    }

    public void writeTo(ByteBuffer target) {
        byte first = (byte)(this.type << 6);
        if (this.length <= 63 && this.length > 0) {
            first = (byte)(first | this.length & 0x3F);
            target.put((byte)(first & 0xFF));
        } else {
            target.put((byte)(first & 0xFF));
            SVNDiffInstruction.writeInt(target, this.length);
        }
        if (this.type == 0 || this.type == 1) {
            SVNDiffInstruction.writeInt(target, this.offset);
        }
    }

    public static void writeInt(ByteBuffer os, int i2) {
        if (i2 == 0) {
            os.put((byte)0);
            return;
        }
        int count = 1;
        long v = i2 >> 7;
        while (v > 0L) {
            v >>= 7;
            ++count;
        }
        while (--count >= 0) {
            byte b = (byte)((count > 0 ? 1 : 0) << 7);
            int r = (byte)(i2 >> 7 * count & 0x7F) | b;
            os.put((byte)r);
        }
    }

    public static void writeLong(ByteBuffer os, long i2) {
        if (i2 == 0L) {
            os.put((byte)0);
            return;
        }
        int count = 1;
        long v = i2 >> 7;
        while (v > 0L) {
            v >>= 7;
            ++count;
        }
        while (--count >= 0) {
            byte b = (byte)((count > 0 ? 1 : 0) << 7);
            int r = (byte)(i2 >> 7 * count & 0x7FL) | b;
            os.put((byte)r);
        }
    }
}

