/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.remote;

import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc2.SvnRemoteOperationRunner;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.SvnWcGeneration;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc2.SvnList;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnRemoteList
extends SvnRemoteOperationRunner<SVNDirEntry, SvnList>
implements ISVNDirEntryHandler {
    @Override
    public boolean isApplicable(SvnList operation, SvnWcGeneration wcGeneration) throws SVNException {
        return wcGeneration != SvnWcGeneration.V16 || !operation.getFirstTarget().isFile();
    }

    @Override
    protected SVNDirEntry run() throws SVNException {
        SvnTarget infoTarget = ((SvnList)this.getOperation()).getFirstTarget();
        Structure<SvnRepositoryAccess.RepositoryInfo> repositoryInfo = this.getRepositoryAccess().createRepositoryFor(infoTarget, ((SvnList)this.getOperation()).getRevision(), infoTarget.getResolvedPegRevision(), null);
        SVNRepository repository = (SVNRepository)repositoryInfo.get(SvnRepositoryAccess.RepositoryInfo.repository);
        long revNum = repositoryInfo.lng(SvnRepositoryAccess.RepositoryInfo.revision);
        repositoryInfo.release();
        this.doList(repository, revNum, this, ((SvnList)this.getOperation()).isFetchLocks(), ((SvnList)this.getOperation()).getDepth(), ((SvnList)this.getOperation()).getEntryFields(), null, null);
        return (SVNDirEntry)((SvnList)this.getOperation()).first();
    }

    @Override
    public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
        ((SvnList)this.getOperation()).receive(SvnTarget.fromURL(dirEntry.getURL()), dirEntry);
    }

    private void doList(SVNRepository repos, long rev, final ISVNDirEntryHandler handler, boolean fetchLocks, SVNDepth depth, int entryFields, SVNURL externalParentUrl, String externalTarget) throws SVNException {
        boolean includeExternals = !((SvnList)this.getOperation()).isIgnoreExternals();
        HashMap<SVNURL, SVNPropertyValue> externals = includeExternals ? new HashMap<SVNURL, SVNPropertyValue>() : null;
        SVNURL url = repos.getLocation();
        SVNURL reposRoot = repos.getRepositoryRoot(false);
        SVNDirEntry entry = null;
        SVNException error = null;
        try {
            entry = repos.info("", rev);
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_IMPLEMENTED) {
                error = svne;
            }
            throw svne;
        }
        if (error != null) {
            SVNNodeKind kind = repos.checkPath("", rev);
            if (kind != SVNNodeKind.NONE) {
                if (!url.equals(reposRoot)) {
                    String name = SVNPathUtil.tail(repos.getLocation().getPath());
                    repos.setLocation(repos.getLocation().removePathTail(), false);
                    Collection<SVNDirEntry> dirEntries = repos.getDir("", rev, null, entryFields, (Collection)null);
                    repos.setLocation(url, false);
                    for (SVNDirEntry dirEntry : dirEntries) {
                        if (!name.equals(dirEntry.getName())) continue;
                        entry = dirEntry;
                        break;
                    }
                    if (entry != null) {
                        entry.setRelativePath(kind == SVNNodeKind.FILE ? name : "");
                    }
                } else {
                    SVNProperties props = new SVNProperties();
                    repos.getDir("", rev, props, entryFields, (Collection)null);
                    SVNProperties revProps = repos.getRevisionProperties(rev, null);
                    String author = revProps.getStringValue("svn:author");
                    String dateStr = revProps.getStringValue("svn:date");
                    Date datestamp = null;
                    if (dateStr != null) {
                        datestamp = SVNDate.parseDateString(dateStr);
                    }
                    entry = new SVNDirEntry(url, reposRoot, "", kind, 0L, !props.isEmpty(), rev, datestamp, author);
                    entry.setRelativePath("");
                }
            }
        } else if (entry != null) {
            if (entry.getKind() == SVNNodeKind.DIR) {
                entry.setName("");
            }
            entry.setRelativePath(entry.getKind() == SVNNodeKind.DIR ? "" : entry.getName());
        }
        if (entry == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NOT_FOUND, "URL ''{0}'' non-existent in that revision", (Object)url);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        final SVNHashMap locksMap = new SVNHashMap();
        if (fetchLocks) {
            SVNLock[] locks;
            block21: {
                locks = new SVNLock[]{};
                try {
                    locks = repos.getLocks("");
                }
                catch (SVNException e) {
                    if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_IMPLEMENTED) break block21;
                    throw e;
                }
            }
            if (locks != null && locks.length > 0) {
                SVNURL root = repos.getRepositoryRoot(true);
                for (int i2 = 0; i2 < locks.length; ++i2) {
                    String repositoryPath = locks[i2].getPath();
                    locksMap.put(root.appendPath(repositoryPath, false), locks[i2]);
                }
            }
        }
        ISVNDirEntryHandler nestedHandler = new ISVNDirEntryHandler(){

            @Override
            public void handleDirEntry(SVNDirEntry dirEntry) throws SVNException {
                dirEntry.setLock((SVNLock)locksMap.get(dirEntry.getURL()));
                handler.handleDirEntry(dirEntry);
            }
        };
        entry.setExternalParentUrl(externalParentUrl);
        entry.setExternalTarget(externalTarget);
        nestedHandler.handleDirEntry(entry);
        if (entry.getKind() == SVNNodeKind.DIR && (depth == SVNDepth.FILES || depth == SVNDepth.IMMEDIATES || depth == SVNDepth.INFINITY)) {
            SvnRemoteList.list(repos, "", rev, depth, entryFields, externals, externalParentUrl, externalTarget, nestedHandler);
        }
        if (includeExternals && externals != null && externals.size() > 0) {
            this.listExternals(repos, externals, depth, entryFields, fetchLocks, handler);
        }
    }

    private static void list(SVNRepository repository, String path, long rev, SVNDepth depth, int entryFields, Map<SVNURL, SVNPropertyValue> externals, SVNURL externalParentUrl, String externalTarget, ISVNDirEntryHandler handler) throws SVNException {
        SVNPropertyValue svnExternalsVaule;
        SVNProperties properties;
        if (depth == SVNDepth.EMPTY) {
            return;
        }
        Collection<Object> entries = new TreeSet();
        try {
            properties = externals == null ? null : new SVNProperties();
            entries = repository.getDir(path, rev, properties, entryFields, entries);
        }
        catch (SVNAuthenticationException e) {
            return;
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_AUTHORIZED) {
                return;
            }
            throw e;
        }
        SVNPropertyValue sVNPropertyValue = svnExternalsVaule = properties == null ? null : properties.getSVNPropertyValue("svn:externals");
        if (svnExternalsVaule != null) {
            SVNURL location = repository.getLocation();
            externals.put(location.appendPath(path, false), svnExternalsVaule);
        }
        for (SVNDirEntry sVNDirEntry : entries) {
            String childPath = SVNPathUtil.append(path, sVNDirEntry.getName());
            sVNDirEntry.setRelativePath(childPath);
            if (sVNDirEntry.getKind() == SVNNodeKind.FILE || depth == SVNDepth.IMMEDIATES || depth == SVNDepth.INFINITY) {
                sVNDirEntry.setExternalParentUrl(externalParentUrl);
                sVNDirEntry.setExternalTarget(externalTarget);
                handler.handleDirEntry(sVNDirEntry);
            }
            if (sVNDirEntry.getKind() != SVNNodeKind.DIR || sVNDirEntry.getDate() == null || depth != SVNDepth.INFINITY) continue;
            SvnRemoteList.list(repository, childPath, rev, depth, entryFields, externals, externalParentUrl, externalTarget, handler);
        }
    }

    private void listExternals(SVNRepository repository, Map<SVNURL, SVNPropertyValue> externals, SVNDepth depth, int entryFields, boolean fetchLocks, ISVNDirEntryHandler handler) throws SVNException {
        for (Map.Entry<SVNURL, SVNPropertyValue> entry : externals.entrySet()) {
            SVNPropertyValue externalValue;
            SVNURL externalParentUrl = entry.getKey();
            SVNExternal[] externalItems = SVNExternal.parseExternals(externalParentUrl, SVNPropertyValue.getPropertyAsString(externalValue = entry.getValue()));
            if (externalItems == null || externalItems.length == 0) continue;
            this.listExternalItems(repository, externalItems, externalParentUrl, depth, entryFields, fetchLocks, handler);
        }
    }

    private void listExternalItems(SVNRepository repository, SVNExternal[] externalItems, SVNURL externalParentUrl, SVNDepth depth, int entryFields, boolean fetchLocks, ISVNDirEntryHandler handler) throws SVNException {
        SVNURL rootUrl = repository.getRepositoryRoot(true);
        for (SVNExternal externalItem : externalItems) {
            SVNURL resolvedURL = externalItem.resolveURL(rootUrl, externalParentUrl);
            try {
                repository.setLocation(resolvedURL, true);
                this.doList(repository, externalItem.getRevision().getNumber(), handler, fetchLocks, depth, entryFields, externalParentUrl, externalItem.getPath());
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() != SVNErrorCode.CANCELLED) {
                    if (((SvnList)this.getOperation()).getEventHandler() == null) continue;
                    SVNEvent event = SVNEventFactory.createSVNEvent(new File(externalItem.getPath()), SVNNodeKind.UNKNOWN, null, -1L, SVNEventAction.FAILED_EXTERNAL, SVNEventAction.FAILED_EXTERNAL, e.getErrorMessage(), null);
                    ((SvnList)this.getOperation()).getEventHandler().handleEvent(event, -1.0);
                    continue;
                }
                throw e;
            }
        }
    }
}

