/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.old;

import java.io.File;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc16.SVNCommitClient16;
import org.tmatesoft.svn.core.internal.wc2.ISvnCommitRunner;
import org.tmatesoft.svn.core.internal.wc2.compat.SvnCodec;
import org.tmatesoft.svn.core.internal.wc2.old.SvnOldRunner;
import org.tmatesoft.svn.core.wc.SVNCommitPacket;
import org.tmatesoft.svn.core.wc2.SvnCommit;
import org.tmatesoft.svn.core.wc2.SvnCommitPacket;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnOldCommit
extends SvnOldRunner<SVNCommitInfo, SvnCommit>
implements ISvnCommitRunner {
    @Override
    public SvnCommitPacket collectCommitItems(SvnCommit operation) throws SVNException {
        SVNCommitPacket[] packets;
        this.setOperation(operation);
        SVNCommitClient16 client = new SVNCommitClient16(((SvnCommit)this.getOperation()).getRepositoryPool(), ((SvnCommit)this.getOperation()).getOptions());
        client.setEventHandler(((SvnCommit)this.getOperation()).getEventHandler());
        client.setCommitHandler(SvnCodec.commitHandler(((SvnCommit)this.getOperation()).getCommitHandler()));
        client.setCommitParameters(SvnCodec.commitParameters(((SvnCommit)this.getOperation()).getCommitParameters()));
        File[] paths = new File[((SvnCommit)this.getOperation()).getTargets().size()];
        int i2 = 0;
        for (SvnTarget tgt : ((SvnCommit)this.getOperation()).getTargets()) {
            paths[i2++] = tgt.getFile();
        }
        String[] changelists = null;
        if (((SvnCommit)this.getOperation()).getApplicableChangelists() != null && !((SvnCommit)this.getOperation()).getApplicableChangelists().isEmpty()) {
            changelists = ((SvnCommit)this.getOperation()).getApplicableChangelists().toArray(new String[((SvnCommit)this.getOperation()).getApplicableChangelists().size()]);
        }
        if ((packets = client.doCollectCommitItems(paths, ((SvnCommit)this.getOperation()).isKeepLocks(), ((SvnCommit)this.getOperation()).isForce(), ((SvnCommit)this.getOperation()).getDepth(), true, changelists)) != null && packets.length == 1) {
            return SvnCodec.commitPacket(this, packets[0]);
        }
        if (packets != null && packets.length > 1) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Commit from different working copies belonging to different repositories is not supported");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        return null;
    }

    @Override
    protected SVNCommitInfo run() throws SVNException {
        SvnCommitPacket packet = ((SvnCommit)this.getOperation()).collectCommitItems();
        if (packet == null || packet.isEmpty()) {
            return null;
        }
        SVNCommitPacket oldPacket = (SVNCommitPacket)packet.getLockingContext();
        SVNCommitClient16 client = new SVNCommitClient16(((SvnCommit)this.getOperation()).getRepositoryPool(), ((SvnCommit)this.getOperation()).getOptions());
        client.setEventHandler(((SvnCommit)this.getOperation()).getEventHandler());
        client.setCommitHandler(SvnCodec.commitHandler(((SvnCommit)this.getOperation()).getCommitHandler()));
        client.setCommitParameters(SvnCodec.commitParameters(((SvnCommit)this.getOperation()).getCommitParameters()));
        SVNCommitInfo info = client.doCommit(oldPacket, ((SvnCommit)this.getOperation()).isKeepLocks(), ((SvnCommit)this.getOperation()).isKeepChangelists(), ((SvnCommit)this.getOperation()).getCommitMessage(), ((SvnCommit)this.getOperation()).getRevisionProperties());
        if (info != null) {
            ((SvnCommit)this.getOperation()).receive(((SvnCommit)this.getOperation()).getFirstTarget(), info);
        }
        return info;
    }

    @Override
    public void disposeCommitPacket(Object lockingContext, boolean disposeParentContext) throws SVNException {
        if (lockingContext instanceof SVNCommitPacket[]) {
            SVNCommitPacket[] packets = (SVNCommitPacket[])lockingContext;
            for (int i2 = 0; i2 < packets.length; ++i2) {
                try {
                    packets[i2].dispose();
                    continue;
                }
                catch (SVNException sVNException) {
                    // empty catch block
                }
            }
        } else if (lockingContext instanceof SVNCommitPacket) {
            ((SVNCommitPacket)lockingContext).dispose();
        }
    }

    @Override
    public Object splitLockingContext(Object lockingContext, SvnCommitPacket newPacket) {
        if (lockingContext instanceof SVNCommitPacket[]) {
            SVNCommitPacket[] oldPackets = (SVNCommitPacket[])lockingContext;
            return lockingContext;
        }
        return lockingContext;
    }
}

