/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc2.ng;

import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNCancelException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCancellableEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNStatusEditor17;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.SvnConflictReport;
import org.tmatesoft.svn.core.internal.wc17.SvnSingleRangeConflictReport;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbExternals;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbReader;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.ng.ISvnDiffCallback2;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffCallbackResult;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnDiffSource;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgMergeCallback2;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgMergeinfoUtil;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgPropertiesManager;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRemoteMergeEditor;
import org.tmatesoft.svn.core.internal.wc2.ng.SvnNgRepositoryAccess;
import org.tmatesoft.svn.core.io.ISVNReporter;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.SVNLocationSegment;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.SVNDiffOptions;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNRevisionRange;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnGetProperties;
import org.tmatesoft.svn.core.wc2.SvnMerge;
import org.tmatesoft.svn.core.wc2.SvnStatus;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SvnNgMergeDriver {
    private static final Comparator<? super File> PATH_COMPARATOR = new Comparator<File>(){

        @Override
        public int compare(File file1, File file2) {
            return SVNPathUtil.PATH_COMPARATOR.compare(SVNFileUtil.getFilePath(file1), SVNFileUtil.getFilePath(file2));
        }
    };
    String diff3Cmd;
    boolean forceDelete;
    public boolean useSleep;
    boolean dryRun;
    boolean recordOnly;
    boolean sourcesAncestral;
    boolean sameRepos;
    boolean ignoreMergeInfo;
    private boolean mergeinfoCapable;
    private boolean diffIgnoreAncestry;
    private boolean targetMissingChild;
    boolean reintegrateMerge;
    File targetAbsPath;
    File addedPath;
    SVNURL reposRootUrl;
    MergeSource mergeSource;
    protected SVNMergeRangeList implicitSrcGap;
    SVNWCContext context;
    private boolean addNecessiatedMerge;
    Collection<File> dryRunDeletions;
    Collection<File> dryRunAdded;
    private int operativeNotifications;
    private int notifications;
    protected Collection<File> addedPaths;
    protected Collection<File> mergedPaths;
    protected Collection<File> skippedPaths;
    protected Collection<File> treeConflictedPaths;
    protected Collection<File> conflictedPaths;
    Collection<File> pathsWithNewMergeInfo;
    Collection<File> pathsWithDeletedMergeInfo;
    SVNDiffOptions diffOptions;
    SVNRepository repos1;
    SVNRepository repos2;
    SvnMerge operation;
    SvnNgRepositoryAccess repositoryAccess;
    private int currentAncestorIndex;
    private boolean singleFileMerge;
    public NotifyBeginState notifyBegin;

    public static MergePath findNearestAncestorWithIntersectingRanges(long[] revisions, Map<File, MergePath> childrenWithMergeInfo, boolean pathIsOwnAncestor, File localAbsPath) {
        MergePath nearestAncestor = null;
        revisions[0] = -1L;
        revisions[1] = -1L;
        assert (childrenWithMergeInfo != null);
        ArrayList<Map.Entry<File, MergePath>> entries = new ArrayList<Map.Entry<File, MergePath>>(childrenWithMergeInfo.entrySet());
        for (int i2 = entries.size() - 1; i2 >= 0; --i2) {
            boolean reverseMerge;
            SVNMergeRange r2;
            SVNMergeRange r1;
            Map.Entry entry = (Map.Entry)entries.get(i2);
            MergePath child = (MergePath)entry.getValue();
            if (!SVNPathUtil.isAncestor(SVNFileUtil.getFilePath(child.absPath), SVNFileUtil.getFilePath(localAbsPath)) || !pathIsOwnAncestor && child.absPath.equals(localAbsPath)) continue;
            if (nearestAncestor == null) {
                nearestAncestor = child;
                if (child.remainingRanges != null && child.remainingRanges.getSize() > 0) {
                    r1 = child.remainingRanges.getRanges()[0];
                    revisions[0] = r1.getStartRevision();
                    revisions[1] = r1.getEndRevision();
                    continue;
                }
                revisions[0] = -1L;
                revisions[1] = -1L;
                break;
            }
            r1 = nearestAncestor.remainingRanges.getSize() == 0 ? null : nearestAncestor.remainingRanges.getRanges()[0];
            SVNMergeRange sVNMergeRange = r2 = child.remainingRanges.getSize() == 0 ? null : child.remainingRanges.getRanges()[0];
            if (r1 == null || r2 == null) continue;
            SVNMergeRange range1 = new SVNMergeRange(-1L, -1L, true);
            SVNMergeRange range2 = new SVNMergeRange(-1L, -1L, true);
            boolean bl = reverseMerge = r1.getStartRevision() > r2.getEndRevision();
            if (reverseMerge) {
                range1.setStartRevision(r1.getEndRevision());
                range1.setEndRevision(r1.getStartRevision());
                range2.setStartRevision(r2.getEndRevision());
                range2.setEndRevision(r2.getStartRevision());
            } else {
                range1.setStartRevision(r1.getStartRevision());
                range1.setEndRevision(r1.getEndRevision());
                range2.setStartRevision(r2.getStartRevision());
                range2.setEndRevision(r2.getEndRevision());
            }
            if (range1.getStartRevision() >= range2.getEndRevision() || range2.getStartRevision() >= range1.getEndRevision()) continue;
            revisions[0] = reverseMerge ? Math.max(r1.getStartRevision(), r2.getStartRevision()) : Math.min(r1.getStartRevision(), r2.getStartRevision());
            revisions[1] = reverseMerge ? Math.max(r1.getEndRevision(), r2.getEndRevision()) : Math.min(r1.getEndRevision(), r2.getEndRevision());
            nearestAncestor = child;
        }
        return nearestAncestor;
    }

    public static void makeMergeConflictError(SvnConflictReport report) throws SVNException {
        assert (report == null || SVNFileUtil.isAbsolute(report.getTargetAbsPath()));
        if (report != null && !report.wasLastRange()) {
            assert (report.getConflictedRange().rev1 != report.getConflictedRange().rev2);
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "One or more conflicts were produced while merging r{0}:{1} into\n''{2}'' --\nresolve all conflicts and rerun the merge to apply the remaining\nunmerged revisions", report.getConflictedRange().rev1, report.getConflictedRange().rev2, report.getTargetAbsPath());
            SVNErrorManager.error(errorMessage, SVNLogType.WC);
        }
    }

    public SvnNgMergeDriver(SVNWCContext context, SvnMerge operation, SvnNgRepositoryAccess repositoryAccess, SVNDiffOptions diffOptions) {
        this.context = context;
        this.operation = operation;
        this.repositoryAccess = repositoryAccess;
        this.diffOptions = diffOptions;
        this.notifyBegin = new NotifyBeginState();
    }

    public void ensureWcIsSuitableForMerge(File targetAbsPath, boolean allowMixedRevs, boolean allowLocalMods, boolean allowSwitchedSubtrees) throws SVNException {
        SVNErrorMessage err;
        if (!allowMixedRevs) {
            long[] revs = SvnWcDbReader.getMinAndMaxRevisions((SVNWCDb)this.context.getDb(), targetAbsPath);
            if (revs[0] < 0L && revs[1] >= 0L) {
                if (!this.context.isNodeAdded(targetAbsPath)) {
                    SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "Cannot determine revision of working copy");
                    SVNErrorManager.error(err2, SVNLogType.WC);
                }
            } else if (revs[0] != revs[1]) {
                SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.CLIENT_MERGE_UPDATE_REQUIRED, "Cannot merge into mixed-revision working copy [{0}:{1}]; try updating first", revs[0], revs[1]);
                SVNErrorManager.error(err3, SVNLogType.WC);
            }
        }
        if (!allowSwitchedSubtrees && SvnWcDbReader.hasSwitchedSubtrees((SVNWCDb)this.context.getDb(), targetAbsPath)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "Cannot merge into a working copy with a switched subtree");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (!allowLocalMods && SvnWcDbReader.hasLocalModifications(this.context, targetAbsPath)) {
            err = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "Cannot merge into a working copy that has local modifications");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
    }

    public MergeData mergeCousinsAndSupplementMergeInfo(File targetWCPath, SVNRepository repository1, SVNRepository repository2, SVNURL url1, long rev1, SVNURL url2, long rev2, long youngestCommonRev, SVNURL sourceReposRoot, SVNURL wcReposRoot, SVNDepth depth, boolean ignoreMergeInfo, boolean ignoreAncestry, boolean forceDelete, boolean recordOnly, boolean dryRun) throws SVNException {
        assert (repository1.getLocation().equals(url1));
        assert (repository2.getLocation().equals(url2));
        List<MergeSource> addSources = null;
        List<MergeSource> removeSources = null;
        SVNRevision sRev = SVNRevision.create(rev1);
        SVNRevision eRev = SVNRevision.create(youngestCommonRev);
        SVNRevisionRange range = new SVNRevisionRange(sRev, eRev);
        LinkedList<SVNRevisionRange> ranges = new LinkedList<SVNRevisionRange>();
        ranges.add(range);
        repository1.setLocation(url1, false);
        removeSources = this.normalizeMergeSources(SvnTarget.fromURL(url1), url1, sourceReposRoot, sRev, ranges, repository1);
        sRev = eRev;
        eRev = SVNRevision.create(rev2);
        range = new SVNRevisionRange(sRev, eRev);
        ranges.clear();
        ranges.add(range);
        repository2.setLocation(url2, false);
        addSources = this.normalizeMergeSources(SvnTarget.fromURL(url2), url2, sourceReposRoot, eRev, ranges, repository2);
        SvnConflictReport conflictReport = null;
        MergeData mergeData = null;
        boolean sameRepos = sourceReposRoot.equals(wcReposRoot);
        Collection<File> modifiedSubtrees = null;
        if (!recordOnly) {
            MergeSource fauxSource = new MergeSource();
            fauxSource.url1 = url1;
            fauxSource.url2 = url2;
            fauxSource.rev1 = rev1;
            fauxSource.rev2 = rev2;
            LinkedList<MergeSource> fauxSources = new LinkedList<MergeSource>();
            fauxSources.add(fauxSource);
            mergeData = this.doMerge(null, fauxSources, targetWCPath, repository1, true, sameRepos, ignoreMergeInfo, ignoreAncestry, forceDelete, dryRun, false, null, true, false, depth, this.diffOptions);
            modifiedSubtrees = mergeData.modifiedSubtrees;
            conflictReport = mergeData.conflictReport;
            if (conflictReport != null && !conflictReport.wasLastRange()) {
                return mergeData;
            }
        } else if (!sameRepos) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Merge from foreign repository is not compatible with mergeinfo modification");
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if (sameRepos && !dryRun) {
            TreeMap<File, Map<String, SVNMergeRangeList>> addResultsCatalog = new TreeMap<File, Map<String, SVNMergeRangeList>>();
            TreeMap<File, Map<String, SVNMergeRangeList>> removeResultsCatalog = new TreeMap<File, Map<String, SVNMergeRangeList>>();
            if (this.context.getEventHandler() != null) {
                SVNEvent mergeStartedEvent = SVNEventFactory.createSVNEvent(this.targetAbsPath, SVNNodeKind.NONE, null, -1L, SVNStatusType.INAPPLICABLE, SVNStatusType.INAPPLICABLE, SVNStatusType.LOCK_INAPPLICABLE, SVNEventAction.MERGE_RECORD_INFO_BEGIN, null, null, null);
                this.context.getEventHandler().handleEvent(mergeStartedEvent, -1.0);
            }
            mergeData = this.doMerge(addResultsCatalog, addSources, targetWCPath, repository1, true, sameRepos, ignoreMergeInfo, ignoreAncestry, forceDelete, dryRun, true, modifiedSubtrees, true, true, depth, this.diffOptions);
            if (mergeData.conflictReport != null && mergeData.conflictReport.wasLastRange()) {
                return mergeData;
            }
            mergeData = this.doMerge(removeResultsCatalog, removeSources, targetWCPath, repository1, true, sameRepos, ignoreMergeInfo, ignoreAncestry, forceDelete, dryRun, true, modifiedSubtrees, true, true, depth, this.diffOptions);
            if (mergeData.conflictReport != null && mergeData.conflictReport.wasLastRange()) {
                return mergeData;
            }
            SVNMergeInfoUtil.mergeCatalog(addResultsCatalog, removeResultsCatalog);
            if (!addResultsCatalog.isEmpty()) {
                for (File file : addResultsCatalog.keySet()) {
                    Map mergeinfo = (Map)addResultsCatalog.get(file);
                    try {
                        this.recordMergeinfo(file, mergeinfo, true);
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_NOT_FOUND) continue;
                        throw e;
                    }
                }
            }
        }
        return mergeData;
    }

    public List<MergeSource> normalizeMergeSources(SvnTarget source2, SVNURL sourceURL, SVNURL sourceRootURL, SVNRevision pegRevision, Collection<SVNRevisionRange> rangesToMerge, SVNRepository repository) throws SVNException {
        Structure<SvnRepositoryAccess.RevisionsPair> pair = this.repositoryAccess.getRevisionNumber(repository, source2, pegRevision, null);
        long pegRevNum = pair.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
        if (pegRevNum < 0L) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        ArrayList<SVNMergeRange> mergeRanges = new ArrayList<SVNMergeRange>();
        for (SVNRevisionRange revRange : rangesToMerge) {
            long endRev;
            SVNRevision rangeStart = revRange.getStartRevision();
            SVNRevision rangeEnd = revRange.getEndRevision();
            if (!rangeStart.isValid() || !rangeEnd.isValid()) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_BAD_REVISION, "Not all required revisions are specified");
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            pair = this.repositoryAccess.getRevisionNumber(repository, source2, rangeStart, pair);
            long startRev = pair.lng(SvnRepositoryAccess.RevisionsPair.revNumber);
            if (startRev == (endRev = (pair = this.repositoryAccess.getRevisionNumber(repository, source2, rangeEnd, pair)).lng(SvnRepositoryAccess.RevisionsPair.revNumber))) continue;
            mergeRanges.add(new SVNMergeRange(startRev, endRev, true));
        }
        pair.release();
        if (mergeRanges.isEmpty()) {
            return Collections.emptyList();
        }
        long oldestRequested = -1L;
        long youngesRequested = -1L;
        for (SVNMergeRange mergeRange : mergeRanges) {
            long minRev = Math.min(mergeRange.getStartRevision(), mergeRange.getEndRevision());
            long maxRev = Math.max(mergeRange.getStartRevision(), mergeRange.getEndRevision());
            if (oldestRequested < 0L || minRev < oldestRequested) {
                oldestRequested = minRev;
            }
            if (youngesRequested >= 0L && maxRev <= youngesRequested) continue;
            youngesRequested = maxRev;
        }
        if (pegRevNum < youngesRequested) {
            this.repositoryAccess.getLocations(repository, SvnTarget.fromURL(sourceURL), SVNRevision.create(pegRevNum), SVNRevision.create(youngesRequested), SVNRevision.UNDEFINED);
            pegRevNum = youngesRequested;
        }
        List<SVNLocationSegment> segments = repository.getLocationSegments("", pegRevNum, youngesRequested, oldestRequested);
        long trimRevision = -1L;
        if (!segments.isEmpty()) {
            SVNLocationSegment segment = segments.get(0);
            if (segment.getStartRevision() != oldestRequested) {
                trimRevision = segment.getStartRevision();
            } else if (segment.getPath() == null && segments.size() > 1) {
                SVNLocationSegment segment2 = segments.get(1);
                SVNURL segmentURL = sourceRootURL.appendPath(segment2.getPath(), false);
                SVNLocationEntry copyFromLocation = this.repositoryAccess.getCopySource(SvnTarget.fromURL(segmentURL), SVNRevision.create(segment2.getStartRevision()));
                String copyFromPath = copyFromLocation.getPath();
                long copyFromRevision = copyFromLocation.getRevision();
                if (copyFromPath != null && SVNRevision.isValidRevisionNumber(copyFromRevision)) {
                    SVNLocationSegment newSegment = new SVNLocationSegment(copyFromRevision, copyFromRevision, copyFromPath);
                    segment.setStartRevision(copyFromRevision + 1L);
                    segments.add(0, newSegment);
                }
            }
        }
        SVNLocationSegment[] segmentsArray = segments.toArray(new SVNLocationSegment[segments.size()]);
        ArrayList<MergeSource> resultMergeSources = new ArrayList<MergeSource>();
        for (SVNMergeRange range : mergeRanges) {
            if (SVNRevision.isValidRevisionNumber(trimRevision)) {
                if (Math.max(range.getStartRevision(), range.getEndRevision()) < trimRevision) continue;
                if (range.getStartRevision() < trimRevision) {
                    range.setStartRevision(trimRevision);
                }
                if (range.getEndRevision() < trimRevision) {
                    range.setEndRevision(trimRevision);
                }
            }
            List<MergeSource> mergeSources = this.combineRangeWithSegments(range, segmentsArray, sourceRootURL);
            resultMergeSources.addAll(mergeSources);
        }
        return resultMergeSources;
    }

    private List<MergeSource> combineRangeWithSegments(SVNMergeRange range, SVNLocationSegment[] segments, SVNURL sourceRootURL) throws SVNException {
        long minRev = Math.min(range.getStartRevision(), range.getEndRevision()) + 1L;
        long maxRev = Math.max(range.getStartRevision(), range.getEndRevision());
        boolean subtractive = range.getStartRevision() > range.getEndRevision();
        ArrayList<MergeSource> mergeSources = new ArrayList<MergeSource>();
        for (int i2 = 0; i2 < segments.length; ++i2) {
            SVNLocationSegment segment = segments[i2];
            if (segment.getEndRevision() < minRev || segment.getStartRevision() > maxRev || segment.getPath() == null) continue;
            String path1 = null;
            long rev1 = Math.max(segment.getStartRevision(), minRev) - 1L;
            if (minRev <= segment.getStartRevision()) {
                if (i2 > 0) {
                    path1 = segments[i2 - 1].getPath();
                }
                if (path1 == null && i2 > 1) {
                    path1 = segments[i2 - 2].getPath();
                    rev1 = segments[i2 - 2].getEndRevision();
                }
            } else {
                path1 = segment.getPath();
            }
            if (path1 == null || segment.getPath() == null) continue;
            MergeSource mergeSource = new MergeSource();
            mergeSource.url1 = sourceRootURL.appendPath(path1, false);
            mergeSource.url2 = sourceRootURL.appendPath(segment.getPath(), false);
            mergeSource.rev1 = rev1;
            mergeSource.rev2 = Math.min(segment.getEndRevision(), maxRev);
            if (subtractive) {
                long tmpRev = mergeSource.rev1;
                SVNURL tmpURL = mergeSource.url1;
                mergeSource.rev1 = mergeSource.rev2;
                mergeSource.url1 = mergeSource.url2;
                mergeSource.rev2 = tmpRev;
                mergeSource.url2 = tmpURL;
            }
            mergeSource.ancestral = true;
            mergeSources.add(mergeSource);
        }
        if (subtractive && !mergeSources.isEmpty()) {
            Collections.sort(mergeSources, new Comparator<MergeSource>(){

                @Override
                public int compare(MergeSource o1, MergeSource o2) {
                    MergeSource source1 = o1;
                    MergeSource source2 = o2;
                    long src1Rev1 = source1.rev1;
                    long src2Rev1 = source2.rev1;
                    if (src1Rev1 == src2Rev1) {
                        return 0;
                    }
                    return src1Rev1 < src2Rev1 ? 1 : -1;
                }
            });
        }
        return mergeSources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MergeData doMerge(Map<File, Map<String, SVNMergeRangeList>> resultCatalog, List<MergeSource> mergeSources, File targetAbsPath, SVNRepository sourceRepository, boolean sourcesRelated, boolean sameRepository, boolean ignoreMergeInfo, boolean diffIgnoreAncestry, boolean forceDelete, boolean dryRun, boolean recordOnly, Collection<File> recordOnlyPaths, boolean reintegrateMerge, boolean squelcheMergeInfoNotifications, SVNDepth depth, SVNDiffOptions diffOptions) throws SVNException {
        MergeData result = new MergeData();
        if (recordOnly) {
            SVNErrorMessage err;
            boolean sourcesAncestral = true;
            for (MergeSource mergeSource : mergeSources) {
                if (mergeSource.ancestral) continue;
                sourcesAncestral = false;
                break;
            }
            if (!sourcesAncestral) {
                err = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Use of two URLs is not compatible with mergeinfo modification");
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            if (!sameRepository) {
                err = SVNErrorMessage.create(SVNErrorCode.INCORRECT_PARAMS, "Merge from foreign repository is not compatible with mergeinfo modification");
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            if (dryRun) {
                return result;
            }
        }
        if (depth == SVNDepth.UNKNOWN) {
            depth = SVNDepth.INFINITY;
        }
        this.forceDelete = forceDelete;
        this.dryRun = dryRun;
        this.recordOnly = recordOnly;
        this.ignoreMergeInfo = ignoreMergeInfo;
        this.diffIgnoreAncestry = diffIgnoreAncestry;
        this.sameRepos = sameRepository;
        this.mergeinfoCapable = false;
        this.sourcesAncestral = this.sourcesAncestral;
        this.targetMissingChild = false;
        this.reintegrateMerge = reintegrateMerge;
        this.targetAbsPath = targetAbsPath;
        this.diffOptions = diffOptions;
        this.notifications = 0;
        this.operativeNotifications = 0;
        this.mergedPaths = recordOnly && recordOnlyPaths != null ? recordOnlyPaths : null;
        this.skippedPaths = null;
        this.addedPaths = null;
        this.treeConflictedPaths = null;
        this.singleFileMerge = false;
        this.currentAncestorIndex = -1;
        SvnNgMergeCallback2 mergeProcessor = new SvnNgMergeCallback2(this.context, this, this.repositoryAccess);
        SVNRepository repository1 = null;
        SVNRepository repository2 = null;
        SVNURL oldSrcReposUrl = null;
        if (sourceRepository != null) {
            oldSrcReposUrl = sourceRepository.getLocation();
            repository1 = sourceRepository;
        }
        boolean checkedMergeInfoCapability = false;
        result.modifiedSubtrees = new HashSet<File>();
        for (int i2 = 0; i2 < mergeSources.size(); ++i2) {
            MergeSource mergeSource = mergeSources.get(i2);
            SVNURL url1 = mergeSource.url1;
            SVNURL url2 = mergeSource.url2;
            long revision1 = mergeSource.rev1;
            long revision2 = mergeSource.rev2;
            if (revision1 == revision2 && mergeSource.url1.equals(mergeSource.url2)) continue;
            try {
                boolean conflictsRemain;
                this.repos1 = this.ensureRepository(repository1, url1);
                this.repos2 = this.ensureRepository(repository2, url2);
                this.reposRootUrl = this.repos1.getRepositoryRoot(true);
                this.mergeSource = mergeSource;
                this.implicitSrcGap = null;
                this.conflictedPaths = null;
                this.pathsWithDeletedMergeInfo = null;
                this.pathsWithNewMergeInfo = null;
                if (!checkedMergeInfoCapability) {
                    this.mergeinfoCapable = this.repos1.hasCapability(SVNCapability.MERGE_INFO);
                    checkedMergeInfoCapability = true;
                }
                repository1 = this.repos1;
                repository2 = this.repos2;
                SVNNodeKind src1Kind = repository1.checkPath("", mergeSource.rev1);
                SvnSingleRangeConflictReport conflictedRangeReport = null;
                while ((conflictedRangeReport = src1Kind != SVNNodeKind.DIR ? this.doFileMerge(targetAbsPath, resultCatalog, mergeSource, mergeProcessor, sourcesRelated, squelcheMergeInfoNotifications) : this.doDirectoryMerge(resultCatalog, mergeSource, targetAbsPath, this.reposRootUrl, mergeProcessor, depth, squelcheMergeInfoNotifications)) != null && this.context.getOptions().getConflictResolver() != null && !dryRun && !(conflictsRemain = this.resolveConflicts(this.conflictedPaths))) {
                    this.conflictedPaths = null;
                    mergeSource = conflictedRangeReport.getRemainingSource();
                    conflictedRangeReport = null;
                    if (mergeSource != null) continue;
                }
                if (!dryRun) {
                    SvnNgMergeinfoUtil.elideMergeInfo(this.context, this.repos1, targetAbsPath, null);
                }
                if (conflictedRangeReport == null) continue;
                result.conflictReport = new SvnConflictReport(targetAbsPath, conflictedRangeReport.getConflictedRange(), i2 == mergeSources.size() - 1 && conflictedRangeReport.getRemainingSource() == null);
                break;
            }
            finally {
                if (this.repos1 != null) {
                    this.repos1.closeSession();
                }
                if (this.repos2 != null) {
                    this.repos2.closeSession();
                }
            }
        }
        if (this.addedPaths != null) {
            result.modifiedSubtrees.addAll(this.addedPaths);
        }
        if (this.mergedPaths != null) {
            result.modifiedSubtrees.addAll(this.mergedPaths);
        }
        if (this.treeConflictedPaths != null) {
            result.modifiedSubtrees.addAll(this.treeConflictedPaths);
        }
        if (this.skippedPaths != null) {
            result.modifiedSubtrees.addAll(this.skippedPaths);
        }
        if (sourceRepository != null) {
            sourceRepository.setLocation(oldSrcReposUrl, false);
        }
        result.useSleep = this.useSleep;
        return result;
    }

    protected SvnSingleRangeConflictReport doMergeInfoAwareDirectoryMerge(Map<File, Map<String, SVNMergeRangeList>> resultCatalog, MergeSource source2, File targetPath, SVNURL sourceRootUrl, Map<File, MergePath> childrenWithMergeInfo, SVNDepth depth, boolean squelchMergeinfoNotifications, ISvnDiffCallback2 processor) throws SVNException {
        boolean isRollback;
        boolean bl = isRollback = source2.rev1 > source2.rev2;
        assert (source2.ancestral);
        SvnSingleRangeConflictReport conflictReport = null;
        SVNRepository repository = isRollback ? this.repos1 : this.repos2;
        SVNURL primaryURL = isRollback ? source2.url1 : source2.url2;
        this.getMergeInfoPaths(childrenWithMergeInfo, this.targetAbsPath, depth, this.dryRun, this.sameRepos);
        MergePath targetMergePath = childrenWithMergeInfo.entrySet().iterator().next().getValue();
        this.populateRemainingRanges(childrenWithMergeInfo, sourceRootUrl, source2.url1, source2.rev1, source2.url2, source2.rev2, true, repository, this.getPathRelativeToRoot(primaryURL, sourceRootUrl, null));
        SVNMergeRange range = new SVNMergeRange(source2.rev1, source2.rev2, true);
        if (!this.reintegrateMerge) {
            long newRangeStart = this.getMostInclusiveStartRevision(childrenWithMergeInfo, isRollback);
            if (SVNRevision.isValidRevisionNumber(newRangeStart)) {
                range.setStartRevision(newRangeStart);
            }
            if (!isRollback) {
                this.removeNoOpSubtreeRanges(source2.url1, source2.rev1, source2.url2, source2.rev2, this.targetAbsPath, repository, childrenWithMergeInfo);
            }
            this.fixDeletedSubtreeRanges(source2.url1, source2.rev1, source2.url2, source2.rev2, repository, childrenWithMergeInfo);
            long startRev = this.getMostInclusiveStartRevision(childrenWithMergeInfo, isRollback);
            if (SVNRevision.isValidRevisionNumber(startRev)) {
                long endRev = this.getMostInclusiveEndRevision(childrenWithMergeInfo, isRollback);
                while (endRev != -1L) {
                    SVNMergeRange firstTargetRange;
                    SVNMergeRange sVNMergeRange = firstTargetRange = targetMergePath.remainingRanges.getSize() == 0 ? null : targetMergePath.remainingRanges.getRanges()[0];
                    if (firstTargetRange != null && startRev != firstTargetRange.getStartRevision()) {
                        if (isRollback) {
                            if (endRev < firstTargetRange.getStartRevision()) {
                                endRev = firstTargetRange.getStartRevision();
                            }
                        } else if (endRev > firstTargetRange.getStartRevision()) {
                            endRev = firstTargetRange.getStartRevision();
                        }
                    }
                    this.sliceRemainingRanges(childrenWithMergeInfo, isRollback, endRev);
                    this.notifyBegin.lastAbsPath = null;
                    MergeSource realSource = source2.subrange(startRev, endRev);
                    this.driveMergeReportEditor(this.targetAbsPath, realSource, childrenWithMergeInfo, processor, depth);
                    this.processChildrenWithNewMergeInfo(childrenWithMergeInfo);
                    this.removeChildrenWithDeletedMergeInfo(childrenWithMergeInfo);
                    this.removeFirstRangeFromRemainingRanges(endRev, childrenWithMergeInfo);
                    if (this.conflictedPaths != null && this.conflictedPaths.size() > 0) {
                        MergeSource remainingRange = null;
                        if (realSource.rev2 != source2.rev2) {
                            remainingRange = source2.subrange(realSource.rev2, source2.rev2);
                        }
                        conflictReport = new SvnSingleRangeConflictReport(realSource, remainingRange);
                        range.setEndRevision(endRev);
                        break;
                    }
                    startRev = this.getMostInclusiveStartRevision(childrenWithMergeInfo, isRollback);
                    endRev = this.getMostInclusiveEndRevision(childrenWithMergeInfo, isRollback);
                }
            }
        } else if (!this.recordOnly) {
            this.notifyBegin.lastAbsPath = null;
            this.driveMergeReportEditor(this.targetAbsPath, source2.url1, source2.rev1, source2.url2, source2.rev2, null, depth, processor);
        }
        if (this.isRecordMergeInfo()) {
            SVNURL primarySrcUrl = isRollback ? source2.url1 : source2.url2;
            long primarySrcRev = isRollback ? source2.rev1 : source2.rev2;
            String mergeInfoPath = this.getPathRelativeToRoot(primaryURL, this.reposRootUrl, null);
            this.recordMergeInfoForDirectoryMerge(resultCatalog, range, mergeInfoPath, depth, squelchMergeinfoNotifications, childrenWithMergeInfo);
            if (range.getStartRevision() < range.getEndRevision()) {
                this.recordMergeInfoForAddedSubtrees(range, mergeInfoPath, depth, squelchMergeinfoNotifications, childrenWithMergeInfo);
            }
        }
        return conflictReport;
    }

    protected SvnSingleRangeConflictReport doMergeInfoUnawareDirectoryMerge(MergeSource source2, File targetPath, Map<File, MergePath> childrenWithMergeInfo, SVNDepth depth) throws SVNException {
        boolean isRollBack = source2.rev1 > source2.rev2;
        MergePath item = new MergePath(targetPath);
        SVNMergeRange itemRange = new SVNMergeRange(source2.rev1, source2.rev2, true);
        item.remainingRanges = new SVNMergeRangeList(itemRange);
        if (childrenWithMergeInfo == null) {
            childrenWithMergeInfo = new TreeMap<File, MergePath>();
        }
        childrenWithMergeInfo.put(targetPath, item);
        SvnNgMergeCallback2 mergeCallback = new SvnNgMergeCallback2(this.context, this, this.repositoryAccess);
        this.driveMergeReportEditor(targetPath, source2.url1, source2.rev1, source2.url2, source2.rev2, childrenWithMergeInfo, depth, mergeCallback);
        if (this.conflictedPaths != null && this.conflictedPaths.size() > 0) {
            return new SvnSingleRangeConflictReport(source2, null);
        }
        return null;
    }

    private SvnSingleRangeConflictReport doFileMerge(File targetAbsPath, Map<File, Map<String, SVNMergeRangeList>> resultCatalog, MergeSource source2, ISvnDiffCallback2 mergeProcessor, boolean sourcesRelated, boolean squelcheMergeInfoNotifications) throws SVNException {
        SVNMergeRangeList filteredRangeList;
        SvnSingleRangeConflictReport conflictReport = null;
        this.singleFileMerge = true;
        SVNURL targetURL = this.context.getNodeUrl(targetAbsPath);
        SVNMergeRange range = new SVNMergeRange(source2.rev1, source2.rev2, true);
        boolean isRollback = source2.rev1 > source2.rev2;
        SVNURL primaryURL = isRollback ? source2.url1 : source2.url2;
        SVNMergeRangeList remainingRanges = null;
        String mergeInfoPath = null;
        MergePath mergeTarget = new MergePath(targetAbsPath);
        boolean[] inherited = new boolean[1];
        Map<String, SVNMergeRangeList> targetMergeInfo = null;
        Object oldRepositoryUrl = null;
        assert (SVNFileUtil.isAbsolute(targetAbsPath));
        if (this.isHonorMergeInfo()) {
            SVNURL sourceReposRootURL = this.repos1.getRepositoryRoot(true);
            mergeInfoPath = this.getPathRelativeToRoot(primaryURL, sourceReposRootURL, this.repos1);
            try {
                Map<String, SVNMergeRangeList>[] mis = this.getFullMergeInfo(true, true, inherited, SVNMergeInfoInheritance.INHERITED, this.repos1, targetAbsPath, Math.max(source2.rev1, source2.rev2), Math.min(source2.rev1, source2.rev2));
                mergeTarget.implicitMergeInfo = mis[1];
                targetMergeInfo = mis[0];
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.MERGE_INFO_PARSE_ERROR) {
                    SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_MERGEINFO_NO_MERGETRACKING, "Invalid mergeinfo detected on merge target ''{0}'', merge tracking not possible", targetAbsPath, e);
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                }
                throw e;
            }
            if (!this.recordOnly) {
                this.repos1.setLocation(source2.url1, false);
                this.calculateRemainingRanges(null, mergeTarget, sourceReposRootURL, source2.url1, source2.rev1, source2.url2, source2.rev2, targetMergeInfo, this.implicitSrcGap, false, false, this.repos1);
                remainingRanges = mergeTarget.remainingRanges;
                if (remainingRanges.getSize() > 0) {
                    SVNMergeRange[] ranges = remainingRanges.getRanges();
                    SVNMergeRange adjStartRange = ranges[0];
                    SVNMergeRange adjEndRange = ranges[ranges.length - 1];
                    range.setStartRevision(adjStartRange.getStartRevision());
                    range.setEndRevision(adjEndRange.getEndRevision());
                }
            }
        }
        if (this.recordOnly || !this.isHonorMergeInfo()) {
            remainingRanges = new SVNMergeRangeList(range);
        }
        Object conflictedRange = null;
        if (!this.recordOnly) {
            SVNMergeRangeList rangesToMerge = remainingRanges;
            File targetRelPath = SVNFileUtil.createFilePath("");
            MergePath targetInfo = null;
            if (source2.ancestral) {
                if (remainingRanges.getSize() > 1) {
                    SVNURL oldUrl = SvnNgMergeDriver.ensureSessionURL(this.repos1, primaryURL);
                    rangesToMerge = this.removeNoOpMergeRanges(this.repos1, remainingRanges);
                    if (oldUrl != null) {
                        this.repos1.setLocation(oldUrl, false);
                    }
                }
                TreeMap<File, MergePath> childWithMergeInfo = new TreeMap<File, MergePath>();
                targetInfo = new MergePath(mergeTarget.absPath);
                targetInfo.remainingRanges = rangesToMerge;
                childWithMergeInfo.put(mergeTarget.absPath, targetInfo);
                this.notifyBegin.nodesWithMergeInfo = childWithMergeInfo;
            }
            SVNMergeRange[] ranges = rangesToMerge.getRanges();
            ArrayList<SVNMergeRange> rangesToMergeList = new ArrayList<SVNMergeRange>(Arrays.asList(ranges));
            Iterator iterator2 = rangesToMergeList.iterator();
            while (iterator2.hasNext()) {
                SVNMergeRange r = (SVNMergeRange)iterator2.next();
                this.notifyBegin.lastAbsPath = null;
                MergeSource realSource = source2.ancestral ? source2.subrange(r.getStartRevision(), r.getEndRevision()) : source2;
                SingleFileMergeData singleFileMergeData1 = this.singleFileMergeGetFile(this.repos1, realSource.url1, realSource.rev1, targetAbsPath);
                File leftFile = singleFileMergeData1.file;
                SVNProperties leftProperties = singleFileMergeData1.properties;
                SingleFileMergeData singleFileMergeData2 = this.singleFileMergeGetFile(this.repos2, realSource.url2, realSource.rev2, targetAbsPath);
                File rightFile = singleFileMergeData2.file;
                SVNProperties rightProperties = singleFileMergeData2.properties;
                SvnDiffSource leftSource = new SvnDiffSource(r.getStartRevision());
                SvnDiffSource rightSource = new SvnDiffSource(r.getEndRevision());
                SvnDiffCallbackResult result = new SvnDiffCallbackResult();
                if (!this.diffIgnoreAncestry && !sourcesRelated) {
                    boolean skip = false;
                    mergeProcessor.fileOpened(result, targetRelPath, leftSource, rightSource, null, true, null);
                    skip = result.skip;
                    Object dirBaton = result.newBaton;
                    result.reset();
                    if (!skip) {
                        mergeProcessor.fileDeleted(result, targetRelPath, leftSource, leftFile, leftProperties);
                        skip = result.skip;
                        result.reset();
                    }
                    mergeProcessor.fileOpened(result, targetRelPath, null, rightSource, null, true, dirBaton);
                    skip = result.skip;
                    result.reset();
                    if (!skip) {
                        mergeProcessor.fileAdded(result, targetRelPath, null, rightSource, null, rightFile, null, rightProperties);
                        skip = result.skip;
                        result.reset();
                    }
                } else {
                    SVNProperties propChanges = leftProperties.compareTo(rightProperties);
                    mergeProcessor.fileOpened(result, targetRelPath, leftSource, rightSource, null, false, null);
                    boolean skip = result.skip;
                    result.reset();
                    if (!skip) {
                        mergeProcessor.fileChanged(result, targetRelPath, leftSource, rightSource, leftFile, rightFile, leftProperties, rightProperties, true, propChanges);
                        result.reset();
                    }
                }
                if (this.conflictedPaths != null && this.conflictedPaths.size() > 0) {
                    MergeSource remainingRange = null;
                    if (realSource.rev2 != this.mergeSource.rev2) {
                        remainingRange = this.mergeSource.subrange(realSource.rev2, this.mergeSource.rev2);
                    }
                    conflictReport = new SvnSingleRangeConflictReport(realSource, remainingRange);
                    range.setEndRevision(r.getEndRevision());
                    break;
                }
                iterator2.remove();
                if (targetInfo == null || targetInfo.absPath != mergeTarget.absPath || targetInfo.remainingRanges == null) continue;
                SVNMergeRange[] resultingRanges = new SVNMergeRange[targetInfo.remainingRanges.getSize() - 1];
                System.arraycopy(targetInfo.remainingRanges.getRanges(), 1, resultingRanges, 0, resultingRanges.length);
                targetInfo.remainingRanges = new SVNMergeRangeList(resultingRanges);
            }
            this.notifyBegin.lastAbsPath = null;
        }
        if (this.isRecordMergeInfo() && remainingRanges.getSize() > 0 && !(filteredRangeList = this.filterNaturalHistoryFromMergeInfo(mergeInfoPath, mergeTarget.implicitMergeInfo, range)).isEmpty() && (this.skippedPaths == null || this.skippedPaths.isEmpty())) {
            TreeMap<File, SVNMergeRangeList> merges = new TreeMap<File, SVNMergeRangeList>();
            if (inherited[0]) {
                this.recordMergeinfo(targetAbsPath, targetMergeInfo, false);
            }
            merges.put(targetAbsPath, filteredRangeList);
            if (!squelcheMergeInfoNotifications) {
                long[] revs = SVNMergeInfoUtil.getRangeEndPoints(merges);
                SVNMergeRange r = new SVNMergeRange(revs[1], revs[0], true);
                SVNEvent mergeBeginEvent = SVNEventFactory.createSVNEvent(targetAbsPath, SVNNodeKind.FILE, null, -1L, SVNEventAction.MERGE_RECORD_INFO_BEGIN, null, null, r);
                if (this.context.getEventHandler() != null) {
                    this.context.getEventHandler().handleEvent(mergeBeginEvent, -1.0);
                }
            }
            this.updateWCMergeInfo(resultCatalog, targetAbsPath, mergeInfoPath, merges, isRollback);
        }
        this.notifyBegin.nodesWithMergeInfo = null;
        return conflictReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SingleFileMergeData singleFileMergeGetFile(SVNRepository repository, SVNURL url, long revision, File wcTarget) throws SVNException {
        SingleFileMergeData result = new SingleFileMergeData();
        result.file = SVNFileUtil.createUniqueFile(this.context.getDb().getWCRootTempDir(wcTarget), "merge", "", false);
        SVNURL oldUrl = SvnNgMergeDriver.ensureSessionURL(repository, url);
        OutputStream outputStream2 = null;
        try {
            outputStream2 = SVNFileUtil.openFileForWriting(result.file);
            result.properties = new SVNProperties();
            repository.getFile("", revision, result.properties, outputStream2);
            SingleFileMergeData singleFileMergeData = result;
            return singleFileMergeData;
        }
        finally {
            SVNFileUtil.closeFile(outputStream2);
            if (oldUrl != null) {
                repository.setLocation(oldUrl, false);
            }
        }
    }

    protected SvnSingleRangeConflictReport doDirectoryMerge(Map<File, Map<String, SVNMergeRangeList>> resultCatalog, MergeSource source2, File targetAbsPath, SVNURL sourceRootUrl, ISvnDiffCallback2 processor, SVNDepth depth, boolean squelchMergeinfoNotifications) throws SVNException {
        TreeMap<File, MergePath> childrenWithMergeInfo = new TreeMap<File, MergePath>(PATH_COMPARATOR);
        this.notifyBegin.nodesWithMergeInfo = childrenWithMergeInfo;
        SvnSingleRangeConflictReport svnSingleRangeConflictReport = this.isHonorMergeInfo() ? this.doMergeInfoAwareDirectoryMerge(resultCatalog, source2, targetAbsPath, sourceRootUrl, childrenWithMergeInfo, depth, squelchMergeinfoNotifications, processor) : this.doMergeInfoUnawareDirectoryMerge(source2, targetAbsPath, childrenWithMergeInfo, depth);
        this.notifyBegin.nodesWithMergeInfo = null;
        return svnSingleRangeConflictReport;
    }

    private void removeNoOpSubtreeRanges(SVNURL url1, long revision1, SVNURL url2, long revision2, File targetAbsPath, SVNRepository repository, Map<File, MergePath> childrenWithMergeInfo) throws SVNException {
        if (revision1 > revision2) {
            return;
        }
        if (childrenWithMergeInfo.size() < 2) {
            return;
        }
        Iterator<MergePath> mps = childrenWithMergeInfo.values().iterator();
        MergePath rootPath = mps.next();
        SVNMergeRangeList requestedRanges = new SVNMergeRangeList(new SVNMergeRange(Math.min(revision1, revision2), Math.max(revision1, revision2), true));
        SVNMergeRangeList subtreeGapRanges = requestedRanges.remove(rootPath.remainingRanges, false);
        if (subtreeGapRanges.isEmpty()) {
            return;
        }
        SVNMergeRangeList subtreeRemainingRanges = new SVNMergeRangeList(new SVNMergeRange[0]);
        while (mps.hasNext()) {
            MergePath child = mps.next();
            if (child.remainingRanges == null || child.remainingRanges.isEmpty()) continue;
            subtreeRemainingRanges = subtreeRemainingRanges.merge(child.remainingRanges);
        }
        if (subtreeRemainingRanges.isEmpty()) {
            return;
        }
        if ((subtreeGapRanges = subtreeGapRanges.intersect(subtreeRemainingRanges, false)).isEmpty()) {
            return;
        }
        SVNMergeRange oldestGapRev = subtreeGapRanges.getRanges()[0];
        SVNMergeRange youngestRev = subtreeGapRanges.getRanges()[subtreeGapRanges.getSize() - 1];
        SVNURL reposRootURL = this.context.getNodeReposInfo((File)targetAbsPath).reposRootUrl;
        NoopLogHandler logHandler = new NoopLogHandler();
        logHandler.sourceReposAbsPath = this.getPathRelativeToRoot(url2, reposRootURL, null);
        logHandler.mergedRanges = new SVNMergeRangeList(new SVNMergeRange[0]);
        logHandler.operativeRanges = new SVNMergeRangeList(new SVNMergeRange[0]);
        logHandler.childrenWithMergeInfo = childrenWithMergeInfo;
        repository.log(new String[]{""}, oldestGapRev.getStartRevision() + 1L, youngestRev.getEndRevision(), true, true, -1L, false, null, logHandler);
        SVNMergeRangeList inoperativeRanges = new SVNMergeRangeList(oldestGapRev.getStartRevision(), youngestRev.getEndRevision(), true);
        inoperativeRanges = inoperativeRanges.remove(logHandler.operativeRanges, false);
        logHandler.mergedRanges = logHandler.mergedRanges.merge(inoperativeRanges);
        Iterator<MergePath> iterator2 = childrenWithMergeInfo.values().iterator();
        if (iterator2.hasNext()) {
            iterator2.next();
        }
        while (iterator2.hasNext()) {
            MergePath child = iterator2.next();
            if (child.remainingRanges == null || child.remainingRanges.isEmpty()) continue;
            child.remainingRanges = child.remainingRanges.remove(logHandler.mergedRanges, false);
        }
    }

    private void driveMergeReportEditor(File targetAbsPath, MergeSource source2, Map<File, MergePath> childrenWithMergeInfo, ISvnDiffCallback2 processor, SVNDepth depth) throws SVNException {
        this.driveMergeReportEditor(targetAbsPath, source2.url1, source2.rev1, source2.url2, source2.rev2, childrenWithMergeInfo, depth, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SvnNgRemoteMergeEditor driveMergeReportEditor(File targetWCPath, SVNURL url1, long revision1, SVNURL url2, final long revision2, final Map<File, MergePath> childrenWithMergeInfo, SVNDepth depth, ISvnDiffCallback2 mergeCallback) throws SVNException {
        boolean isRollBack;
        final boolean honorMergeInfo = this.isHonorMergeInfo();
        long targetStart = revision1;
        boolean bl = isRollBack = revision1 > revision2;
        if (honorMergeInfo) {
            targetStart = revision2;
            if (childrenWithMergeInfo != null && !childrenWithMergeInfo.isEmpty()) {
                MergePath targetMergePath = childrenWithMergeInfo.values().iterator().next();
                SVNMergeRangeList remainingRanges = targetMergePath.remainingRanges;
                if (remainingRanges != null && !remainingRanges.isEmpty()) {
                    SVNMergeRange[] ranges = remainingRanges.getRanges();
                    SVNMergeRange range = ranges[0];
                    targetStart = !isRollBack && range.getStartRevision() > revision2 || isRollBack && range.getStartRevision() < revision2 ? revision2 : range.getStartRevision();
                }
            }
        }
        SVNURL oldURL1 = SvnNgMergeDriver.ensureSessionURL(this.repos1, url1);
        SvnNgRemoteMergeEditor editor = new SvnNgRemoteMergeEditor(targetWCPath, this.context, this.repos2, revision1, mergeCallback, true);
        SVNURL oldURL2 = SvnNgMergeDriver.ensureSessionURL(this.repos2, url1);
        try {
            final SVNDepth reportDepth = depth;
            final long reportStart = targetStart;
            final String targetPath = targetWCPath.getAbsolutePath().replace(File.separatorChar, '/');
            this.repos1.diff(url2, revision2, revision2, null, this.diffIgnoreAncestry, depth, true, new ISVNReporterBaton(){

                @Override
                public void report(ISVNReporter reporter) throws SVNException {
                    reporter.setPath("", null, reportStart, reportDepth, false);
                    if (honorMergeInfo && childrenWithMergeInfo != null) {
                        Object[] childrenWithMergeInfoArray = childrenWithMergeInfo.values().toArray();
                        for (int i2 = 0; i2 < childrenWithMergeInfoArray.length; ++i2) {
                            MergePath childMergePath = (MergePath)childrenWithMergeInfoArray[i2];
                            MergePath parent = null;
                            if (childMergePath == null || childMergePath.absent) continue;
                            int parentIndex = SvnNgMergeDriver.findNearestAncestor(childrenWithMergeInfoArray, false, childMergePath.absPath);
                            if (parentIndex >= 0 && parentIndex < childrenWithMergeInfoArray.length) {
                                parent = (MergePath)childrenWithMergeInfoArray[parentIndex];
                            }
                            SVNMergeRange range = null;
                            if (childMergePath.remainingRanges != null && !childMergePath.remainingRanges.isEmpty()) {
                                SVNMergeRangeList remainingRangesList = childMergePath.remainingRanges;
                                SVNMergeRange[] remainingRanges = remainingRangesList.getRanges();
                                range = remainingRanges[0];
                                if (!isRollBack && range.getStartRevision() > revision2 || isRollBack && range.getStartRevision() < revision2) continue;
                                if (parent.remainingRanges != null && !parent.remainingRanges.isEmpty()) {
                                    SVNMergeRange parentRange = parent.remainingRanges.getRanges()[0];
                                    SVNMergeRange childRange = childMergePath.remainingRanges.getRanges()[0];
                                    if (parentRange.getStartRevision() == childRange.getStartRevision()) {
                                        continue;
                                    }
                                }
                            } else if (parent.remainingRanges == null || parent.remainingRanges.isEmpty()) continue;
                            String childPath = childMergePath.absPath.getAbsolutePath();
                            String relChildPath = (childPath = childPath.replace(File.separatorChar, '/')).substring(targetPath.length());
                            if (relChildPath.startsWith("/")) {
                                relChildPath = relChildPath.substring(1);
                            }
                            if (childMergePath.remainingRanges == null || childMergePath.remainingRanges.isEmpty() || isRollBack && range.getStartRevision() < revision2 || !isRollBack && range.getStartRevision() > revision2) {
                                reporter.setPath(relChildPath, null, revision2, reportDepth, false);
                                continue;
                            }
                            reporter.setPath(relChildPath, null, range.getStartRevision(), reportDepth, false);
                        }
                    }
                    reporter.finishReport();
                }
            }, SVNCancellableEditor.newInstance(editor, this.operation.getCanceller(), SVNDebugLog.getDefaultLog()));
        }
        finally {
            if (oldURL1 != null) {
                this.repos1.setLocation(oldURL1, false);
            }
            if (oldURL2 != null) {
                this.repos2.setLocation(oldURL2, false);
            }
            editor.cleanup();
        }
        return editor;
    }

    protected boolean isHonorMergeInfo() {
        return this.mergeSource.ancestral && this.sameRepos && !this.diffIgnoreAncestry && this.mergeinfoCapable && !this.ignoreMergeInfo;
    }

    public boolean isRecordMergeInfo() {
        return !this.dryRun && this.isHonorMergeInfo();
    }

    protected static SVNURL ensureSessionURL(SVNRepository repository, SVNURL url) throws SVNException {
        SVNURL oldURL = repository.getLocation();
        if (url == null) {
            url = repository.getRepositoryRoot(true);
        }
        if (!url.equals(oldURL)) {
            repository.setLocation(url, false);
            return oldURL;
        }
        return oldURL;
    }

    protected static MergePath findNearestAncestor(Map<File, MergePath> childrenWithMergeInfo, boolean pathIsAncestor, File localAbsPath) {
        assert (childrenWithMergeInfo != null);
        for (Map.Entry<File, MergePath> entry : childrenWithMergeInfo.entrySet()) {
            MergePath child = entry.getValue();
            if (!SVNPathUtil.isAncestor(SVNFileUtil.getFilePath(child.absPath), SVNFileUtil.getFilePath(localAbsPath)) || !pathIsAncestor && child.absPath.equals(localAbsPath)) continue;
            return child;
        }
        return null;
    }

    protected static int findNearestAncestor(Object[] childrenWithMergeInfoArray, boolean pathIsOwnAncestor, File path) {
        if (childrenWithMergeInfoArray == null) {
            return 0;
        }
        int ancestorIndex = 0;
        for (int i2 = 0; i2 < childrenWithMergeInfoArray.length; ++i2) {
            String pathStr;
            MergePath child = (MergePath)childrenWithMergeInfoArray[i2];
            String childPath = child.absPath.getAbsolutePath().replace(File.separatorChar, '/');
            if (!SVNPathUtil.isAncestor(childPath, pathStr = path.getAbsolutePath().replace(File.separatorChar, '/')) || childPath.equals(pathStr) && !pathIsOwnAncestor) continue;
            ancestorIndex = i2;
        }
        return ancestorIndex;
    }

    private TreeMap<File, Map<String, SVNMergeRangeList>> getWcExplicitMergeInfoCatalog(File targetAbsPath, SVNDepth depth) throws SVNException {
        SvnGetProperties pg = this.operation.getOperationFactory().createGetProperties();
        final TreeMap subtreesWithMergeinfo = new TreeMap();
        pg.setDepth(depth);
        pg.setSingleTarget(SvnTarget.fromFile(targetAbsPath, SVNRevision.WORKING));
        pg.setRevision(SVNRevision.WORKING);
        pg.setReceiver(new ISvnObjectReceiver<SVNProperties>(){

            @Override
            public void receive(SvnTarget target, SVNProperties object) throws SVNException {
                String value = object.getStringValue("svn:mergeinfo");
                if (value != null) {
                    subtreesWithMergeinfo.put(target.getFile(), value);
                }
            }
        });
        pg.run();
        Map<File, File> externals = this.context.getDb().getExternalsDefinedBelow(targetAbsPath);
        TreeMap<File, Map<String, SVNMergeRangeList>> result = new TreeMap<File, Map<String, SVNMergeRangeList>>();
        for (Map.Entry entry : subtreesWithMergeinfo.entrySet()) {
            Map<String, SVNMergeRangeList> mergeRangeList;
            File wcPath;
            block3: {
                wcPath = (File)entry.getKey();
                String mergeInfoString = (String)entry.getValue();
                if (externals.containsKey(wcPath)) continue;
                mergeRangeList = null;
                try {
                    mergeRangeList = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(mergeInfoString), null);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage().getErrorCode() != SVNErrorCode.MERGE_INFO_PARSE_ERROR) break block3;
                    SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_MERGEINFO_NO_MERGETRACKING, "Invalid mergeinfo detected on ''{0}'', merge tracking not possible", wcPath, e);
                    SVNErrorManager.error(errorMessage, SVNLogType.WC);
                }
            }
            result.put(wcPath, mergeRangeList);
        }
        return result;
    }

    private Map<File, MergePath> getMergeInfoPaths(Map<File, MergePath> childrenWithMergeInfo, final File targetAbsPath, SVNDepth depth, boolean dryRun, boolean sameRepos) throws SVNException {
        Collection<File> excludedTrees;
        TreeMap<File, Map<String, SVNMergeRangeList>> subtreesWithMergeInfo = this.getWcExplicitMergeInfoCatalog(targetAbsPath, depth);
        if (subtreesWithMergeInfo != null) {
            for (Map.Entry<File, Map<String, SVNMergeRangeList>> entry : subtreesWithMergeInfo.entrySet()) {
                File wcPath = entry.getKey();
                Map<String, SVNMergeRangeList> mergeInfoString = entry.getValue();
                MergePath mergeInfoChild = new MergePath(wcPath);
                mergeInfoChild.preMergeMergeInfo = mergeInfoString;
                mergeInfoChild.hasNonInheritable = SVNMergeInfoUtil.isNonInheritable(mergeInfoChild.preMergeMergeInfo);
                childrenWithMergeInfo.put(wcPath, mergeInfoChild);
            }
        }
        final HashMap shallowSubtrees = new HashMap();
        final HashSet missingSubtrees = new HashSet();
        final HashSet switchedSubtrees = new HashSet();
        SVNStatusEditor17 statusEditor = new SVNStatusEditor17(targetAbsPath, this.context, this.operation.getOptions(), true, true, depth, new ISvnObjectReceiver<SvnStatus>(){

            @Override
            public void receive(SvnTarget target, SvnStatus status) throws SVNException {
                boolean fileExternal;
                block8: {
                    fileExternal = false;
                    if (status.isVersioned() && status.isSwitched() && status.getKind() == SVNNodeKind.FILE) {
                        try {
                            Structure<StructureFields.ExternalNodeInfo> info = SvnWcDbExternals.readExternal(SvnNgMergeDriver.this.context, status.getPath(), targetAbsPath, StructureFields.ExternalNodeInfo.kind);
                            fileExternal = info.get(StructureFields.ExternalNodeInfo.kind) == ISVNWCDb.SVNWCDbKind.File;
                        }
                        catch (SVNException e) {
                            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) break block8;
                            throw e;
                        }
                    }
                }
                if (status.isSwitched() && !fileExternal) {
                    switchedSubtrees.add(status.getPath());
                }
                if (status.getDepth() == SVNDepth.EMPTY || status.getDepth() == SVNDepth.FILES) {
                    shallowSubtrees.put(status.getPath(), status.getDepth());
                }
                if (status.getNodeStatus() == SVNStatusType.STATUS_MISSING) {
                    boolean parentPresent = false;
                    for (File missingRoot : missingSubtrees) {
                        if (!SVNWCUtils.isAncestor(missingRoot, status.getPath())) continue;
                        parentPresent = true;
                        break;
                    }
                    if (!parentPresent) {
                        missingSubtrees.add(status.getPath());
                    }
                }
            }
        });
        statusEditor.walkStatus(targetAbsPath, depth, true, true, true, null);
        if (!missingSubtrees.isEmpty()) {
            Iterator errorMessage = new StringBuffer("Merge tracking not allowed with missing subtrees; try restoring these items first:\n");
            Object[] values2 = new Object[missingSubtrees.size()];
            int index = 0;
            for (File missingPath : missingSubtrees) {
                values2[index] = missingPath;
                ((StringBuffer)((Object)errorMessage)).append("{" + index + "}\n");
                ++index;
            }
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, ((StringBuffer)((Object)errorMessage)).toString(), values2);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (!switchedSubtrees.isEmpty()) {
            for (File switchedPath : switchedSubtrees) {
                MergePath child = this.getChildWithMergeinfo(childrenWithMergeInfo, switchedPath);
                if (child != null) {
                    child.switched = true;
                    continue;
                }
                child = new MergePath(switchedPath);
                child.switched = true;
                childrenWithMergeInfo.put(child.absPath, child);
            }
        }
        if (!shallowSubtrees.isEmpty()) {
            for (Object shallowPath : shallowSubtrees.keySet()) {
                MergePath child = this.getChildWithMergeinfo(childrenWithMergeInfo, (File)shallowPath);
                SVNDepth childDepth = (SVNDepth)shallowSubtrees.get(shallowPath);
                boolean newChild = false;
                if (child != null) {
                    if (childDepth == SVNDepth.EMPTY || childDepth == SVNDepth.FILES) {
                        child.missingChild = true;
                    }
                } else {
                    newChild = true;
                    child = new MergePath((File)shallowPath);
                    if (childDepth == SVNDepth.EMPTY || childDepth == SVNDepth.FILES) {
                        child.missingChild = true;
                    }
                }
                if (!(child.hasNonInheritable || childDepth != SVNDepth.EMPTY && childDepth != SVNDepth.FILES)) {
                    child.hasNonInheritable = true;
                }
                if (!newChild) continue;
                childrenWithMergeInfo.put(child.absPath, child);
            }
        }
        if ((excludedTrees = SvnWcDbReader.getServerExcludedNodes((SVNWCDb)this.context.getDb(), targetAbsPath)) != null && !excludedTrees.isEmpty()) {
            for (File excludedTree : excludedTrees) {
                MergePath mp = this.getChildWithMergeinfo(childrenWithMergeInfo, excludedTree);
                if (mp != null) {
                    mp.absent = true;
                    continue;
                }
                mp = new MergePath(excludedTree);
                mp.absent = true;
                childrenWithMergeInfo.put(mp.absPath, mp);
            }
        }
        if (this.getChildWithMergeinfo(childrenWithMergeInfo, targetAbsPath) == null) {
            childrenWithMergeInfo.put(targetAbsPath, new MergePath(targetAbsPath));
        }
        if (depth == SVNDepth.IMMEDIATES || depth == SVNDepth.FILES) {
            List<File> immediateChildren = this.context.getChildrenOfWorkingNode(targetAbsPath, false);
            for (File immeidateChild : immediateChildren) {
                SVNNodeKind childKind = this.context.readKind(immeidateChild, false);
                if ((childKind != SVNNodeKind.DIR || depth != SVNDepth.IMMEDIATES) && (childKind != SVNNodeKind.FILE || depth != SVNDepth.FILES) || this.getChildWithMergeinfo(childrenWithMergeInfo, immeidateChild) != null) continue;
                MergePath mp = new MergePath(immeidateChild);
                if (childKind == SVNNodeKind.DIR && depth == SVNDepth.IMMEDIATES) {
                    mp.immediateChildDir = true;
                }
                childrenWithMergeInfo.put(mp.absPath, mp);
            }
        }
        if (depth.compareTo(SVNDepth.EMPTY) <= 0) {
            return childrenWithMergeInfo;
        }
        for (File childPath : new TreeSet<File>(childrenWithMergeInfo.keySet())) {
            MergePath child = childrenWithMergeInfo.get(childPath);
            if (child.hasNonInheritable) {
                List<File> childrenOfNonInheritable = this.context.getNodeChildren(child.absPath, false);
                for (File childOfNonInheritable : childrenOfNonInheritable) {
                    SVNNodeKind childKind;
                    MergePath mpOfNonInheritable = this.getChildWithMergeinfo(childrenWithMergeInfo, childOfNonInheritable);
                    if (mpOfNonInheritable != null || depth == SVNDepth.FILES && (childKind = this.context.readKind(childOfNonInheritable, false)) != SVNNodeKind.FILE) continue;
                    mpOfNonInheritable = new MergePath(childOfNonInheritable);
                    mpOfNonInheritable.childOfNonInheritable = true;
                    childrenWithMergeInfo.put(mpOfNonInheritable.absPath, mpOfNonInheritable);
                    if (dryRun || !sameRepos) continue;
                    SvnNgMergeinfoUtil.SvnMergeInfoInfo info = SvnNgMergeinfoUtil.getWCMergeInfo(this.context, mpOfNonInheritable.absPath, targetAbsPath, SVNMergeInfoInheritance.NEAREST_ANCESTOR, false);
                    this.recordMergeinfo(childOfNonInheritable, info.mergeinfo, false);
                }
            }
            this.insertParentAndSiblingsOfAbsentDelSubtree(childrenWithMergeInfo, child, depth);
        }
        return childrenWithMergeInfo;
    }

    private void insertParentAndSiblingsOfAbsentDelSubtree(Map<File, MergePath> childrenWithMergeInfo, MergePath child, SVNDepth depth) throws SVNException {
        if (!(child.absent || child.switched && !this.targetAbsPath.equals(child.absPath))) {
            return;
        }
        File parentPath = SVNFileUtil.getParentFile(child.absPath);
        MergePath parentMp = this.getChildWithMergeinfo(childrenWithMergeInfo, parentPath);
        if (parentMp != null) {
            parentMp.missingChild = child.absent;
            parentMp.switchedChild = child.switched;
        } else {
            parentMp = new MergePath(parentPath);
            parentMp.missingChild = child.absent;
            parentMp.switchedChild = child.switched;
            childrenWithMergeInfo.put(parentPath, parentMp);
        }
        List<File> files = this.context.getNodeChildren(parentPath, false);
        for (File file : files) {
            MergePath siblingMp = this.getChildWithMergeinfo(childrenWithMergeInfo, file);
            if (siblingMp != null || depth == SVNDepth.FILES && this.context.readKind(file, false) != SVNNodeKind.FILE) continue;
            childrenWithMergeInfo.put(file, new MergePath(file));
        }
    }

    private MergePath getChildWithMergeinfo(Map<File, MergePath> childrenWithMergeInfo, File path) {
        return childrenWithMergeInfo.get(path);
    }

    private void populateRemainingRanges(Map<File, MergePath> childrenWithMergeInfo, SVNURL sourceRootURL, SVNURL url1, long revision1, SVNURL url2, long revision2, boolean honorMergeInfo, SVNRepository repository, String parentMergeSrcCanonPath) throws SVNException {
        if (!honorMergeInfo || this.recordOnly) {
            int index = 0;
            Object[] childrenWithMergeInfoArray = childrenWithMergeInfo.values().toArray();
            for (MergePath child : childrenWithMergeInfo.values()) {
                SVNMergeRange range = new SVNMergeRange(revision1, revision2, true);
                child.remainingRanges = new SVNMergeRangeList(range);
                if (index == 0) {
                    boolean[] indirect = new boolean[]{false};
                    Map<String, SVNMergeRangeList>[] mergeInfo = this.getFullMergeInfo(false, true, indirect, SVNMergeInfoInheritance.INHERITED, repository, child.absPath, Math.max(revision1, revision2), Math.min(revision1, revision2));
                    child.implicitMergeInfo = mergeInfo[1];
                } else {
                    int parentIndex = SvnNgMergeDriver.findNearestAncestor(childrenWithMergeInfoArray, false, child.absPath);
                    MergePath parent = (MergePath)childrenWithMergeInfoArray[parentIndex];
                    boolean childInheritsImplicit = parent != null && !child.switched;
                    this.ensureImplicitMergeinfo(parent, child, childInheritsImplicit, revision1, revision2, repository);
                }
                ++index;
            }
            return;
        }
        long[] gap = new long[2];
        this.findGapsInMergeSourceHistory(gap, parentMergeSrcCanonPath, url1, revision1, url2, revision2, repository);
        if (gap[0] >= 0L && gap[1] >= 0L) {
            this.implicitSrcGap = new SVNMergeRangeList(gap[0], gap[1], true);
        }
        int index = 0;
        for (MergePath child : childrenWithMergeInfo.values()) {
            Object[] childrenWithMergeInfoArray;
            int parentIndex;
            if (child == null || child.absent) {
                ++index;
                continue;
            }
            String childRelativePath = null;
            childRelativePath = this.targetAbsPath.equals(child.absPath) ? "" : SVNPathUtil.getRelativePath(this.targetAbsPath.getAbsolutePath(), child.absPath.getAbsolutePath());
            MergePath parent = null;
            SVNURL childURL1 = url1.appendPath(childRelativePath, false);
            SVNURL childURL2 = url2.appendPath(childRelativePath, false);
            boolean[] inherited = new boolean[]{false};
            Map<String, SVNMergeRangeList>[] mergeInfo = this.getFullMergeInfo(child.preMergeMergeInfo == null, index == 0, inherited, SVNMergeInfoInheritance.INHERITED, repository, child.absPath, Math.max(revision1, revision2), Math.min(revision1, revision2));
            if (child.preMergeMergeInfo == null) {
                child.preMergeMergeInfo = mergeInfo[0];
            }
            if (index == 0) {
                child.implicitMergeInfo = mergeInfo[1];
            }
            child.inheritedMergeInfo = inherited[0];
            if (index > 0 && (parentIndex = SvnNgMergeDriver.findNearestAncestor(childrenWithMergeInfoArray = childrenWithMergeInfo.values().toArray(), false, child.absPath)) >= 0 && parentIndex < childrenWithMergeInfoArray.length) {
                parent = (MergePath)childrenWithMergeInfoArray[parentIndex];
            }
            boolean childInheritsImplicit = parent != null && !child.switched;
            this.calculateRemainingRanges(parent, child, sourceRootURL, childURL1, revision1, childURL2, revision2, child.preMergeMergeInfo, this.implicitSrcGap, index > 0, childInheritsImplicit, repository);
            if (child.remainingRanges.getSize() > 0 && this.implicitSrcGap != null) {
                boolean properSubset = false;
                boolean equals = false;
                boolean overlapsOrAdjoins = false;
                if (revision1 > revision2) {
                    child.remainingRanges.reverse();
                }
                for (int j = 0; j < child.remainingRanges.getSize(); ++j) {
                    long start = child.remainingRanges.getRanges()[j].getStartRevision();
                    long end = child.remainingRanges.getRanges()[j].getEndRevision();
                    if (start <= gap[0] && gap[1] < end || start < gap[0] && gap[1] <= end) {
                        properSubset = true;
                        break;
                    }
                    if (gap[0] == start && gap[1] == end) {
                        equals = true;
                        break;
                    }
                    if (gap[0] > end || start > gap[1]) continue;
                    overlapsOrAdjoins = true;
                    break;
                }
                if (!properSubset) {
                    if (overlapsOrAdjoins) {
                        child.remainingRanges = child.remainingRanges.merge(this.implicitSrcGap);
                    } else if (equals) {
                        child.remainingRanges = child.remainingRanges.diff(this.implicitSrcGap, false);
                    }
                }
                if (revision1 > revision2) {
                    child.remainingRanges.reverse();
                }
            }
            ++index;
        }
    }

    protected Map<String, SVNMergeRangeList>[] getFullMergeInfo(boolean getRecorded, boolean getImplicit, boolean[] inherited, SVNMergeInfoInheritance inherit, SVNRepository repos, File target, long start, long end) throws SVNException {
        SvnNgMergeinfoUtil.SvnMergeInfoCatalogInfo catalog;
        Map[] result = new Map[2];
        SVNErrorManager.assertionFailure(SVNRevision.isValidRevisionNumber(start) && SVNRevision.isValidRevisionNumber(end) && start > end, null, SVNLogType.WC);
        if (getRecorded && (catalog = SvnNgMergeinfoUtil.getWcOrReposMergeInfoCatalog(this.context, repos, target, false, false, false, inherit)) != null) {
            result[0] = catalog.catalog != null ? catalog.catalog.values().iterator().next() : null;
            inherited[0] = catalog.inherited;
        }
        if (getImplicit) {
            File reposRelPath = null;
            SVNURL reposRootUrl = null;
            long targetRevision = -1L;
            Structure<StructureFields.NodeOriginInfo> originInfo = this.context.getNodeOrigin(target, false, StructureFields.NodeOriginInfo.revision, StructureFields.NodeOriginInfo.reposRelpath, StructureFields.NodeOriginInfo.reposRootUrl);
            reposRelPath = (File)originInfo.get(StructureFields.NodeOriginInfo.reposRelpath);
            reposRootUrl = (SVNURL)originInfo.get(StructureFields.NodeOriginInfo.reposRootUrl);
            targetRevision = originInfo.lng(StructureFields.NodeOriginInfo.revision);
            if (reposRelPath == null) {
                result[1] = new TreeMap();
            } else if (targetRevision <= end) {
                result[1] = new TreeMap();
            } else {
                SVNURL url = SVNWCUtils.join(reposRootUrl, reposRelPath);
                SVNURL sessionUrl = SvnNgMergeDriver.ensureSessionURL(repos, url);
                if (targetRevision < start) {
                    start = targetRevision;
                }
                result[1] = this.repositoryAccess.getHistoryAsMergeInfo(repos, SvnTarget.fromURL(url, SVNRevision.create(targetRevision)), start, end);
                SvnNgMergeDriver.ensureSessionURL(repos, sessionUrl);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map calculateImplicitMergeInfo(SVNRepository repos, SVNURL url, long[] targetRev, long start, long end) throws SVNException {
        Map<String, SVNMergeRangeList> implicitMergeInfo = null;
        boolean closeSession = false;
        SVNURL sessionURL = null;
        try {
            if (repos != null) {
                sessionURL = SvnNgMergeDriver.ensureSessionURL(repos, url);
            } else {
                repos = this.repositoryAccess.createRepository(url, null, false);
                closeSession = true;
            }
            if (targetRev[0] < start) {
                this.repositoryAccess.getLocations(repos, SvnTarget.fromURL(url), SVNRevision.create(targetRev[0]), SVNRevision.create(start), SVNRevision.UNDEFINED);
                targetRev[0] = start;
            }
            implicitMergeInfo = this.repositoryAccess.getHistoryAsMergeInfo(repos, SvnTarget.fromURL(url, SVNRevision.create(targetRev[0])), start, end);
            if (sessionURL != null) {
                repos.setLocation(sessionURL, false);
            }
        }
        finally {
            if (closeSession) {
                repos.closeSession();
            }
        }
        return implicitMergeInfo;
    }

    private void inheritImplicitMergeinfoFromParent(MergePath parent, MergePath child, long revision1, long revision2, SVNRepository repository) throws SVNException {
        if (parent.implicitMergeInfo == null) {
            Map<String, SVNMergeRangeList>[] mergeinfo = this.getFullMergeInfo(false, true, null, SVNMergeInfoInheritance.INHERITED, repository, parent.absPath, Math.max(revision1, revision2), Math.min(revision1, revision2));
            parent.implicitMergeInfo = mergeinfo[1];
        }
        child.implicitMergeInfo = new TreeMap<String, SVNMergeRangeList>();
        String ancestorPath = SVNPathUtil.getCommonPathAncestor(parent.absPath.getAbsolutePath().replace(File.separatorChar, '/'), child.absPath.getAbsolutePath().replace(File.separatorChar, '/'));
        String childPath = SVNPathUtil.getPathAsChild(ancestorPath, child.absPath.getAbsolutePath().replace(File.separatorChar, '/'));
        if (childPath.startsWith("/")) {
            childPath = childPath.substring(1);
        }
        SVNMergeInfoUtil.adjustMergeInfoSourcePaths(child.implicitMergeInfo, childPath, parent.implicitMergeInfo);
    }

    private void ensureImplicitMergeinfo(MergePath parent, MergePath child, boolean childInheritsParent, long revision1, long revision2, SVNRepository repository) throws SVNException {
        if (child.implicitMergeInfo != null) {
            return;
        }
        if (childInheritsParent) {
            this.inheritImplicitMergeinfoFromParent(parent, child, revision1, revision2, repository);
        } else {
            Map<String, SVNMergeRangeList>[] mergeinfo = this.getFullMergeInfo(false, true, null, SVNMergeInfoInheritance.INHERITED, repository, child.absPath, Math.max(revision1, revision2), Math.min(revision1, revision2));
            child.implicitMergeInfo = mergeinfo[1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void findGapsInMergeSourceHistory(long[] gap, String mergeSrcCanonPath, SVNURL url1, long rev1, SVNURL url2, long rev2, SVNRepository repos) throws SVNException {
        long youngRev = Math.max(rev1, rev2);
        long oldRev = Math.min(rev1, rev2);
        SVNURL url = rev2 < rev1 ? url1 : url2;
        gap[1] = -1L;
        gap[0] = -1L;
        SVNRevision pegRevision = SVNRevision.create(youngRev);
        SVNURL oldURL = null;
        if (repos != null) {
            oldURL = SvnNgMergeDriver.ensureSessionURL(repos, url);
        }
        Map<String, SVNMergeRangeList> implicitSrcMergeInfo = null;
        try {
            implicitSrcMergeInfo = this.repositoryAccess.getHistoryAsMergeInfo(repos, SvnTarget.fromURL(url, pegRevision), youngRev, oldRev);
        }
        finally {
            if (repos != null && oldURL != null) {
                repos.setLocation(oldURL, false);
            }
        }
        SVNMergeRangeList rangelist = implicitSrcMergeInfo.get(mergeSrcCanonPath);
        if (rangelist != null) {
            if (rangelist.getSize() > 1) {
                gap[0] = Math.min(rev1, rev2);
                gap[1] = rangelist.getRanges()[rangelist.getSize() - 1].getStartRevision();
            } else if (implicitSrcMergeInfo.size() > 1) {
                SVNMergeRangeList implicitMergeRangeList = new SVNMergeRangeList(new SVNMergeRange[0]);
                SVNMergeRangeList requestedMergeRangeList = new SVNMergeRangeList(Math.min(rev1, rev2), Math.max(rev1, rev2), true);
                for (String path : implicitSrcMergeInfo.keySet()) {
                    rangelist = implicitSrcMergeInfo.get(path);
                    implicitMergeRangeList = implicitMergeRangeList != null ? implicitMergeRangeList.merge(rangelist) : rangelist;
                }
                SVNMergeRangeList gapRangeList = requestedMergeRangeList.diff(implicitMergeRangeList, false);
                if (gapRangeList.getSize() > 0) {
                    gap[0] = gapRangeList.getRanges()[0].getStartRevision();
                    gap[1] = gapRangeList.getRanges()[0].getEndRevision();
                }
            }
        }
    }

    public void calculateRemainingRanges(MergePath parent, MergePath child, SVNURL sourceRootURL, SVNURL url1, long revision1, SVNURL url2, long revision2, Map targetMergeInfo, SVNMergeRangeList implicitSrcGap, boolean isSubtree, boolean childInheritsImplicit, SVNRepository repository) throws SVNException {
        block7: {
            SVNURL primaryURL = revision1 < revision2 ? url2 : url1;
            Map<String, SVNMergeRangeList> adjustedTargetMergeInfo = null;
            String mergeInfoPath = this.getPathRelativeToRoot(primaryURL, sourceRootURL, repository);
            if (implicitSrcGap != null && child.preMergeMergeInfo != null) {
                SVNMergeRangeList explicitMergeInfoGapRanges = child.preMergeMergeInfo.get(mergeInfoPath);
                if (explicitMergeInfoGapRanges != null) {
                    TreeMap<String, SVNMergeRangeList> gapMergeInfo = new TreeMap<String, SVNMergeRangeList>();
                    gapMergeInfo.put(mergeInfoPath, implicitSrcGap);
                    adjustedTargetMergeInfo = SVNMergeInfoUtil.removeMergeInfo(gapMergeInfo, targetMergeInfo, false);
                }
            } else {
                adjustedTargetMergeInfo = targetMergeInfo;
            }
            this.filterMergedRevisions(parent, child, repository, mergeInfoPath, adjustedTargetMergeInfo, revision1, revision2, childInheritsImplicit);
            long childBaseRevision = this.context.getNodeBaseRev(child.absPath);
            if (childBaseRevision >= 0L && (child.remainingRanges == null || child.remainingRanges.isEmpty()) && revision2 < revision1 && childBaseRevision <= revision2) {
                try {
                    Structure<SvnRepositoryAccess.LocationsInfo> locations = this.repositoryAccess.getLocations(repository, SvnTarget.fromURL(url1), SVNRevision.create(revision1), SVNRevision.create(childBaseRevision), SVNRevision.UNDEFINED);
                    SVNURL startURL = (SVNURL)locations.get(SvnRepositoryAccess.LocationsInfo.startUrl);
                    if (startURL.equals(this.context.getNodeUrl(child.absPath))) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_NOT_READY_TO_MERGE, "Cannot reverse-merge a range from a path's own future history; try updating first");
                        SVNErrorManager.error(err, SVNLogType.DEFAULT);
                    }
                }
                catch (SVNException svne) {
                    SVNErrorCode code = svne.getErrorMessage().getErrorCode();
                    if (code == SVNErrorCode.FS_NOT_FOUND || code == SVNErrorCode.RA_DAV_PATH_NOT_FOUND || code == SVNErrorCode.CLIENT_UNRELATED_RESOURCES) break block7;
                    throw svne;
                }
            }
        }
    }

    private void adjustDeletedSubTreeRanges(MergePath child, MergePath parent, long revision1, long revision2, SVNURL primaryURL, SVNRepository repository) throws SVNException {
        long pegRev;
        SVNErrorManager.assertionFailure(parent.remainingRanges != null, "parent must already have non-null remaining ranges set", SVNLogType.WC);
        String relativePath = this.getPathRelativeToRoot(primaryURL, repository.getLocation(), repository);
        if (relativePath.startsWith("/")) {
            relativePath = relativePath.substring(1);
        }
        boolean isRollback = revision2 < revision1;
        long youngerRev = pegRev = isRollback ? revision1 : revision2;
        long olderRev = isRollback ? revision2 : revision1;
        List<SVNLocationSegment> locationSegments = null;
        try {
            locationSegments = repository.getLocationSegments(relativePath, pegRev, youngerRev, olderRev);
        }
        catch (SVNException e) {
            SVNErrorCode errCode = e.getErrorMessage().getErrorCode();
            if (errCode == SVNErrorCode.FS_NOT_FOUND || errCode == SVNErrorCode.RA_DAV_REQUEST_FAILED) {
                SVNNodeKind kind = repository.checkPath(relativePath, olderRev);
                if (kind == SVNNodeKind.NONE) {
                    child.remainingRanges = parent.remainingRanges.dup();
                } else {
                    long primaryURLDeletedRevision = repository.getDeletedRevision(relativePath, olderRev, youngerRev);
                    SVNErrorManager.assertionFailure(SVNRevision.isValidRevisionNumber(primaryURLDeletedRevision), "deleted revision must exist", SVNLogType.WC);
                    if (isRollback) {
                        child.remainingRanges = child.remainingRanges.reverse();
                        parent.remainingRanges = parent.remainingRanges.reverse();
                    }
                    SVNMergeRangeList existingRangeList = new SVNMergeRangeList(new SVNMergeRange(olderRev, primaryURLDeletedRevision - 1L, true));
                    child.remainingRanges = child.remainingRanges.intersect(existingRangeList, false);
                    SVNMergeRangeList deletedRangeList = new SVNMergeRangeList(new SVNMergeRange(primaryURLDeletedRevision - 1L, pegRev, true));
                    deletedRangeList = parent.remainingRanges.intersect(deletedRangeList, false);
                    child.remainingRanges = child.remainingRanges.merge(deletedRangeList);
                    if (isRollback) {
                        child.remainingRanges = child.remainingRanges.reverse();
                        parent.remainingRanges = parent.remainingRanges.reverse();
                    }
                }
            }
            throw e;
        }
        if (locationSegments != null && !locationSegments.isEmpty()) {
            SVNLocationSegment segment = locationSegments.get(locationSegments.size() - 1);
            if (segment.getStartRevision() == olderRev) {
                return;
            }
            if (isRollback) {
                child.remainingRanges = child.remainingRanges.reverse();
                parent.remainingRanges = parent.remainingRanges.reverse();
            }
            SVNMergeRangeList existingRangeList = new SVNMergeRangeList(new SVNMergeRange(segment.getStartRevision(), pegRev, true));
            child.remainingRanges = child.remainingRanges.intersect(existingRangeList, false);
            SVNMergeRangeList nonExistentRangeList = new SVNMergeRangeList(new SVNMergeRange(olderRev, segment.getStartRevision(), true));
            nonExistentRangeList = parent.remainingRanges.intersect(nonExistentRangeList, false);
            child.remainingRanges = child.remainingRanges.merge(nonExistentRangeList);
            if (isRollback) {
                child.remainingRanges = child.remainingRanges.reverse();
                parent.remainingRanges = parent.remainingRanges.reverse();
            }
        }
    }

    private void filterMergedRevisions(MergePath parent, MergePath child, SVNRepository repository, String mergeInfoPath, Map targetMergeInfo, long rev1, long rev2, boolean childInheritsImplicit) throws SVNException {
        SVNMergeRangeList targetRangeList = null;
        SVNMergeRangeList targetImplicitRangeList = null;
        SVNMergeRangeList explicitRangeList = null;
        SVNMergeRangeList requestedMergeRangeList = new SVNMergeRangeList(new SVNMergeRange(rev1, rev2, true));
        if (rev1 > rev2) {
            SVNMergeRangeList[] diff = SVNMergeInfoUtil.diffMergeRangeLists(requestedMergeRangeList = requestedMergeRangeList.reverse(), explicitRangeList = (targetRangeList = targetMergeInfo != null ? (SVNMergeRangeList)targetMergeInfo.get(mergeInfoPath) : null) != null ? targetRangeList.intersect(requestedMergeRangeList, false) : new SVNMergeRangeList(new SVNMergeRange[0]), false);
            SVNMergeRangeList deletedRangeList = diff[0];
            if (deletedRangeList == null || deletedRangeList.isEmpty()) {
                requestedMergeRangeList = requestedMergeRangeList.reverse();
                child.remainingRanges = requestedMergeRangeList.dup();
            } else {
                SVNMergeRangeList implicitRangeList = null;
                this.ensureImplicitMergeinfo(parent, child, childInheritsImplicit, rev1, rev2, repository);
                targetImplicitRangeList = child.implicitMergeInfo.get(mergeInfoPath);
                implicitRangeList = targetImplicitRangeList != null ? targetImplicitRangeList.intersect(requestedMergeRangeList, false) : new SVNMergeRangeList(new SVNMergeRange[0]);
                implicitRangeList = implicitRangeList.merge(explicitRangeList);
                implicitRangeList = implicitRangeList.reverse();
                child.remainingRanges = implicitRangeList.dup();
            }
        } else {
            targetRangeList = targetMergeInfo != null ? (SVNMergeRangeList)targetMergeInfo.get(mergeInfoPath) : null;
            explicitRangeList = targetRangeList != null ? requestedMergeRangeList.remove(targetRangeList, false) : requestedMergeRangeList.dup();
            if (explicitRangeList == null || explicitRangeList.isEmpty()) {
                child.remainingRanges = new SVNMergeRangeList(new SVNMergeRange[0]);
            } else {
                this.ensureImplicitMergeinfo(parent, child, childInheritsImplicit, rev1, rev2, repository);
                targetImplicitRangeList = child.implicitMergeInfo.get(mergeInfoPath);
                child.remainingRanges = targetImplicitRangeList != null ? explicitRangeList.remove(targetImplicitRangeList, false) : explicitRangeList.dup();
            }
        }
    }

    protected String getPathRelativeToRoot(SVNURL url, SVNURL reposRootURL, SVNRepository repos) throws SVNException {
        if (reposRootURL == null) {
            reposRootURL = repos.getRepositoryRoot(true);
        }
        String reposRootPath = reposRootURL.getPath();
        String absPath = url.getPath();
        if (!absPath.startsWith(reposRootPath)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CLIENT_UNRELATED_RESOURCES, "URL ''{0}'' is not a child of repository root URL ''{1}''", url, reposRootURL);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (!(absPath = absPath.substring(reposRootPath.length())).startsWith("/")) {
            absPath = "/" + absPath;
        }
        return absPath;
    }

    private void sliceRemainingRanges(Map<File, MergePath> childrenWithMergeInfo, boolean isRollBack, long endRevision) {
        for (MergePath child : childrenWithMergeInfo.values()) {
            if (child == null || child.absent || child.remainingRanges.isEmpty()) continue;
            SVNMergeRange[] originalRemainingRanges = child.remainingRanges.getRanges();
            SVNMergeRange range = originalRemainingRanges[0];
            if ((!isRollBack || range.getStartRevision() <= endRevision || range.getEndRevision() >= endRevision) && (isRollBack || range.getStartRevision() >= endRevision || range.getEndRevision() <= endRevision)) continue;
            SVNMergeRange splitRange1 = new SVNMergeRange(range.getStartRevision(), endRevision, range.isInheritable());
            SVNMergeRange splitRange2 = new SVNMergeRange(endRevision, range.getEndRevision(), range.isInheritable());
            SVNMergeRange[] remainingRanges = new SVNMergeRange[originalRemainingRanges.length + 1];
            remainingRanges[0] = splitRange1;
            remainingRanges[1] = splitRange2;
            System.arraycopy(originalRemainingRanges, 1, remainingRanges, 2, originalRemainingRanges.length - 1);
            child.remainingRanges = new SVNMergeRangeList(remainingRanges);
        }
    }

    private long getMostInclusiveEndRevision(Map<File, MergePath> childrenWithMergeInfo, boolean isRollBack) {
        long endRev = -1L;
        for (MergePath child : childrenWithMergeInfo.values()) {
            if (child == null || child.absent || child.remainingRanges.getSize() <= 0) continue;
            SVNMergeRange[] ranges = child.remainingRanges.getRanges();
            SVNMergeRange range = ranges[0];
            if (SVNRevision.isValidRevisionNumber(endRev) && (!isRollBack || range.getEndRevision() <= endRev) && (isRollBack || range.getEndRevision() >= endRev)) continue;
            endRev = range.getEndRevision();
        }
        return endRev;
    }

    private long getMostInclusiveStartRevision(Map<File, MergePath> childrenWithMergeInfo, boolean isRollBack) {
        long startRev = -1L;
        boolean first = true;
        for (MergePath child : childrenWithMergeInfo.values()) {
            if (child == null || child.absent) {
                first = false;
                continue;
            }
            if (child.remainingRanges.isEmpty()) {
                first = false;
                continue;
            }
            SVNMergeRange[] ranges = child.remainingRanges.getRanges();
            SVNMergeRange range = ranges[0];
            if (first && range.getStartRevision() == range.getEndRevision()) {
                first = false;
                continue;
            }
            if (!SVNRevision.isValidRevisionNumber(startRev) || isRollBack && range.getStartRevision() > startRev || !isRollBack && range.getStartRevision() < startRev) {
                startRev = range.getStartRevision();
            }
            first = false;
        }
        return startRev;
    }

    private void processChildrenWithNewMergeInfo(Map<File, MergePath> childrenWithMergeInfo) throws SVNException {
        if (this.pathsWithNewMergeInfo != null && !this.dryRun) {
            for (File pathWithNewMergeInfo : this.pathsWithNewMergeInfo) {
                SvnNgMergeinfoUtil.SvnMergeInfoInfo pathExplicitMergeInfo = SvnNgMergeinfoUtil.getWCMergeInfo(this.context, pathWithNewMergeInfo, this.targetAbsPath, SVNMergeInfoInheritance.EXPLICIT, false);
                SVNURL oldURL = null;
                if (pathExplicitMergeInfo != null) {
                    oldURL = SvnNgMergeDriver.ensureSessionURL(this.repos2, this.context.getNodeUrl(pathWithNewMergeInfo));
                    Map<String, SVNMergeRangeList> pathInheritedMergeInfo = SvnNgMergeinfoUtil.getWCOrReposMergeInfo(this.context, pathWithNewMergeInfo, this.repos2, false, SVNMergeInfoInheritance.NEAREST_ANCESTOR);
                    if (pathInheritedMergeInfo != null) {
                        pathExplicitMergeInfo.mergeinfo = SVNMergeInfoUtil.mergeMergeInfos(pathExplicitMergeInfo.mergeinfo, pathInheritedMergeInfo);
                        String value = SVNMergeInfoUtil.formatMergeInfoToString(pathExplicitMergeInfo.mergeinfo, "");
                        SvnNgPropertiesManager.setProperty(this.context, pathWithNewMergeInfo, "svn:mergeinfo", SVNPropertyValue.create(value), SVNDepth.EMPTY, true, null, null);
                    }
                    MergePath newChild = new MergePath(pathWithNewMergeInfo);
                    if (!childrenWithMergeInfo.containsKey(newChild.absPath)) {
                        Object[] childrenWithMergeInfoArray = childrenWithMergeInfo.values().toArray();
                        int parentIndex = SvnNgMergeDriver.findNearestAncestor(childrenWithMergeInfoArray, false, pathWithNewMergeInfo);
                        MergePath parent = (MergePath)childrenWithMergeInfoArray[parentIndex];
                        newChild.remainingRanges = parent.remainingRanges.dup();
                        childrenWithMergeInfo.put(newChild.absPath, newChild);
                    }
                }
                if (oldURL == null) continue;
                this.repos2.setLocation(oldURL, false);
            }
        }
    }

    private void removeChildrenWithDeletedMergeInfo(Map<File, MergePath> childrenWithMergeInfo) {
        if (this.pathsWithDeletedMergeInfo != null && !this.dryRun) {
            Iterator<MergePath> children = childrenWithMergeInfo.values().iterator();
            children.next();
            while (children.hasNext()) {
                MergePath path = children.next();
                if (path == null || !this.pathsWithDeletedMergeInfo.contains(path.absPath)) continue;
                children.remove();
            }
        }
    }

    private void removeFirstRangeFromRemainingRanges(long endRevision, Map<File, MergePath> childrenWithMergeInfo) {
        for (MergePath child : childrenWithMergeInfo.values()) {
            SVNMergeRange[] originalRemainingRanges;
            SVNMergeRange firstRange;
            if (child == null || child.absent || child.remainingRanges.isEmpty() || (firstRange = (originalRemainingRanges = child.remainingRanges.getRanges())[0]).getEndRevision() != endRevision) continue;
            SVNMergeRange[] remainingRanges = new SVNMergeRange[originalRemainingRanges.length - 1];
            System.arraycopy(originalRemainingRanges, 1, remainingRanges, 0, originalRemainingRanges.length - 1);
            child.remainingRanges = new SVNMergeRangeList(remainingRanges);
        }
    }

    private SVNErrorMessage makeMergeConflictError(File targetPath, SVNMergeRange range) {
        SVNErrorMessage error = SVNErrorMessage.create(SVNErrorCode.WC_FOUND_CONFLICT, "One or more conflicts were produced while merging r{0}:{1} into\n''{2}'' --\nresolve all conflicts and rerun the merge to apply the remaining\nunmerged revisions", Long.toString(range.getStartRevision()), Long.toString(range.getEndRevision()), targetPath);
        return error;
    }

    private void removeAbsentChildren(File targetWCPath, Map<File, MergePath> childrenWithMergeInfo) {
        Iterator<File> children = childrenWithMergeInfo.keySet().iterator();
        while (children.hasNext()) {
            File childPath = children.next();
            MergePath child = childrenWithMergeInfo.get(childPath);
            String topDir = targetWCPath.getAbsolutePath().replace(File.separatorChar, '/');
            String childPathStr = child.absPath.getAbsolutePath().replace(File.separatorChar, '/');
            if (child == null || !child.absent && !child.scheduledForDeletion || !SVNPathUtil.isAncestor(topDir, childPathStr)) continue;
            children.remove();
        }
    }

    protected void recordMergeInfoForDirectoryMerge(Map<File, Map<String, SVNMergeRangeList>> resultCatalog, SVNMergeRange mergeRange, String mergeInfoPath, SVNDepth depth, boolean squelchMergeinfoNotifications, Map<File, MergePath> childrenWithMergeInfo) throws SVNException {
        boolean isRollBack = mergeRange.getStartRevision() > mergeRange.getEndRevision();
        boolean operativeMerge = this.isSubtreeTouchedByMerge(this.targetAbsPath);
        SVNMergeRange range = mergeRange.dup();
        if (!operativeMerge) {
            range.setInheritable(true);
        }
        this.removeAbsentChildren(this.targetAbsPath, childrenWithMergeInfo);
        this.flagSubTreesNeedingMergeInfo(operativeMerge, range, childrenWithMergeInfo, SVNFileUtil.createFilePath(mergeInfoPath), depth);
        ArrayList<Map.Entry<File, MergePath>> entries = new ArrayList<Map.Entry<File, MergePath>>(childrenWithMergeInfo.entrySet());
        for (int i2 = 0; i2 < entries.size(); ++i2) {
            Map.Entry entry = (Map.Entry)entries.get(i2);
            MergePath child = (MergePath)entry.getValue();
            assert (child != null);
            if (child.recordMergeInfo) {
                File childReposPath = SVNFileUtil.skipAncestor(this.targetAbsPath, child.absPath);
                assert (childReposPath != null);
                File childMergeSrcPath = SVNFileUtil.createFilePath(SVNFileUtil.createFilePath(mergeInfoPath), childReposPath);
                SVNMergeRangeList childMergeRangelist = this.filterNaturalHistoryFromMergeInfo(SVNFileUtil.getFilePath(childMergeSrcPath), child.implicitMergeInfo, range);
                if (childMergeRangelist.getSize() == 0) continue;
                if (!squelchMergeinfoNotifications) {
                    this.removeSourceGap(range, this.implicitSrcGap);
                    SVNEvent mergeBeginEvent = SVNEventFactory.createSVNEvent(child.absPath, SVNNodeKind.NONE, null, -1L, SVNEventAction.MERGE_RECORD_INFO_BEGIN, null, null, range);
                    if (this.context.getEventHandler() != null) {
                        this.context.getEventHandler().handleEvent(mergeBeginEvent, -1.0);
                    }
                }
                if (i2 == 0) {
                    this.recordSkips(mergeInfoPath, childMergeRangelist, isRollBack);
                }
                if (child.recordNonInheritable) {
                    childMergeRangelist.setInheritable(false);
                }
                if (child.inheritedMergeInfo) {
                    this.recordMergeinfo(child.absPath, child.preMergeMergeInfo, false);
                }
                if (this.implicitSrcGap != null) {
                    if (isRollBack) {
                        childMergeRangelist = childMergeRangelist.reverse();
                    }
                    childMergeRangelist = childMergeRangelist.remove(this.implicitSrcGap, false);
                    if (isRollBack) {
                        childMergeRangelist = childMergeRangelist.reverse();
                    }
                }
                TreeMap<File, SVNMergeRangeList> childMerges = new TreeMap<File, SVNMergeRangeList>(PATH_COMPARATOR);
                if (!(this.recordOnly && !this.reintegrateMerge || isRollBack)) {
                    SVNURL oldUrl;
                    block23: {
                        SVNURL subtreeMergeUrl = this.reposRootUrl.appendPath(SVNFileUtil.getFilePath(childMergeSrcPath), false);
                        oldUrl = SvnNgMergeDriver.ensureSessionURL(this.repos2, subtreeMergeUrl);
                        Map<String, SVNMergeRangeList> subtreeHistory = null;
                        try {
                            subtreeHistory = this.repositoryAccess.getHistoryAsMergeInfo(this.repos2, SvnTarget.fromURL(subtreeMergeUrl, SVNRevision.create(mergeRange.getEndRevision())), Math.max(mergeRange.getStartRevision(), mergeRange.getEndRevision()), Math.min(mergeRange.getStartRevision(), mergeRange.getEndRevision()));
                            SVNMergeRangeList childMergeSrcRangelist = subtreeHistory.get(SVNFileUtil.getFilePath(childMergeSrcPath));
                            childMergeRangelist = childMergeRangelist.intersect(childMergeSrcRangelist, false);
                            if (child.recordNonInheritable) {
                                childMergeRangelist.setInheritable(false);
                            }
                        }
                        catch (SVNException e) {
                            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) break block23;
                            throw e;
                        }
                    }
                    if (oldUrl != null) {
                        this.repos2.setLocation(oldUrl, false);
                    }
                }
                childMerges.put(child.absPath, childMergeRangelist);
                this.updateWCMergeInfo(resultCatalog, child.absPath, SVNFileUtil.getFilePath(childMergeSrcPath), childMerges, isRollBack);
                if (this.addedPaths != null) {
                    this.addedPaths.remove(child.absPath);
                }
            }
            if (i2 <= 0) continue;
            boolean inSwitchedSubtree = false;
            if (child.switched) {
                inSwitchedSubtree = true;
            } else if (i2 > 1) {
                for (int j = i2 - 1; j > 0; --j) {
                    MergePath parent = (MergePath)((Map.Entry)entries.get(j)).getValue();
                    if (parent == null || !parent.switched || !SVNWCUtils.isAncestor(parent.absPath, child.absPath)) continue;
                    inSwitchedSubtree = true;
                    break;
                }
            }
            SvnNgMergeinfoUtil.elideMergeInfo(this.context, this.repos1, child.absPath, inSwitchedSubtree ? null : this.targetAbsPath);
        }
    }

    private void removeSourceGap(SVNMergeRange range, SVNMergeRangeList implicitSrcGap) {
        if (implicitSrcGap != null) {
            SVNMergeRange gapRange = implicitSrcGap.getRanges()[0];
            if (range.getStartRevision() < range.getEndRevision()) {
                if (gapRange.getStartRevision() == range.getStartRevision()) {
                    range.setStartRevision(gapRange.getEndRevision());
                }
            } else if (gapRange.getStartRevision() == range.getEndRevision()) {
                range.setEndRevision(gapRange.getEndRevision());
            }
        }
    }

    private void flagSubTreesNeedingMergeInfo(boolean operativeMerge, SVNMergeRange mergeRange, Map<File, MergePath> childrenWithMergeInfo, File mergeInfoPath, SVNDepth depth) throws SVNException {
        assert (!this.dryRun);
        Map<File, String> operativeImmediateChildren = null;
        if (!this.recordOnly && mergeRange.getStartRevision() <= mergeRange.getEndRevision() && depth.compareTo(SVNDepth.INFINITY) < 0) {
            operativeImmediateChildren = this.getOperativeImmediateChildren(mergeInfoPath, mergeRange.getStartRevision() + 1L, mergeRange.getEndRevision(), this.targetAbsPath, depth, this.repos1);
        }
        ArrayList<Map.Entry<File, MergePath>> entries = new ArrayList<Map.Entry<File, MergePath>>(childrenWithMergeInfo.entrySet());
        for (int i2 = entries.size() - 1; i2 >= 0; --i2) {
            MergePath child = (MergePath)((Map.Entry)entries.get(i2)).getValue();
            if (child.absent) continue;
            assert (i2 == 0 || this.pathsWithDeletedMergeInfo == null || !this.pathsWithDeletedMergeInfo.contains(child.absPath));
            if (this.skippedPaths != null && this.skippedPaths.contains(child.absPath)) continue;
            if (i2 == 0) {
                child.recordMergeInfo = true;
            } else if (this.recordOnly && !this.reintegrateMerge) {
                child.recordMergeInfo = true;
            } else if (child.immediateChildDir && child.preMergeMergeInfo == null && operativeImmediateChildren != null && operativeImmediateChildren.containsKey(child.absPath)) {
                child.recordMergeInfo = true;
            }
            if (operativeMerge && this.isSubtreeTouchedByMerge(child.absPath)) {
                child.recordMergeInfo = true;
                if (!this.reintegrateMerge && child.missingChild && !this.isPathSubtree(child.absPath, this.skippedPaths)) {
                    child.missingChild = false;
                }
                if (child.switchedChild) {
                    boolean operativeSwitchedChild = false;
                    for (int j = i2 + 1; j < entries.size(); ++j) {
                        MergePath potentialChild = (MergePath)((Map.Entry)entries.get(j)).getValue();
                        if (!SVNPathUtil.isAncestor(SVNFileUtil.getFilePath(child.absPath), SVNFileUtil.getFilePath(potentialChild.absPath))) break;
                        if (!child.absPath.equals(SVNFileUtil.getParentFile(potentialChild.absPath)) || !potentialChild.switched || !potentialChild.recordMergeInfo) continue;
                        operativeSwitchedChild = true;
                        break;
                    }
                    if (!operativeSwitchedChild) {
                        child.switchedChild = false;
                    }
                }
            }
            if (child.recordMergeInfo) {
                SVNNodeKind pathKind = this.context.readKind(child.absPath, false);
                if (pathKind != SVNNodeKind.DIR) continue;
                boolean bl = child.recordNonInheritable = child.missingChild || child.switchedChild;
                if (i2 == 0) {
                    if (depth.compareTo(SVNDepth.IMMEDIATES) >= 0 || operativeImmediateChildren == null || operativeImmediateChildren.size() <= 0) continue;
                    child.recordNonInheritable = true;
                    continue;
                }
                if (depth != SVNDepth.IMMEDIATES || !operativeImmediateChildren.containsKey(child.absPath)) continue;
                child.recordNonInheritable = true;
                continue;
            }
            if (!child.childOfNonInheritable) continue;
            this.recordMergeinfo(child.absPath, null, false);
        }
    }

    private boolean isPathSubtree(File localAbsPath, Collection<File> subtrees) {
        if (subtrees != null) {
            for (File pathTouchedByMerge : subtrees) {
                if (!SVNPathUtil.isAncestor(SVNFileUtil.getFilePath(localAbsPath), SVNFileUtil.getFilePath(pathTouchedByMerge))) continue;
                return true;
            }
        }
        return false;
    }

    private Map<File, String> getOperativeImmediateChildren(File mergeSourceFsPath, long oldestRevision, long youngestRevision, File mergeTargetAbsPath, SVNDepth depth, SVNRepository repository) throws SVNException {
        assert (SVNRevision.isValidRevisionNumber(oldestRevision));
        assert (SVNRevision.isValidRevisionNumber(youngestRevision));
        assert (oldestRevision <= youngestRevision);
        HashMap<File, String> operativeChildren = new HashMap<File, String>();
        if (depth == SVNDepth.INFINITY) {
            return operativeChildren;
        }
        FindOperativeSubtreeRevisions findOperativeSubtreeRevisions = new FindOperativeSubtreeRevisions(operativeChildren, this.context, mergeSourceFsPath, mergeTargetAbsPath, depth);
        repository.log(new String[]{""}, youngestRevision, oldestRevision, true, false, 0L, false, null, findOperativeSubtreeRevisions);
        return operativeChildren;
    }

    private boolean calculateMergeInheritance(SVNMergeRangeList rangeList, File localAbsPath, boolean wcPathIsMergeTarget, boolean wcPathHasMissingChild, SVNDepth depth) throws SVNException {
        SVNNodeKind kind = this.context.readKind(localAbsPath, false);
        boolean result = true;
        if (kind == SVNNodeKind.FILE) {
            rangeList.setInheritable(true);
        } else if (kind == SVNNodeKind.DIR) {
            if (wcPathIsMergeTarget) {
                if (wcPathHasMissingChild || depth == SVNDepth.FILES || depth == SVNDepth.EMPTY) {
                    rangeList.setInheritable(false);
                    result = false;
                } else {
                    rangeList.setInheritable(true);
                }
            } else if (wcPathHasMissingChild || depth == SVNDepth.IMMEDIATES) {
                rangeList.setInheritable(false);
                result = false;
            } else {
                rangeList.setInheritable(true);
            }
        }
        return result;
    }

    private void recordSkips(String mergeInfoPath, SVNMergeRangeList childMergeRangelist, boolean isRollBack) throws SVNException {
        if (this.skippedPaths == null || this.skippedPaths.isEmpty()) {
            return;
        }
        TreeMap<File, SVNMergeRangeList> merges = new TreeMap<File, SVNMergeRangeList>(PATH_COMPARATOR);
        for (File skippedPath : this.skippedPaths) {
            ObstructionState os = this.performObstructionCheck(skippedPath, SVNNodeKind.UNKNOWN);
            if (os != null && (os.obstructionState == SVNStatusType.OBSTRUCTED || os.obstructionState == SVNStatusType.MISSING)) continue;
            merges.put(skippedPath, new SVNMergeRangeList(new SVNMergeRange[0]));
        }
        this.updateWCMergeInfo(null, this.targetAbsPath, mergeInfoPath, merges, isRollBack);
    }

    private void updateWCMergeInfo(Map<File, Map<String, SVNMergeRangeList>> resultCatalog, File targetAbsPath, String reposRelPath, Map<File, SVNMergeRangeList> merges, boolean isRollBack) throws SVNException {
        for (File localAbsPath : merges.keySet()) {
            String localAbsPathRelToTarget;
            String relPath;
            SVNMergeRangeList rangelist;
            SvnNgMergeinfoUtil.SvnMergeInfoInfo mergeinfoInfo;
            Map<String, SVNMergeRangeList> mergeinfo = null;
            SVNMergeRangeList ranges = merges.get(localAbsPath);
            try {
                String propValue;
                SVNProperties properties = this.context.getDb().readProperties(localAbsPath);
                String string = propValue = properties != null ? properties.getStringValue("svn:mergeinfo") : null;
                if (propValue != null) {
                    mergeinfo = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(propValue), null);
                }
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_LOCKED || e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) continue;
                throw e;
            }
            if (mergeinfo == null && ranges.isEmpty() && (mergeinfoInfo = SvnNgMergeinfoUtil.getWCMergeInfo(this.context, localAbsPath, targetAbsPath, SVNMergeInfoInheritance.NEAREST_ANCESTOR, false)) != null) {
                mergeinfo = mergeinfoInfo.mergeinfo;
            }
            if (mergeinfo == null) {
                mergeinfo = new TreeMap<String, SVNMergeRangeList>();
            }
            if ((rangelist = mergeinfo.get(relPath = (localAbsPathRelToTarget = SVNWCUtils.getPathAsChild(targetAbsPath, localAbsPath)) != null ? SVNPathUtil.append(reposRelPath, localAbsPathRelToTarget) : reposRelPath)) == null) {
                rangelist = new SVNMergeRangeList(new SVNMergeRange[0]);
            }
            if (isRollBack) {
                ranges = ranges.dup().reverse();
                rangelist = rangelist.remove(ranges, false);
            } else {
                rangelist = rangelist.merge(ranges);
            }
            mergeinfo.put(relPath, rangelist);
            if (isRollBack && mergeinfo.isEmpty()) {
                mergeinfo = null;
            }
            SVNMergeInfoUtil.removeEmptyRangeLists(mergeinfo);
            if (resultCatalog != null) {
                Map<String, SVNMergeRangeList> existingMergeInfo = resultCatalog.get(localAbsPath);
                if (existingMergeInfo != null) {
                    mergeinfo = SVNMergeInfoUtil.mergeMergeInfos(mergeinfo, existingMergeInfo);
                }
                resultCatalog.put(localAbsPath, mergeinfo);
                continue;
            }
            try {
                this.recordMergeinfo(localAbsPath, mergeinfo, true);
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.ENTRY_NOT_FOUND) continue;
                throw e;
            }
        }
    }

    private void recordMergeinfo(File localAbsPath, Map<String, SVNMergeRangeList> mergeinfo, boolean notify) throws SVNException {
        String mergeInfoValue = null;
        if (mergeinfo != null) {
            mergeInfoValue = SVNMergeInfoUtil.formatMergeInfoToString(mergeinfo, null);
        }
        boolean mergeInfoChanged = false;
        if (notify && this.context.getEventHandler() != null) {
            SVNWCContext.PropDiffs propDiff = this.context.getPropDiffs(localAbsPath);
            mergeInfoChanged = propDiff.propChanges != null && propDiff.propChanges.containsName("svn:mergeinfo");
        }
        ISVNEventHandler oldEventHandler = this.context.getEventHandler();
        this.context.setEventHandler(null);
        SvnNgPropertiesManager.setProperty(this.context, localAbsPath, "svn:mergeinfo", mergeInfoValue != null ? SVNPropertyValue.create(mergeInfoValue) : null, SVNDepth.EMPTY, true, null, null);
        this.context.setEventHandler(oldEventHandler);
        if (notify && this.context.getEventHandler() != null) {
            SVNEvent event = SVNEventFactory.createSVNEvent(localAbsPath, SVNNodeKind.UNKNOWN, null, -1L, SVNStatusType.INAPPLICABLE, mergeInfoChanged ? SVNStatusType.MERGED : SVNStatusType.CHANGED, SVNStatusType.LOCK_INAPPLICABLE, SVNEventAction.MERGE_RECORD_INFO, null, null, null);
            this.context.getEventHandler().handleEvent(event, -1.0);
        }
    }

    private boolean isSubtreeTouchedByMerge(File absPath) {
        return this.isSubtree(absPath, this.mergedPaths) || this.isSubtree(absPath, this.skippedPaths) || this.isSubtree(absPath, this.addedPaths) || this.isSubtree(absPath, this.treeConflictedPaths);
    }

    private boolean isSubtree(File path, Collection<File> paths) {
        if (path != null && paths != null) {
            for (File subtree : paths) {
                if (!SVNWCUtils.isAncestor(path, subtree)) continue;
                return true;
            }
        }
        return false;
    }

    private SVNMergeRangeList filterNaturalHistoryFromMergeInfo(String srcPath, Map<String, SVNMergeRangeList> implicitMergeInfo, SVNMergeRange requestedRange) {
        SVNMergeRangeList impliedRangeList;
        SVNMergeRangeList requestedRangeList = new SVNMergeRangeList(requestedRange.dup());
        SVNMergeRangeList filteredRangeList = null;
        if (implicitMergeInfo != null && requestedRange.getStartRevision() < requestedRange.getEndRevision() && (impliedRangeList = implicitMergeInfo.get(srcPath)) != null) {
            filteredRangeList = requestedRangeList.diff(impliedRangeList, false);
        }
        if (filteredRangeList == null) {
            filteredRangeList = requestedRangeList;
        }
        return filteredRangeList;
    }

    private Map<File, String> getInoperativeImmediateChildrent(String mergeSourceReposAbsPath, long oldestRev, long youngestRev, File targetAbsPath, SVNRepository repos, Map<File, MergePath> childrenWithMergeInfo) throws SVNException {
        final TreeMap<File, String> result = new TreeMap<File, String>();
        for (File childPath : childrenWithMergeInfo.keySet()) {
            MergePath child = childrenWithMergeInfo.get(childPath);
            if (!child.immediateChildDir) continue;
            String relPath = SVNWCUtils.getPathAsChild(targetAbsPath, child.absPath);
            String fullPath = SVNPathUtil.append(mergeSourceReposAbsPath, relPath);
            result.put(child.absPath, fullPath);
        }
        if (!result.isEmpty()) {
            repos.log(new String[]{""}, youngestRev, oldestRev, true, false, -1L, false, null, new ISVNLogEntryHandler(){

                @Override
                public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                    for (String changedPath : logEntry.getChangedPaths().keySet()) {
                        File removedPath = null;
                        for (File iPath : result.keySet()) {
                            String reposPath = (String)result.get(iPath);
                            if (reposPath == null || !SVNPathUtil.isAncestor(reposPath, changedPath)) continue;
                            removedPath = iPath;
                            break;
                        }
                        if (removedPath == null) continue;
                        result.remove(removedPath);
                    }
                }
            });
        }
        return result;
    }

    private void recordMergeInfoForAddedSubtrees(SVNMergeRange range, String mergeInfoPath, SVNDepth depth, boolean squelchMergeinfoNotifications, Map<File, MergePath> childrenWithMergeInfo) throws SVNException {
        if (this.addedPaths == null) {
            return;
        }
        for (File addedPath : this.addedPaths) {
            File dirPath = SVNFileUtil.getFileDir(addedPath);
            SvnNgMergeinfoUtil.SvnMergeInfoInfo miInfo = SvnNgMergeinfoUtil.getWCMergeInfo(this.context, addedPath, null, SVNMergeInfoInheritance.EXPLICIT, false);
            SvnNgMergeinfoUtil.SvnMergeInfoInfo parentMiInfo = null;
            if (miInfo.mergeinfo == null) {
                parentMiInfo = SvnNgMergeinfoUtil.getWCMergeInfo(this.context, dirPath, null, SVNMergeInfoInheritance.EXPLICIT, false);
                miInfo.inherited = parentMiInfo.inherited;
            }
            if (miInfo.mergeinfo == null && !SVNMergeInfoUtil.isNonInheritable(parentMiInfo.mergeinfo)) continue;
            MergePath targetMergePath = childrenWithMergeInfo.values().iterator().next();
            SVNNodeKind kind = this.context.readKind(addedPath, false);
            SVNMergeRange rng = range.dup();
            if (kind == SVNNodeKind.FILE) {
                rng.setInheritable(true);
            } else {
                rng.setInheritable(depth != SVNDepth.INFINITY && depth != SVNDepth.IMMEDIATES);
            }
            SVNMergeRangeList rangelist = new SVNMergeRangeList(rng);
            Map<String, SVNMergeRangeList> mergeMergeino = new TreeMap<String, SVNMergeRangeList>();
            String relAddedPath = SVNWCUtils.getPathAsChild(targetMergePath.absPath, addedPath);
            String addedMergeInfoPath = SVNPathUtil.append(mergeInfoPath, relAddedPath);
            mergeMergeino.put(addedMergeInfoPath, rangelist);
            SVNURL addedMergeInfoUrl = this.reposRootUrl.appendPath(addedMergeInfoPath, false);
            SVNRevision pegRevision = SVNRevision.create(Math.max(range.getStartRevision(), range.getEndRevision()));
            SVNURL oldUrl = SvnNgMergeDriver.ensureSessionURL(this.repos2, addedMergeInfoUrl);
            Map<String, SVNMergeRangeList> addsHistory = this.repositoryAccess.getHistoryAsMergeInfo(this.repos2, SvnTarget.fromURL(addedMergeInfoUrl, pegRevision), Math.max(range.getStartRevision(), range.getEndRevision()), Math.min(range.getStartRevision(), range.getEndRevision()));
            if (oldUrl != null) {
                this.repos2.setLocation(oldUrl, false);
            }
            mergeMergeino = SVNMergeInfoUtil.intersectMergeInfo(mergeMergeino, addsHistory, false);
            if (miInfo.mergeinfo != null) {
                mergeMergeino = SVNMergeInfoUtil.mergeMergeInfos(mergeMergeino, miInfo.mergeinfo);
            }
            this.recordMergeinfo(addedPath, mergeMergeino, !squelchMergeinfoNotifications);
        }
    }

    private SVNMergeRangeList removeNoOpMergeRanges(SVNRepository repository, SVNMergeRangeList ranges) throws SVNException {
        long oldestRev = -1L;
        long youngestRev = -1L;
        SVNMergeRange[] mergeRanges = ranges.getRanges();
        for (int i2 = 0; i2 < ranges.getSize(); ++i2) {
            SVNMergeRange range = mergeRanges[i2];
            long maxRev = Math.max(range.getStartRevision(), range.getEndRevision());
            long minRev = Math.min(range.getStartRevision(), range.getEndRevision());
            if (!SVNRevision.isValidRevisionNumber(youngestRev) || maxRev > youngestRev) {
                youngestRev = maxRev;
            }
            if (SVNRevision.isValidRevisionNumber(oldestRev) && minRev >= oldestRev) continue;
            oldestRev = minRev;
        }
        if (SVNRevision.isValidRevisionNumber(oldestRev)) {
            ++oldestRev;
        }
        final LinkedList changedRevs = new LinkedList();
        repository.log(new String[]{""}, youngestRev, oldestRev, false, false, 0L, false, new String[0], new ISVNLogEntryHandler(){

            @Override
            public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                changedRevs.add(logEntry.getRevision());
            }
        });
        long youngestChangedRevision = -1L;
        long oldestChangedRevision = -1L;
        if (changedRevs.size() > 0) {
            youngestChangedRevision = (Long)changedRevs.get(0);
            oldestChangedRevision = (Long)changedRevs.get(changedRevs.size() - 1);
        }
        LinkedList<SVNMergeRange> operativeRanges = new LinkedList<SVNMergeRange>();
        block1: for (int i3 = 0; i3 < ranges.getSize(); ++i3) {
            SVNMergeRange range = mergeRanges[i3];
            long rangeMinRev = Math.min(range.getStartRevision(), range.getEndRevision()) + 1L;
            long rangeMaxRev = Math.max(range.getStartRevision(), range.getEndRevision());
            if (rangeMinRev > youngestChangedRevision || rangeMaxRev < oldestChangedRevision) continue;
            Iterator changedRevsIter = changedRevs.iterator();
            while (changedRevsIter.hasNext()) {
                long changedRev = (Long)changedRevsIter.next();
                if (changedRev < rangeMinRev || changedRev > rangeMaxRev) continue;
                operativeRanges.add(range);
                continue block1;
            }
        }
        return SVNMergeRangeList.fromCollection(operativeRanges);
    }

    private void fixDeletedSubtreeRanges(SVNURL url1, long revision1, SVNURL url2, long revision2, SVNRepository repository, Map<File, MergePath> childrenWithMergeInfo) throws SVNException {
        boolean isRollback = revision2 < revision1;
        SVNURL sourceRootUrl = repository.getRepositoryRoot(true);
        Object[] array = childrenWithMergeInfo.values().toArray();
        for (MergePath child : childrenWithMergeInfo.values()) {
            if (child.absent) continue;
            int parentIndex = SvnNgMergeDriver.findNearestAncestor(array, false, child.absPath);
            MergePath parent = (MergePath)array[parentIndex];
            if (isRollback) {
                child.remainingRanges = child.remainingRanges.reverse();
                parent.remainingRanges = parent.remainingRanges.reverse();
            }
            SVNMergeRangeList added = child.remainingRanges.diff(parent.remainingRanges, true);
            SVNMergeRangeList deleted = parent.remainingRanges.diff(child.remainingRanges, true);
            if (isRollback) {
                child.remainingRanges = child.remainingRanges.reverse();
                parent.remainingRanges = parent.remainingRanges.reverse();
            }
            if (added.isEmpty() && deleted.isEmpty()) continue;
            String childReposSrcPath = SVNWCUtils.getPathAsChild(this.targetAbsPath, child.absPath);
            SVNURL childPrimarySrcUrl = revision1 < revision2 ? url2 : url1;
            childPrimarySrcUrl = childPrimarySrcUrl.appendPath(childReposSrcPath, false);
            this.adjustDeletedSubTreeRanges(child, parent, revision1, revision2, childPrimarySrcUrl, repository);
        }
    }

    public void checkCancelled() throws SVNCancelException {
    }

    private static boolean isOperativeNotification(SVNEvent event) {
        return event.getContentsStatus() == SVNStatusType.CONFLICTED || event.getContentsStatus() == SVNStatusType.MERGED || event.getContentsStatus() == SVNStatusType.CHANGED || event.getPropertiesStatus() == SVNStatusType.CONFLICTED || event.getPropertiesStatus() == SVNStatusType.MERGED || event.getPropertiesStatus() == SVNStatusType.CHANGED || event.getAction() == SVNEventAction.UPDATE_ADD || event.getAction() == SVNEventAction.TREE_CONFLICT;
    }

    protected SVNRepository ensureRepository(SVNRepository repository, SVNURL url) throws SVNException {
        if (repository != null) {
            try {
                SvnNgMergeDriver.ensureSessionURL(repository, url);
                return repository;
            }
            catch (SVNException sVNException) {
                repository = null;
            }
        }
        if (repository == null) {
            repository = this.repositoryAccess.createRepository(url, null, false);
        } else {
            repository.setLocation(url, false);
        }
        return repository;
    }

    public ObstructionState performObstructionCheck(File localAbsPath, SVNNodeKind expectedKind) throws SVNException {
        ObstructionState result = new ObstructionState();
        result.obstructionState = SVNStatusType.INAPPLICABLE;
        result.kind = SVNNodeKind.NONE;
        if (this.dryRun) {
            if (this.isDryRunDeletion(localAbsPath)) {
                result.deleted = true;
                if (expectedKind != SVNNodeKind.UNKNOWN && expectedKind != SVNNodeKind.NONE) {
                    result.obstructionState = SVNStatusType.OBSTRUCTED;
                }
                return result;
            }
            if (this.isDryRunAddition(localAbsPath)) {
                result.added = true;
                result.kind = SVNNodeKind.DIR;
                return result;
            }
        }
        boolean checkRoot = localAbsPath.equals(this.targetAbsPath);
        this.checkWcForObstruction(result, localAbsPath, checkRoot);
        if (result.obstructionState == SVNStatusType.INAPPLICABLE && expectedKind != SVNNodeKind.UNKNOWN && result.kind != expectedKind) {
            result.obstructionState = SVNStatusType.OBSTRUCTED;
        }
        return result;
    }

    boolean isDryRunAddition(File path) {
        return this.dryRun && this.dryRunAdded != null && this.dryRunAdded.contains(path);
    }

    boolean isDryRunDeletion(File path) {
        return this.dryRun && this.dryRunDeletions != null && this.dryRunDeletions.contains(path);
    }

    private void checkWcForObstruction(ObstructionState result, File localAbsPath, boolean noWcRootCheck) throws SVNException {
        boolean isRoot;
        result.kind = SVNNodeKind.NONE;
        result.obstructionState = SVNStatusType.INAPPLICABLE;
        SVNFileType diskKind = SVNFileType.getType(localAbsPath);
        ISVNWCDb.SVNWCDbStatus status = null;
        ISVNWCDb.SVNWCDbKind dbKind = null;
        boolean conflicted = false;
        try {
            Structure<StructureFields.NodeInfo> info = this.context.getDb().readInfo(localAbsPath, StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind, StructureFields.NodeInfo.conflicted);
            status = (ISVNWCDb.SVNWCDbStatus)((Object)info.get(StructureFields.NodeInfo.status));
            dbKind = (ISVNWCDb.SVNWCDbKind)((Object)info.get(StructureFields.NodeInfo.kind));
            conflicted = info.is(StructureFields.NodeInfo.conflicted);
            info.release();
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                throw e;
            }
            if (diskKind != SVNFileType.NONE) {
                result.obstructionState = SVNStatusType.OBSTRUCTED;
                return;
            }
            try {
                Structure<StructureFields.NodeInfo> parentInfo = this.context.getDb().readInfo(SVNFileUtil.getParentFile(localAbsPath), StructureFields.NodeInfo.status, StructureFields.NodeInfo.kind);
                ISVNWCDb.SVNWCDbStatus parentStatus = (ISVNWCDb.SVNWCDbStatus)((Object)parentInfo.get(StructureFields.NodeInfo.status));
                ISVNWCDb.SVNWCDbKind parentDbKind = (ISVNWCDb.SVNWCDbKind)((Object)parentInfo.get(StructureFields.NodeInfo.kind));
                if (parentDbKind != ISVNWCDb.SVNWCDbKind.Dir || parentStatus != ISVNWCDb.SVNWCDbStatus.Normal && parentStatus != ISVNWCDb.SVNWCDbStatus.Added) {
                    result.obstructionState = SVNStatusType.OBSTRUCTED;
                }
                parentInfo.release();
            }
            catch (SVNException e2) {
                if (e2.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) {
                    result.obstructionState = SVNStatusType.OBSTRUCTED;
                    return;
                }
                throw e;
            }
            return;
        }
        if (!noWcRootCheck && dbKind == ISVNWCDb.SVNWCDbKind.Dir && status == ISVNWCDb.SVNWCDbStatus.Normal && (isRoot = this.context.getDb().isWCRoot(localAbsPath))) {
            result.obstructionState = SVNStatusType.OBSTRUCTED;
            return;
        }
        result.kind = dbKind.toNodeKind(status, false);
        switch (status) {
            case Deleted: {
                result.deleted = true;
            }
            case NotPresent: {
                if (diskKind == SVNFileType.NONE) break;
                result.obstructionState = SVNStatusType.OBSTRUCTED;
                break;
            }
            case Excluded: 
            case ServerExcluded: 
            case Incomplete: {
                result.obstructionState = SVNStatusType.MISSING;
                break;
            }
            case Added: {
                result.added = true;
            }
            case Normal: {
                if (diskKind == SVNFileType.NONE) {
                    result.obstructionState = SVNStatusType.MISSING;
                    break;
                }
                SVNNodeKind expectedKind = dbKind.toNodeKind();
                if (SVNFileType.getNodeKind(diskKind) == expectedKind) break;
                result.obstructionState = SVNStatusType.OBSTRUCTED;
            }
        }
        if (conflicted) {
            SVNWCContext.ConflictInfo ci = this.context.getConflicted(localAbsPath, true, true, true);
            result.conflicted = ci != null && (ci.propConflicted || ci.textConflicted || ci.treeConflicted);
        }
    }

    private boolean resolveConflicts(Collection<File> conflictedPaths) throws SVNException {
        ArrayList<String> sortedPaths = new ArrayList<String>();
        for (File conflictedPath : conflictedPaths) {
            sortedPaths.add(SVNFileUtil.getFilePath(conflictedPath));
        }
        Collections.sort(sortedPaths, SVNPathUtil.PATH_COMPARATOR);
        boolean conflictRemains = false;
        for (String path : sortedPaths) {
            File localAbsPath = SVNFileUtil.createFilePath(path);
            this.context.resolvedConflict(localAbsPath, SVNDepth.EMPTY, true, "", true, null);
            try {
                SVNWCContext.ConflictInfo conflicted = this.context.getConflicted(localAbsPath, true, true, true);
                if (!conflicted.textConflicted && !conflicted.propConflicted && !conflicted.treeConflicted) continue;
                conflictRemains = true;
            }
            catch (SVNException e) {
                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.WC_PATH_NOT_FOUND) continue;
                throw e;
            }
        }
        return conflictRemains;
    }

    private static class FindOperativeSubtreeRevisions
    implements ISVNLogEntryHandler {
        private Map<File, String> operativeChildren;
        private SVNWCContext context;
        private File mergeSourceFsPath;
        private File mergeTargetAbsPath;
        private SVNDepth depth;

        private FindOperativeSubtreeRevisions(Map<File, String> operativeChildren, SVNWCContext context, File mergeSourceFsPath, File mergeTargetAbsPath, SVNDepth depth) {
            this.operativeChildren = operativeChildren;
            this.context = context;
            this.mergeSourceFsPath = mergeSourceFsPath;
            this.mergeTargetAbsPath = mergeTargetAbsPath;
            this.depth = depth;
        }

        @Override
        public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
            if (logEntry.getChangedPaths() == null) {
                return;
            }
            for (Map.Entry<String, SVNLogEntryPath> entry : logEntry.getChangedPaths().entrySet()) {
                String path = entry.getKey();
                SVNLogEntryPath logEntryPath = entry.getValue();
                File relPath = SVNFileUtil.skipAncestor(this.mergeSourceFsPath, SVNFileUtil.createFilePath(path));
                if (relPath == null || "".equals(SVNFileUtil.getFilePath(relPath))) continue;
                File child = SVNFileUtil.getFileDir(relPath);
                if ("".equals(SVNFileUtil.getFilePath(child))) {
                    SVNNodeKind nodeKind;
                    if (logEntryPath.getKind() == SVNNodeKind.UNKNOWN) {
                        File wcChildAbsPath = SVNFileUtil.createFilePath(this.mergeTargetAbsPath, relPath);
                        nodeKind = this.context.readKind(wcChildAbsPath, false);
                    } else {
                        nodeKind = logEntryPath.getKind();
                    }
                    if (this.depth == SVNDepth.FILES && nodeKind != SVNNodeKind.DIR || this.depth == SVNDepth.IMMEDIATES) continue;
                    child = relPath;
                }
                File potentialChild = SVNFileUtil.createFilePath(this.mergeTargetAbsPath, child);
                if (logEntryPath.getType() != 'A' && this.operativeChildren.containsKey(potentialChild)) continue;
                this.operativeChildren.put(potentialChild, path);
            }
        }
    }

    public static class ObstructionState {
        SVNStatusType obstructionState;
        boolean added;
        boolean deleted;
        boolean conflicted;
        SVNNodeKind kind;
    }

    private class NoopLogHandler
    implements ISVNLogEntryHandler {
        private SVNMergeRangeList operativeRanges;
        private SVNMergeRangeList mergedRanges;
        private String sourceReposAbsPath;
        private Map<File, MergePath> childrenWithMergeInfo;

        private NoopLogHandler() {
        }

        @Override
        public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
            this.operativeRanges = this.operativeRanges.mergeRevision(logEntry.getRevision());
            boolean logEntryRevisionRequired = false;
            long revision = logEntry.getRevision();
            for (String changedPath : logEntry.getChangedPaths().keySet()) {
                String relativePath = SVNPathUtil.getRelativePath(this.sourceReposAbsPath, changedPath);
                if (relativePath == null) continue;
                File cwmiPath = SVNFileUtil.createFilePath(SvnNgMergeDriver.this.targetAbsPath, relativePath);
                SVNMergeRangeList pathExclplicitRangeList = null;
                boolean mergeInfoInherited = false;
                while (!logEntryRevisionRequired) {
                    MergePath child = this.childrenWithMergeInfo.get(cwmiPath);
                    if (child != null && child.preMergeMergeInfo != null) {
                        pathExclplicitRangeList = child.preMergeMergeInfo.get(changedPath);
                        break;
                    }
                    if (cwmiPath == null || cwmiPath.equals(SvnNgMergeDriver.this.targetAbsPath)) break;
                    cwmiPath = SVNFileUtil.getParentFile(cwmiPath);
                    changedPath = SVNPathUtil.removeTail(changedPath);
                    mergeInfoInherited = true;
                }
                if (pathExclplicitRangeList != null) {
                    SVNMergeRangeList rl = new SVNMergeRangeList(new SVNMergeRange(revision - 1L, revision, true));
                    SVNMergeRangeList intersection = pathExclplicitRangeList.intersect(rl, mergeInfoInherited);
                    if (intersection.getSize() != 0) continue;
                    logEntryRevisionRequired = true;
                    continue;
                }
                logEntryRevisionRequired = true;
            }
            if (!logEntryRevisionRequired) {
                this.mergedRanges.mergeRevision(revision);
            }
        }
    }

    protected class MergePath
    implements Comparable {
        protected File absPath;
        protected boolean missingChild;
        protected boolean switched;
        protected boolean switchedChild;
        protected boolean hasNonInheritable;
        protected boolean absent;
        protected boolean childOfNonInheritable;
        protected boolean recordMergeInfo;
        protected SVNMergeRangeList remainingRanges;
        protected Map<String, SVNMergeRangeList> preMergeMergeInfo;
        protected Map<String, SVNMergeRangeList> implicitMergeInfo;
        protected boolean inheritedMergeInfo;
        protected boolean scheduledForDeletion;
        protected boolean immediateChildDir;
        protected boolean recordNonInheritable;

        public MergePath(File path) {
            this.absPath = path;
        }

        public int compareTo(Object obj) {
            if (obj == null || obj.getClass() != MergePath.class) {
                return -1;
            }
            MergePath mergePath = (MergePath)obj;
            if (this == mergePath) {
                return 0;
            }
            return this.absPath.compareTo(mergePath.absPath);
        }

        public boolean equals(Object obj) {
            return this.compareTo(obj) == 0;
        }

        public String toString() {
            String str = String.format("missingChild=%s,switched=%s,hasNonInheritable=%s,absent=%s, childOfNonInh=%s,inhMi=%s,scheduledForDeletion=%s,immediateChildDir=%s", this.missingChild, this.switched, this.hasNonInheritable, this.absent, this.childOfNonInheritable, this.inheritedMergeInfo, this.scheduledForDeletion, this.immediateChildDir);
            return this.absPath.toString() + " [" + str + "]";
        }
    }

    private static class SingleFileMergeData {
        private File file;
        private SVNProperties properties;

        private SingleFileMergeData() {
        }
    }

    protected static class MergeData {
        Collection<File> modifiedSubtrees;
        SvnConflictReport conflictReport;
        public boolean useSleep;

        protected MergeData() {
        }
    }

    public static class MergeSource {
        SVNURL url1;
        long rev1;
        SVNURL url2;
        long rev2;
        boolean ancestral;

        public MergeSource subrange(long startRevision, long endRevision) {
            boolean isRollBack = this.rev1 > this.rev2;
            boolean sameUrls = this.url1.equals(this.url2);
            MergeSource mergeSource = new MergeSource();
            mergeSource.ancestral = this.ancestral;
            mergeSource.url1 = this.url1;
            mergeSource.url2 = this.url2;
            mergeSource.rev1 = startRevision;
            mergeSource.rev2 = endRevision;
            if (!sameUrls) {
                if (isRollBack && endRevision != this.rev2) {
                    mergeSource.url2 = this.url1;
                }
                if (!isRollBack && startRevision != this.rev1) {
                    mergeSource.url1 = this.url2;
                }
            }
            return mergeSource;
        }
    }

    public static class NotifyBeginState {
        public File lastAbsPath;
        public Map<File, MergePath> nodesWithMergeInfo;
    }
}

