/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc17.db;

import java.io.File;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNWCUtils;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.statement.SVNWCDbSchema;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc2.SvnChecksum;

public class SvnWcDbStatementUtil {
    private static final EnumMap<ISVNWCDb.SVNWCDbStatus, String> presenceMap = new EnumMap(ISVNWCDb.SVNWCDbStatus.class);
    private static final HashMap<String, ISVNWCDb.SVNWCDbStatus> presenceMap2 = new HashMap();
    private static final EnumMap<ISVNWCDb.SVNWCDbKind, String> kindMap;
    private static final HashMap<String, ISVNWCDb.SVNWCDbKind> kindMap2;

    public static SVNSqlJetStatement bindf(SVNSqlJetStatement stmt, String format, Object ... binds) throws SVNException {
        if (binds != null) {
            for (int i2 = 0; i2 < binds.length; ++i2) {
                if (binds[i2] instanceof ISVNWCDb.SVNWCDbStatus) {
                    binds[i2] = SvnWcDbStatementUtil.getPresenceText((ISVNWCDb.SVNWCDbStatus)((Object)binds[i2]));
                    continue;
                }
                if (binds[i2] instanceof ISVNWCDb.SVNWCDbKind) {
                    binds[i2] = SvnWcDbStatementUtil.getKindText((ISVNWCDb.SVNWCDbKind)((Object)binds[i2]));
                    continue;
                }
                if (binds[i2] instanceof File) {
                    binds[i2] = SVNFileUtil.getFilePath((File)binds[i2]);
                    continue;
                }
                if (binds[i2] instanceof SVNDate) {
                    binds[i2] = ((SVNDate)binds[i2]).getTimeInMicros();
                    continue;
                }
                if (!(binds[i2] instanceof SVNDepth)) continue;
                binds[i2] = binds[i2].toString();
            }
        }
        stmt.bindf(format, binds);
        return stmt;
    }

    public static String getPresenceText(ISVNWCDb.SVNWCDbStatus status) {
        return presenceMap.get((Object)status);
    }

    public static String getKindText(ISVNWCDb.SVNWCDbKind kind) {
        return kindMap.get((Object)kind);
    }

    public static ISVNWCDb.SVNWCDbStatus parsePresence(String presenceString) {
        return presenceMap2.get(presenceString);
    }

    public static ISVNWCDb.SVNWCDbKind parseKind(String kindString) {
        return kindMap2.get(kindString);
    }

    public static SVNDepth parseDepth(String depthStr) {
        SVNDepth d = null;
        if (depthStr != null) {
            d = SVNDepth.fromString(depthStr);
        }
        if (d == null) {
            d = SVNDepth.UNKNOWN;
        }
        return d;
    }

    public static ISVNWCDb.SVNWCDbStatus getColumnPresence(SVNSqlJetStatement stmt) throws SVNException {
        return SvnWcDbStatementUtil.getColumnToken(stmt, SVNWCDbSchema.NODES__Fields.presence, presenceMap2);
    }

    public static ISVNWCDb.SVNWCDbStatus getColumnPresence(SVNSqlJetStatement stmt, Enum<?> f) throws SVNException {
        return SvnWcDbStatementUtil.getColumnToken(stmt, f, presenceMap2);
    }

    public static ISVNWCDb.SVNWCDbKind getColumnKind(SVNSqlJetStatement stmt, Enum<?> f) throws SVNException {
        return SvnWcDbStatementUtil.getColumnToken(stmt, f, kindMap2);
    }

    public static SVNProperties getColumnProperties(SVNSqlJetStatement stmt, Enum<?> f) throws SVNException {
        return stmt.getColumnProperties(f);
    }

    public static List<Structure<StructureFields.InheritedProperties>> getColumnInheritedProperties(SVNSqlJetStatement stmt, Enum<?> f) throws SVNException {
        return stmt.getColumnInheritedProperties(f);
    }

    public static boolean hasColumnProperties(SVNSqlJetStatement stmt, Enum<?> f) throws SVNException {
        return stmt.hasColumnProperties(f);
    }

    public static String getColumnText(SVNSqlJetStatement stmt, Enum<?> f) throws SVNException {
        return stmt.getColumnString(f);
    }

    public static File getColumnPath(SVNSqlJetStatement stmt, Enum<?> f) throws SVNException {
        String path = stmt.getColumnString(f);
        if (path != null) {
            return SVNFileUtil.createFilePath(path);
        }
        return null;
    }

    public static SVNDepth getColumnDepth(SVNSqlJetStatement stmt, Enum<?> f) throws SVNException {
        return SvnWcDbStatementUtil.parseDepth(stmt.getColumnString(f));
    }

    public static boolean isColumnNull(SVNSqlJetStatement stmt, Enum<?> f) throws SVNException {
        return stmt.isColumnNull(f);
    }

    public static long getColumnInt64(SVNSqlJetStatement stmt, Enum<?> f) throws SVNException {
        return stmt.getColumnLong(f);
    }

    public static byte[] getColumnBlob(SVNSqlJetStatement stmt, Enum<?> f) throws SVNException {
        return stmt.getColumnBlob(f);
    }

    public static boolean getColumnBoolean(SVNSqlJetStatement stmt, Enum<?> f) throws SVNException {
        return stmt.getColumnBoolean(f);
    }

    public static long getColumnRevNum(SVNSqlJetStatement stmt, Enum<?> f) throws SVNException {
        if (SvnWcDbStatementUtil.isColumnNull(stmt, f)) {
            return -1L;
        }
        return (int)SvnWcDbStatementUtil.getColumnInt64(stmt, f);
    }

    public static long getTranslatedSize(SVNSqlJetStatement stmt, Enum<?> f) throws SVNException {
        if (SvnWcDbStatementUtil.isColumnNull(stmt, f)) {
            return -1L;
        }
        return SvnWcDbStatementUtil.getColumnInt64(stmt, f);
    }

    public static <T extends Enum<T>> T getColumnToken(SVNSqlJetStatement stmt, Enum<?> f, Map<String, T> tokenMap) throws SVNException {
        return (T)((Enum)tokenMap.get(SvnWcDbStatementUtil.getColumnText(stmt, f)));
    }

    public static SvnChecksum getColumnChecksum(SVNSqlJetStatement stmt, Enum<?> f) throws SVNException {
        String str = stmt.getColumnString(f);
        if (str == null) {
            return null;
        }
        return SvnChecksum.fromString(str);
    }

    public static SVNDate getColumnDate(SVNSqlJetStatement stmt, Enum<?> f) throws SVNException {
        if (SvnWcDbStatementUtil.isColumnNull(stmt, f)) {
            return null;
        }
        return SVNWCUtils.readDate(SvnWcDbStatementUtil.getColumnInt64(stmt, f));
    }

    public static ISVNWCDb.SVNWCDbLock getLockFromColumns(SVNSqlJetStatement stmt, Enum<?> tokenField, Enum<?> owner, Enum<?> comment, Enum<?> date) throws SVNException {
        if (SvnWcDbStatementUtil.isColumnNull(stmt, tokenField)) {
            return null;
        }
        ISVNWCDb.SVNWCDbLock lock = new ISVNWCDb.SVNWCDbLock();
        lock.token = SvnWcDbStatementUtil.getColumnText(stmt, tokenField);
        if (!SvnWcDbStatementUtil.isColumnNull(stmt, owner)) {
            lock.owner = SvnWcDbStatementUtil.getColumnText(stmt, owner);
        }
        if (!SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.LOCK__Fields.lock_comment)) {
            lock.comment = SvnWcDbStatementUtil.getColumnText(stmt, comment);
        }
        if (!SvnWcDbStatementUtil.isColumnNull(stmt, SVNWCDbSchema.LOCK__Fields.lock_date)) {
            lock.date = SvnWcDbStatementUtil.getColumnDate(stmt, date);
        }
        return lock;
    }

    public static void reset(SVNSqlJetStatement stmt) throws SVNException {
        if (stmt != null) {
            stmt.reset();
        }
    }

    public static SVNEventAction getColumnEventAction(SVNSqlJetStatement stmt, Enum<?> f) throws SVNException {
        return SVNEventAction.getEventActionById((int)stmt.getColumnLong(f));
    }

    public static SVNStatusType getColumnStatusType(SVNSqlJetStatement stmt, Enum<?> f) throws SVNException {
        return SVNStatusType.getEventStatusById((int)stmt.getColumnLong(f));
    }

    public static SVNNodeKind getColumnNodeKind(SVNSqlJetStatement stmt, Enum<?> f) throws SVNException {
        return SVNNodeKind.getNodeKindById((int)stmt.getColumnLong(f));
    }

    static {
        presenceMap.put(ISVNWCDb.SVNWCDbStatus.Normal, "normal");
        presenceMap.put(ISVNWCDb.SVNWCDbStatus.Excluded, "excluded");
        presenceMap.put(ISVNWCDb.SVNWCDbStatus.ServerExcluded, "server-excluded");
        presenceMap.put(ISVNWCDb.SVNWCDbStatus.NotPresent, "not-present");
        presenceMap.put(ISVNWCDb.SVNWCDbStatus.Incomplete, "incomplete");
        presenceMap.put(ISVNWCDb.SVNWCDbStatus.BaseDeleted, "base-deleted");
        presenceMap2.put("normal", ISVNWCDb.SVNWCDbStatus.Normal);
        presenceMap2.put("server-excluded", ISVNWCDb.SVNWCDbStatus.ServerExcluded);
        presenceMap2.put("absent", ISVNWCDb.SVNWCDbStatus.ServerExcluded);
        presenceMap2.put("excluded", ISVNWCDb.SVNWCDbStatus.Excluded);
        presenceMap2.put("not-present", ISVNWCDb.SVNWCDbStatus.NotPresent);
        presenceMap2.put("incomplete", ISVNWCDb.SVNWCDbStatus.Incomplete);
        presenceMap2.put("base-deleted", ISVNWCDb.SVNWCDbStatus.BaseDeleted);
        kindMap = new EnumMap(ISVNWCDb.SVNWCDbKind.class);
        kindMap2 = new HashMap();
        kindMap.put(ISVNWCDb.SVNWCDbKind.File, "file");
        kindMap.put(ISVNWCDb.SVNWCDbKind.Dir, "dir");
        kindMap.put(ISVNWCDb.SVNWCDbKind.Symlink, "symlink");
        kindMap.put(ISVNWCDb.SVNWCDbKind.Unknown, "unknown");
        kindMap2.put("file", ISVNWCDb.SVNWCDbKind.File);
        kindMap2.put("dir", ISVNWCDb.SVNWCDbKind.Dir);
        kindMap2.put("symlink", ISVNWCDb.SVNWCDbKind.Symlink);
        kindMap2.put("unknown", ISVNWCDb.SVNWCDbKind.Unknown);
    }
}

