/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc16;

import java.io.File;
import java.util.Iterator;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNCopyDriver;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.internal.wc16.SVNCopyClient16;
import org.tmatesoft.svn.core.internal.wc16.SVNWCClient16;
import org.tmatesoft.svn.core.wc.ISVNEventHandler;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNRepositoryPool;
import org.tmatesoft.svn.core.wc.SVNCopySource;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.util.ISVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNMoveClient16
extends SVNCopyDriver {
    private SVNWCClient16 myWCClient;
    private SVNCopyClient16 myCopyClient;

    public SVNMoveClient16(ISVNAuthenticationManager authManager, ISVNOptions options) {
        super(authManager, options);
        this.myWCClient = new SVNWCClient16(authManager, options);
        this.myCopyClient = new SVNCopyClient16(authManager, options);
    }

    public SVNMoveClient16(ISVNRepositoryPool repositoryPool, ISVNOptions options) {
        super(repositoryPool, options);
        this.myWCClient = new SVNWCClient16(repositoryPool, options);
        this.myCopyClient = new SVNCopyClient16(repositoryPool, options);
    }

    @Override
    public void setEventHandler(ISVNEventHandler dispatcher) {
        super.setEventHandler(dispatcher);
        this.myWCClient.setEventHandler(dispatcher);
        this.myCopyClient.setEventHandler(dispatcher);
    }

    @Override
    public void setDebugLog(ISVNDebugLog log) {
        super.setDebugLog(log);
        this.myWCClient.setDebugLog(log);
        this.myCopyClient.setDebugLog(log);
    }

    @Override
    public void setOptions(ISVNOptions options) {
        super.setOptions(options);
        if (this.myWCClient != null) {
            this.myWCClient.setOptions(options);
        }
        if (this.myCopyClient != null) {
            this.myCopyClient.setOptions(options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doMove(File src, File dst) throws SVNException {
        SVNErrorMessage err;
        if (dst.exists()) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "File ''{0}'' already exists", (Object)dst);
            SVNErrorManager.error(err, SVNLogType.WC);
        } else if (!src.exists()) {
            err = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Path ''{0}'' does not exist", (Object)src);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        boolean srcIsVersioned = SVNMoveClient16.isVersionedFile(src);
        boolean dstParentIsVersioned = SVNMoveClient16.isVersionedFile(dst.getParentFile());
        if (!srcIsVersioned && !dstParentIsVersioned) {
            SVNFileUtil.rename(src, dst);
        } else if (!dstParentIsVersioned) {
            SVNFileUtil.copy(src, dst, false, false);
            this.myWCClient.doDelete(src, true, false);
        } else if (!srcIsVersioned) {
            SVNFileUtil.rename(src, dst);
        } else {
            SVNWCAccess wcAccess = this.createWCAccess();
            File srcParent = src.getParentFile();
            File dstParent = dst.getParentFile();
            SVNAdminArea srcParentArea = null;
            SVNAdminArea dstParentArea = null;
            try {
                boolean sameWC;
                if (srcParent.equals(dstParent)) {
                    wcAccess.closeAdminArea(srcParent);
                    srcParentArea = dstParentArea = wcAccess.open(srcParent, true, 0);
                } else {
                    srcParentArea = wcAccess.open(srcParent, false, 0);
                    dstParentArea = wcAccess.open(dstParent, true, 0);
                }
                SVNEntry srcEntry = srcParentArea.getVersionedEntry(src.getName(), false);
                SVNEntry dstEntry = dstParentArea.getEntry(dst.getName(), false);
                File srcWCRoot = SVNWCUtil.getWorkingCopyRoot(src, true);
                File dstWCRoot = SVNWCUtil.getWorkingCopyRoot(dst, true);
                boolean bl = sameWC = srcWCRoot != null && srcWCRoot.equals(dstWCRoot);
                if (sameWC && dstEntry != null && (dstEntry.isScheduledForDeletion() || dstEntry.getKind() != srcEntry.getKind())) {
                    wcAccess.close();
                    if (srcEntry.getKind() == dstEntry.getKind() && srcEntry.getSchedule() == null && srcEntry.isFile()) {
                        SVNCopySource source2 = new SVNCopySource(SVNRevision.UNDEFINED, SVNRevision.WORKING, src);
                        this.myCopyClient.doCopy(new SVNCopySource[]{source2}, dst, true, false, true);
                        return;
                    }
                    SVNFileUtil.copy(src, dst, false, false);
                    try {
                        this.myWCClient.doAdd(dst, false, false, false, SVNDepth.INFINITY, false, false);
                    }
                    catch (SVNException source2) {
                        // empty catch block
                    }
                    this.myWCClient.doDelete(src, true, false);
                    return;
                }
                if (!sameWC) {
                    SVNEntry srcTmpEntry;
                    SVNEntry dstTmpEntry = dstEntry != null && dstEntry.isThisDir() ? dstEntry : dstParentArea.getVersionedEntry(dstParentArea.getThisDirName(), false);
                    SVNEntry sVNEntry = srcTmpEntry = srcEntry != null && srcEntry.isThisDir() ? srcEntry : srcParentArea.getVersionedEntry(srcParentArea.getThisDirName(), false);
                    if (srcTmpEntry.getRepositoryRoot() != null && dstTmpEntry.getRepositoryRoot() != null && srcTmpEntry.getRepositoryRoot().equals(dstTmpEntry.getRepositoryRoot())) {
                        wcAccess.close();
                        SVNCopySource source3 = new SVNCopySource(SVNRevision.UNDEFINED, SVNRevision.WORKING, src);
                        this.myCopyClient.doCopy(new SVNCopySource[]{source3}, dst, true, false, true);
                        return;
                    }
                }
                if (dstEntry != null) {
                    SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "There is already a versioned item ''{0}''", (Object)dst);
                    SVNErrorManager.error(err2, SVNLogType.WC);
                }
                SVNFileUtil.copy(src, dst, false, sameWC);
                if (!sameWC) {
                    wcAccess.close();
                    try {
                        this.myWCClient.doAdd(dst, false, false, false, SVNDepth.INFINITY, false, false);
                    }
                    catch (SVNException err2) {}
                } else if (srcEntry.isFile()) {
                    if (dstEntry == null) {
                        dstEntry = dstParentArea.addEntry(dst.getName());
                    }
                    String srcURL = srcEntry.getURL();
                    String srcCFURL = srcEntry.getCopyFromURL();
                    long srcRevision = srcEntry.getRevision();
                    long srcCFRevision = srcEntry.getCopyFromRevision();
                    SVNVersionedProperties srcProps = srcParentArea.getProperties(src.getName());
                    SVNVersionedProperties dstProps = dstParentArea.getProperties(dst.getName());
                    srcProps.copyTo(dstProps);
                    File srcBaseFile = srcParentArea.getBaseFile(src.getName(), false);
                    File dstBaseFile = dstParentArea.getBaseFile(dst.getName(), false);
                    if (srcBaseFile.isFile()) {
                        SVNFileUtil.copy(srcBaseFile, dstBaseFile, false, false);
                    }
                    if (srcEntry.isScheduledForAddition() && srcEntry.isCopied()) {
                        dstEntry.scheduleForAddition();
                        dstEntry.setCopyFromRevision(srcCFRevision);
                        dstEntry.setCopyFromURL(srcCFURL);
                        dstEntry.setKind(SVNNodeKind.FILE);
                        dstEntry.setRevision(srcRevision);
                        dstEntry.setCopied(true);
                    } else if (!srcEntry.isCopied() && !srcEntry.isScheduledForAddition()) {
                        dstEntry.setCopied(true);
                        dstEntry.scheduleForAddition();
                        dstEntry.setKind(SVNNodeKind.FILE);
                        dstEntry.setCopyFromRevision(srcRevision);
                        dstEntry.setCopyFromURL(srcURL);
                    } else {
                        dstEntry.scheduleForAddition();
                        dstEntry.setKind(SVNNodeKind.FILE);
                        if (!dstEntry.isScheduledForReplacement()) {
                            dstEntry.setRevision(0L);
                        }
                    }
                    SVNLog log = dstParentArea.getLog();
                    dstParentArea.saveEntries(false);
                    dstParentArea.saveVersionedProperties(log, true);
                    log.save();
                    dstParentArea.runLogs();
                } else if (srcEntry.isDirectory()) {
                    SVNAdminArea srcArea = wcAccess.open(src, false, 0);
                    srcEntry = srcArea.getEntry(srcArea.getThisDirName(), false);
                    if (dstEntry == null) {
                        dstEntry = dstParentArea.addEntry(dst.getName());
                    }
                    SVNAdminArea dstArea = wcAccess.open(dst, true, -1);
                    SVNVersionedProperties srcProps = srcArea.getProperties(srcArea.getThisDirName());
                    SVNVersionedProperties dstProps = dstArea.getProperties(dstArea.getThisDirName());
                    SVNEntry dstParentEntry = dstParentArea.getEntry(dstParentArea.getThisDirName(), false);
                    String srcURL = srcEntry.getURL();
                    String srcCFURL = srcEntry.getCopyFromURL();
                    String dstURL = dstParentEntry.getURL();
                    String repositoryRootURL = dstParentEntry.getRepositoryRoot();
                    long srcRevision = srcEntry.getRevision();
                    long srcCFRevision = srcEntry.getCopyFromRevision();
                    dstURL = SVNPathUtil.append(dstURL, SVNEncodingUtil.uriEncode(dst.getName()));
                    if (srcEntry.isScheduledForAddition() && srcEntry.isCopied()) {
                        srcProps.copyTo(dstProps);
                        dstEntry.scheduleForAddition();
                        dstEntry.setKind(SVNNodeKind.DIR);
                        dstEntry.setCopied(true);
                        dstEntry.setCopyFromRevision(srcCFRevision);
                        dstEntry.setCopyFromURL(srcCFURL);
                        SVNEntry dstThisEntry = dstArea.getEntry(dstArea.getThisDirName(), false);
                        dstThisEntry.scheduleForAddition();
                        dstThisEntry.setKind(SVNNodeKind.DIR);
                        dstThisEntry.setCopyFromRevision(srcCFRevision);
                        dstThisEntry.setCopyFromURL(srcCFURL);
                        dstThisEntry.setRevision(srcRevision);
                        dstThisEntry.setCopied(true);
                        SVNLog log = dstArea.getLog();
                        dstArea.saveVersionedProperties(log, true);
                        dstParentArea.saveEntries(false);
                        log.save();
                        dstArea.runLogs();
                        dstArea.updateURL(dstURL, true);
                        dstParentArea.saveEntries(true);
                    } else if (!srcEntry.isCopied() && !srcEntry.isScheduledForAddition()) {
                        srcProps.copyTo(dstProps);
                        dstEntry.scheduleForAddition();
                        dstEntry.setKind(SVNNodeKind.DIR);
                        dstEntry.setCopied(true);
                        dstEntry.setCopyFromRevision(srcRevision);
                        dstEntry.setCopyFromURL(srcURL);
                        SVNEntry dstThisEntry = dstArea.getEntry(dstArea.getThisDirName(), false);
                        dstThisEntry.scheduleForAddition();
                        dstThisEntry.setKind(SVNNodeKind.DIR);
                        dstThisEntry.setCopied(true);
                        dstThisEntry.scheduleForAddition();
                        dstThisEntry.setKind(SVNNodeKind.DIR);
                        dstThisEntry.setCopyFromRevision(srcRevision);
                        dstThisEntry.setCopyFromURL(srcURL);
                        dstThisEntry.setURL(dstURL);
                        dstThisEntry.setRepositoryRoot(repositoryRootURL);
                        SVNLog log = dstArea.getLog();
                        dstArea.saveVersionedProperties(log, true);
                        dstArea.saveEntries(false);
                        log.save();
                        dstArea.runLogs();
                        this.updateCopiedDirectory(dstArea, dstArea.getThisDirName(), dstURL, repositoryRootURL, null, -1L);
                        dstArea.saveEntries(true);
                        dstParentArea.saveEntries(true);
                    } else {
                        dstParentArea.deleteEntry(dst.getName());
                        dstParentArea.saveEntries(true);
                        SVNFileUtil.deleteAll(dst, this);
                        SVNFileUtil.copy(src, dst, false, false);
                        wcAccess.close();
                        this.myWCClient.doAdd(dst, false, false, false, SVNDepth.INFINITY, false, false);
                    }
                }
                try {
                    wcAccess.close();
                    this.myWCClient.doDelete(src, true, false);
                }
                catch (SVNException sVNException) {
                    // empty catch block
                }
            }
            finally {
                wcAccess.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undoMove(File src, File dst) throws SVNException {
        if (!src.exists()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.NODE_UNKNOWN_KIND, "Path ''{0}'' does not exist", (Object)src);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        boolean srcIsVersioned = SVNMoveClient16.isVersionedFile(src);
        boolean dstParentIsVersioned = SVNMoveClient16.isVersionedFile(dst.getParentFile());
        if (!srcIsVersioned && !dstParentIsVersioned) {
            SVNFileUtil.rename(src, dst);
        } else if (!dstParentIsVersioned) {
            SVNFileUtil.copy(src, dst, false, false);
            this.myWCClient.doDelete(src, true, false);
        } else if (!srcIsVersioned) {
            SVNFileUtil.rename(src, dst);
            boolean revert = false;
            try (SVNWCAccess dstAccess = this.createWCAccess();){
                dstAccess.probeOpen(dst, false, 0);
                SVNEntry dstEntry = dstAccess.getEntry(dst, false);
                revert = dstEntry != null && dstEntry.isScheduledForDeletion();
            }
            if (revert) {
                this.myWCClient.doRevert(new File[]{dst}, SVNDepth.INFINITY, null);
            }
        } else {
            SVNWCAccess wcAccess = this.createWCAccess();
            File srcParent = src.getParentFile();
            File dstParent = dst.getParentFile();
            SVNAdminArea srcParentArea = null;
            SVNAdminArea dstParentArea = null;
            try {
                if (srcParent.equals(dstParent)) {
                    wcAccess.closeAdminArea(srcParent);
                    srcParentArea = dstParentArea = wcAccess.open(srcParent, true, 0);
                } else {
                    srcParentArea = wcAccess.open(srcParent, false, 0);
                    dstParentArea = wcAccess.open(dstParent, true, 0);
                }
                SVNEntry srcEntry = srcParentArea.getEntry(src.getName(), true);
                SVNEntry dstEntry = dstParentArea.getEntry(dst.getName(), true);
                if (dstEntry != null && dstEntry.isScheduledForDeletion()) {
                    wcAccess.close();
                    this.myWCClient.doRevert(new File[]{dst}, SVNDepth.INFINITY, null);
                    this.myWCClient.doDelete(src, true, false);
                    return;
                }
                SVNEntry dstParentEntry = wcAccess.getEntry(dstParent, false);
                File srcWCRoot = SVNWCUtil.getWorkingCopyRoot(src, true);
                File dstWCRoot = SVNWCUtil.getWorkingCopyRoot(dst, true);
                boolean sameWC = srcWCRoot != null && srcWCRoot.equals(dstWCRoot);
                SVNFileUtil.copy(src, dst, false, sameWC);
                if (dstEntry != null && dstEntry.getKind() != srcEntry.getKind()) {
                    wcAccess.close();
                    this.myWCClient.doDelete(src, true, false);
                    return;
                }
                if (!sameWC) {
                    wcAccess.close();
                    try {
                        this.myWCClient.doAdd(dst, false, false, false, SVNDepth.INFINITY, false, false);
                    }
                    catch (SVNException sVNException) {}
                } else if (srcEntry.isFile()) {
                    if (dstEntry == null) {
                        dstEntry = dstParentArea.addEntry(dst.getName());
                    }
                    String srcURL = srcEntry.getURL();
                    String srcCFURL = srcEntry.getCopyFromURL();
                    long srcRevision = srcEntry.getRevision();
                    long srcCFRevision = srcEntry.getCopyFromRevision();
                    if (srcEntry.isScheduledForAddition() && srcEntry.isCopied()) {
                        dstEntry.scheduleForAddition();
                        dstEntry.setCopyFromRevision(srcCFRevision);
                        dstEntry.setCopyFromURL(srcCFURL);
                        dstEntry.setKind(SVNNodeKind.FILE);
                        dstEntry.setRevision(srcRevision);
                        dstEntry.setCopied(true);
                    } else if (!srcEntry.isCopied() && !srcEntry.isScheduledForAddition()) {
                        dstEntry.setCopied(true);
                        dstEntry.scheduleForAddition();
                        dstEntry.setKind(SVNNodeKind.FILE);
                        dstEntry.setCopyFromRevision(srcRevision);
                        dstEntry.setCopyFromURL(srcURL);
                    } else {
                        dstEntry.scheduleForAddition();
                        dstEntry.setKind(SVNNodeKind.FILE);
                        if (!dstEntry.isScheduledForReplacement()) {
                            dstEntry.setRevision(0L);
                        }
                    }
                    dstParentArea.saveEntries(false);
                } else if (srcEntry.isDirectory()) {
                    SVNAdminArea srcArea = wcAccess.open(src, false, 0);
                    srcEntry = srcArea.getEntry(srcArea.getThisDirName(), false);
                    if (dstEntry == null) {
                        dstEntry = dstParentArea.addEntry(dst.getName());
                    }
                    String srcURL = srcEntry.getURL();
                    String dstURL = dstParentEntry.getURL();
                    long srcRevision = srcEntry.getRevision();
                    String repositoryRootURL = srcEntry.getRepositoryRoot();
                    dstURL = SVNPathUtil.append(dstURL, SVNEncodingUtil.uriEncode(dst.getName()));
                    SVNAdminArea dstArea = wcAccess.open(dst, true, -1);
                    if (srcEntry.isScheduledForAddition() && srcEntry.isCopied()) {
                        dstEntry.scheduleForAddition();
                        dstEntry.setKind(SVNNodeKind.DIR);
                        dstParentArea.saveEntries(true);
                        dstArea.updateURL(dstURL, true);
                        dstArea.saveEntries(true);
                    } else if (!srcEntry.isCopied() && !srcEntry.isScheduledForAddition()) {
                        dstEntry.setCopied(true);
                        dstEntry.scheduleForAddition();
                        dstEntry.setKind(SVNNodeKind.DIR);
                        dstEntry.setCopyFromRevision(srcRevision);
                        dstEntry.setCopyFromURL(srcURL);
                        dstParentArea.saveEntries(true);
                        SVNEntry dstThisEntry = dstArea.getEntry(dstArea.getThisDirName(), false);
                        dstThisEntry.setCopied(true);
                        dstThisEntry.scheduleForAddition();
                        dstThisEntry.setKind(SVNNodeKind.DIR);
                        dstThisEntry.setCopyFromRevision(srcRevision);
                        dstThisEntry.setURL(dstURL);
                        dstThisEntry.setCopyFromURL(srcURL);
                        dstThisEntry.setRepositoryRoot(repositoryRootURL);
                        this.updateCopiedDirectory(dstArea, dstArea.getThisDirName(), dstURL, repositoryRootURL, null, -1L);
                        dstArea.saveEntries(true);
                    } else {
                        dstParentArea.deleteEntry(dst.getName());
                        dstParentArea.saveEntries(true);
                        wcAccess.close();
                        SVNFileUtil.deleteAll(dst, this);
                        SVNFileUtil.copy(src, dst, false, false);
                        this.myWCClient.doAdd(dst, false, false, false, SVNDepth.INFINITY, false, false);
                    }
                }
                try {
                    wcAccess.close();
                    this.myWCClient.doDelete(src, true, false);
                }
                catch (SVNException sVNException) {
                    // empty catch block
                }
            }
            finally {
                wcAccess.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doVirtualCopy(File src, File dst, boolean move) throws SVNException {
        SVNErrorMessage err;
        String opName;
        SVNFileType srcType = SVNFileType.getType(src);
        SVNFileType dstType = SVNFileType.getType(dst);
        String string = opName = move ? "move" : "copy";
        if (move && srcType != SVNFileType.NONE) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_EXISTS, "Cannot perform 'virtual' {0}: ''{1}'' still exists", opName, src);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (dstType == SVNFileType.NONE) {
            err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Cannot perform 'virtual' {0}: ''{1}'' does not exist", opName, dst);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (dstType == SVNFileType.DIRECTORY) {
            err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot perform 'virtual' {0}: ''{1}'' is a directory", opName, dst);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (!move && srcType == SVNFileType.DIRECTORY) {
            err = SVNErrorMessage.create(SVNErrorCode.ILLEGAL_TARGET, "Cannot perform 'virtual' {0}: ''{1}'' is a directory", opName, src);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNURL srcRepoRoot = null;
        SVNURL dstRepoRoot = null;
        boolean versionedDst = false;
        try (SVNWCAccess dstAccess = this.createWCAccess();){
            dstAccess.probeOpen(dst, false, 0);
            SVNEntry dstEntry = dstAccess.getEntry(dst, false);
            if (dstEntry != null) {
                if (!dstEntry.isScheduledForAddition() && !dstEntry.isScheduledForReplacement()) {
                    SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.ENTRY_ATTRIBUTE_INVALID, "Cannot perform 'virtual' {0}: ''{1}'' is scheduled neither for addition nor for replacement", opName, dst);
                    SVNErrorManager.error(err2, SVNLogType.WC);
                }
                versionedDst = true;
                dstRepoRoot = dstEntry.getRepositoryRootURL();
            }
        }
        SVNWCAccess srcAccess = this.createWCAccess();
        String cfURL = null;
        boolean added = false;
        long cfRevision = -1L;
        try {
            SVNErrorMessage err3;
            srcAccess.probeOpen(src, false, 0);
            SVNEntry srcEntry = srcAccess.getEntry(src, false);
            if (srcEntry == null) {
                err3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "''{0}'' is not under version control", (Object)src);
                SVNErrorManager.error(err3, SVNLogType.WC);
            }
            srcRepoRoot = srcEntry.getRepositoryRootURL();
            if (this.isCopiedAsAChild(src, srcEntry)) {
                cfURL = this.getCopyFromURL(src.getParentFile(), SVNEncodingUtil.uriEncode(src.getName()));
                cfRevision = this.getCopyFromRevision(src.getParentFile());
                if (cfURL == null || cfRevision < 0L) {
                    err3 = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "Cannot locate copied directory root for ''{0}''", (Object)src);
                    SVNErrorManager.error(err3, SVNLogType.WC);
                }
                added = false;
            } else {
                cfURL = srcEntry.isCopied() ? srcEntry.getCopyFromURL() : srcEntry.getURL();
                cfRevision = srcEntry.isCopied() ? srcEntry.getCopyFromRevision() : srcEntry.getRevision();
                added = srcEntry.isScheduledForAddition() && !srcEntry.isCopied();
            }
        }
        finally {
            srcAccess.close();
        }
        if (added && !versionedDst) {
            if (move) {
                this.myWCClient.doDelete(src, true, false);
            }
            this.myWCClient.doAdd(dst, true, false, false, SVNDepth.EMPTY, false, false);
            return;
        }
        dstAccess = this.createWCAccess();
        srcAccess = this.createWCAccess();
        try {
            SVNErrorMessage err4;
            SVNAdminArea dstArea = dstAccess.probeOpen(dst, true, 0);
            SVNEntry dstEntry = dstAccess.getEntry(dst, false);
            if (dstEntry != null && !dstEntry.isScheduledForAddition() && !dstEntry.isScheduledForReplacement()) {
                err4 = SVNErrorMessage.create(SVNErrorCode.ENTRY_ATTRIBUTE_INVALID, "Cannot perform 'virtual' {0}: ''{1}'' is scheduled neither for addition nor for replacement", opName, dst);
                SVNErrorManager.error(err4, SVNLogType.WC);
            }
            if (srcRepoRoot != null && dstRepoRoot != null && !dstRepoRoot.equals(srcRepoRoot)) {
                err4 = SVNErrorMessage.create(SVNErrorCode.ENTRY_ATTRIBUTE_INVALID, "Cannot perform 'virtual' {0}: paths belong to different repositories", (Object)opName);
                SVNErrorManager.error(err4, SVNLogType.WC);
            }
            SVNAdminArea srcArea = srcAccess.probeOpen(src, false, 0);
            SVNVersionedProperties srcProps = srcArea.getProperties(src.getName());
            SVNVersionedProperties srcBaseProps = srcArea.getBaseProperties(src.getName());
            SVNVersionedProperties dstProps = dstArea.getProperties(dst.getName());
            SVNVersionedProperties dstBaseProps = dstArea.getBaseProperties(dst.getName());
            dstBaseProps.removeAll();
            srcProps.copyTo(dstProps);
            srcBaseProps.copyTo(dstBaseProps);
            dstEntry = dstArea.addEntry(dst.getName());
            dstEntry.setCopyFromURL(cfURL);
            dstEntry.setCopyFromRevision(cfRevision);
            dstEntry.setCopied(true);
            dstEntry.setKind(SVNNodeKind.FILE);
            File baseSrc = srcArea.getBaseFile(src.getName(), false);
            File baseDst = dstArea.getBaseFile(dst.getName(), false);
            SVNFileUtil.copyFile(baseSrc, baseDst, false);
            if (dstEntry.isScheduledForDeletion()) {
                dstEntry.unschedule();
                dstEntry.scheduleForReplacement();
            } else if (!dstEntry.isScheduledForReplacement()) {
                dstEntry.unschedule();
                dstEntry.scheduleForAddition();
            }
            dstArea.saveEntries(false);
            SVNLog log = dstArea.getLog();
            dstArea.saveVersionedProperties(log, true);
            log.save();
            dstArea.runLogs();
            SVNEvent event = SVNEventFactory.createSVNEvent(dst, SVNNodeKind.FILE, null, -1L, SVNEventAction.COPY, null, null, null);
            this.dispatchEvent(event);
        }
        finally {
            srcAccess.close();
            dstAccess.close();
        }
        if (move) {
            this.myWCClient.doDelete(src, true, false);
        }
    }

    private boolean isCopiedAsAChild(File path, SVNEntry entry) throws SVNException {
        if (!entry.isScheduledForAddition() && entry.isCopied()) {
            return true;
        }
        if (entry.isScheduledForDeletion() && path != null) {
            return this.getCopyFromURL(path.getParentFile(), SVNEncodingUtil.uriEncode(entry.getName())) != null;
        }
        return false;
    }

    private void updateCopiedDirectory(SVNAdminArea dir, String name, String newURL, String reposRootURL, String copyFromURL, long copyFromRevision) throws SVNException {
        SVNWCAccess wcAccess = dir.getWCAccess();
        SVNEntry entry = dir.getEntry(name, true);
        if (entry != null) {
            entry.setCopied(true);
            if (newURL != null) {
                entry.setURL(newURL);
            }
            entry.setRepositoryRoot(reposRootURL);
            if (entry.isFile()) {
                if (dir.getWCProperties(name) != null) {
                    dir.getWCProperties(name).removeAll();
                    dir.saveWCProperties(false);
                }
                if (copyFromURL != null) {
                    entry.setCopyFromURL(copyFromURL);
                    entry.setCopyFromRevision(copyFromRevision);
                }
            }
            boolean deleted = false;
            if (entry.isDeleted() && newURL != null) {
                deleted = true;
                entry.setDeleted(false);
                entry.scheduleForDeletion();
                if (entry.isDirectory()) {
                    entry.setKind(SVNNodeKind.FILE);
                }
            }
            if (entry.getLockToken() != null && newURL != null) {
                entry.setLockToken(null);
                entry.setLockOwner(null);
                entry.setLockComment(null);
                entry.setLockCreationDate(null);
            }
            if (!dir.getThisDirName().equals(name) && entry.isDirectory() && !deleted) {
                SVNAdminArea childDir = wcAccess.retrieve(dir.getFile(name));
                if (childDir != null) {
                    String childCopyFromURL = copyFromURL == null ? null : SVNPathUtil.append(copyFromURL, SVNEncodingUtil.uriEncode(entry.getName()));
                    this.updateCopiedDirectory(childDir, childDir.getThisDirName(), newURL, reposRootURL, childCopyFromURL, copyFromRevision);
                }
            } else if (dir.getThisDirName().equals(name)) {
                dir.getWCProperties(dir.getThisDirName()).removeAll();
                dir.saveWCProperties(false);
                if (copyFromURL != null) {
                    entry.setCopyFromURL(copyFromURL);
                    entry.setCopyFromRevision(copyFromRevision);
                }
                Iterator ents = dir.entries(true);
                while (ents.hasNext()) {
                    SVNEntry childEntry = (SVNEntry)ents.next();
                    if (dir.getThisDirName().equals(childEntry.getName())) continue;
                    String childCopyFromURL = copyFromURL == null ? null : SVNPathUtil.append(copyFromURL, SVNEncodingUtil.uriEncode(childEntry.getName()));
                    String newChildURL = newURL == null ? null : SVNPathUtil.append(newURL, SVNEncodingUtil.uriEncode(childEntry.getName()));
                    this.updateCopiedDirectory(dir, childEntry.getName(), newChildURL, reposRootURL, childCopyFromURL, copyFromRevision);
                }
                dir.saveEntries(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCopyFromURL(File path, String urlTail) throws SVNException {
        if (path == null) {
            return null;
        }
        SVNWCAccess wcAccess = this.createWCAccess();
        try {
            wcAccess.probeOpen(path, false, 0);
        }
        catch (SVNException e) {
            wcAccess.close();
            return null;
        }
        try {
            SVNEntry entry = wcAccess.getEntry(path, false);
            if (entry == null) {
                String string = null;
                return string;
            }
            String cfURL = entry.getCopyFromURL();
            if (cfURL != null) {
                String string = SVNPathUtil.append(cfURL, urlTail);
                return string;
            }
            urlTail = SVNPathUtil.append(SVNEncodingUtil.uriEncode(path.getName()), urlTail);
            path = path.getParentFile();
            String string = this.getCopyFromURL(path, urlTail);
            return string;
        }
        finally {
            wcAccess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getCopyFromRevision(File path) throws SVNException {
        if (path == null) {
            return -1L;
        }
        SVNWCAccess wcAccess = this.createWCAccess();
        try {
            wcAccess.probeOpen(path, false, 0);
        }
        catch (SVNException e) {
            wcAccess.close();
            return -1L;
        }
        try {
            SVNEntry entry = wcAccess.getEntry(path, false);
            if (entry == null) {
                long l = -1L;
                return l;
            }
            long rev = entry.getCopyFromRevision();
            if (rev >= 0L) {
                long l = rev;
                return l;
            }
            path = path.getParentFile();
            long l = this.getCopyFromRevision(path);
            return l;
        }
        finally {
            wcAccess.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isVersionedFile(File file) {
        SVNWCAccess wcAccess = SVNWCAccess.newInstance(null);
        try {
            SVNAdminArea area = wcAccess.probeOpen(file, false, 0);
            if (area.getEntry(area.getThisDirName(), false) == null) {
                boolean bl = false;
                return bl;
            }
            SVNFileType type = SVNFileType.getType(file);
            if (type.isFile() || type == SVNFileType.NONE) {
                boolean bl = area.getEntry(file.getName(), false) != null;
                return bl;
            }
            if (type != SVNFileType.NONE && !area.getRoot().equals(file)) {
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (SVNException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                wcAccess.close();
            }
            catch (SVNException sVNException) {}
        }
    }
}

