/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.patch;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchFileStream;
import org.tmatesoft.svn.core.internal.wc.patch.SVNPatchHunk;

public class SVNPatch {
    public static final String MINUS = "--- ";
    public static final String PLUS = "+++ ";
    public static final String ATAT = "@@";
    private File path;
    private SVNPatchFileStream patchFile;
    private File oldFilename;
    private File newFilename;
    private List hunks;

    public File getPath() {
        return this.path;
    }

    public SVNPatchFileStream getPatchFile() {
        return this.patchFile;
    }

    public File getOldFilename() {
        return this.oldFilename;
    }

    public File getNewFilename() {
        return this.newFilename;
    }

    public List getHunks() {
        return this.hunks;
    }

    public void close() throws IOException {
        int hunksCount;
        if (this.hunks != null && (hunksCount = this.hunks.size()) > 0) {
            for (int i2 = 0; i2 < hunksCount; ++i2) {
                SVNPatchHunk hunk = (SVNPatchHunk)this.hunks.get(i2);
                hunk.close();
            }
        }
    }

    public static SVNPatch parseNextPatch(SVNPatchFileStream patchFile) throws SVNException, IOException {
        SVNPatchHunk hunk;
        if (patchFile.isEOF()) {
            return null;
        }
        File patchPath = patchFile.getPath();
        SVNPatch patch = new SVNPatch();
        patch.patchFile = patchFile;
        patch.path = patchPath;
        String indicator = MINUS;
        boolean eof = false;
        boolean in_header = false;
        StringBuffer lineBuf = new StringBuffer();
        do {
            lineBuf.setLength(0);
            eof = patchFile.readLine(lineBuf);
            String line = lineBuf.toString();
            if (eof || line.length() <= indicator.length() || !line.startsWith(indicator)) continue;
            int tab = line.indexOf(9);
            File filePath = new File(line.substring(indicator.length(), tab > 0 ? tab : line.length()));
            if (!in_header && MINUS.equals(indicator)) {
                patch.oldFilename = filePath;
                indicator = PLUS;
                in_header = true;
                continue;
            }
            if (in_header && PLUS.equals(indicator)) {
                patch.newFilename = filePath;
                in_header = false;
                break;
            }
            in_header = false;
        } while (!eof);
        if (patch.oldFilename == null || patch.newFilename == null) {
            return null;
        }
        patch.hunks = new ArrayList(10);
        do {
            if ((hunk = SVNPatchHunk.parseNextHunk(patch)) == null) continue;
            patch.hunks.add(hunk);
        } while (hunk != null);
        Collections.sort(patch.hunks, SVNPatchHunk.COMPARATOR);
        return patch;
    }
}

