/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryUtil;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNFileFetcher;
import org.tmatesoft.svn.core.internal.wc.ISVNUpdateEditor;
import org.tmatesoft.svn.core.internal.wc.SVNAdminUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNEventFactory;
import org.tmatesoft.svn.core.internal.wc.SVNFileType;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCManager;
import org.tmatesoft.svn.core.internal.wc.admin.ISVNCleanupHandler;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminAreaInfo;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumInputStream;
import org.tmatesoft.svn.core.internal.wc.admin.SVNChecksumOutputStream;
import org.tmatesoft.svn.core.internal.wc.admin.SVNEntry;
import org.tmatesoft.svn.core.internal.wc.admin.SVNLog;
import org.tmatesoft.svn.core.internal.wc.admin.SVNVersionedProperties;
import org.tmatesoft.svn.core.internal.wc.admin.SVNWCAccess;
import org.tmatesoft.svn.core.io.diff.SVNDeltaProcessor;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.core.wc.SVNEvent;
import org.tmatesoft.svn.core.wc.SVNEventAction;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNUpdateEditor15
implements ISVNUpdateEditor,
ISVNCleanupHandler {
    private String mySwitchURL;
    private String myTarget;
    private String myTargetURL;
    private String myRootURL;
    private SVNAdminAreaInfo myAdminInfo;
    private SVNDirectoryInfo myCurrentDirectory;
    private SVNFileInfo myCurrentFile;
    private long myTargetRevision;
    private boolean myIsRootOpen;
    private boolean myIsTargetDeleted;
    private boolean myIsUnversionedObstructionsAllowed;
    private boolean myIsDepthSticky;
    private Collection mySkippedPaths;
    private SVNWCAccess myWCAccess;
    private SVNDeltaProcessor myDeltaProcessor;
    private SVNDepth myRequestedDepth;
    private String[] myExtensionPatterns;
    private ISVNFileFetcher myFileFetcher;
    private boolean myIsLockOnDemand;

    private SVNUpdateEditor15(SVNAdminAreaInfo info, String switchURL, boolean allowUnversionedObstructions, boolean depthIsSticky, SVNDepth depth, String[] preservedExtensions, String targetURL, String rootURL, ISVNFileFetcher fileFetcher, boolean lockOnDemand) {
        this.myAdminInfo = info;
        this.myWCAccess = info.getWCAccess();
        this.myIsUnversionedObstructionsAllowed = allowUnversionedObstructions;
        this.myTarget = info.getTargetName();
        this.mySwitchURL = switchURL;
        this.myTargetRevision = -1L;
        this.myRequestedDepth = depth;
        this.myIsDepthSticky = depthIsSticky;
        this.myDeltaProcessor = new SVNDeltaProcessor();
        this.myExtensionPatterns = preservedExtensions;
        this.myFileFetcher = fileFetcher;
        this.myTargetURL = targetURL;
        this.myRootURL = rootURL;
        this.myIsLockOnDemand = lockOnDemand;
        if (this.myTarget != null) {
            this.myTargetURL = SVNPathUtil.append(this.myTargetURL, SVNEncodingUtil.uriEncode(this.myTarget));
        }
        if ("".equals(this.myTarget)) {
            this.myTarget = null;
        }
    }

    @Override
    public void targetRevision(long revision) throws SVNException {
        this.myTargetRevision = revision;
    }

    @Override
    public long getTargetRevision() {
        return this.myTargetRevision;
    }

    @Override
    public void openRoot(long revision) throws SVNException {
        this.myIsRootOpen = true;
        this.myCurrentDirectory = this.createDirectoryInfo(null, "", false);
        this.myWCAccess.registerCleanupHandler(this.myCurrentDirectory.getAdminArea(), this.myCurrentDirectory);
        if (this.myTarget == null) {
            SVNAdminArea adminArea = this.myCurrentDirectory.getAdminArea();
            SVNEntry entry = adminArea.getEntry(adminArea.getThisDirName(), false);
            if (entry != null) {
                this.myCurrentDirectory.myAmbientDepth = entry.getDepth();
                this.myCurrentDirectory.myPreviousRevision = entry.getRevision();
            }
            SVNHashMap attributes = new SVNHashMap();
            attributes.put("svn:entry:revision", Long.toString(this.myTargetRevision));
            attributes.put("svn:entry:url", this.myCurrentDirectory.URL);
            attributes.put("svn:entry:incomplete", Boolean.TRUE.toString());
            if (this.myRootURL != null && SVNPathUtil.isAncestor(this.myRootURL, this.myCurrentDirectory.URL)) {
                attributes.put("svn:entry:repos", this.myRootURL);
            }
            adminArea.modifyEntry(adminArea.getThisDirName(), attributes, true, false);
            if (this.mySwitchURL != null) {
                this.clearWCProperty(this.myCurrentDirectory.getAdminArea(), null);
            }
        } else if (this.mySwitchURL != null) {
            if (this.myAdminInfo.getTarget() == this.myAdminInfo.getAnchor()) {
                this.clearWCProperty(this.myAdminInfo.getTarget(), this.myTarget);
            } else {
                this.clearWCProperty(this.myAdminInfo.getTarget(), null);
            }
        }
    }

    @Override
    public void deleteEntry(String path, long revision) throws SVNException {
        SVNAdminArea childArea;
        this.checkIfPathIsUnderRoot(path);
        String name = SVNPathUtil.tail(path);
        SVNAdminArea parentArea = this.myCurrentDirectory.getAdminArea();
        SVNEntry entry = parentArea.getEntry(name, true);
        if (entry == null) {
            return;
        }
        SVNLog log = this.myCurrentDirectory.getLog();
        SVNProperties attributes = new SVNProperties();
        attributes.put("name", name);
        log.addCommand("delete-entry", attributes, false);
        SVNNodeKind kind = entry.getKind();
        long previousRevision = entry.getRevision();
        boolean isDeleted = entry.isDeleted();
        SVNURL url = entry.getSVNURL();
        if (path.equals(this.myTarget)) {
            attributes.put("name", name);
            attributes.put(SVNProperty.shortPropertyName("svn:entry:kind"), kind == SVNNodeKind.DIR ? "dir" : "file");
            attributes.put(SVNProperty.shortPropertyName("svn:entry:revision"), Long.toString(this.myTargetRevision));
            attributes.put(SVNProperty.shortPropertyName("svn:entry:deleted"), Boolean.TRUE.toString());
            log.addCommand("modify-entry", attributes, false);
            this.myIsTargetDeleted = true;
        }
        try {
            this.myCurrentDirectory.flushLog();
        }
        catch (SVNException svne) {
            SVNErrorMessage err = svne.getErrorMessage().wrap("Error writing log file for ''{0}''", this.myCurrentDirectory.getPath());
            SVNErrorManager.error(err, svne, SVNLogType.WC);
        }
        if (this.myIsLockOnDemand && kind == SVNNodeKind.DIR && (childArea = this.myWCAccess.getAdminArea(parentArea.getFile(name))) != null && !childArea.isLocked()) {
            childArea.lock(false);
        }
        if (this.mySwitchURL != null && kind == SVNNodeKind.DIR) {
            childArea = this.myWCAccess.retrieve(parentArea.getFile(name));
            try {
                childArea.removeFromRevisionControl(childArea.getThisDirName(), true, true);
            }
            catch (SVNException svne) {
                this.handleLeftLocalModificationsError(svne);
            }
        }
        try {
            this.myCurrentDirectory.runLogs();
        }
        catch (SVNException svne) {
            this.handleLeftLocalModificationsError(svne);
        }
        if (isDeleted) {
            return;
        }
        SVNEvent event = SVNEventFactory.createSVNEvent(parentArea.getFile(name), kind, null, -1L, SVNEventAction.UPDATE_DELETE, null, null, null);
        event.setPreviousRevision(previousRevision);
        event.setPreviousURL(url);
        this.myWCAccess.handleEvent(event);
    }

    private void handleLeftLocalModificationsError(SVNException originalError) throws SVNException {
        SVNException error = null;
        error = originalError;
        while (error != null && error.getErrorMessage().getErrorCode() != SVNErrorCode.WC_LEFT_LOCAL_MOD) {
            error = error.getCause() instanceof SVNException ? (SVNException)error.getCause() : null;
        }
        if (error != null) {
            return;
        }
        throw originalError;
    }

    @Override
    public void addDir(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        SVNErrorMessage err;
        SVNAdminArea parentArea = this.myCurrentDirectory.getAdminArea();
        SVNDirectoryInfo parentDirectory = this.myCurrentDirectory;
        this.myCurrentDirectory = this.createDirectoryInfo(this.myCurrentDirectory, path, true);
        this.myCurrentDirectory.myPreviousRevision = -1L;
        this.myCurrentDirectory.myAmbientDepth = path.equals(this.myTarget) ? (this.myRequestedDepth == SVNDepth.UNKNOWN ? SVNDepth.INFINITY : this.myRequestedDepth) : (this.myRequestedDepth == SVNDepth.IMMEDIATES || this.myRequestedDepth == SVNDepth.UNKNOWN && parentDirectory.myAmbientDepth == SVNDepth.IMMEDIATES ? SVNDepth.EMPTY : SVNDepth.INFINITY);
        parentDirectory.flushLog();
        this.checkIfPathIsUnderRoot(path);
        String name = SVNPathUtil.tail(path);
        File childDir = parentArea.getFile(name);
        SVNFileType kind = SVNFileType.getType(childDir);
        if (kind == SVNFileType.FILE || kind == SVNFileType.UNKNOWN) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add directory ''{0}'': a non-directory object of the same name already exists", (Object)path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (kind == SVNFileType.DIRECTORY) {
            SVNErrorMessage err2;
            SVNAdminArea adminArea = null;
            try {
                adminArea = SVNWCAccess.newInstance(null).open(childDir, false, 0);
            }
            catch (SVNException svne) {
                if (svne.getErrorMessage().getErrorCode() != SVNErrorCode.WC_NOT_DIRECTORY) {
                    throw svne;
                }
                if (this.myIsUnversionedObstructionsAllowed) {
                    this.myCurrentDirectory.isExisted = true;
                }
                err2 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add directory ''{0}'': an unversioned directory of the same name already exists", (Object)this.myCurrentDirectory.getPath());
                SVNErrorManager.error(err2, SVNLogType.WC);
            }
            if (adminArea != null) {
                SVNEntry entry = adminArea.getEntry(adminArea.getThisDirName(), false);
                if (entry != null && entry.isScheduledForAddition() && !entry.isCopied()) {
                    this.myCurrentDirectory.isAddExisted = true;
                } else {
                    err2 = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add directory ''{0}'': a versioned directory of the same name already exists", (Object)this.myCurrentDirectory.getPath());
                    SVNErrorManager.error(err2, SVNLogType.WC);
                }
            }
        }
        if (SVNFileUtil.getAdminDirectoryName().equals(name)) {
            err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add directory ''{0}'':  object of the same name as the administrative directory", (Object)path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        if (copyFromPath != null || SVNRevision.isValidRevisionNumber(copyFromRevision)) {
            err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Failed to add directory ''{0}'': copyfrom arguments not yet supported", (Object)path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNEntry entry = parentArea.getEntry(name, false);
        SVNHashMap attributes = new SVNHashMap();
        attributes.put("svn:entry:kind", "dir");
        attributes.put("svn:entry:absent", null);
        attributes.put("svn:entry:deleted", null);
        boolean force = false;
        if (this.myCurrentDirectory.isAddExisted) {
            attributes.put("svn:entry:schedule", null);
            force = true;
        }
        entry = parentArea.modifyEntry(name, attributes, true, force);
        if (this.myCurrentDirectory.isAddExisted) {
            attributes.put("svn:entry:revision", Long.toString(this.myTargetRevision));
            if (this.mySwitchURL != null) {
                attributes.put("svn:entry:url", this.myCurrentDirectory.URL);
            }
            SVNAdminArea adminArea = this.myCurrentDirectory.getAdminArea();
            adminArea.modifyEntry(adminArea.getThisDirName(), attributes, true, true);
        }
        String rootURL = null;
        if (SVNPathUtil.isAncestor(this.myRootURL, this.myCurrentDirectory.URL)) {
            rootURL = this.myRootURL;
        }
        if (this.myWCAccess.getAdminArea(childDir) != null) {
            this.myWCAccess.closeAdminArea(childDir);
        }
        if (SVNWCManager.ensureAdminAreaExists(childDir, this.myCurrentDirectory.URL, rootURL, null, this.myTargetRevision, this.myCurrentDirectory.myAmbientDepth)) {
            SVNFileUtil.deleteFile(new File(childDir, SVNFileUtil.getAdminDirectoryName() + "/lock"));
        }
        SVNAdminArea childArea = this.myWCAccess.open(childDir, true, 0);
        this.myWCAccess.registerCleanupHandler(childArea, this.myCurrentDirectory);
        if (!this.myCurrentDirectory.isAddExisted) {
            SVNEvent event = SVNEventFactory.createSVNEvent(parentArea.getFile(entry.getName()), SVNNodeKind.DIR, null, this.myTargetRevision, this.myCurrentDirectory.isExisted ? SVNEventAction.UPDATE_EXISTS : SVNEventAction.UPDATE_ADD, null, null, null);
            event.setPreviousRevision(this.myCurrentDirectory.myPreviousRevision);
            event.setPreviousURL(entry.getSVNURL());
            event.setURL(this.myCurrentDirectory.URL != null ? SVNURL.parseURIEncoded(this.myCurrentDirectory.URL) : null);
            this.myWCAccess.handleEvent(event);
        }
    }

    @Override
    public void openDir(String path, long revision) throws SVNException {
        this.myCurrentDirectory.flushLog();
        this.checkIfPathIsUnderRoot(path);
        this.myCurrentDirectory = this.createDirectoryInfo(this.myCurrentDirectory, path, false);
        SVNAdminArea adminArea = this.myCurrentDirectory.getAdminArea();
        this.myWCAccess.registerCleanupHandler(adminArea, this.myCurrentDirectory);
        SVNEntry entry = adminArea.getEntry(adminArea.getThisDirName(), true);
        if (entry != null) {
            this.myCurrentDirectory.myPreviousRevision = entry.getRevision();
            this.myCurrentDirectory.myAmbientDepth = entry.getDepth();
            boolean hasPropConflicts = adminArea.hasPropConflict(adminArea.getThisDirName());
            if (hasPropConflicts) {
                this.myCurrentDirectory.isSkipped = true;
                Collection skippedPaths = this.getSkippedPaths();
                skippedPaths.add(adminArea.getRoot());
                SVNEvent event = SVNEventFactory.createSVNEvent(adminArea.getRoot(), SVNNodeKind.DIR, null, this.myTargetRevision, SVNStatusType.INAPPLICABLE, SVNStatusType.CONFLICTED, SVNStatusType.LOCK_INAPPLICABLE, SVNEventAction.SKIP, SVNEventAction.UPDATE_UPDATE, null, null);
                event.setPreviousRevision(entry.getRevision());
                event.setURL(entry.getSVNURL());
                this.myWCAccess.handleEvent(event);
                return;
            }
        } else {
            this.myCurrentDirectory.myPreviousRevision = -1L;
        }
        SVNHashMap attributes = new SVNHashMap();
        attributes.put("svn:entry:revision", Long.toString(this.myTargetRevision));
        attributes.put("svn:entry:url", this.myCurrentDirectory.URL);
        attributes.put("svn:entry:incomplete", Boolean.TRUE.toString());
        if (this.myRootURL != null && SVNPathUtil.isAncestor(this.myRootURL, this.myCurrentDirectory.URL)) {
            attributes.put("svn:entry:repos", this.myRootURL);
        }
        entry = adminArea.modifyEntry(adminArea.getThisDirName(), attributes, true, false);
        if (this.mySwitchURL != null) {
            this.clearWCProperty(this.myCurrentDirectory.getAdminArea(), null);
        }
    }

    private Collection getSkippedPaths() {
        if (this.mySkippedPaths == null) {
            this.mySkippedPaths = new LinkedList();
        }
        return this.mySkippedPaths;
    }

    @Override
    public void absentDir(String path) throws SVNException {
        this.absentEntry(path, SVNNodeKind.DIR);
    }

    @Override
    public void absentFile(String path) throws SVNException {
        this.absentEntry(path, SVNNodeKind.FILE);
    }

    private void absentEntry(String path, SVNNodeKind kind) throws SVNException {
        String name = SVNPathUtil.tail(path);
        SVNAdminArea adminArea = this.myCurrentDirectory.getAdminArea();
        SVNEntry entry = adminArea.getEntry(name, false);
        if (entry != null && entry.isScheduledForAddition()) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to mark ''{0}'' absent: item of the same name is already scheduled for addition", (Object)path);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNHashMap attributes = new SVNHashMap();
        attributes.put("svn:entry:revision", Long.toString(this.myTargetRevision));
        attributes.put("svn:entry:kind", kind.toString());
        attributes.put("svn:entry:deleted", null);
        attributes.put("svn:entry:absent", Boolean.TRUE.toString());
        entry = adminArea.modifyEntry(name, attributes, true, false);
    }

    @Override
    public void changeDirProperty(String name, SVNPropertyValue value) throws SVNException {
        if (!this.myCurrentDirectory.isSkipped) {
            this.myCurrentDirectory.propertyChanged(name, value);
        }
    }

    private void clearWCProperty(SVNAdminArea adminArea, String target) throws SVNException {
        if (adminArea == null) {
            return;
        }
        Iterator ents = adminArea.entries(false);
        while (ents.hasNext()) {
            SVNVersionedProperties props;
            SVNEntry entry = (SVNEntry)ents.next();
            if (target != null) {
                if (!entry.isFile() || !target.equals(entry.getName())) continue;
                props = adminArea.getWCProperties(entry.getName());
                props.setPropertyValue("svn:wc:ra_dav:version-url", null);
                adminArea.saveWCProperties(false);
                continue;
            }
            if (entry.isFile() || adminArea.getThisDirName().equals(entry.getName())) {
                props = adminArea.getWCProperties(entry.getName());
                props.setPropertyValue("svn:wc:ra_dav:version-url", null);
                adminArea.saveWCProperties(false);
                continue;
            }
            SVNAdminArea childArea = this.myAdminInfo.getWCAccess().getAdminArea(adminArea.getFile(entry.getName()));
            this.clearWCProperty(childArea, null);
        }
    }

    @Override
    public void closeDir() throws SVNException {
        SVNProperties modifiedWCProps = this.myCurrentDirectory.getChangedWCProperties();
        SVNProperties modifiedEntryProps = this.myCurrentDirectory.getChangedEntryProperties();
        SVNProperties modifiedProps = this.myCurrentDirectory.getChangedProperties();
        SVNStatusType propStatus = SVNStatusType.UNKNOWN;
        SVNAdminArea adminArea = this.myCurrentDirectory.getAdminArea();
        if (this.myAdminInfo.isIncomplete(this.myCurrentDirectory.getPath())) {
            SVNVersionedProperties oldBaseProps = adminArea.getBaseProperties(adminArea.getThisDirName());
            SVNProperties baseMap = oldBaseProps.asMap();
            if (modifiedProps == null) {
                modifiedProps = new SVNProperties();
            }
            for (String name : baseMap.nameSet()) {
                if (modifiedProps.containsName(name)) continue;
                modifiedProps.put(name, SVNPropertyValue.create(null));
            }
        }
        if (modifiedWCProps != null || modifiedEntryProps != null || modifiedProps != null) {
            SVNLog log = this.myCurrentDirectory.getLog();
            if (modifiedProps != null && !modifiedProps.isEmpty()) {
                if (modifiedProps.containsName("svn:externals")) {
                    String oldExternal = adminArea.getProperties(adminArea.getThisDirName()).getStringPropertyValue("svn:externals");
                    String newExternal = modifiedProps.getStringValue("svn:externals");
                    String path = this.myCurrentDirectory.getPath();
                    if (oldExternal == null && newExternal != null) {
                        this.myAdminInfo.addExternal(path, oldExternal, newExternal);
                        this.myAdminInfo.addDepth(path, this.myCurrentDirectory.myAmbientDepth);
                    } else if (oldExternal != null && newExternal == null) {
                        this.myAdminInfo.addExternal(path, oldExternal, newExternal);
                        this.myAdminInfo.addDepth(path, this.myCurrentDirectory.myAmbientDepth);
                    } else if (oldExternal != null && !oldExternal.equals(newExternal)) {
                        this.myAdminInfo.addExternal(path, oldExternal, newExternal);
                        this.myAdminInfo.addDepth(path, this.myCurrentDirectory.myAmbientDepth);
                    }
                }
                SVNVersionedProperties oldBaseProps = adminArea.getBaseProperties(adminArea.getThisDirName());
                try {
                    propStatus = adminArea.mergeProperties(adminArea.getThisDirName(), oldBaseProps.asMap(), modifiedProps, null, null, true, false, log);
                }
                catch (SVNException svne) {
                    SVNErrorMessage err = svne.getErrorMessage().wrap("Couldn't do property merge");
                    SVNErrorManager.error(err, svne, SVNLogType.WC);
                }
            }
            log.logChangedEntryProperties(adminArea.getThisDirName(), modifiedEntryProps);
            log.logChangedWCProperties(adminArea.getThisDirName(), modifiedWCProps);
        }
        this.myCurrentDirectory.flushLog();
        this.myCurrentDirectory.runLogs();
        this.maybeBumpDirInfo(this.myCurrentDirectory);
        if (!(this.myCurrentDirectory.isSkipped || !this.myCurrentDirectory.isAddExisted && this.myCurrentDirectory.IsAdded || adminArea == this.myAdminInfo.getAnchor() && !"".equals(this.myAdminInfo.getTargetName()))) {
            SVNEventAction action;
            SVNEventAction sVNEventAction = action = this.myCurrentDirectory.isAddExisted || this.myCurrentDirectory.isExisted ? SVNEventAction.UPDATE_EXISTS : SVNEventAction.UPDATE_UPDATE;
            if (propStatus == SVNStatusType.UNKNOWN && action != SVNEventAction.UPDATE_EXISTS) {
                action = SVNEventAction.UPDATE_NONE;
            }
            SVNEvent event = SVNEventFactory.createSVNEvent(adminArea.getRoot(), SVNNodeKind.DIR, null, this.myTargetRevision, SVNStatusType.UNKNOWN, propStatus, null, action, null, null, null);
            event.setPreviousRevision(this.myCurrentDirectory.myPreviousRevision);
            event.setURL(this.myCurrentDirectory.URL != null ? SVNURL.parseURIEncoded(this.myCurrentDirectory.URL) : null);
            this.myWCAccess.handleEvent(event);
        }
        this.myCurrentDirectory = this.myCurrentDirectory.Parent;
    }

    @Override
    public SVNCommitInfo closeEdit() throws SVNException {
        if (this.myTarget != null && this.myWCAccess.isMissing(this.myAdminInfo.getAnchor().getFile(this.myTarget))) {
            this.myCurrentDirectory = this.createDirectoryInfo(null, "", false);
            this.myWCAccess.registerCleanupHandler(this.myCurrentDirectory.getAdminArea(), this.myCurrentDirectory);
            this.deleteEntry(this.myTarget, this.myTargetRevision);
        }
        if (!this.myIsRootOpen) {
            if (this.myCurrentDirectory == null) {
                this.myCurrentDirectory = this.createDirectoryInfo(null, "", false);
            }
            this.completeDirectory(this.myCurrentDirectory);
        }
        if (!this.myIsTargetDeleted) {
            File targetFile = this.myTarget != null ? this.myAdminInfo.getAnchor().getFile(this.myTarget) : this.myAdminInfo.getAnchor().getRoot();
            SVNWCManager.updateCleanup(targetFile, this.myWCAccess, this.mySwitchURL, this.myRootURL, this.myTargetRevision, true, this.mySkippedPaths, this.myRequestedDepth, this.myIsLockOnDemand);
        }
        return null;
    }

    @Override
    public void addFile(String path, String copyFromPath, long copyFromRevision) throws SVNException {
        this.myCurrentFile = this.addFile(this.myCurrentDirectory, path, copyFromPath, copyFromRevision);
    }

    @Override
    public void openFile(String path, long revision) throws SVNException {
        this.myCurrentFile = this.openFile(path, this.myCurrentDirectory);
    }

    @Override
    public void changeFileProperty(String commitPath, String name, SVNPropertyValue value) throws SVNException {
        this.changeFileProperty(name, value, this.myCurrentFile);
    }

    @Override
    public void applyTextDelta(String commitPath, String baseChecksum) throws SVNException {
        String checksum;
        if (this.myCurrentFile.isSkipped) {
            return;
        }
        this.myCurrentFile.receivedTextDelta = true;
        SVNAdminArea adminArea = this.myCurrentFile.getAdminArea();
        SVNEntry entry = adminArea.getEntry(this.myCurrentFile.Name, false);
        boolean replaced = entry != null && entry.isScheduledForReplacement();
        boolean useRevertBase = replaced;
        if (useRevertBase) {
            this.myCurrentFile.baseFile = adminArea.getFile(SVNAdminUtil.getTextRevertPath(this.myCurrentFile.Name, false));
            this.myCurrentFile.newBaseFile = adminArea.getFile(SVNAdminUtil.getTextRevertPath(this.myCurrentFile.Name, true));
        } else {
            this.myCurrentFile.baseFile = adminArea.getBaseFile(this.myCurrentFile.Name, false);
            this.myCurrentFile.newBaseFile = adminArea.getBaseFile(this.myCurrentFile.Name, true);
        }
        String string = checksum = entry != null ? entry.getChecksum() : null;
        if (!replaced && baseChecksum != null && checksum != null && !baseChecksum.equals(checksum)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT_TEXT_BASE, "Checksum mismatch for ''{0}''; expected: ''{1}'', recorded: ''{2}''", this.myCurrentFile.baseFile, baseChecksum, checksum);
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        File baseSrcFile = null;
        if (!this.myCurrentFile.IsAdded) {
            baseSrcFile = this.myCurrentFile.baseFile;
        } else if (this.myCurrentFile.copiedBaseText != null) {
            baseSrcFile = this.myCurrentFile.copiedBaseText;
        }
        if (replaced || checksum == null) {
            checksum = baseChecksum;
        }
        File baseTmpFile = this.myCurrentFile.newBaseFile;
        if (checksum != null) {
            this.myCurrentFile.expectedSrcChecksum = checksum;
            InputStream baseIS = baseSrcFile != null && baseSrcFile.exists() ? SVNFileUtil.openFileForReading(baseSrcFile) : SVNFileUtil.DUMMY_IN;
            this.myCurrentFile.sourceChecksumStream = baseIS != SVNFileUtil.DUMMY_IN ? new SVNChecksumInputStream(baseIS, "MD5") : null;
            this.myDeltaProcessor.applyTextDelta(this.myCurrentFile.sourceChecksumStream != null ? this.myCurrentFile.sourceChecksumStream : baseIS, baseTmpFile, true);
        } else {
            this.myDeltaProcessor.applyTextDelta(baseSrcFile, baseTmpFile, true);
        }
    }

    @Override
    public OutputStream textDeltaChunk(String commitPath, SVNDiffWindow diffWindow) throws SVNException {
        if (!this.myCurrentFile.isSkipped) {
            try {
                this.myDeltaProcessor.textDeltaChunk(diffWindow);
            }
            catch (SVNException svne) {
                this.myDeltaProcessor.textDeltaEnd();
                SVNFileUtil.deleteFile(this.myCurrentFile.newBaseFile);
                this.myCurrentFile.newBaseFile = null;
                throw svne;
            }
        }
        return SVNFileUtil.DUMMY_OUT;
    }

    @Override
    public void textDeltaEnd(String commitPath) throws SVNException {
        if (!this.myCurrentFile.isSkipped) {
            this.myCurrentFile.Checksum = this.myDeltaProcessor.textDeltaEnd();
        }
        if (this.myCurrentFile.expectedSrcChecksum != null) {
            String actualSourceChecksum;
            String string = actualSourceChecksum = this.myCurrentFile.sourceChecksumStream != null ? this.myCurrentFile.sourceChecksumStream.getDigest() : null;
            if (!this.myCurrentFile.expectedSrcChecksum.equals(actualSourceChecksum)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_CORRUPT_TEXT_BASE, "Checksum mismatch while updating ''{0}''; expected: ''{1}'', actual: ''{2}''", this.myCurrentFile.baseFile, this.myCurrentFile.expectedSrcChecksum, actualSourceChecksum);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
    }

    @Override
    public void closeFile(String commitPath, String textChecksum) throws SVNException {
        this.closeFile(textChecksum, this.myCurrentFile, this.myCurrentDirectory);
        this.myCurrentFile = null;
    }

    @Override
    public void abortEdit() throws SVNException {
    }

    private void checkIfPathIsUnderRoot(String path) throws SVNException {
        if (SVNFileUtil.isWindows && path != null) {
            String testPath = path.replace(File.separatorChar, '/');
            int ind = -1;
            while (testPath.length() > 0 && (ind = testPath.indexOf("..")) != -1) {
                if (ind == 0 || testPath.charAt(ind - 1) == '/') {
                    SVNErrorMessage err;
                    int i2;
                    for (i2 = ind + 2; i2 < testPath.length(); ++i2) {
                        if (testPath.charAt(i2) == '.') continue;
                        if (testPath.charAt(i2) != '/') break;
                        err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Path ''{0}'' is not in the working copy", (Object)path);
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    if (i2 == testPath.length()) {
                        err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Path ''{0}'' is not in the working copy", (Object)path);
                        SVNErrorManager.error(err, SVNLogType.WC);
                    }
                    testPath = testPath.substring(i2);
                    continue;
                }
                testPath = testPath.substring(ind + 2);
            }
        }
    }

    private void maybeBumpDirInfo(SVNDirectoryInfo dirInfo) throws SVNException {
        while (dirInfo != null) {
            --dirInfo.RefCount;
            if (dirInfo.RefCount > 0) {
                return;
            }
            if (!dirInfo.isSkipped) {
                this.completeDirectory(dirInfo);
            }
            dirInfo = dirInfo.Parent;
        }
    }

    private void completeDirectory(SVNDirectoryInfo dirInfo) throws SVNException {
        if (dirInfo.Parent == null && this.myTarget != null) {
            return;
        }
        SVNAdminArea adminArea = dirInfo.getAdminArea();
        SVNEntry entry = adminArea.getEntry(adminArea.getThisDirName(), true);
        if (entry == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.ENTRY_NOT_FOUND, "No ''.'' entry found in ''{0}''", (Object)adminArea.getRoot());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        entry.setIncomplete(false);
        if (!this.myIsDepthSticky && entry.isThisDir() && this.myRequestedDepth == SVNDepth.IMMEDIATES) {
            SVNDepth ambientDepth;
            int directoryDepth = SVNPathUtil.getSegmentsCount(dirInfo.getPath());
            if (this.myTarget != null && !"".equals(this.myTarget)) {
                --directoryDepth;
            }
            if (directoryDepth > 0 && ((ambientDepth = dirInfo.myAmbientDepth) == null || ambientDepth == SVNDepth.UNKNOWN || ambientDepth.compareTo(SVNDepth.EMPTY) > 0)) {
                entry.setIncomplete(true);
            }
        }
        File target = this.myAdminInfo.getTarget().getRoot();
        if (this.myIsDepthSticky && (this.myRequestedDepth == SVNDepth.INFINITY || adminArea.getRoot().equals(target) && this.myRequestedDepth.compareTo(entry.getDepth()) > 0)) {
            entry.setDepth(this.myRequestedDepth);
            this.myAdminInfo.addDepth(dirInfo.getPath(), this.myRequestedDepth);
        }
        Iterator ents = adminArea.entries(true);
        while (ents.hasNext()) {
            SVNEntry currentEntry = (SVNEntry)ents.next();
            if (currentEntry.isDeleted()) {
                if (!currentEntry.isScheduledForAddition()) {
                    adminArea.deleteEntry(currentEntry.getName());
                    continue;
                }
                SVNHashMap attributes = new SVNHashMap();
                attributes.put("svn:entry:deleted", null);
                adminArea.modifyEntry(currentEntry.getName(), attributes, false, false);
                continue;
            }
            if (currentEntry.isAbsent() && currentEntry.getRevision() != this.myTargetRevision) {
                adminArea.deleteEntry(currentEntry.getName());
                continue;
            }
            if (currentEntry.getKind() != SVNNodeKind.DIR || !this.myWCAccess.isMissing(adminArea.getFile(currentEntry.getName())) || currentEntry.isAbsent() || currentEntry.isScheduledForAddition()) continue;
            adminArea.deleteEntry(currentEntry.getName());
            this.myWCAccess.handleEvent(SVNEventFactory.createSVNEvent(adminArea.getFile(currentEntry.getName()), currentEntry.getKind(), null, currentEntry.getRevision(), SVNEventAction.UPDATE_DELETE, null, null, null));
        }
        adminArea.saveEntries(true);
    }

    private SVNFileInfo addFile(SVNDirectoryInfo parent, String path, String copyFromPath, long copyFromRevision) throws SVNException {
        if (copyFromPath != null || SVNRevision.isValidRevisionNumber(copyFromRevision)) {
            if (copyFromPath == null || !SVNRevision.isValidRevisionNumber(copyFromRevision)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OP_ON_CWD, "Bad copyfrom arguments received.");
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            return this.addFileWithHistory(parent, path, copyFromPath, copyFromRevision);
        }
        this.checkIfPathIsUnderRoot(path);
        SVNFileInfo info = this.createFileInfo(parent, path, true);
        SVNAdminArea adminArea = parent.getAdminArea();
        SVNFileType kind = SVNFileType.getType(adminArea.getFile(info.Name));
        SVNEntry entry = adminArea.getEntry(info.Name, true);
        if (kind != SVNFileType.NONE) {
            if (this.myIsUnversionedObstructionsAllowed || entry != null && entry.isScheduledForAddition()) {
                SVNErrorMessage err;
                if (entry != null && entry.isCopied()) {
                    err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add file ''{0}'': a file of the same name is already scheduled for addition with history", (Object)path);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                if (kind != SVNFileType.FILE) {
                    err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add file ''{0}'': a non-file object of the same name already exists", (Object)path);
                    SVNErrorManager.error(err, SVNLogType.WC);
                }
                if (entry != null) {
                    info.isAddExisted = true;
                } else {
                    info.isExisted = true;
                }
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_OBSTRUCTED_UPDATE, "Failed to add file ''{0}'': object of the same name already exists", (Object)path);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SVNFileInfo addFileWithHistory(SVNDirectoryInfo parent, String path, String copyFromPath, long copyFromRevision) throws SVNException {
        SVNProperties workingProperties;
        SVNProperties baseProperties;
        SVNFileInfo info;
        block14: {
            block13: {
                SVNEntry srcEntry;
                SVNAdminArea adminArea;
                block11: {
                    info = this.addFile(parent, path, null, -1L);
                    info.addedWithHistory = true;
                    adminArea = parent.getAdminArea();
                    SVNEntry pathEntry = adminArea.getEntry(adminArea.getThisDirName(), false);
                    srcEntry = null;
                    try {
                        srcEntry = this.locateCopyFrom(copyFromPath, copyFromRevision, adminArea.getRoot(), pathEntry);
                    }
                    catch (SVNException svne) {
                        if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_COPYFROM_PATH_NOT_FOUND) break block11;
                        throw svne;
                    }
                }
                info.copiedBaseText = SVNAdminUtil.createTmpFile(adminArea);
                baseProperties = null;
                workingProperties = null;
                if (srcEntry == null) break block13;
                SVNAdminArea srcArea = srcEntry.getAdminArea();
                String srcTextBasePath = null;
                if (srcEntry.isScheduledForReplacement() && srcEntry.getCopyFromURL() != null) {
                    srcTextBasePath = SVNAdminUtil.getTextRevertPath(srcEntry.getName(), false);
                    workingProperties = baseProperties = srcArea.getRevertProperties(srcEntry.getName()).asMap();
                } else {
                    srcTextBasePath = SVNAdminUtil.getTextBasePath(srcEntry.getName(), false);
                    baseProperties = srcArea.getBaseProperties(srcEntry.getName()).asMap();
                    workingProperties = srcArea.getProperties(srcEntry.getName()).asMap();
                }
                InputStream srcIS = null;
                OutputStream copiedBaseOS = null;
                try {
                    srcIS = SVNFileUtil.openFileForReading(srcArea.getFile(srcTextBasePath));
                    copiedBaseOS = SVNFileUtil.openFileForWriting(info.copiedBaseText);
                    SVNChecksumOutputStream checksumOS = new SVNChecksumOutputStream(copiedBaseOS, "MD5", true);
                    copiedBaseOS = checksumOS;
                    FSRepositoryUtil.copy(srcIS, copiedBaseOS, this.myWCAccess);
                    info.copiedBaseChecksum = checksumOS.getDigest();
                }
                catch (Throwable throwable) {
                    SVNFileUtil.closeFile(srcIS);
                    SVNFileUtil.closeFile(copiedBaseOS);
                    throw throwable;
                }
                SVNFileUtil.closeFile(srcIS);
                SVNFileUtil.closeFile(copiedBaseOS);
                if (srcArea.hasTextModifications(srcEntry.getName(), false, true, false)) {
                    info.copiedWorkingText = SVNAdminUtil.createTmpFile(adminArea);
                    SVNFileUtil.copyFile(srcArea.getFile(srcEntry.getName()), info.copiedWorkingText, true);
                }
                break block14;
            }
            if (this.myFileFetcher == null) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_OP_ON_CWD, "No fetch_func supplied to update_editor.");
                SVNErrorManager.error(err, SVNLogType.DEFAULT);
            }
            baseProperties = new SVNProperties();
            OutputStream baseTextOS = null;
            try {
                baseTextOS = SVNFileUtil.openFileForWriting(info.copiedBaseText);
                SVNChecksumOutputStream checksumBaseTextOS = new SVNChecksumOutputStream(baseTextOS, "MD5", true);
                baseTextOS = checksumBaseTextOS;
                this.myFileFetcher.fetchFile(copyFromPath, copyFromRevision, baseTextOS, baseProperties);
                info.copiedBaseChecksum = checksumBaseTextOS.getDigest();
            }
            finally {
                SVNFileUtil.closeFile(baseTextOS);
            }
            workingProperties = baseProperties;
        }
        info.copiedBaseProperties = baseProperties.getRegularProperties();
        info.copiedWorkingProperties = workingProperties.getRegularProperties();
        return info;
    }

    private SVNEntry locateCopyFrom(String copyFromPath, long copyFromRevision, File dstDir, SVNEntry dstEntry) throws SVNException {
        String copyFromParent;
        if (dstEntry.getRepositoryRoot() == null || dstEntry.getURL() == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_COPYFROM_PATH_NOT_FOUND, "Destination directory of add-with-history is missing a URL");
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        dstDir = new File(SVNPathUtil.validateFilePath(dstDir.getAbsolutePath())).getAbsoluteFile();
        String dstReposPath = SVNPathUtil.getPathAsChild(dstEntry.getRepositoryRootURL().toDecodedString(), dstEntry.getSVNURL().toDecodedString());
        if (dstReposPath == null) {
            if (dstEntry.getURL().equals(dstEntry.getRepositoryRoot())) {
                dstReposPath = "";
            } else {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_COPYFROM_PATH_NOT_FOUND, "Destination URLs are broken");
                SVNErrorManager.error(err, SVNLogType.WC);
            }
        }
        dstReposPath = "/" + dstReposPath;
        String ancestorPath = SVNPathUtil.getCommonPathAncestor(dstReposPath = SVNPathUtil.canonicalizePath(dstReposPath), copyFromParent = SVNPathUtil.removeTail(copyFromPath));
        if ("".equals(ancestorPath)) {
            return null;
        }
        int levelsUP = SVNPathUtil.getSegmentsCount(dstReposPath) - SVNPathUtil.getSegmentsCount(ancestorPath);
        File currentWD = dstDir;
        for (int i2 = 0; i2 < levelsUP && currentWD != null; currentWD = currentWD.getParentFile(), ++i2) {
        }
        if (currentWD == null) {
            return null;
        }
        SVNFileType kind = SVNFileType.getType(currentWD);
        if (kind != SVNFileType.DIRECTORY) {
            return null;
        }
        SVNWCAccess ancestorAccess = SVNWCAccess.newInstance(null);
        SVNAdminArea ancestorArea = null;
        try {
            ancestorArea = ancestorAccess.open(currentWD, false, 0);
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                ancestorAccess.close();
                return null;
            }
            throw svne;
        }
        SVNEntry ancestorEntry = ancestorArea.getEntry(ancestorArea.getThisDirName(), false);
        if (dstEntry.getUUID() != null && ancestorEntry.getUUID() != null && !dstEntry.getUUID().equals(ancestorEntry.getUUID())) {
            ancestorAccess.close();
            return null;
        }
        SVNURL ancestorURL = dstEntry.getRepositoryRootURL().appendPath(ancestorPath, false);
        if (!ancestorURL.equals(ancestorEntry.getSVNURL())) {
            ancestorAccess.close();
            return null;
        }
        String extraComponents = SVNPathUtil.getPathAsChild(ancestorPath, copyFromPath);
        currentWD = new File(currentWD, extraComponents);
        File currentWDParent = currentWD.getParentFile();
        kind = SVNFileType.getType(currentWD);
        if (kind != SVNFileType.FILE) {
            ancestorAccess.close();
            return null;
        }
        try {
            ancestorAccess.close();
            ancestorArea = ancestorAccess.open(currentWDParent, false, 0);
        }
        catch (SVNException svne) {
            if (svne.getErrorMessage().getErrorCode() == SVNErrorCode.WC_NOT_DIRECTORY) {
                ancestorAccess.close();
                return null;
            }
            throw svne;
        }
        SVNEntry fileEntry = ancestorArea.getEntry(currentWD.getName(), false);
        if (fileEntry == null) {
            ancestorAccess.close();
            return null;
        }
        if (fileEntry.getUUID() != null && dstEntry.getUUID() != null && !fileEntry.getUUID().equals(dstEntry.getUUID())) {
            ancestorAccess.close();
            return null;
        }
        SVNURL fileURL = fileEntry.getRepositoryRootURL().appendPath(copyFromPath, false);
        if (!fileURL.equals(fileEntry.getSVNURL())) {
            ancestorAccess.close();
            return null;
        }
        if (!SVNRevision.isValidRevisionNumber(fileEntry.getCommittedRevision()) || !SVNRevision.isValidRevisionNumber(fileEntry.getRevision())) {
            ancestorAccess.close();
            return null;
        }
        if (fileEntry.getCommittedRevision() > copyFromRevision || copyFromRevision > fileEntry.getRevision()) {
            ancestorAccess.close();
            return null;
        }
        return fileEntry;
    }

    private void changeFileProperty(String name, SVNPropertyValue value, SVNFileInfo fileInfo) {
        if (!fileInfo.isSkipped) {
            fileInfo.propertyChanged(name, value);
            if (this.myWCAccess.getOptions().isUseCommitTimes() && "svn:entry:committed-date".equals(name)) {
                fileInfo.CommitTime = value.getString();
                if (fileInfo.CommitTime != null) {
                    fileInfo.CommitTime = fileInfo.CommitTime.trim();
                }
            }
        }
    }

    private SVNFileInfo openFile(String path, SVNDirectoryInfo parent) throws SVNException {
        this.checkIfPathIsUnderRoot(path);
        SVNFileInfo info = this.createFileInfo(parent, path, false);
        SVNAdminArea adminArea = parent.getAdminArea();
        SVNEntry entry = adminArea.getEntry(info.Name, true);
        if (entry == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "File ''{0}'' in directory ''{1}'' is not a versioned resource", info.Name, adminArea.getRoot());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        boolean hasTextConflicts = adminArea.hasTextConflict(info.Name);
        boolean hasPropConflicts = adminArea.hasPropConflict(info.Name);
        if (hasTextConflicts || hasPropConflicts) {
            info.isSkipped = true;
            Collection skippedPaths = this.getSkippedPaths();
            File file = new File(this.myAdminInfo.getAnchor().getRoot(), path);
            skippedPaths.add(file);
            SVNEvent event = SVNEventFactory.createSVNEvent(adminArea.getFile(info.Name), SVNNodeKind.FILE, null, this.myTargetRevision, hasTextConflicts ? SVNStatusType.CONFLICTED : SVNStatusType.UNKNOWN, hasPropConflicts ? SVNStatusType.CONFLICTED : SVNStatusType.UNKNOWN, SVNStatusType.LOCK_INAPPLICABLE, SVNEventAction.SKIP, SVNEventAction.UPDATE_UPDATE, null, null);
            event.setPreviousRevision(entry.getRevision());
            event.setURL(entry.getSVNURL());
            this.myWCAccess.handleEvent(event);
        }
        return info;
    }

    private void closeFile(String textChecksum, SVNFileInfo fileInfo, SVNDirectoryInfo dirInfo) throws SVNException {
        String absTmpBasePath;
        String absBasePath;
        boolean isTextUpdated;
        if (fileInfo.isSkipped) {
            this.maybeBumpDirInfo(dirInfo);
            return;
        }
        if (fileInfo.addedWithHistory && !fileInfo.receivedTextDelta) {
            boolean useRevertBase;
            SVNErrorManager.assertionFailure(fileInfo.baseFile == null && fileInfo.newBaseFile == null && fileInfo.copiedBaseText != null, null, SVNLogType.WC);
            SVNAdminArea adminArea = fileInfo.getAdminArea();
            SVNEntry entry = adminArea.getEntry(fileInfo.Name, false);
            boolean replaced = entry != null && entry.isScheduledForReplacement();
            boolean bl = useRevertBase = replaced && entry.getCopyFromURL() != null;
            if (useRevertBase) {
                fileInfo.baseFile = adminArea.getFile(SVNAdminUtil.getTextRevertPath(fileInfo.Name, false));
                fileInfo.newBaseFile = adminArea.getFile(SVNAdminUtil.getTextRevertPath(fileInfo.Name, true));
            } else {
                fileInfo.baseFile = adminArea.getBaseFile(fileInfo.Name, false);
                fileInfo.newBaseFile = adminArea.getBaseFile(fileInfo.Name, true);
            }
            SVNFileUtil.copyFile(fileInfo.copiedBaseText, fileInfo.newBaseFile, true);
            fileInfo.Checksum = fileInfo.copiedBaseChecksum;
        }
        String checksum = null;
        boolean bl = isTextUpdated = fileInfo.newBaseFile != null;
        if (textChecksum != null && isTextUpdated) {
            if (fileInfo.Checksum != null && !textChecksum.equals(fileInfo.Checksum)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}''; expected: ''{1}'', actual: ''{2}''", fileInfo.getPath(), textChecksum, fileInfo.Checksum);
                SVNErrorManager.error(err, SVNLogType.WC);
            }
            checksum = textChecksum;
        }
        SVNAdminArea adminArea = fileInfo.getAdminArea();
        SVNLog log = dirInfo.getLog();
        String name = fileInfo.Name;
        SVNEntry fileEntry = adminArea.getEntry(name, false);
        if (fileEntry == null && !fileInfo.IsAdded) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNVERSIONED_RESOURCE, "''{0}'' is not under version control", (Object)fileInfo.getPath());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        long previousRevision = fileEntry != null ? fileEntry.getRevision() : -1L;
        SVNURL previousURL = fileEntry != null ? fileEntry.getSVNURL() : null;
        SVNProperties modifiedWCProps = fileInfo.getChangedWCProperties();
        SVNProperties modifiedEntryProps = fileInfo.getChangedEntryProperties();
        SVNProperties modifiedProps = fileInfo.getChangedProperties();
        String commitTime = fileInfo.CommitTime;
        SVNProperties command = new SVNProperties();
        SVNStatusType textStatus = SVNStatusType.UNCHANGED;
        SVNStatusType lockStatus = SVNStatusType.LOCK_UNCHANGED;
        if (this.myAdminInfo.isIncomplete(fileInfo.getPath()) && fileEntry != null) {
            SVNVersionedProperties oldBaseProps = adminArea.getBaseProperties(fileEntry.getName());
            SVNProperties baseMap = oldBaseProps.asMap();
            if (modifiedProps == null) {
                modifiedProps = new SVNProperties();
            }
            for (String propName : baseMap.nameSet()) {
                if (modifiedProps.containsName(propName)) continue;
                modifiedProps.put(propName, SVNPropertyValue.create(null));
            }
        }
        boolean magicPropsChanged = false;
        if (modifiedProps != null && !modifiedProps.isEmpty()) {
            magicPropsChanged = modifiedProps.containsName("svn:executable") || modifiedProps.containsName("svn:needs-lock") || modifiedProps.containsName("svn:keywords") || modifiedProps.containsName("svn:eol-style") || modifiedProps.containsName("svnkit:charset") || modifiedProps.containsName("svn:special");
        }
        SVNStatusType propStatus = adminArea.mergeProperties(name, null, fileInfo.copiedBaseProperties, fileInfo.copiedWorkingProperties, modifiedProps, null, null, true, false, log);
        if (modifiedEntryProps != null) {
            lockStatus = log.logChangedEntryProperties(name, modifiedEntryProps);
        }
        if (modifiedWCProps != null) {
            log.logChangedWCProperties(name, modifiedWCProps);
        }
        boolean isLocallyModified = false;
        if (fileInfo.copiedWorkingText != null) {
            isLocallyModified = true;
        } else if (fileEntry != null && fileEntry.getExternalFilePath() != null && fileEntry.isScheduledForAddition()) {
            isLocallyModified = false;
        } else if (!fileInfo.isExisted) {
            isLocallyModified = adminArea.hasTextModifications(name, false, false, false);
        } else if (isTextUpdated) {
            isLocallyModified = adminArea.hasVersionedFileTextChanges(adminArea.getFile(name), fileInfo.newBaseFile, false);
        }
        boolean isReplaced = fileEntry != null && fileEntry.isScheduledForReplacement();
        SVNProperties logAttributes = new SVNProperties();
        if (fileInfo.isAddExisted) {
            logAttributes.put("force", "true");
            logAttributes.put(SVNProperty.shortPropertyName("svn:entry:schedule"), "");
        }
        log.logTweakEntry(name, fileInfo.URL, this.myTargetRevision);
        String absDirPath = adminArea.getRoot().getAbsolutePath().replace(File.separatorChar, '/');
        String basePath = null;
        if (fileInfo.baseFile != null && (basePath = (absBasePath = fileInfo.baseFile.getAbsolutePath().replace(File.separatorChar, '/')).substring(absDirPath.length())).startsWith("/")) {
            basePath = basePath.substring(1);
        }
        String tmpBasePath = null;
        if (fileInfo.newBaseFile != null && (tmpBasePath = (absTmpBasePath = fileInfo.newBaseFile.getAbsolutePath().replace(File.separatorChar, '/')).substring(absDirPath.length())).startsWith("/")) {
            tmpBasePath = tmpBasePath.substring(1);
        }
        SVNStatusType mergeOutcome = SVNStatusType.UNCHANGED;
        File workingFile = adminArea.getFile(name);
        boolean deletedCopiedBaseText = false;
        if (tmpBasePath != null) {
            textStatus = SVNStatusType.CHANGED;
            if (!isLocallyModified && !isReplaced) {
                if (fileEntry == null || !fileEntry.isScheduledForDeletion()) {
                    command.put("name", tmpBasePath);
                    command.put("dest", name);
                    log.addCommand("cp-and-translate", command, false);
                    command.clear();
                }
            } else {
                SVNFileType kind = SVNFileType.getType(workingFile);
                if (kind == SVNFileType.NONE && !fileInfo.addedWithHistory) {
                    command.put("name", tmpBasePath);
                    command.put("dest", name);
                    log.addCommand("cp-and-translate", command, false);
                    command.clear();
                } else if (!fileInfo.isExisted) {
                    File mergeLeftFile = fileInfo.baseFile;
                    String pathExt = null;
                    if (this.myExtensionPatterns != null && this.myExtensionPatterns.length > 0) {
                        int dotInd = name.lastIndexOf(46);
                        if (dotInd != -1 && dotInd != 0 && dotInd != name.length() - 1) {
                            pathExt = name.substring(dotInd + 1);
                        }
                        if (pathExt != null && !"".equals(pathExt)) {
                            String extPattern;
                            boolean matches = false;
                            for (int i2 = 0; i2 < this.myExtensionPatterns.length && !(matches = DefaultSVNOptions.matches(extPattern = this.myExtensionPatterns[i2], pathExt)); ++i2) {
                            }
                            if (!matches) {
                                pathExt = null;
                            }
                        }
                    }
                    boolean deleteLeftMergeFile = false;
                    boolean deleteCopiedBaseText = false;
                    if (fileInfo.isAddExisted && !isReplaced) {
                        deleteLeftMergeFile = true;
                        mergeLeftFile = SVNAdminUtil.createTmpFile(adminArea);
                    } else if (fileInfo.copiedBaseText != null) {
                        deleteCopiedBaseText = true;
                        deleteLeftMergeFile = true;
                        mergeLeftFile = fileInfo.copiedBaseText;
                    }
                    String absMergeLeftFilePath = mergeLeftFile.getAbsolutePath().replace(File.separatorChar, '/');
                    String mergeLeftFilePath = absMergeLeftFilePath.substring(absDirPath.length());
                    if (mergeLeftFilePath.startsWith("/")) {
                        mergeLeftFilePath = mergeLeftFilePath.substring(1);
                    }
                    String leftLabel = null;
                    leftLabel = fileInfo.addedWithHistory ? ".copied" + (pathExt != null ? "." + pathExt : "") : ".r" + fileEntry.getRevision() + (pathExt != null ? "." + pathExt : "");
                    String rightLabel = ".r" + this.myTargetRevision + (pathExt != null ? "." + pathExt : "");
                    String mineLabel = ".mine" + (pathExt != null ? "." + pathExt : "");
                    mergeOutcome = adminArea.mergeText(name, mergeLeftFile, adminArea.getFile(tmpBasePath), fileInfo.copiedWorkingText, mineLabel, leftLabel, rightLabel, modifiedProps, false, null, log);
                    if (mergeOutcome == SVNStatusType.UNCHANGED) {
                        textStatus = SVNStatusType.MERGED;
                    }
                    if (deleteLeftMergeFile) {
                        command.put("name", mergeLeftFilePath);
                        log.addCommand("rm", command, false);
                        command.clear();
                        if (deleteCopiedBaseText) {
                            deletedCopiedBaseText = true;
                        }
                    }
                    if (fileInfo.copiedWorkingText != null) {
                        String absCopiedWorkingTextPath = fileInfo.copiedWorkingText.getAbsolutePath().replace(File.separatorChar, '/');
                        String copiedWorkingTextPath = absCopiedWorkingTextPath.substring(absDirPath.length());
                        if (copiedWorkingTextPath.startsWith("/")) {
                            copiedWorkingTextPath = copiedWorkingTextPath.substring(1);
                        }
                        command.put("name", copiedWorkingTextPath);
                        log.addCommand("rm", command, false);
                        command.clear();
                    }
                }
            }
        } else {
            if (magicPropsChanged && (workingFile.exists() || SVNFileType.getType(workingFile) == SVNFileType.SYMLINK)) {
                String tmpPath = SVNAdminUtil.getTextBasePath(name, true);
                command.put("name", name);
                command.put("dest", tmpPath);
                log.addCommand("cp-and-detranslate", command, false);
                command.clear();
                command.put("name", tmpPath);
                command.put("dest", name);
                log.addCommand("cp-and-translate", command, false);
                command.clear();
            }
            if (lockStatus == SVNStatusType.LOCK_UNLOCKED) {
                command.put("name", name);
                log.addCommand("maybe-readonly", command, false);
                command.clear();
            }
        }
        if (tmpBasePath != null) {
            command.put("name", tmpBasePath);
            command.put("dest", basePath);
            log.addCommand("mv", command, false);
            command.clear();
            command.put("name", basePath);
            log.addCommand("readonly", command, false);
            command.clear();
            if (!isReplaced) {
                logAttributes.put(SVNProperty.shortPropertyName("svn:entry:checksum"), checksum);
            }
        }
        if (logAttributes.size() > 0) {
            logAttributes.put("name", name);
            log.addCommand("modify-entry", logAttributes, false);
        }
        if (!isLocallyModified && (fileInfo.IsAdded || fileEntry.getSchedule() == null)) {
            if (commitTime != null && !fileInfo.isExisted) {
                command.put("name", name);
                command.put("timestamp", commitTime);
                log.addCommand("set-timestamp", command, false);
                command.clear();
            }
            if (tmpBasePath != null || magicPropsChanged) {
                command.put("name", name);
                command.put(SVNProperty.shortPropertyName("svn:entry:text-time"), "working");
                log.addCommand("modify-entry", command, false);
                command.clear();
            }
            command.put("name", name);
            command.put(SVNProperty.shortPropertyName("svn:entry:working-size"), "working");
            log.addCommand("modify-entry", command, false);
            command.clear();
        }
        if (fileInfo.copiedBaseText != null && !deletedCopiedBaseText) {
            String absCopiedBaseTextPath = fileInfo.copiedBaseText.getAbsolutePath().replace(File.separatorChar, '/');
            String copiedBaseTextPath = absCopiedBaseTextPath.substring(absDirPath.length());
            if (copiedBaseTextPath.startsWith("/")) {
                copiedBaseTextPath = copiedBaseTextPath.substring(1);
            }
            command.put("name", copiedBaseTextPath);
            log.addCommand("rm", command, false);
            command.clear();
        }
        this.maybeBumpDirInfo(dirInfo);
        if (mergeOutcome == SVNStatusType.CONFLICTED_UNRESOLVED) {
            textStatus = SVNStatusType.CONFLICTED_UNRESOLVED;
        } else if (mergeOutcome == SVNStatusType.CONFLICTED) {
            textStatus = SVNStatusType.CONFLICTED;
        } else if (fileInfo.newBaseFile != null) {
            textStatus = isLocallyModified ? SVNStatusType.MERGED : SVNStatusType.CHANGED;
        }
        if (textStatus != SVNStatusType.UNCHANGED || propStatus != SVNStatusType.UNCHANGED || lockStatus != SVNStatusType.LOCK_UNCHANGED) {
            SVNEventAction action = SVNEventAction.UPDATE_UPDATE;
            if (fileInfo.isExisted || fileInfo.isAddExisted) {
                if (textStatus != SVNStatusType.CONFLICTED_UNRESOLVED && textStatus != SVNStatusType.CONFLICTED) {
                    action = SVNEventAction.UPDATE_EXISTS;
                }
            } else if (fileInfo.IsAdded) {
                action = SVNEventAction.UPDATE_ADD;
            }
            SVNEvent event = SVNEventFactory.createSVNEvent(adminArea.getFile(fileInfo.Name), SVNNodeKind.FILE, null, this.myTargetRevision, textStatus, propStatus, lockStatus, action, null, null, null);
            event.setPreviousRevision(previousRevision);
            event.setPreviousURL(previousURL);
            event.setURL(fileInfo.URL != null ? SVNURL.parseURIEncoded(fileInfo.URL) : null);
            this.myWCAccess.handleEvent(event);
        }
    }

    private SVNFileInfo createFileInfo(SVNDirectoryInfo parent, String path, boolean added) throws SVNException {
        SVNFileInfo info = new SVNFileInfo(parent, path);
        info.IsAdded = added;
        info.Name = SVNPathUtil.tail(path);
        info.isExisted = false;
        info.isAddExisted = false;
        info.isSkipped = false;
        info.baseFile = null;
        info.newBaseFile = null;
        SVNAdminArea adminArea = parent.getAdminArea();
        SVNEntry entry = adminArea.getEntry(info.Name, true);
        info.URL = this.mySwitchURL != null || entry == null ? SVNPathUtil.append(parent.URL, SVNEncodingUtil.uriEncode(info.Name)) : entry.getURL();
        ++parent.RefCount;
        return info;
    }

    private SVNDirectoryInfo createDirectoryInfo(SVNDirectoryInfo parent, String path, boolean added) {
        String name;
        SVNDirectoryInfo info = new SVNDirectoryInfo(path);
        info.Parent = parent;
        info.IsAdded = added;
        String string = name = path != null ? SVNPathUtil.tail(path) : "";
        if (this.mySwitchURL == null) {
            SVNAdminArea area = null;
            SVNEntry dirEntry = null;
            File areaPath = new File(this.myAdminInfo.getAnchor().getRoot(), info.getPath());
            try {
                area = this.myWCAccess.getAdminArea(areaPath);
                if (area != null) {
                    dirEntry = area.getEntry(area.getThisDirName(), false);
                }
            }
            catch (SVNException sVNException) {
                // empty catch block
            }
            if (area != null && dirEntry != null) {
                info.URL = dirEntry.getURL();
            }
            if (info.URL == null && parent != null) {
                info.URL = SVNPathUtil.append(parent.URL, SVNEncodingUtil.uriEncode(name));
            } else if (info.URL == null && parent == null) {
                info.URL = this.myTargetURL;
            }
        } else {
            info.URL = parent == null ? (this.myTarget == null ? this.mySwitchURL : SVNPathUtil.removeTail(this.mySwitchURL)) : (this.myTarget != null && parent.Parent == null ? this.mySwitchURL : SVNPathUtil.append(parent.URL, SVNEncodingUtil.uriEncode(name)));
        }
        info.RefCount = 1;
        info.isSkipped = false;
        if (info.Parent != null) {
            ++info.Parent.RefCount;
        }
        info.isExisted = false;
        info.isAddExisted = false;
        info.log = null;
        info.myAmbientDepth = SVNDepth.UNKNOWN;
        return info;
    }

    public static SVNUpdateEditor15 createUpdateEditor(SVNAdminAreaInfo info, String switchURL, boolean allowUnversionedObstructions, boolean depthIsSticky, SVNDepth depth, String[] preservedExtensions, ISVNFileFetcher fileFetcher, boolean lockOnDemand) throws SVNException {
        if (depth == SVNDepth.UNKNOWN) {
            depthIsSticky = false;
        }
        SVNEntry entry = info.getAnchor().getEntry(info.getAnchor().getThisDirName(), false);
        if (switchURL != null && entry != null && entry.getRepositoryRoot() != null && !SVNPathUtil.isAncestor(entry.getRepositoryRoot(), switchURL)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.WC_INVALID_SWITCH, "''{0}''\nis not the same repository as\n''{1}''", switchURL, entry.getRepositoryRoot());
            SVNErrorManager.error(err, SVNLogType.WC);
        }
        SVNUpdateEditor15 editor = new SVNUpdateEditor15(info, switchURL, allowUnversionedObstructions, depthIsSticky, depth, preservedExtensions, entry != null ? entry.getURL() : null, entry != null ? entry.getRepositoryRoot() : null, fileFetcher, lockOnDemand);
        info.getTarget().closeEntries();
        return editor;
    }

    @Override
    public void cleanup(SVNAdminArea area) throws SVNException {
        area.runLogs();
    }

    private class SVNDirectoryInfo
    extends SVNEntryInfo
    implements ISVNCleanupHandler {
        public int RefCount;
        private SVNLog log;
        public int LogCount;
        public SVNDepth myAmbientDepth;

        public SVNDirectoryInfo(String path) {
            super(path);
        }

        public SVNAdminArea getAdminArea() throws SVNException {
            String path = this.getPath();
            File file = new File(SVNUpdateEditor15.this.myAdminInfo.getAnchor().getRoot(), path);
            SVNAdminArea area = SVNUpdateEditor15.this.myAdminInfo.getWCAccess().retrieve(file);
            if (SVNUpdateEditor15.this.myIsLockOnDemand && area != null && !area.isLocked()) {
                area.lock(false);
                area = SVNUpdateEditor15.this.myAdminInfo.getWCAccess().upgrade(file);
            }
            return area;
        }

        public SVNLog getLog() throws SVNException {
            if (this.log == null) {
                this.log = this.getAdminArea().getLog();
                ++this.LogCount;
            }
            return this.log;
        }

        public void flushLog() throws SVNException {
            if (this.log != null) {
                this.log.save();
                this.log = null;
            }
        }

        public void runLogs() throws SVNException {
            this.LogCount = 0;
            this.getAdminArea().runLogs();
        }

        @Override
        public void cleanup(SVNAdminArea area) throws SVNException {
            if (area != null && this.LogCount > 0) {
                this.LogCount = 0;
                area.runLogs();
            }
        }
    }

    private class SVNFileInfo
    extends SVNEntryInfo {
        public String Name;
        public String CommitTime;
        public String Checksum;
        public String expectedSrcChecksum;
        public String copiedBaseChecksum;
        public File baseFile;
        public File newBaseFile;
        public boolean addedWithHistory;
        public boolean receivedTextDelta;
        private SVNProperties copiedBaseProperties;
        private SVNProperties copiedWorkingProperties;
        private File copiedBaseText;
        private File copiedWorkingText;
        private SVNChecksumInputStream sourceChecksumStream;

        public SVNFileInfo(SVNDirectoryInfo parent, String path) {
            super(path);
            this.Parent = parent;
        }

        public SVNAdminArea getAdminArea() throws SVNException {
            return this.Parent.getAdminArea();
        }
    }

    private class SVNEntryInfo {
        public String URL;
        public boolean IsAdded;
        public boolean isExisted;
        public boolean isAddExisted;
        public SVNDirectoryInfo Parent;
        public boolean isSkipped;
        public long myPreviousRevision;
        private String myPath;
        private SVNProperties myChangedProperties;
        private SVNProperties myChangedEntryProperties;
        private SVNProperties myChangedWCProperties;

        protected SVNEntryInfo(String path) {
            this.myPath = path;
        }

        protected String getPath() {
            return this.myPath;
        }

        public void propertyChanged(String name, SVNPropertyValue value) {
            if (name.startsWith("svn:entry:")) {
                String strValue;
                SVNProperties sVNProperties = this.myChangedEntryProperties = this.myChangedEntryProperties == null ? new SVNProperties() : this.myChangedEntryProperties;
                if (value != null && (strValue = value.getString()) != null) {
                    strValue = strValue.trim();
                    value = SVNPropertyValue.create(strValue);
                }
                this.myChangedEntryProperties.put(name.substring("svn:entry:".length()), value);
            } else if (name.startsWith("svn:wc:")) {
                this.myChangedWCProperties = this.myChangedWCProperties == null ? new SVNProperties() : this.myChangedWCProperties;
                this.myChangedWCProperties.put(name, value);
            } else {
                this.myChangedProperties = this.myChangedProperties == null ? new SVNProperties() : this.myChangedProperties;
                this.myChangedProperties.put(name, value);
            }
        }

        public SVNProperties getChangedWCProperties() {
            return this.myChangedWCProperties;
        }

        public SVNProperties getChangedEntryProperties() {
            return this.myChangedEntryProperties;
        }

        public SVNProperties getChangedProperties() {
            return this.myChangedProperties;
        }
    }
}

