/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNExternal;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc17.SVNExternalsStore;
import org.tmatesoft.svn.core.internal.wc17.SVNWCContext;
import org.tmatesoft.svn.core.internal.wc17.db.ISVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.SVNWCDb;
import org.tmatesoft.svn.core.internal.wc17.db.Structure;
import org.tmatesoft.svn.core.internal.wc17.db.StructureFields;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbExternals;
import org.tmatesoft.svn.core.internal.wc17.db.SvnWcDbReader;
import org.tmatesoft.svn.core.internal.wc2.SvnRepositoryAccess;
import org.tmatesoft.svn.core.internal.wc2.remote.SvnRemoteGetProperties;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.ISvnObjectReceiver;
import org.tmatesoft.svn.core.wc2.SvnTarget;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNExternalsUtil {
    public static Map<String, SVNPropertyValue> resolvePinnedExternals(SVNWCContext context, SvnRepositoryAccess repositoryAccess, Map<SvnTarget, List<SVNExternal>> externalsToPin, SvnTarget pairSource, SvnTarget pairDst, long pairSourceRevision, SVNRepository svnRepository, SVNURL reposRootUrl) throws SVNException {
        HashMap<String, SVNPropertyValue> pinnedExternals = new HashMap<String, SVNPropertyValue>();
        final HashMap<SvnTarget, SVNPropertyValue> externalsProps = new HashMap<SvnTarget, SVNPropertyValue>();
        SVNURL oldUrl = null;
        if (pairSource.isURL()) {
            oldUrl = svnRepository.getLocation();
            svnRepository.setLocation(pairSource.getURL(), false);
            SvnRemoteGetProperties.remotePropertyGet(pairSource.getURL(), SVNNodeKind.DIR, "", svnRepository, pairSourceRevision, SVNDepth.INFINITY, new ISvnObjectReceiver<SVNProperties>(){

                @Override
                public void receive(SvnTarget target, SVNProperties properties) throws SVNException {
                    SVNPropertyValue externalsValue;
                    if (properties != null && (externalsValue = properties.getSVNPropertyValue("svn:externals")) != null) {
                        externalsProps.put(target, externalsValue);
                    }
                }
            });
        } else {
            SVNExternalsStore externalsStore = new SVNExternalsStore();
            context.getDb().gatherExternalDefinitions(pairSource.getFile(), externalsStore);
            Map<File, String> newExternals = externalsStore.getNewExternals();
            for (Map.Entry<File, String> entry : newExternals.entrySet()) {
                File localAbsPath = entry.getKey();
                String externalsValue = entry.getValue();
                externalsProps.put(SvnTarget.fromFile(localAbsPath), SVNPropertyValue.create(externalsValue));
            }
        }
        if (externalsProps.size() == 0) {
            if (oldUrl != null) {
                svnRepository.setLocation(oldUrl, false);
            }
            return Collections.emptyMap();
        }
        for (Map.Entry entry : externalsProps.entrySet()) {
            SvnTarget localAbsPathOrUrl = (SvnTarget)entry.getKey();
            SVNPropertyValue externalsPropValue = (SVNPropertyValue)entry.getValue();
            SVNPropertyValue newPropVal = SVNExternalsUtil.pinExternalProps(context, repositoryAccess, externalsPropValue, externalsToPin, reposRootUrl, localAbsPathOrUrl);
            if (newPropVal == null) continue;
            String relativePath = SVNPathUtil.getRelativePath(pairSource.getPathOrUrlDecodedString(), localAbsPathOrUrl.getPathOrUrlDecodedString());
            pinnedExternals.put(relativePath, newPropVal);
        }
        if (oldUrl != null) {
            svnRepository.setLocation(oldUrl, false);
        }
        return pinnedExternals;
    }

    private static SVNPropertyValue pinExternalProps(SVNWCContext context, SvnRepositoryAccess repositoryAccess, SVNPropertyValue externalsPropValue, Map<SvnTarget, List<SVNExternal>> externalsToPin, SVNURL reposRootUrl, SvnTarget localAbsPathOrUrl) throws SVNException {
        List<SVNExternal> itemsToPin;
        StringBuilder stringBuilder = new StringBuilder();
        SVNExternal[] externals = SVNExternal.parseExternals(localAbsPathOrUrl, SVNPropertyValue.getPropertyAsString(externalsPropValue));
        if (externalsToPin != null) {
            itemsToPin = externalsToPin.get(localAbsPathOrUrl);
            if (itemsToPin == null) {
                return null;
            }
        } else {
            itemsToPin = null;
        }
        int pinnedItems = 0;
        for (SVNExternal item : externals) {
            SVNRevision externalPegRev;
            if (itemsToPin != null) {
                SVNExternal itemToPin = null;
                for (SVNExternal current : itemsToPin) {
                    if (current == null || !current.getUnresolvedUrl().equals(item.getUnresolvedUrl()) || !current.getPath().equals(item.getPath())) continue;
                    itemToPin = current;
                    break;
                }
                if (itemToPin == null) {
                    externalPegRev = SVNRevision.UNDEFINED;
                    String externalDescription = SVNExternalsUtil.makeExternalDescription(localAbsPathOrUrl, item, externalPegRev);
                    stringBuilder.append(externalDescription);
                    continue;
                }
            }
            if (item.getPegRevision().getDate() != null) {
                externalPegRev = item.getPegRevision();
            } else if (SVNRevision.isValidRevisionNumber(item.getPegRevision().getNumber())) {
                externalPegRev = item.getPegRevision();
            } else {
                assert (item.getPegRevision() == SVNRevision.HEAD || item.getPegRevision() == SVNRevision.UNDEFINED);
                ++pinnedItems;
                if (localAbsPathOrUrl.isURL()) {
                    SVNURL resolvedURL = item.resolveURL(reposRootUrl, localAbsPathOrUrl.getURL());
                    SVNRepository svnRepository = repositoryAccess.createRepository(resolvedURL, null, true);
                    externalPegRev = SVNRevision.create(svnRepository.getLatestRevision());
                } else {
                    ISVNWCDb.SVNWCDbKind externalKind;
                    File externalAbsPath = SVNFileUtil.createFilePath(localAbsPathOrUrl.getFile(), item.getPath());
                    try {
                        Structure<StructureFields.ExternalNodeInfo> externalNodeInfoStructure = SvnWcDbExternals.readExternal(context, externalAbsPath, localAbsPathOrUrl.getFile(), StructureFields.ExternalNodeInfo.kind, StructureFields.ExternalNodeInfo.presence);
                        assert (externalNodeInfoStructure != null);
                        assert (externalNodeInfoStructure.hasField(StructureFields.ExternalNodeInfo.presence));
                        ISVNWCDb.SVNWCDbStatus status = (ISVNWCDb.SVNWCDbStatus)((Object)externalNodeInfoStructure.get(StructureFields.ExternalNodeInfo.presence));
                        if (status != ISVNWCDb.SVNWCDbStatus.Normal) {
                            externalKind = ISVNWCDb.SVNWCDbKind.Unknown;
                        } else {
                            ISVNWCDb.SVNWCDbKind kind = (ISVNWCDb.SVNWCDbKind)((Object)externalNodeInfoStructure.get(StructureFields.ExternalNodeInfo.kind));
                            switch (kind) {
                                case File: 
                                case Symlink: {
                                    externalKind = ISVNWCDb.SVNWCDbKind.File;
                                    break;
                                }
                                case Dir: {
                                    externalKind = ISVNWCDb.SVNWCDbKind.Dir;
                                    break;
                                }
                                default: {
                                    externalKind = null;
                                }
                            }
                        }
                    }
                    catch (SVNException e) {
                        if (e.getErrorMessage().getErrorCode() != SVNErrorCode.WC_PATH_NOT_FOUND) {
                            throw e;
                        }
                        externalKind = null;
                    }
                    long externalCheckedOutRevision = 0L;
                    if (externalKind == null) {
                        SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Cannot pin external ''{0}'' defined in {1} at ''{2}'' because it is not checked out in the working copy at ''{3}''", item.getUnresolvedUrl(), "svn:externals", localAbsPathOrUrl.getFile(), externalAbsPath.getAbsolutePath(), "svn:externals");
                        SVNErrorManager.error(errorMessage, SVNLogType.CLIENT);
                    } else if (externalKind == ISVNWCDb.SVNWCDbKind.Dir) {
                        long[] minMaxRevisions;
                        boolean isModified;
                        boolean isSwitched = SvnWcDbReader.hasSwitchedSubtrees((SVNWCDb)context.getDb(), externalAbsPath);
                        if (isSwitched) {
                            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Cannot pin external ''{0}'' defined in {1} at ''{2}'' because ''{3}'' has switched subtrees (switches cannot be represented in {4})", item.getUnresolvedUrl(), "svn:externals", localAbsPathOrUrl.getFile(), externalAbsPath.getAbsolutePath(), "svn:externals");
                            SVNErrorManager.error(errorMessage, SVNLogType.CLIENT);
                        }
                        if (isModified = SvnWcDbReader.hasLocalModifications(context, externalAbsPath)) {
                            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Cannot pin external ''{0}'' defined in {1} at ''{2}'' because ''{3}'' has local modifications (local modifications cannot be represented in {4})", item.getUnresolvedUrl(), "svn:externals", localAbsPathOrUrl.getFile(), externalAbsPath.getAbsolutePath(), "svn:externals");
                            SVNErrorManager.error(errorMessage, SVNLogType.CLIENT);
                        }
                        if ((minMaxRevisions = SvnWcDbReader.getMinAndMaxRevisions((SVNWCDb)context.getDb(), externalAbsPath))[0] != minMaxRevisions[1]) {
                            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.WC_PATH_UNEXPECTED_STATUS, "Cannot pin external ''{0}'' defined in {1} at ''{2}'' because ''{3}'' is a mixed-revision working copy (mixed-revisions cannot be represented in {4})", item.getUnresolvedUrl(), "svn:externals", localAbsPathOrUrl.getFile(), externalAbsPath.getAbsolutePath(), "svn:externals");
                            SVNErrorManager.error(errorMessage, SVNLogType.CLIENT);
                        }
                        externalCheckedOutRevision = minMaxRevisions[0];
                    } else {
                        assert (externalKind == ISVNWCDb.SVNWCDbKind.File);
                        SVNWCContext.SVNWCNodeReposInfo nodeReposInfo = context.getNodeReposInfo(externalAbsPath);
                        externalCheckedOutRevision = nodeReposInfo.revision;
                    }
                    externalPegRev = SVNRevision.create(externalCheckedOutRevision);
                }
            }
            assert (externalPegRev.getDate() != null || SVNRevision.isValidRevisionNumber(externalPegRev.getNumber()));
            String pinnedDescription = SVNExternalsUtil.makeExternalDescription(localAbsPathOrUrl, item, externalPegRev);
            stringBuilder.append(pinnedDescription);
        }
        if (pinnedItems > 0) {
            return SVNPropertyValue.create(stringBuilder.toString());
        }
        return null;
    }

    private static String makeExternalDescription(SvnTarget localAbsPathOrUrl, SVNExternal item, SVNRevision externalPegRevision) throws SVNException {
        String parserRevisionString = item.getRevisionString();
        String parserPegRevisionString = item.getPegRevisionString();
        switch (item.getFormat()) {
            case 1: {
                String revisionString;
                if (externalPegRevision == SVNRevision.UNDEFINED) {
                    revisionString = parserRevisionString + " ";
                } else if (parserRevisionString != null && item.getRevision() != SVNRevision.HEAD) {
                    revisionString = parserRevisionString + " ";
                } else {
                    assert (SVNRevision.isValidRevisionNumber(externalPegRevision.getNumber()));
                    revisionString = "-r" + externalPegRevision.getNumber() + " ";
                }
                return SVNExternalsUtil.maybeQuote(item.getPath()) + " " + revisionString + SVNExternalsUtil.maybeQuote(item.getRawURL()) + "\n";
            }
            case 2: {
                String pegRevisionString;
                String revisionString = externalPegRevision == SVNRevision.UNDEFINED ? parserRevisionString + " " : (parserRevisionString != null && item.getRevision() != SVNRevision.HEAD ? parserRevisionString + " " : "");
                if (externalPegRevision == SVNRevision.UNDEFINED) {
                    pegRevisionString = parserPegRevisionString != null ? parserPegRevisionString : "";
                } else if (parserPegRevisionString != null && item.getRevision() != SVNRevision.HEAD) {
                    pegRevisionString = parserPegRevisionString;
                } else {
                    assert (SVNRevision.isValidRevisionNumber(externalPegRevision.getNumber()));
                    pegRevisionString = "@" + externalPegRevision.getNumber();
                }
                return revisionString + SVNExternalsUtil.maybeQuote(item.getRawURL() + pegRevisionString) + " " + SVNExternalsUtil.maybeQuote(item.getPath()) + "\n";
            }
        }
        SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.CLIENT_INVALID_EXTERNALS_DESCRIPTION, "{0} property defined at ''{1}'' is using an unsupported syntax", "svn:externals", localAbsPathOrUrl.getFile());
        SVNErrorManager.error(errorMessage, SVNLogType.CLIENT);
        return null;
    }

    private static String maybeQuote(String s) {
        String[] argv = s.split("\\s");
        if (argv.length == 1 && argv[0].equals(s)) {
            return s;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('\"');
        for (int i2 = 0; i2 < s.length(); ++i2) {
            char c = s.charAt(i2);
            if (c == '\\' || c == '\"' || c == '\'') {
                stringBuilder.append('\\');
            }
            stringBuilder.append(c);
        }
        stringBuilder.append('\"');
        return stringBuilder.toString();
    }
}

