/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.delta.SVNDeltaReader;
import org.tmatesoft.svn.core.internal.io.fs.FSCommitter;
import org.tmatesoft.svn.core.internal.io.fs.FSDeltaConsumer;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionInfo;
import org.tmatesoft.svn.core.internal.io.fs.FSTransactionRoot;
import org.tmatesoft.svn.core.internal.util.FixedSizeInputStream;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNLoadHandler;
import org.tmatesoft.svn.core.internal.wc.SVNAdminHelper;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.core.internal.wc.SVNWCProperties;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.admin.ISVNAdminEventHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEvent;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;
import org.tmatesoft.svn.core.wc.admin.SVNUUIDAction;
import org.tmatesoft.svn.util.SVNLogType;

public class DefaultLoadHandler
implements ISVNLoadHandler {
    private FSFS myFSFS;
    private RevisionBaton myCurrentRevisionBaton;
    private NodeBaton myCurrentNodeBaton;
    private boolean myIsUsePreCommitHook;
    private boolean myIsUsePostCommitHook;
    private Map myRevisionsMap;
    private String myParentDir;
    private SVNUUIDAction myUUIDAction;
    private SVNDeltaReader myDeltaReader;
    private SVNDeltaGenerator myDeltaGenerator;
    private ISVNAdminEventHandler myProgressHandler;

    public DefaultLoadHandler(boolean usePreCommitHook, boolean usePostCommitHook, SVNUUIDAction uuidAction, String parentDir, ISVNAdminEventHandler progressHandler) {
        this.myProgressHandler = progressHandler;
        this.myIsUsePreCommitHook = usePreCommitHook;
        this.myIsUsePostCommitHook = usePostCommitHook;
        this.myUUIDAction = uuidAction;
        this.myParentDir = SVNPathUtil.canonicalizePath(parentDir);
        this.myRevisionsMap = new SVNHashMap();
    }

    public void setFSFS(FSFS fsfs) {
        this.myFSFS = fsfs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeRevision() throws SVNException {
        if (this.myCurrentRevisionBaton != null) {
            File revProps;
            this.myCurrentRevisionBaton.getConsumer().close();
            RevisionBaton baton = this.myCurrentRevisionBaton;
            this.myCurrentRevisionBaton = null;
            if (baton.myRevision <= 0L) {
                return;
            }
            long oldRevision = baton.myRevision;
            long newRevision = -1L;
            try {
                newRevision = baton.getCommitter().commitTxn(this.myIsUsePreCommitHook, this.myIsUsePostCommitHook, null, null);
            }
            catch (SVNException svne) {
                try {
                    FSCommitter.abortTransaction(this.myFSFS, baton.myTxn.getTxnId());
                }
                catch (SVNException sVNException) {
                    // empty catch block
                }
                throw svne;
            }
            if (baton.myDatestamp == null) {
                this.myFSFS.setRevisionProperty(baton.myRevision, "svn:date", null);
            }
            if (!(revProps = this.myFSFS.getRevisionPropertiesFile(baton.myRevision, true)).exists()) {
                OutputStream os = SVNFileUtil.openFileForWriting(revProps);
                try {
                    SVNWCProperties.setProperties(new SVNProperties(), os, "END");
                }
                finally {
                    SVNFileUtil.closeFile(os);
                }
            }
            this.myRevisionsMap.put(oldRevision, newRevision);
            if (baton.myDatestamp != null) {
                this.myFSFS.setRevisionProperty(newRevision, "svn:date", baton.myDatestamp);
            }
            String message = newRevision == baton.myRevision ? "\n------- Committed revision " + newRevision + " >>>" : "\n------- Committed new rev " + newRevision + " (loaded from original rev " + baton.myRevision + ") >>>";
            if (this.myProgressHandler != null) {
                SVNAdminEvent event = new SVNAdminEvent(newRevision, baton.myRevision, SVNAdminEventAction.REVISION_LOADED, message);
                this.myProgressHandler.handleAdminEvent(event, -1.0);
            }
        }
    }

    @Override
    public void openRevision(Map headers) throws SVNException {
        this.myCurrentRevisionBaton = new RevisionBaton();
        long revision = -1L;
        if (headers.containsKey("Revision-number")) {
            try {
                revision = Long.parseLong((String)headers.get("Revision-number"));
            }
            catch (NumberFormatException nfe) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Cannot parse revision ({0}) in dump file", headers.get("Revision-number"));
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
        }
        this.myCurrentRevisionBaton.myRevision = revision;
        long headRevision = this.myFSFS.getYoungestRevision();
        this.myCurrentRevisionBaton.myRevisionOffset = revision - (headRevision + 1L);
        if (revision > 0L) {
            this.myCurrentRevisionBaton.myTxn = FSTransactionRoot.beginTransaction(headRevision, 0, this.myFSFS);
            this.myCurrentRevisionBaton.myTxnRoot = this.myFSFS.createTransactionRoot(this.myCurrentRevisionBaton.myTxn);
            String message = "<<< Started new transaction, based on original revision " + revision;
            if (this.myProgressHandler != null) {
                SVNAdminEvent event = new SVNAdminEvent(revision, SVNAdminEventAction.REVISION_LOAD, message);
                this.myProgressHandler.handleAdminEvent(event, -1.0);
            }
        }
    }

    @Override
    public void openNode(Map headers) throws SVNException {
        if (this.myCurrentRevisionBaton.myRevision == 0L) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Malformed dumpstream: Revision 0 must not contain node records");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        this.myCurrentNodeBaton = this.createNodeBaton(headers);
        switch (this.myCurrentNodeBaton.myAction) {
            case 0: {
                String message = "     * editing path : " + this.myCurrentNodeBaton.myPath + " ...";
                if (this.myProgressHandler == null) break;
                SVNAdminEvent event = new SVNAdminEvent(SVNAdminEventAction.REVISION_LOAD_EDIT_PATH, this.myCurrentNodeBaton.myPath, message);
                this.myProgressHandler.handleAdminEvent(event, -1.0);
                break;
            }
            case 2: {
                String message = "     * deleting path : " + this.myCurrentNodeBaton.myPath + " ...";
                if (this.myProgressHandler != null) {
                    SVNAdminEvent event = new SVNAdminEvent(SVNAdminEventAction.REVISION_LOAD_DELETE_PATH, this.myCurrentNodeBaton.myPath, message);
                    this.myProgressHandler.handleAdminEvent(event, -1.0);
                }
                this.myCurrentRevisionBaton.getCommitter().deleteNode(this.myCurrentNodeBaton.myPath);
                break;
            }
            case 1: {
                String message = "     * adding path : " + this.myCurrentNodeBaton.myPath + " ...";
                if (this.maybeAddWithHistory(this.myCurrentNodeBaton)) {
                    message = message + "COPIED...";
                }
                if (this.myProgressHandler == null) break;
                SVNAdminEvent event = new SVNAdminEvent(SVNAdminEventAction.REVISION_LOAD_ADD_PATH, this.myCurrentNodeBaton.myPath, message);
                this.myProgressHandler.handleAdminEvent(event, -1.0);
                break;
            }
            case 3: {
                String message = "     * replacing path : " + this.myCurrentNodeBaton.myPath + " ...";
                this.myCurrentRevisionBaton.getCommitter().deleteNode(this.myCurrentNodeBaton.myPath);
                if (this.maybeAddWithHistory(this.myCurrentNodeBaton)) {
                    message = message + "COPIED...";
                }
                if (this.myProgressHandler == null) break;
                SVNAdminEvent event = new SVNAdminEvent(SVNAdminEventAction.REVISION_LOAD_REPLACE_PATH, this.myCurrentNodeBaton.myPath, message);
                this.myProgressHandler.handleAdminEvent(event, -1.0);
                break;
            }
            default: {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.STREAM_UNRECOGNIZED_DATA, "Unrecognized node-action on node ''{0}''", (Object)this.myCurrentNodeBaton.myPath);
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
        }
    }

    @Override
    public void parseUUID(String uuid) throws SVNException {
        long latestRevision;
        if (this.myUUIDAction == SVNUUIDAction.IGNORE_UUID) {
            return;
        }
        if (this.myUUIDAction != SVNUUIDAction.FORCE_UUID && (latestRevision = this.myFSFS.getYoungestRevision()) != 0L) {
            return;
        }
        this.myFSFS.setUUID(uuid);
    }

    @Override
    public void closeNode() throws SVNException {
        this.myCurrentNodeBaton = null;
    }

    @Override
    public void applyTextDelta() throws SVNException {
        FSDeltaConsumer fsConsumer = this.myCurrentRevisionBaton.getConsumer();
        fsConsumer.applyTextDelta(this.myCurrentNodeBaton.myPath, this.myCurrentNodeBaton.myBaseChecksum);
    }

    @Override
    public void setFullText() throws SVNException {
        FSDeltaConsumer fsConsumer = this.myCurrentRevisionBaton.getConsumer();
        fsConsumer.applyText(this.myCurrentNodeBaton.myPath);
    }

    @Override
    public void parseTextBlock(InputStream dumpStream, long contentLength, boolean isDelta) throws SVNException {
        FSDeltaConsumer fsConsumer = this.myCurrentRevisionBaton.getConsumer();
        try {
            if (isDelta) {
                this.applyTextDelta();
            } else {
                this.setFullText();
            }
            String checksum = null;
            byte[] buffer = null;
            if (contentLength == 0L) {
                this.getDeltaGenerator().sendDelta(this.myCurrentNodeBaton.myPath, SVNFileUtil.DUMMY_IN, fsConsumer, false);
            } else if (!isDelta) {
                FixedSizeInputStream tgt = new FixedSizeInputStream(dumpStream, contentLength);
                checksum = this.getDeltaGenerator().sendDelta(this.myCurrentNodeBaton.myPath, tgt, fsConsumer, true);
            } else {
                buffer = new byte[16384];
                SVNDeltaReader deltaReader = null;
                try {
                    while (contentLength > 0L) {
                        int numRead;
                        int read = 0;
                        for (int numToRead = contentLength > 16384L ? 16384 : (int)contentLength; numToRead > 0; numToRead -= numRead) {
                            numRead = dumpStream.read(buffer, read, numToRead);
                            if (numRead < 0) {
                                SVNAdminHelper.generateIncompleteDataError();
                            }
                            read += numRead;
                        }
                        deltaReader = this.getDeltaReader();
                        deltaReader.nextWindow(buffer, 0, read, this.myCurrentNodeBaton.myPath, fsConsumer);
                        contentLength -= (long)read;
                    }
                }
                catch (IOException ioe) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getMessage());
                    SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
                }
                if (deltaReader != null) {
                    deltaReader.reset(this.myCurrentNodeBaton.myPath, fsConsumer);
                }
                fsConsumer.textDeltaEnd(this.myCurrentNodeBaton.myPath);
                checksum = fsConsumer.getChecksum();
            }
            if (checksum != null && this.myCurrentNodeBaton.myResultChecksum != null && !checksum.equals(this.myCurrentNodeBaton.myResultChecksum)) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Checksum mismatch for ''{0}'':\n   expected:  {1}\n     actual:  {2}\n", this.myCurrentNodeBaton.myPath, this.myCurrentNodeBaton.myResultChecksum, checksum);
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
        }
        catch (SVNException svne) {
            fsConsumer.abort();
            throw svne;
        }
    }

    @Override
    public void removeNodeProperties() throws SVNException {
        FSTransactionRoot txnRoot = this.myCurrentRevisionBaton.myTxnRoot;
        FSRevisionNode node = txnRoot.getRevisionNode(this.myCurrentNodeBaton.myPath);
        SVNProperties props = node.getProperties(this.myFSFS);
        for (String propName : props.nameSet()) {
            this.myCurrentRevisionBaton.getCommitter().changeNodeProperty(this.myCurrentNodeBaton.myPath, propName, null);
        }
    }

    @Override
    public void setRevisionProperty(String propertyName, SVNPropertyValue propertyValue) throws SVNException {
        long youngestRevision;
        if (this.myCurrentRevisionBaton.myRevision > 0L) {
            this.myFSFS.setTransactionProperty(this.myCurrentRevisionBaton.myTxn.getTxnId(), propertyName, propertyValue);
            if ("svn:date".equals(propertyName)) {
                this.myCurrentRevisionBaton.myDatestamp = propertyValue;
            }
        } else if (this.myCurrentRevisionBaton.myRevision == 0L && (youngestRevision = this.myFSFS.getYoungestRevision()) == 0L) {
            this.myFSFS.setRevisionProperty(0L, propertyName, propertyValue);
        }
    }

    public void setUsePreCommitHook(boolean use) {
        this.myIsUsePreCommitHook = use;
    }

    public void setUsePostCommitHook(boolean use) {
        this.myIsUsePostCommitHook = use;
    }

    public void setParentDir(String parentDir) {
        this.myParentDir = parentDir;
    }

    public void setUUIDAction(SVNUUIDAction action) {
        this.myUUIDAction = action;
    }

    @Override
    public void deleteNodeProperty(String propertyName) throws SVNException {
        this.myCurrentRevisionBaton.getCommitter().changeNodeProperty(this.myCurrentNodeBaton.myPath, propertyName, null);
    }

    @Override
    public void setNodeProperty(String propertyName, SVNPropertyValue propertyValue) throws SVNException {
        if ("svn:mergeinfo".equals(propertyName)) {
            Map mergeInfo = this.renumberMergeInfoRevisions(propertyValue);
            if (this.myParentDir != null) {
                mergeInfo = this.prefixMergeInfoPaths(mergeInfo);
            }
            String mergeInfoString = SVNMergeInfoUtil.formatMergeInfoToString(mergeInfo, null);
            propertyValue = SVNPropertyValue.create(mergeInfoString);
        }
        this.myCurrentRevisionBaton.getCommitter().changeNodeProperty(this.myCurrentNodeBaton.myPath, propertyName, propertyValue);
    }

    private SVNDeltaReader getDeltaReader() {
        if (this.myDeltaReader == null) {
            this.myDeltaReader = new SVNDeltaReader();
        }
        return this.myDeltaReader;
    }

    private SVNDeltaGenerator getDeltaGenerator() {
        if (this.myDeltaGenerator == null) {
            this.myDeltaGenerator = new SVNDeltaGenerator();
        }
        return this.myDeltaGenerator;
    }

    private boolean maybeAddWithHistory(NodeBaton nodeBaton) throws SVNException {
        FSRevisionNode revNode;
        String hexDigest;
        if (nodeBaton.myCopyFromPath == null) {
            if (nodeBaton.myKind == SVNNodeKind.FILE) {
                this.myCurrentRevisionBaton.getCommitter().makeFile(nodeBaton.myPath);
            } else if (nodeBaton.myKind == SVNNodeKind.DIR) {
                this.myCurrentRevisionBaton.getCommitter().makeDir(nodeBaton.myPath);
            }
            return false;
        }
        long srcRevision = nodeBaton.myCopyFromRevision - this.myCurrentRevisionBaton.myRevisionOffset;
        Long copyFromRevision = nodeBaton.myCopyFromRevision;
        if (this.myRevisionsMap.containsKey(copyFromRevision)) {
            Long revision = (Long)this.myRevisionsMap.get(copyFromRevision);
            srcRevision = revision;
        }
        if (!SVNRevision.isValidRevisionNumber(srcRevision)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.FS_NO_SUCH_REVISION, "Relative source revision {0} is not available in current repository", (Object)srcRevision);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        FSRevisionRoot copyRoot = this.myFSFS.createRevisionRoot(srcRevision);
        if (nodeBaton.myCopySourceChecksum != null && (hexDigest = (revNode = copyRoot.getRevisionNode(nodeBaton.myCopyFromPath)).getFileMD5Checksum()) != null && !hexDigest.equals(nodeBaton.myCopySourceChecksum)) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.CHECKSUM_MISMATCH, "Copy source checksum mismatch on copy from ''{0}''@{1}\n to ''{2}'' in rev based on r{3}:\n   expected:  {4}\n     actual:  {5}\n", nodeBaton.myCopyFromPath, String.valueOf(srcRevision), nodeBaton.myPath, String.valueOf(this.myCurrentRevisionBaton.myRevision), nodeBaton.myCopySourceChecksum, hexDigest);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        this.myCurrentRevisionBaton.getCommitter().makeCopy(copyRoot, nodeBaton.myCopyFromPath, nodeBaton.myPath, true);
        return true;
    }

    private NodeBaton createNodeBaton(Map headers) throws SVNException {
        NodeBaton baton = new NodeBaton();
        baton.myKind = SVNNodeKind.UNKNOWN;
        if (headers.containsKey("Node-path")) {
            String nodePath = (String)headers.get("Node-path");
            baton.myPath = this.myParentDir != null ? SVNPathUtil.getAbsolutePath(SVNPathUtil.append(this.myParentDir, nodePath)) : SVNPathUtil.getAbsolutePath(SVNPathUtil.canonicalizePath(nodePath));
        }
        if (headers.containsKey("Node-kind")) {
            baton.myKind = SVNNodeKind.parseKind((String)headers.get("Node-kind"));
        }
        baton.myAction = -1;
        if (headers.containsKey("Node-action")) {
            String action = (String)headers.get("Node-action");
            if ("change".equals(action)) {
                baton.myAction = 0;
            } else if ("add".equals(action)) {
                baton.myAction = 1;
            } else if ("delete".equals(action)) {
                baton.myAction = 2;
            } else if ("replace".equals(action)) {
                baton.myAction = 3;
            }
        }
        baton.myCopyFromRevision = -1L;
        if (headers.containsKey("Node-copyfrom-rev")) {
            try {
                baton.myCopyFromRevision = Long.parseLong((String)headers.get("Node-copyfrom-rev"));
            }
            catch (NumberFormatException nfe) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.STREAM_MALFORMED_DATA, "Cannot parse revision ({0}) in dump file", headers.get("Node-copyfrom-rev"));
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
        }
        if (headers.containsKey("Node-copyfrom-path")) {
            String copyFromPath = (String)headers.get("Node-copyfrom-path");
            baton.myCopyFromPath = this.myParentDir != null ? SVNPathUtil.append(this.myParentDir, copyFromPath) : SVNPathUtil.canonicalizePath(copyFromPath);
            baton.myCopyFromPath = SVNPathUtil.getAbsolutePath(baton.myCopyFromPath);
        }
        if (headers.containsKey("Text-content-md5")) {
            baton.myResultChecksum = (String)headers.get("Text-content-md5");
        }
        if (headers.containsKey("Text-delta-base-md5")) {
            baton.myBaseChecksum = (String)headers.get("Text-delta-base-md5");
        }
        if (headers.containsKey("Text-copy-source-md5")) {
            baton.myCopySourceChecksum = (String)headers.get("Text-copy-source-md5");
        }
        return baton;
    }

    private Map renumberMergeInfoRevisions(SVNPropertyValue mergeInfoProp) throws SVNException {
        String mergeInfoString = SVNPropertyValue.getPropertyAsString(mergeInfoProp);
        Map<String, SVNMergeRangeList> mergeInfo = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(mergeInfoString), null);
        for (String mergeSource : mergeInfo.keySet()) {
            SVNMergeRangeList rangeList = mergeInfo.get(mergeSource);
            Object[] ranges = rangeList.getRanges();
            for (int i2 = 0; i2 < ranges.length; ++i2) {
                Object range = ranges[i2];
                Long revFromMap = (Long)this.myRevisionsMap.get(((SVNMergeRange)range).getStartRevision());
                if (revFromMap != null && SVNRevision.isValidRevisionNumber(revFromMap)) {
                    ((SVNMergeRange)range).setStartRevision(revFromMap);
                }
                if ((revFromMap = (Long)this.myRevisionsMap.get(((SVNMergeRange)range).getEndRevision())) == null || !SVNRevision.isValidRevisionNumber(revFromMap)) continue;
                ((SVNMergeRange)range).setEndRevision(revFromMap);
            }
            Arrays.sort(ranges);
        }
        return mergeInfo;
    }

    private Map prefixMergeInfoPaths(Map mergeInfo) {
        TreeMap<String, SVNMergeRangeList> prefixedMergeInfo = new TreeMap<String, SVNMergeRangeList>();
        for (String mergeSource : mergeInfo.keySet()) {
            SVNMergeRangeList rangeList = (SVNMergeRangeList)mergeInfo.get(mergeSource);
            mergeSource = mergeSource.startsWith("/") ? mergeSource.substring(1) : mergeSource;
            if ((mergeSource = SVNPathUtil.append(this.myParentDir, mergeSource)).charAt(0) != '/') {
                mergeSource = '/' + mergeSource;
            }
            prefixedMergeInfo.put(mergeSource, rangeList);
        }
        return prefixedMergeInfo;
    }

    private class NodeBaton {
        String myPath;
        SVNNodeKind myKind;
        int myAction;
        String myBaseChecksum;
        String myResultChecksum;
        String myCopySourceChecksum;
        long myCopyFromRevision;
        String myCopyFromPath;

        private NodeBaton() {
        }
    }

    private class RevisionBaton {
        FSTransactionInfo myTxn;
        FSTransactionRoot myTxnRoot;
        long myRevision;
        long myRevisionOffset;
        SVNPropertyValue myDatestamp;
        private FSCommitter myCommitter;
        private FSDeltaConsumer myDeltaConsumer;

        private RevisionBaton() {
        }

        public FSDeltaConsumer getConsumer() {
            if (this.myDeltaConsumer == null) {
                this.myDeltaConsumer = new FSDeltaConsumer("", this.myTxnRoot, DefaultLoadHandler.this.myFSFS, this.getCommitter(), null, null);
            }
            return this.myDeltaConsumer;
        }

        public FSCommitter getCommitter() {
            if (this.myCommitter == null) {
                this.myCommitter = new FSCommitter(DefaultLoadHandler.this.myFSFS, this.myTxnRoot, this.myTxn, null, null);
            }
            return this.myCommitter;
        }
    }
}

