/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNMergeInfoUtil;
import org.tmatesoft.svn.core.internal.wc.ISVNLoadHandler;
import org.tmatesoft.svn.core.internal.wc.SVNAdminHelper;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.admin.ISVNAdminEventHandler;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEvent;
import org.tmatesoft.svn.core.wc.admin.SVNAdminEventAction;
import org.tmatesoft.svn.util.SVNLogType;

public class DefaultDumpFilterHandler
implements ISVNLoadHandler {
    private boolean myIsDoRenumberRevisions;
    private boolean myIsDoExclude;
    private boolean myIsPreserveRevisionProps;
    private boolean myIsDropEmptyRevisions;
    private boolean myIsSkipMissingMergeSources;
    private long myDroppedRevisionsCount = 0L;
    private long myLastLiveRevision = -1L;
    private OutputStream myOutputStream;
    private Collection myPrefixes;
    private Map myDroppedNodes;
    private Map myRenumberHistory;
    private RevisionBaton myCurrentRevisionBaton;
    private NodeBaton myCurrentNodeBaton;
    private ISVNAdminEventHandler myEventHandler;

    public DefaultDumpFilterHandler(OutputStream os, ISVNAdminEventHandler handler, boolean exclude, boolean renumberRevisions, boolean dropEmptyRevisions, boolean preserveRevisionProperties, Collection prefixes, boolean skipMissingMergeSources) {
        this.myOutputStream = os;
        this.myEventHandler = handler;
        this.myIsDoExclude = exclude;
        this.myIsDoRenumberRevisions = renumberRevisions;
        this.myIsDropEmptyRevisions = dropEmptyRevisions;
        this.myIsPreserveRevisionProps = preserveRevisionProperties;
        this.myIsSkipMissingMergeSources = skipMissingMergeSources;
        this.myPrefixes = prefixes;
        this.myDroppedNodes = new SVNHashMap();
        this.myRenumberHistory = new SVNHashMap();
    }

    public void reset(OutputStream os, ISVNAdminEventHandler handler, boolean exclude, boolean renumberRevisions, boolean dropEmptyRevisions, boolean preserveRevisionProperties, Collection prefixes, boolean skipMissingMergeSources) {
        this.myDroppedRevisionsCount = 0L;
        this.myLastLiveRevision = -1L;
        this.myOutputStream = os;
        this.myEventHandler = handler;
        this.myIsDoExclude = exclude;
        this.myIsDoRenumberRevisions = renumberRevisions;
        this.myIsDropEmptyRevisions = dropEmptyRevisions;
        this.myIsPreserveRevisionProps = preserveRevisionProperties;
        this.myIsSkipMissingMergeSources = skipMissingMergeSources;
        this.myPrefixes = prefixes;
        this.myDroppedNodes.clear();
        this.myRenumberHistory.clear();
    }

    @Override
    public void closeNode() throws SVNException {
        if (this.myCurrentNodeBaton.myIsDoSkip) {
            return;
        }
        if (!this.myCurrentNodeBaton.myHasWritingBegun) {
            this.outputNode(this.myCurrentNodeBaton);
        }
        this.writeDumpData(this.myOutputStream, "\n\n");
    }

    @Override
    public void closeRevision() throws SVNException {
        if (this.myCurrentRevisionBaton != null && !this.myCurrentRevisionBaton.myHasWritingBegun) {
            this.outputRevision(this.myCurrentRevisionBaton);
        }
    }

    @Override
    public void openNode(Map headers) throws SVNException {
        this.myCurrentNodeBaton = new NodeBaton();
        String nodePath = (String)headers.get("Node-path");
        String copyFromPath = (String)headers.get("Node-copyfrom-path");
        if (!nodePath.startsWith("/")) {
            nodePath = "/" + nodePath;
        }
        if (copyFromPath != null && !copyFromPath.startsWith("/")) {
            copyFromPath = "/" + copyFromPath;
        }
        this.myCurrentNodeBaton.myIsDoSkip = this.skipPath(nodePath);
        if (this.myCurrentNodeBaton.myIsDoSkip) {
            this.myDroppedNodes.put(nodePath, nodePath);
            this.myCurrentRevisionBaton.myHadDroppedNodes = true;
        } else {
            long textContentLength = this.getLongFromHeaders("Text-content-length", headers);
            if (copyFromPath != null && this.skipPath(copyFromPath)) {
                SVNNodeKind kind = this.getNodeKindFromHeaders("Node-kind", headers);
                if (textContentLength >= 0L && kind == SVNNodeKind.FILE) {
                    headers.remove("Node-copyfrom-path");
                    headers.remove("Node-copyfrom-rev");
                    copyFromPath = null;
                } else {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.INCOMPLETE_DATA, "Invalid copy source path ''{0}''", (Object)copyFromPath);
                    SVNErrorManager.error(err, SVNLogType.FSFS);
                }
            }
            this.myCurrentNodeBaton.myTextContentLength = textContentLength > 0L ? textContentLength : 0L;
            this.myCurrentRevisionBaton.myHasNodes = true;
            if (!this.myCurrentRevisionBaton.myHasWritingBegun) {
                this.outputRevision(this.myCurrentRevisionBaton);
            }
            for (String header : headers.keySet()) {
                if (header.equals("Content-length") || header.equals("Prop-content-length") || header.equals("Text-content-length")) continue;
                String headerValue = (String)headers.get(header);
                if (this.myIsDoRenumberRevisions && header.equals("Node-copyfrom-rev")) {
                    long copyFromOriginalRevision = -1L;
                    try {
                        copyFromOriginalRevision = Long.parseLong(headerValue);
                    }
                    catch (NumberFormatException nfe) {
                        SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.INCOMPLETE_DATA, nfe), SVNLogType.FSFS);
                    }
                    RevisionItem reNumberedCopyFromValue = (RevisionItem)this.myRenumberHistory.get(copyFromOriginalRevision);
                    if (reNumberedCopyFromValue == null || !SVNRevision.isValidRevisionNumber(reNumberedCopyFromValue.myRevision)) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "No valid copyfrom revision in filtered stream");
                        SVNErrorManager.error(err, SVNLogType.FSFS);
                    }
                    this.writeDumpData(this.myOutputStream, "Node-copyfrom-rev: " + reNumberedCopyFromValue.myRevision + "\n");
                    continue;
                }
                this.writeDumpData(this.myOutputStream, header + ": " + headerValue + "\n");
            }
        }
    }

    @Override
    public void openRevision(Map headers) throws SVNException {
        RevisionBaton revisionBaton = new RevisionBaton();
        revisionBaton.myProperties = new SVNProperties();
        revisionBaton.myOriginalRevision = this.getLongFromHeaders("Revision-number", headers);
        revisionBaton.myActualRevision = this.myIsDoRenumberRevisions ? revisionBaton.myOriginalRevision - this.myDroppedRevisionsCount : revisionBaton.myOriginalRevision;
        revisionBaton.writeToHeader("Revision-number: " + revisionBaton.myActualRevision + "\n");
        for (String header : headers.keySet()) {
            String headerValue = (String)headers.get(header);
            if (header.equals("Content-length") || header.equals("Prop-content-length") || header.equals("Revision-number")) continue;
            revisionBaton.writeToHeader(header + ": " + headerValue + "\n");
        }
        this.myCurrentRevisionBaton = revisionBaton;
    }

    @Override
    public void parseTextBlock(InputStream dumpStream, long contentLength, boolean isDelta) throws SVNException {
        if (isDelta) {
            this.applyTextDelta();
        } else {
            this.setFullText();
        }
        byte[] buffer = null;
        if (contentLength > 0L) {
            buffer = new byte[16384];
            while (contentLength > 0L) {
                int numRead;
                int read = 0;
                for (int numToRead = contentLength > 16384L ? 16384 : (int)contentLength; numToRead > 0; numToRead -= numRead) {
                    numRead = -1;
                    try {
                        numRead = dumpStream.read(buffer, read, numToRead);
                    }
                    catch (IOException ioe) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getMessage());
                        SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
                    }
                    if (numRead < 0) {
                        SVNAdminHelper.generateIncompleteDataError();
                    }
                    read += numRead;
                }
                if (!this.myCurrentNodeBaton.myIsDoSkip) {
                    try {
                        this.myOutputStream.write(buffer, 0, read);
                    }
                    catch (IOException ioe) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.STREAM_UNEXPECTED_EOF, "Unexpected EOF writing contents");
                        SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
                    }
                }
                contentLength -= (long)read;
            }
        }
    }

    @Override
    public void parseUUID(String uuid) throws SVNException {
        this.writeDumpData(this.myOutputStream, "UUID: " + uuid + "\n\n");
    }

    @Override
    public void removeNodeProperties() throws SVNException {
        this.myCurrentNodeBaton.myHasProps = true;
    }

    @Override
    public void setFullText() throws SVNException {
        if (!this.myCurrentNodeBaton.myIsDoSkip) {
            this.myCurrentNodeBaton.myHasText = true;
            if (!this.myCurrentNodeBaton.myHasWritingBegun) {
                this.outputNode(this.myCurrentNodeBaton);
            }
        }
    }

    @Override
    public void setRevisionProperty(String propertyName, SVNPropertyValue propertyValue) throws SVNException {
        this.myCurrentRevisionBaton.myHasProps = true;
        if (propertyValue == null) {
            this.myCurrentRevisionBaton.myProperties.remove(propertyName);
        } else {
            this.myCurrentRevisionBaton.myProperties.put(propertyName, propertyValue);
        }
    }

    @Override
    public void setNodeProperty(String propertyName, SVNPropertyValue propertyValue) throws SVNException {
        if (this.myCurrentNodeBaton.myIsDoSkip) {
            return;
        }
        if (!this.myCurrentNodeBaton.myHasProps) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Delta property block detected - not supported by svndumpfilter");
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (propertyName.equals("svn:mergeinfo")) {
            Map filteredMergeInfo = this.adjustMergeInfo(propertyValue);
            propertyValue = SVNPropertyValue.create(SVNMergeInfoUtil.formatMergeInfoToString(filteredMergeInfo, null));
        }
        this.myCurrentNodeBaton.writeProperty(propertyName, propertyValue);
    }

    @Override
    public void deleteNodeProperty(String propertyName) throws SVNException {
    }

    @Override
    public void applyTextDelta() throws SVNException {
    }

    public long getDroppedRevisionsCount() {
        return this.myDroppedRevisionsCount;
    }

    public Map getRenumberHistory() {
        return this.myRenumberHistory;
    }

    public Map getDroppedNodes() {
        return this.myDroppedNodes;
    }

    private void outputRevision(RevisionBaton revisionBaton) throws SVNException {
        String message;
        revisionBaton.myHasWritingBegun = true;
        if (!this.myIsPreserveRevisionProps && !revisionBaton.myHasNodes && revisionBaton.myHadDroppedNodes && !this.myIsDropEmptyRevisions) {
            SVNProperties oldProps = revisionBaton.myProperties;
            revisionBaton.myHasProps = true;
            revisionBaton.myProperties = new SVNProperties();
            revisionBaton.myProperties.put("svn:date", oldProps.getSVNPropertyValue("svn:date"));
            revisionBaton.myProperties.put("svn:log", "This is an empty revision for padding.");
        }
        ByteArrayOutputStream propsBuffer = new ByteArrayOutputStream();
        if (revisionBaton.myHasProps) {
            for (String propName : revisionBaton.myProperties.nameSet()) {
                SVNPropertyValue propValue = revisionBaton.myProperties.getSVNPropertyValue(propName);
                this.writeProperty(propsBuffer, propName, propValue);
            }
            this.writeDumpData((OutputStream)propsBuffer, "PROPS-END\n");
            revisionBaton.writeToHeader("Prop-content-length: " + propsBuffer.size() + "\n");
        }
        revisionBaton.writeToHeader("Content-length: " + propsBuffer.size() + "\n\n");
        this.writeDumpData((OutputStream)propsBuffer, "\n");
        if (revisionBaton.myHasNodes || !this.myIsDropEmptyRevisions || !revisionBaton.myHadDroppedNodes) {
            this.writeDumpData(this.myOutputStream, revisionBaton.myHeaderBuffer.toByteArray());
            this.writeDumpData(this.myOutputStream, propsBuffer.toByteArray());
            if (this.myIsDoRenumberRevisions) {
                this.myRenumberHistory.put(revisionBaton.myOriginalRevision, new RevisionItem(revisionBaton.myActualRevision, false));
                this.myLastLiveRevision = revisionBaton.myActualRevision;
            }
            message = MessageFormat.format("Revision {0} committed as {1}.", String.valueOf(revisionBaton.myOriginalRevision), String.valueOf(revisionBaton.myActualRevision));
            this.dispatchEvent(new SVNAdminEvent(revisionBaton.myActualRevision, revisionBaton.myOriginalRevision, SVNAdminEventAction.DUMP_FILTER_REVISION_COMMITTED, message));
        } else {
            ++this.myDroppedRevisionsCount;
            if (this.myIsDoRenumberRevisions) {
                this.myRenumberHistory.put(revisionBaton.myOriginalRevision, new RevisionItem(this.myLastLiveRevision, true));
            }
            message = MessageFormat.format("Revision {0} skipped.", String.valueOf(revisionBaton.myOriginalRevision));
            this.dispatchEvent(new SVNAdminEvent(revisionBaton.myOriginalRevision, SVNAdminEventAction.DUMP_FILTER_REVISION_SKIPPED, message));
        }
    }

    private void outputNode(NodeBaton nodeBaton) throws SVNException {
        nodeBaton.myHasWritingBegun = true;
        if (nodeBaton.myHasProps) {
            nodeBaton.writeToPropertyBuffer("PROPS-END\n");
            nodeBaton.writeToHeader("Prop-content-length: " + nodeBaton.myPropertiesBuffer.size() + "\n");
        }
        if (nodeBaton.myHasText) {
            nodeBaton.writeToHeader("Text-content-length: " + nodeBaton.myTextContentLength + "\n");
        }
        nodeBaton.writeToHeader("Content-length: " + ((long)nodeBaton.myPropertiesBuffer.size() + nodeBaton.myTextContentLength) + "\n\n");
        this.writeDumpData(this.myOutputStream, nodeBaton.myHeaderBuffer.toByteArray());
        this.writeDumpData(this.myOutputStream, nodeBaton.myPropertiesBuffer.toByteArray());
    }

    private void writeProperty(OutputStream out, String propName, SVNPropertyValue propValue) throws SVNException {
        try {
            this.writeDumpData(out, "K ");
            byte[] propNameBytes = propName.getBytes("UTF-8");
            this.writeDumpData(out, String.valueOf(propNameBytes.length));
            this.writeDumpData(out, "\n");
            this.writeDumpData(out, propNameBytes);
            this.writeDumpData(out, "\n");
            this.writeDumpData(out, "V ");
            byte[] propValueBytes = SVNPropertyValue.getPropertyAsBytes(propValue);
            this.writeDumpData(out, String.valueOf(propValueBytes.length));
            this.writeDumpData(out, "\n");
            this.writeDumpData(out, propValueBytes);
            this.writeDumpData(out, "\n");
        }
        catch (IOException e) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e.getLocalizedMessage());
            SVNErrorManager.error(err, e, SVNLogType.FSFS);
        }
    }

    private Map adjustMergeInfo(SVNPropertyValue initialValue) throws SVNException {
        TreeMap<String, SVNMergeRangeList> finalMergeInfo = new TreeMap<String, SVNMergeRangeList>();
        Map<String, SVNMergeRangeList> mergeInfo = SVNMergeInfoUtil.parseMergeInfo(new StringBuffer(initialValue.getString()), null);
        for (String mergeSource : mergeInfo.keySet()) {
            SVNMergeRangeList rangeList = mergeInfo.get(mergeSource);
            if (this.skipPath(mergeSource)) {
                if (this.myIsSkipMissingMergeSources) continue;
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.INCOMPLETE_DATA, "Missing merge source path ''{0}''; try with --skip-missing-merge-sources", (Object)mergeSource);
                SVNErrorManager.error(err, SVNLogType.FSFS);
            }
            if (this.myIsDoRenumberRevisions) {
                Object[] ranges = rangeList.getRanges();
                for (int i2 = 0; i2 < rangeList.getSize(); ++i2) {
                    RevisionItem revItemEnd;
                    Object range = ranges[i2];
                    RevisionItem revItemStart = (RevisionItem)this.myRenumberHistory.get(((SVNMergeRange)range).getStartRevision());
                    if (revItemStart == null || !SVNRevision.isValidRevisionNumber(revItemStart.myRevision)) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "No valid revision range 'start' in filtered stream");
                        SVNErrorManager.error(err, SVNLogType.FSFS);
                    }
                    if ((revItemEnd = (RevisionItem)this.myRenumberHistory.get(((SVNMergeRange)range).getEndRevision())) == null || !SVNRevision.isValidRevisionNumber(revItemEnd.myRevision)) {
                        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.NODE_UNEXPECTED_KIND, "No valid revision range 'end' in filtered stream");
                        SVNErrorManager.error(err, SVNLogType.FSFS);
                    }
                    ((SVNMergeRange)range).setStartRevision(revItemStart.myRevision);
                    ((SVNMergeRange)range).setEndRevision(revItemEnd.myRevision);
                }
                Arrays.sort(ranges);
            }
            finalMergeInfo.put(mergeSource, rangeList);
        }
        return finalMergeInfo;
    }

    private SVNNodeKind getNodeKindFromHeaders(String header, Map headers) {
        return SVNNodeKind.parseKind((String)headers.get(header));
    }

    private long getLongFromHeaders(String header, Map headers) {
        String val = (String)headers.get(header);
        if (val != null) {
            try {
                return Long.parseLong(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }

    private void writeDumpData(OutputStream out, String data) throws SVNException {
        try {
            out.write(data.getBytes("UTF-8"));
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
        }
    }

    private void writeDumpData(OutputStream out, byte[] bytes) throws SVNException {
        try {
            out.write(bytes);
        }
        catch (IOException ioe) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, ioe.getLocalizedMessage());
            SVNErrorManager.error(err, ioe, SVNLogType.FSFS);
        }
    }

    private boolean skipPath(String path) {
        for (String prefix : this.myPrefixes) {
            if (!path.startsWith(prefix)) continue;
            return this.myIsDoExclude;
        }
        return !this.myIsDoExclude;
    }

    private void dispatchEvent(SVNAdminEvent event) throws SVNException {
        if (this.myEventHandler != null) {
            this.myEventHandler.handleAdminEvent(event, -1.0);
        }
    }

    private class NodeBaton {
        boolean myIsDoSkip;
        boolean myHasProps;
        boolean myHasText;
        boolean myHasWritingBegun;
        long myTextContentLength;
        ByteArrayOutputStream myPropertiesBuffer = new ByteArrayOutputStream();
        ByteArrayOutputStream myHeaderBuffer = new ByteArrayOutputStream();

        void writeProperty(String propName, SVNPropertyValue propValue) throws SVNException {
            DefaultDumpFilterHandler.this.writeProperty(this.myPropertiesBuffer, propName, propValue);
        }

        void writeToPropertyBuffer(String data) throws SVNException {
            DefaultDumpFilterHandler.this.writeDumpData(this.myPropertiesBuffer, data);
        }

        void writeToHeader(String data) throws SVNException {
            DefaultDumpFilterHandler.this.writeDumpData(this.myHeaderBuffer, data);
        }
    }

    private class RevisionBaton {
        boolean myHasNodes;
        boolean myHasProps;
        boolean myHadDroppedNodes;
        boolean myHasWritingBegun;
        long myOriginalRevision;
        long myActualRevision;
        SVNProperties myProperties;
        ByteArrayOutputStream myHeaderBuffer;

        private RevisionBaton() {
        }

        void writeToHeader(String data) throws SVNException {
            if (this.myHeaderBuffer == null) {
                this.myHeaderBuffer = new ByteArrayOutputStream();
            }
            DefaultDumpFilterHandler.this.writeDumpData(this.myHeaderBuffer, data);
        }
    }

    public class RevisionItem {
        long myRevision;
        boolean myWasDropped;

        public RevisionItem(long revision, boolean dropped) {
            this.myRevision = revision;
            this.myWasDropped = dropped;
        }

        public boolean wasDropped() {
            return this.myWasDropped;
        }

        public long getRevision() {
            return this.myRevision;
        }
    }
}

