/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Map;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tmatesoft.svn.core.internal.util.DefaultSVNDebugFormatter;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.wc.SVNFileUtil;
import org.tmatesoft.svn.util.SVNDebugLogAdapter;
import org.tmatesoft.svn.util.SVNLogType;

public class DefaultSVNDebugLogger
extends SVNDebugLogAdapter {
    private Map myLoggers = new SVNHashMap();
    private Handler myTestHandler;

    @Override
    public void log(SVNLogType logType, Throwable th, Level logLevel) {
        Logger logger = this.getLogger(logType);
        if (logger.isLoggable(logLevel) && th != null) {
            logger.log(logLevel, this.getMessage(logType, th.getMessage()), th);
        }
    }

    @Override
    public void log(SVNLogType logType, String message, Level logLevel) {
        Logger logger = this.getLogger(logType);
        if (logger.isLoggable(logLevel) && message != null) {
            logger.log(logLevel, this.getMessage(logType, message));
        }
    }

    @Override
    public void log(SVNLogType logType, String message, byte[] data) {
        Logger logger = this.getLogger(logType);
        if (logger.isLoggable(Level.FINEST)) {
            try {
                logger.log(Level.FINEST, message + "\n" + new String(data, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                logger.log(Level.FINEST, message + "\n" + new String(data));
            }
        }
    }

    @Override
    public InputStream createLogStream(SVNLogType logType, InputStream is) {
        if (this.getLogger(logType).isLoggable(Level.FINEST)) {
            return super.createLogStream(logType, is);
        }
        return is;
    }

    @Override
    public OutputStream createLogStream(SVNLogType logType, OutputStream os) {
        if (this.getLogger(logType).isLoggable(Level.FINEST)) {
            return super.createLogStream(logType, os);
        }
        return os;
    }

    private Logger getLogger(SVNLogType logType) {
        Logger logger = (Logger)this.myLoggers.get(logType);
        if (logger == null) {
            logger = Logger.getLogger(logType.getName());
            String testName = SVNFileUtil.getEnvironmentVariable("SVN_CURRENT_TEST");
            if (testName != null) {
                if (this.myTestHandler == null) {
                    try {
                        this.myTestHandler = DefaultSVNDebugLogger.createTestLogger(testName);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (this.myTestHandler != null) {
                    Handler[] existingHandlers = logger.getHandlers();
                    for (int i2 = 0; i2 < existingHandlers.length; ++i2) {
                        logger.removeHandler(existingHandlers[i2]);
                    }
                    logger.addHandler(this.myTestHandler);
                }
            }
            this.myLoggers.put(logType, logger);
        }
        return logger;
    }

    private String getMessage(SVNLogType logType, String originalMessage) {
        return logType.getShortName() + ": " + originalMessage;
    }

    private static Handler createTestLogger(String testName) throws IOException {
        URL mySource = DefaultSVNDebugLogger.class.getProtectionDomain().getCodeSource().getLocation();
        File programDir = new File(mySource.getPath()).getParentFile();
        File logFile = new File(programDir, "../logs/" + testName.trim() + ".log");
        FileHandler fileHandler = new FileHandler(logFile.getAbsolutePath(), 0, 1, true);
        fileHandler.setLevel(Level.FINEST);
        fileHandler.setFormatter(new DefaultSVNDebugFormatter());
        return fileHandler;
    }
}

