/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.svn;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sshd.common.channel.exception.SshChannelClosedException;

public class StreamLogger
implements Closeable {
    private static final Logger log = Logger.getLogger(StreamLogger.class.getName());
    private int copied;
    private Thread thread = new Thread(() -> {
        try {
            ByteArrayOutputStream buffy = null;
            if (logger.isLoggable(level)) {
                buffy = new ByteArrayOutputStream();
            }
            byte[] buf = new byte[2048];
            int emptyRead = 0;
            while (!this.thread.isInterrupted() || emptyRead < 10) {
                int length;
                if (buffy != null) {
                    buffy.reset();
                }
                while (in.available() > 0 && (length = in.read(buf)) > 0) {
                    if (buffy != null) {
                        buffy.write(buf, 0, length);
                    }
                    this.copied += length;
                    emptyRead = 0;
                }
                ++emptyRead;
                if (buffy != null && logger.isLoggable(level)) {
                    logger.log(level, "Discarded input from " + name + ": " + buffy);
                }
                Thread.sleep(100L);
            }
        }
        catch (SshChannelClosedException e) {
            logger.log(level, name + ": Channel closed " + e);
        }
        catch (IOException e) {
            logger.log(level, name + ": Failed while streaming " + e);
        }
        catch (InterruptedException e) {
            logger.log(level, name + ": Got interrupted");
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Got exception while closing the input stream", e);
            }
        }
    });

    public StreamLogger(String name, InputStream in, Logger logger, Level level) {
        this.thread.setName("Piping " + name);
        this.thread.start();
    }

    public static StreamLogger consume(InputStream errorStream) {
        return new StreamLogger("consumer", errorStream, log, Level.FINE);
    }

    @Override
    public void close() {
        if (this.thread != null) {
            if (this.thread.isAlive()) {
                this.thread.interrupt();
                try {
                    this.thread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.thread = null;
        }
    }

    public int getCopied() {
        return this.copied;
    }
}

