/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs.index;

import java.io.IOException;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.util.SVNLogType;

public class FSPackedNumbersStream {
    private static final int MAX_BYTES_PER_NUMER = 4;
    private static final int NUMBERS_BUFFER_SIZE = 1024;
    private static final int BYTES_BUFFER_SIZE = 4096;
    private final byte[] bytes;
    private final long[] numbers;
    private final int[] numbersLengths;
    private final FSFile input;
    private int bytesStart;
    private int bytesLength;
    private int numbersStart;
    private int numbersLength;
    private boolean eof;
    private long inputStartPosition;
    private long prefetchedBytesCount;

    public FSPackedNumbersStream(FSFile input) {
        this.input = input;
        this.bytes = new byte[4096];
        this.numbers = new long[1024];
        this.numbersLengths = new int[1024];
        this.bytesStart = 0;
        this.bytesLength = 0;
        this.numbersStart = 0;
        this.numbersLength = 0;
        this.eof = false;
        this.inputStartPosition = input.position();
        this.prefetchedBytesCount = 0L;
    }

    public boolean isEof() {
        return this.eof;
    }

    public long readSigned() throws SVNException {
        return this.decodeSigned(this.read());
    }

    private long decodeSigned(long value) {
        return value % 2L != 0L ? -1L - value / 2L : value / 2L;
    }

    public long read() throws SVNException {
        try {
            if (this.numbersLength == 0) {
                this.numbersStart = 0;
                if (!this.eof) {
                    this.eof = this.readNextNumbersBlock();
                }
            }
            int length = this.numbersLengths[this.numbersStart];
            long value = this.numbers[this.numbersStart];
            ++this.numbersStart;
            --this.numbersLength;
            if (this.numbersLength == 0 || this.numbersStart == this.numbers.length) {
                this.numbersStart = 0;
            }
            this.prefetchedBytesCount -= (long)length;
            return value;
        }
        catch (IOException e) {
            SVNErrorMessage errorMessage = SVNErrorMessage.create(SVNErrorCode.IO_ERROR, e);
            SVNErrorManager.error(errorMessage, SVNLogType.FSFS);
            return -1L;
        }
    }

    private boolean readNextNumbersBlock() throws IOException {
        int bytesToUnpack;
        boolean eof = false;
        do {
            int numbersToRead;
            int bytesToRead;
            int bytesRead;
            if ((bytesRead = this.input.read(this.bytes, this.bytesStart + this.bytesLength, bytesToRead = Math.min((numbersToRead = this.numbers.length - (this.numbersStart + this.numbersLength)) * 4, this.bytes.length - (this.bytesStart + this.bytesLength)))) < 0) {
                bytesRead = 0;
                eof = true;
            }
            this.prefetchedBytesCount += (long)bytesRead;
            this.bytesLength += bytesRead;
            for (bytesToUnpack = this.bytesLength; bytesToUnpack > 0 && (this.bytes[bytesToUnpack - 1] & 0x80) != 0; --bytesToUnpack) {
            }
        } while (!eof && bytesToUnpack == 0);
        int i2 = 0;
        while (i2 < bytesToUnpack && this.numbers.length != this.numbersLength) {
            byte b = this.bytes[i2];
            long value = 0L;
            int length = 0;
            if ((b & 0x80) == 0) {
                ++this.bytesStart;
                --this.bytesLength;
                ++i2;
                value = b;
                length = 1;
            } else {
                int j = i2;
                while (this.bytes[j] < 0) {
                    ++j;
                }
                int bytesProcessed = j - i2 + 1;
                if (bytesProcessed > 9) {
                    throw new RuntimeException("Packed number exceeds capacity of signed long");
                }
                value = this.bytes[j];
                while (j > i2) {
                    value <<= 7;
                    value += (long)(this.bytes[--j] & 0x7F);
                }
                length = bytesProcessed;
                i2 += bytesProcessed;
                this.bytesStart += bytesProcessed;
                this.bytesLength -= bytesProcessed;
            }
            int p = this.numbersStart + this.numbersLength;
            if (p >= this.numbers.length) {
                p -= this.numbers.length;
            }
            this.numbers[p] = value;
            this.numbersLengths[p] = length;
            ++this.numbersLength;
        }
        for (int k = 0; k < this.bytesLength; ++k) {
            this.bytes[k] = this.bytes[k + i2];
        }
        this.bytesStart = 0;
        return eof && this.numbersLength <= 0;
    }

    public void seek(long offset) {
        this.numbersStart = 0;
        this.numbersLength = 0;
        this.bytesStart = 0;
        this.bytesLength = 0;
        this.prefetchedBytesCount = 0L;
        this.input.seek(this.inputStartPosition + offset);
    }

    public long position() {
        return this.input.position() - this.inputStartPosition - this.prefetchedBytesCount;
    }
}

