/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.fs;

import java.util.ArrayList;
import java.util.Arrays;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.internal.io.fs.FSFS;
import org.tmatesoft.svn.core.internal.io.fs.FSNodeHistory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepository;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionNode;
import org.tmatesoft.svn.core.internal.io.fs.FSRevisionRoot;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNLocationEntryHandler;
import org.tmatesoft.svn.core.io.ISVNLocationSegmentHandler;
import org.tmatesoft.svn.core.io.SVNLocationEntry;
import org.tmatesoft.svn.core.io.SVNLocationSegment;
import org.tmatesoft.svn.util.SVNLogType;

public class FSLocationsFinder {
    private FSFS myFSFS;

    public FSLocationsFinder(FSFS fsfs) {
        this.myFSFS = fsfs;
    }

    public int traceNodeLocations(String path, long pegRevision, long[] revisions, ISVNLocationEntryHandler handler) throws SVNException {
        ArrayList<SVNLocationEntry> locationEntries = new ArrayList<SVNLocationEntry>(0);
        long[] locationRevs = new long[revisions.length];
        Arrays.sort(revisions);
        for (int i2 = 0; i2 < revisions.length; ++i2) {
            locationRevs[i2] = revisions[revisions.length - (i2 + 1)];
        }
        int count = 0;
        boolean isAncestor = false;
        for (count = 0; count < locationRevs.length && locationRevs[count] > pegRevision && !(isAncestor = FSNodeHistory.checkAncestryOfPegPath(path, pegRevision, locationRevs[count], this.myFSFS)); ++count) {
        }
        if (count >= locationRevs.length) {
            return 0;
        }
        long revision = isAncestor ? locationRevs[count] : pegRevision;
        FSRevisionRoot root = null;
        while (count < revisions.length) {
            long[] appearedRevision = new long[1];
            root = this.myFSFS.createRevisionRoot(revision);
            SVNLocationEntry previousLocation = root.getPreviousLocation(path, appearedRevision);
            if (previousLocation == null) break;
            String previousPath = previousLocation.getPath();
            long previousRevision = previousLocation.getRevision();
            while (count < revisions.length && locationRevs[count] >= appearedRevision[0]) {
                locationEntries.add(new SVNLocationEntry(locationRevs[count], path));
                ++count;
            }
            while (count < revisions.length && locationRevs[count] > previousRevision) {
                ++count;
            }
            path = previousPath;
            revision = previousRevision;
        }
        if (root != null && revision != root.getRevision()) {
            root = this.myFSFS.createRevisionRoot(revision);
        }
        FSRevisionNode curNode = root.getRevisionNode(path);
        while (count < revisions.length && (root = this.myFSFS.createRevisionRoot(locationRevs[count])).checkNodeKind(path) != SVNNodeKind.NONE) {
            FSRevisionNode currentNode = root.getRevisionNode(path);
            if (!curNode.getId().isRelated(currentNode.getId())) break;
            locationEntries.add(new SVNLocationEntry(locationRevs[count], path));
            ++count;
        }
        for (count = 0; count < locationEntries.size(); ++count) {
            if (handler == null) continue;
            handler.handleLocationEntry((SVNLocationEntry)locationEntries.get(count));
        }
        return count;
    }

    public long getNodeLocationSegments(String path, long pegRevision, long startRevision, long endRevision, ISVNLocationSegmentHandler handler) throws SVNException {
        SVNErrorMessage err;
        long youngestRevision = -1L;
        if (FSRepository.isInvalidRevision(pegRevision)) {
            pegRevision = youngestRevision = this.myFSFS.getYoungestRevision();
        }
        if (FSRepository.isInvalidRevision(startRevision)) {
            startRevision = FSRepository.isValidRevision(youngestRevision) ? youngestRevision : this.myFSFS.getYoungestRevision();
        }
        if (FSRepository.isInvalidRevision(endRevision)) {
            endRevision = 0L;
        }
        if (endRevision > startRevision) {
            err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "End revision {0} must be less or equal to start revision {1}", endRevision, startRevision);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (pegRevision < startRevision) {
            err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "Peg revision {0} must be greater or equal to start revision {1}", pegRevision, startRevision);
            SVNErrorManager.error(err, SVNLogType.FSFS);
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        long count = 0L;
        long currentRevision = pegRevision;
        String currentPath = path;
        long[] appearedRevision = new long[1];
        while (currentRevision >= endRevision) {
            long segmentStartRevision = endRevision;
            long segmentEndRevision = currentRevision;
            String segmentPath = currentPath;
            FSRevisionRoot root = this.myFSFS.createRevisionRoot(currentRevision);
            SVNLocationEntry previousLocation = root.getPreviousLocation(currentPath, appearedRevision);
            if (previousLocation == null) {
                segmentStartRevision = root.getNodeOriginRevision(currentPath);
                if (segmentStartRevision < endRevision) {
                    segmentStartRevision = endRevision;
                }
                currentRevision = -1L;
            } else {
                segmentStartRevision = appearedRevision[0];
                currentPath = previousLocation.getPath();
                currentRevision = previousLocation.getRevision();
            }
            count += this.maybeCropAndSendSegment(segmentStartRevision, segmentEndRevision, startRevision, endRevision, segmentPath, handler);
            if (FSRepository.isInvalidRevision(currentRevision)) break;
            if (segmentStartRevision - currentRevision <= 1L) continue;
            count += this.maybeCropAndSendSegment(currentRevision + 1L, segmentStartRevision - 1L, startRevision, endRevision, null, handler);
        }
        return count;
    }

    protected void reset(FSFS fsfs) {
        this.myFSFS = fsfs;
    }

    private long maybeCropAndSendSegment(long segmentStartRevision, long segmentEndRevision, long startRevision, long endRevision, String segmentPath, ISVNLocationSegmentHandler handler) throws SVNException {
        if (segmentStartRevision <= startRevision && segmentEndRevision >= endRevision) {
            if (segmentStartRevision < endRevision) {
                segmentStartRevision = endRevision;
            }
            if (segmentEndRevision > startRevision) {
                segmentEndRevision = startRevision;
            }
            if (handler != null) {
                handler.handleLocationSegment(new SVNLocationSegment(segmentStartRevision, segmentEndRevision, segmentPath));
            }
            return segmentEndRevision - segmentStartRevision + 1L;
        }
        return 0L;
    }
}

