/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav.http;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPStatus;

class HTTPParser {
    private static ThreadLocal<byte[]> ourLocalReadBuffer = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[8192];
        }
    };

    HTTPParser() {
    }

    public static HTTPStatus parseStatus(InputStream is, String charset) throws IOException, ParseException {
        String line = null;
        int limit = 100;
        do {
            if (limit < 0) {
                line = null;
                break;
            }
            line = HTTPParser.readLine(is, charset);
            --limit;
        } while (line != null && (line.length() == 0 || line.trim().length() == 0 || !HTTPStatus.isHTTPStatusLine(line)));
        if (line == null) {
            throw new EOFException("can not read HTTP status line");
        }
        return HTTPStatus.createHTTPStatus(line);
    }

    public static String readLine(InputStream is, String charset) throws IOException {
        int length = HTTPParser.readPlainLine(is);
        if (length <= 0) {
            return null;
        }
        byte[] buffer = ourLocalReadBuffer.get();
        if (length > 0 && buffer[length - 1] == 10 && --length > 0 && buffer[length - 1] == 13) {
            --length;
        }
        return new String(buffer, 0, length, charset);
    }

    private static int readPlainLine(InputStream is) throws IOException {
        int ch;
        int i2;
        byte[] buffer = ourLocalReadBuffer.get();
        for (i2 = 0; i2 < buffer.length && (ch = is.read()) >= 0; ++i2) {
            buffer[i2] = (byte)(ch & 0xFF);
            if (ch == 10) break;
        }
        return i2;
    }

    public static StringBuffer getCanonicalPath(String path, StringBuffer target) {
        StringBuffer stringBuffer = target = target == null ? new StringBuffer() : target;
        if (path.startsWith("http:") || path.startsWith("https:")) {
            target.append(path);
            return target;
        }
        int end = path.length() - 1;
        block3: for (int i2 = 0; i2 <= end; ++i2) {
            char ch = path.charAt(i2);
            switch (ch) {
                case '/': {
                    if (i2 == end && i2 != 0 || i2 > 0 && path.charAt(i2 - 1) == '/') continue block3;
                }
                default: {
                    target.append(ch);
                }
            }
        }
        return target;
    }
}

