/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.delta;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.zip.InflaterInputStream;
import net.jpountz.lz4.LZ4Factory;
import net.jpountz.lz4.LZ4FastDecompressor;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.internal.delta.SVNRangeTree;
import org.tmatesoft.svn.core.internal.io.fs.FSFile;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.diff.SVNDiffInstruction;
import org.tmatesoft.svn.core.io.diff.SVNDiffWindow;
import org.tmatesoft.svn.util.SVNDebugLog;
import org.tmatesoft.svn.util.SVNLogType;

public class SVNDeltaCombiner {
    private SVNDiffWindow myWindow;
    private ByteBuffer myWindowData;
    private ByteBuffer myNextWindowInstructions;
    private ByteBuffer myNextWindowData;
    private ByteBuffer myTarget;
    private ByteBuffer myRealTarget;
    private ByteBuffer myReadWindowBuffer;
    private SVNRangeTree myRangeTree = new SVNRangeTree();
    private SVNOffsetsIndex myOffsetsIndex;
    private SVNDiffInstruction[] myWindowInstructions = new SVNDiffInstruction[10];
    private SVNDiffInstruction myInstructionTemplate = new SVNDiffInstruction(0, 0, 0);

    public SVNDeltaCombiner() {
        this.myOffsetsIndex = new SVNOffsetsIndex();
        this.myNextWindowData = ByteBuffer.allocate(2048);
    }

    public void reset() {
        this.myWindow = null;
        this.myWindowData = null;
        this.myReadWindowBuffer = null;
        this.myNextWindowData = this.clearBuffer(this.myNextWindowData);
        this.myNextWindowInstructions = null;
        this.myTarget = null;
        this.myRealTarget = null;
        this.myRangeTree.dispose();
    }

    public SVNDiffWindow readWindow(FSFile file, int version) throws SVNException {
        SVNErrorMessage err;
        this.myReadWindowBuffer = this.clearBuffer(this.myReadWindowBuffer);
        this.myReadWindowBuffer = this.ensureBufferSize(this.myReadWindowBuffer, 4096);
        long position = 0L;
        try {
            position = file.position();
            file.read(this.myReadWindowBuffer);
        }
        catch (IOException e) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_CORRUPT_WINDOW);
            SVNErrorManager.error(err2, e, SVNLogType.DEFAULT);
        }
        this.myReadWindowBuffer.flip();
        long sourceOffset = this.readLongOffset(this.myReadWindowBuffer);
        int sourceLength = this.readOffset(this.myReadWindowBuffer);
        int targetLength = this.readOffset(this.myReadWindowBuffer);
        int instructionsLength = this.readOffset(this.myReadWindowBuffer);
        int dataLength = this.readOffset(this.myReadWindowBuffer);
        if (sourceOffset < 0L || sourceLength < 0 || targetLength < 0 || instructionsLength < 0 || dataLength < 0) {
            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_CORRUPT_WINDOW);
            SVNErrorManager.error(err3, SVNLogType.DEFAULT);
        }
        file.seek(position += (long)this.myReadWindowBuffer.position());
        this.myReadWindowBuffer = this.clearBuffer(this.myReadWindowBuffer);
        this.myReadWindowBuffer = this.ensureBufferSize(this.myReadWindowBuffer, instructionsLength + dataLength);
        this.myReadWindowBuffer.limit(instructionsLength + dataLength);
        try {
            file.read(this.myReadWindowBuffer);
        }
        catch (IOException e) {
            SVNDebugLog.getDefaultLog().logSevere(SVNLogType.DEFAULT, e);
            err = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_CORRUPT_WINDOW);
            SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
        }
        this.myReadWindowBuffer.position(0);
        this.myReadWindowBuffer.limit(this.myReadWindowBuffer.capacity());
        if (version == 1 || version == 2) {
            try {
                int[] lenghts = this.decompress(instructionsLength, dataLength, version);
                instructionsLength = lenghts[0];
                dataLength = lenghts[1];
            }
            catch (IOException e) {
                err = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_CORRUPT_WINDOW);
                SVNErrorManager.error(err, e, SVNLogType.DEFAULT);
            }
        }
        SVNDiffWindow window = new SVNDiffWindow(sourceOffset, sourceLength, targetLength, instructionsLength, dataLength);
        window.setData(this.myReadWindowBuffer);
        return window;
    }

    private int[] decompress(int instructionsLength, int dataLength, int version) throws IOException {
        LZ4FastDecompressor dc;
        int read;
        InflaterInputStream is;
        byte[] compressedData;
        int originalPosition = this.myReadWindowBuffer.position();
        int realInstructionsLength = this.readOffset(this.myReadWindowBuffer);
        byte[] instructionsData = new byte[realInstructionsLength];
        byte[] data = null;
        int realDataLength = 0;
        int compressedLength = instructionsLength - (this.myReadWindowBuffer.position() - originalPosition);
        if (realInstructionsLength == compressedLength) {
            System.arraycopy(this.myReadWindowBuffer.array(), this.myReadWindowBuffer.arrayOffset() + this.myReadWindowBuffer.position(), instructionsData, 0, realInstructionsLength);
            this.myReadWindowBuffer.position(this.myReadWindowBuffer.position() + realInstructionsLength);
        } else {
            compressedData = new byte[compressedLength];
            System.arraycopy(this.myReadWindowBuffer.array(), this.myReadWindowBuffer.arrayOffset() + this.myReadWindowBuffer.position(), compressedData, 0, compressedLength);
            this.myReadWindowBuffer.position(this.myReadWindowBuffer.position() + compressedLength);
            if (version == 1) {
                is = new InflaterInputStream(new ByteArrayInputStream(compressedData));
                for (read = 0; read < realInstructionsLength; read += is.read(instructionsData, read, realInstructionsLength - read)) {
                }
            } else if (version == 2) {
                dc = LZ4Factory.fastestInstance().fastDecompressor();
                dc.decompress(compressedData, 0, instructionsData, 0, realInstructionsLength);
            }
        }
        if (dataLength > 0) {
            originalPosition = this.myReadWindowBuffer.position();
            realDataLength = this.readOffset(this.myReadWindowBuffer);
            compressedLength = dataLength - (this.myReadWindowBuffer.position() - originalPosition);
            data = new byte[realDataLength];
            if (compressedLength == realDataLength) {
                System.arraycopy(this.myReadWindowBuffer.array(), this.myReadWindowBuffer.arrayOffset() + this.myReadWindowBuffer.position(), data, 0, realDataLength);
                this.myReadWindowBuffer.position(this.myReadWindowBuffer.position() + realDataLength);
            } else {
                compressedData = new byte[compressedLength];
                System.arraycopy(this.myReadWindowBuffer.array(), this.myReadWindowBuffer.arrayOffset() + this.myReadWindowBuffer.position(), compressedData, 0, compressedLength);
                this.myReadWindowBuffer.position(this.myReadWindowBuffer.position() + compressedLength);
                if (version == 1) {
                    is = new InflaterInputStream(new ByteArrayInputStream(compressedData));
                    for (read = 0; read < realDataLength; read += is.read(data, read, realDataLength - read)) {
                    }
                } else if (version == 2) {
                    dc = LZ4Factory.fastestInstance().fastDecompressor();
                    dc.decompress(compressedData, 0, data, 0, realDataLength);
                }
            }
        }
        this.myReadWindowBuffer = this.clearBuffer(this.myReadWindowBuffer);
        this.myReadWindowBuffer = this.ensureBufferSize(this.myReadWindowBuffer, realInstructionsLength + realDataLength);
        this.myReadWindowBuffer.put(instructionsData);
        if (data != null) {
            this.myReadWindowBuffer.put(data);
        }
        this.myReadWindowBuffer.position(0);
        this.myReadWindowBuffer.limit(this.myReadWindowBuffer.capacity());
        return new int[]{realInstructionsLength, realDataLength};
    }

    public void skipWindow(FSFile file) throws SVNException {
        SVNErrorMessage err;
        this.myReadWindowBuffer = this.clearBuffer(this.myReadWindowBuffer);
        this.myReadWindowBuffer = this.ensureBufferSize(this.myReadWindowBuffer, 4096);
        long position = 0L;
        try {
            position = file.position();
            file.read(this.myReadWindowBuffer);
        }
        catch (IOException e) {
            SVNErrorMessage err2 = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_CORRUPT_WINDOW);
            SVNErrorManager.error(err2, e, SVNLogType.DEFAULT);
        }
        this.myReadWindowBuffer.flip();
        if (this.readLongOffset(this.myReadWindowBuffer) < 0L) {
            err = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_CORRUPT_WINDOW);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if (this.readOffset(this.myReadWindowBuffer) < 0) {
            err = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_CORRUPT_WINDOW);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        if (this.readOffset(this.myReadWindowBuffer) < 0) {
            err = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_CORRUPT_WINDOW);
            SVNErrorManager.error(err, SVNLogType.DEFAULT);
        }
        int instructionsLength = this.readOffset(this.myReadWindowBuffer);
        int dataLength = this.readOffset(this.myReadWindowBuffer);
        if (instructionsLength < 0 || dataLength < 0) {
            SVNErrorMessage err3 = SVNErrorMessage.create(SVNErrorCode.SVNDIFF_CORRUPT_WINDOW);
            SVNErrorManager.error(err3, SVNLogType.DEFAULT);
        }
        file.seek((position += (long)this.myReadWindowBuffer.position()) + (long)dataLength + (long)instructionsLength);
        this.myReadWindowBuffer = this.clearBuffer(this.myReadWindowBuffer);
    }

    public ByteBuffer addWindow(SVNDiffWindow window) throws SVNException {
        if (window.getSourceViewLength() == 0 || !window.hasCopyFromSourceInstructions()) {
            this.myTarget = this.clearBuffer(this.myTarget);
            this.myTarget = this.ensureBufferSize(this.myTarget, window.getTargetViewLength());
            window.apply(new byte[0], this.myTarget.array());
            ByteBuffer result = null;
            if (this.myWindow != null) {
                this.myRealTarget = this.clearBuffer(this.myRealTarget);
                this.myRealTarget = this.ensureBufferSize(this.myRealTarget, this.myWindow.getTargetViewLength());
                this.myWindow.apply(this.myTarget.array(), this.myRealTarget.array());
                result = this.myRealTarget;
            } else {
                result = this.myTarget;
            }
            result.position(0);
            int tLength = this.myWindow != null ? this.myWindow.getTargetViewLength() : window.getTargetViewLength();
            result.limit(tLength);
            return result;
        }
        if (this.myWindow != null) {
            this.myWindow = this.combineWindows(window);
            return null;
        }
        this.myWindowData = this.clearBuffer(this.myWindowData);
        this.myWindowData = this.ensureBufferSize(this.myWindowData, window.getDataLength());
        this.myWindow = window.clone(this.myWindowData);
        return null;
    }

    private SVNDiffWindow combineWindows(SVNDiffWindow window) throws SVNException {
        this.myNextWindowInstructions = this.clearBuffer(this.myNextWindowInstructions);
        this.myNextWindowData = this.clearBuffer(this.myNextWindowData);
        int targetOffset = 0;
        this.myWindowInstructions = window.loadDiffInstructions(this.myWindowInstructions);
        this.createOffsetsIndex(this.myWindowInstructions, window.getInstructionsCount());
        SVNRangeTree rangeIndexTree = this.myRangeTree;
        rangeIndexTree.dispose();
        Iterator instructions = this.myWindow.instructions(true);
        while (instructions.hasNext()) {
            SVNDiffInstruction instruction = (SVNDiffInstruction)instructions.next();
            if (instruction.type != 0) {
                this.myNextWindowInstructions = this.ensureBufferSize(this.myNextWindowInstructions, 10);
                instruction.writeTo(this.myNextWindowInstructions);
                if (instruction.type == 2) {
                    this.myNextWindowData = this.ensureBufferSize(this.myNextWindowData, instruction.length);
                    this.myWindow.writeNewData(this.myNextWindowData, instruction.offset, instruction.length);
                }
            } else {
                SVNRangeTree.SVNRangeListNode listHead;
                int offset = instruction.offset;
                int limit = instruction.offset + instruction.length;
                int tgt_off = targetOffset;
                rangeIndexTree.splay(offset);
                SVNRangeTree.SVNRangeListNode listTail = rangeIndexTree.buildRangeList(offset, limit);
                SVNRangeTree.SVNRangeListNode range = listHead = listTail.head;
                while (range != null) {
                    if (range.kind == SVNRangeTree.SVNRangeListNode.FROM_TARGET) {
                        this.myInstructionTemplate.type = 1;
                        this.myInstructionTemplate.length = range.limit - range.offset;
                        this.myInstructionTemplate.offset = range.targetOffset;
                        this.myNextWindowInstructions = this.ensureBufferSize(this.myNextWindowInstructions, 10);
                        this.myInstructionTemplate.writeTo(this.myNextWindowInstructions);
                    } else {
                        this.copySourceInstructions(range.offset, range.limit, tgt_off, window, this.myWindowInstructions);
                    }
                    tgt_off += range.limit - range.offset;
                    range = range.next;
                }
                SVNErrorManager.assertionFailure(tgt_off == targetOffset + instruction.length, null, SVNLogType.DEFAULT);
                rangeIndexTree.disposeList(listHead);
                rangeIndexTree.insert(offset, limit, targetOffset);
            }
            targetOffset += instruction.length;
        }
        this.myNextWindowData.flip();
        this.myNextWindowInstructions.flip();
        int instrLength = this.myNextWindowInstructions.limit();
        int newDataLength = this.myNextWindowData.limit();
        this.myWindowData = this.clearBuffer(this.myWindowData);
        this.myWindowData = this.ensureBufferSize(this.myWindowData, instrLength + newDataLength);
        this.myWindowData.put(this.myNextWindowInstructions);
        this.myWindowData.put(this.myNextWindowData);
        this.myWindowData.position(0);
        this.myWindow = new SVNDiffWindow(window.getSourceViewOffset(), window.getSourceViewLength(), this.myWindow.getTargetViewLength(), instrLength, newDataLength);
        this.myWindow.setData(this.myWindowData);
        this.myNextWindowInstructions = this.clearBuffer(this.myNextWindowInstructions);
        this.myNextWindowData = this.clearBuffer(this.myNextWindowData);
        return this.myWindow;
    }

    private void copySourceInstructions(int offset, int limit, int targetOffset, SVNDiffWindow window, SVNDiffInstruction[] windowInsructions) throws SVNException {
        int firstInstuctionIndex = this.findInstructionIndex(this.myOffsetsIndex, offset);
        int lastInstuctionIndex = this.findInstructionIndex(this.myOffsetsIndex, limit - 1);
        for (int i2 = firstInstuctionIndex; i2 <= lastInstuctionIndex; ++i2) {
            SVNDiffInstruction instruction = windowInsructions[i2];
            int off0 = this.myOffsetsIndex.offsets[i2];
            int off1 = this.myOffsetsIndex.offsets[i2 + 1];
            int fix_offset = offset > off0 ? offset - off0 : 0;
            int fix_limit = off1 > limit ? off1 - limit : 0;
            SVNErrorManager.assertionFailure(fix_offset + fix_limit < instruction.length, null, SVNLogType.DEFAULT);
            if (instruction.type != 1) {
                int oldOffset = instruction.offset;
                int oldLength = instruction.length;
                instruction.offset += fix_offset;
                instruction.length = oldLength - fix_offset - fix_limit;
                this.myNextWindowInstructions = this.ensureBufferSize(this.myNextWindowInstructions, 10);
                instruction.writeTo(this.myNextWindowInstructions);
                if (instruction.type == 2) {
                    this.myNextWindowData = this.ensureBufferSize(this.myNextWindowData, instruction.length);
                    window.writeNewData(this.myNextWindowData, instruction.offset, instruction.length);
                }
                instruction.offset = oldOffset;
                instruction.length = oldLength;
            } else {
                SVNErrorManager.assertionFailure(instruction.offset < off0, null, SVNLogType.DEFAULT);
                if (instruction.offset + instruction.length - fix_limit <= off0) {
                    this.copySourceInstructions(instruction.offset + fix_offset, instruction.offset + instruction.length - fix_limit, targetOffset, window, windowInsructions);
                } else {
                    int length;
                    int patternLength = off0 - instruction.offset;
                    int patternOverlap = fix_offset % patternLength;
                    SVNErrorManager.assertionFailure(patternLength > patternOverlap, null, SVNLogType.DEFAULT);
                    int fix_off = fix_offset;
                    int tgt_off = targetOffset;
                    if (patternOverlap >= 0) {
                        length = Math.min(instruction.length - fix_off - fix_limit, patternLength - patternOverlap);
                        this.copySourceInstructions(instruction.offset + patternOverlap, instruction.offset + patternOverlap + length, tgt_off, window, windowInsructions);
                        tgt_off += length;
                        fix_off += length;
                    }
                    SVNErrorManager.assertionFailure(fix_off + fix_limit <= instruction.length, null, SVNLogType.DEFAULT);
                    if (patternOverlap > 0 && fix_off + fix_limit < instruction.length) {
                        length = Math.min(instruction.length - fix_off - fix_limit, patternOverlap);
                        this.copySourceInstructions(instruction.offset, instruction.offset + length, tgt_off, window, windowInsructions);
                        tgt_off += length;
                        fix_off += length;
                    }
                    SVNErrorManager.assertionFailure(fix_off + fix_limit <= instruction.length, null, SVNLogType.DEFAULT);
                    if (fix_off + fix_limit < instruction.length) {
                        this.myInstructionTemplate.type = 1;
                        this.myInstructionTemplate.length = instruction.length - fix_off - fix_limit;
                        this.myInstructionTemplate.offset = tgt_off - patternLength;
                        this.myNextWindowInstructions = this.ensureBufferSize(this.myNextWindowInstructions, 10);
                        this.myInstructionTemplate.writeTo(this.myNextWindowInstructions);
                    }
                }
            }
            targetOffset += instruction.length - fix_offset - fix_limit;
        }
    }

    private void createOffsetsIndex(SVNDiffInstruction[] instructions, int length) {
        if (this.myOffsetsIndex == null) {
            this.myOffsetsIndex = new SVNOffsetsIndex();
        }
        this.myOffsetsIndex.clear();
        int offset = 0;
        for (int i2 = 0; i2 < length; ++i2) {
            SVNDiffInstruction instruction = instructions[i2];
            this.myOffsetsIndex.addOffset(offset);
            offset += instruction.length;
        }
        this.myOffsetsIndex.addOffset(offset);
    }

    private int findInstructionIndex(SVNOffsetsIndex offsets, int offset) throws SVNException {
        int lo = 0;
        int hi = offsets.length - 1;
        int op = (lo + hi) / 2;
        SVNErrorManager.assertionFailure(offset < offsets.offsets[offsets.length - 1], null, SVNLogType.DEFAULT);
        while (lo < hi) {
            int thisOffset = offsets.offsets[op];
            int nextOffset = offsets.offsets[op + 1];
            if (offset < thisOffset) {
                hi = op;
            } else if (offset > nextOffset) {
                lo = op;
            } else {
                if (offset != nextOffset) break;
                ++op;
                break;
            }
            op = (lo + hi) / 2;
        }
        SVNErrorManager.assertionFailure(offsets.offsets[op] <= offset && offset < offsets.offsets[op + 1], null, SVNLogType.DEFAULT);
        return op;
    }

    private ByteBuffer clearBuffer(ByteBuffer b) {
        if (b != null) {
            b.clear();
        }
        return b;
    }

    private ByteBuffer ensureBufferSize(ByteBuffer buffer, int dataLength) {
        if (buffer == null || buffer.remaining() < dataLength) {
            ByteBuffer data = buffer != null ? ByteBuffer.allocate((buffer.position() + dataLength) * 3 / 2) : ByteBuffer.allocate(dataLength * 3 / 2);
            data.clear();
            if (buffer != null) {
                data.put(buffer.array(), 0, buffer.position());
            }
            buffer = data;
        }
        return buffer;
    }

    private int readOffset(ByteBuffer buffer) {
        buffer.mark();
        int offset = 0;
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            offset = offset << 7 | b & 0x7F;
            if ((b & 0x80) != 0) continue;
            return offset;
        }
        buffer.reset();
        return -1;
    }

    private long readLongOffset(ByteBuffer buffer) {
        buffer.mark();
        long offset = 0L;
        while (buffer.hasRemaining()) {
            byte b = buffer.get();
            offset = offset << 7 | (long)(b & 0x7F);
            if ((b & 0x80) != 0) continue;
            return offset;
        }
        buffer.reset();
        return -1L;
    }

    private static class SVNOffsetsIndex {
        public int length;
        public int[] offsets = new int[10];

        public void clear() {
            this.length = 0;
        }

        public void addOffset(int offset) {
            if (this.length >= this.offsets.length) {
                int[] newOffsets = new int[this.length * 3 / 2];
                System.arraycopy(this.offsets, 0, newOffsets, 0, this.length);
                this.offsets = newOffsets;
            }
            this.offsets[this.length] = offset;
            ++this.length;
        }
    }
}

