/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.db;

import java.util.List;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetDb;
import org.tmatesoft.svn.core.internal.db.SVNSqlJetStatement;
import org.tmatesoft.svn.core.wc2.SvnChecksum;

public class SVNSqlJetUnionStatement
extends SVNSqlJetStatement {
    private SVNSqlJetStatement[] statements;
    private int current = 0;

    public SVNSqlJetUnionStatement(SVNSqlJetDb sDb, SVNSqlJetStatement ... statements) {
        super(sDb);
        this.statements = statements;
    }

    @Override
    public boolean next() throws SVNException {
        if (this.statements == null) {
            return false;
        }
        boolean next = false;
        while (!next && this.current < this.statements.length) {
            SVNSqlJetStatement stmt = this.statements[this.current];
            if (stmt != null) {
                next = stmt.next();
            }
            if (next) continue;
            ++this.current;
        }
        return next;
    }

    @Override
    protected ISqlJetCursor getCursor() {
        if (this.statements == null) {
            return null;
        }
        if (this.current < this.statements.length) {
            return this.statements[this.current].getCursor();
        }
        return null;
    }

    @Override
    public void reset() throws SVNException {
        this.current = 0;
        if (this.statements == null) {
            return;
        }
        for (SVNSqlJetStatement stmt : this.statements) {
            stmt.reset();
        }
    }

    private void updateBinds() {
        if (this.statements == null) {
            return;
        }
        for (SVNSqlJetStatement stmt : this.statements) {
            List<Object> stmtBinds = stmt.getBinds();
            stmtBinds.clear();
            stmtBinds.addAll(this.getBinds());
        }
    }

    @Override
    public void bindf(String format, Object ... data) throws SVNException {
        super.bindf(format, data);
        this.updateBinds();
    }

    @Override
    public void bindLong(int i2, long v) {
        super.bindLong(i2, v);
        this.updateBinds();
    }

    @Override
    public void bindString(int i2, String string) {
        super.bindString(i2, string);
        this.updateBinds();
    }

    @Override
    public void bindNull(int i2) {
        super.bindNull(i2);
        this.updateBinds();
    }

    @Override
    public void bindBlob(int i2, byte[] serialized) {
        super.bindBlob(i2, serialized);
        this.updateBinds();
    }

    @Override
    public void bindChecksum(int i2, SvnChecksum checksum) {
        super.bindChecksum(i2, checksum);
        this.updateBinds();
    }

    @Override
    public void bindProperties(int i2, SVNProperties props) throws SVNException {
        super.bindProperties(i2, props);
        this.updateBinds();
    }
}

