/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableConstraint;
import org.tmatesoft.sqljet.core.schema.SqlJetConflictAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SqlJetTableIndexConstraint
extends SqlJetTableConstraint {
    private List<String> columns;
    private SqlJetConflictAction conflictAction;
    private String indexName;

    public SqlJetTableIndexConstraint(String name, CommonTree ast) {
        super(name);
        CommonTree columnsNode = (CommonTree)ast.getChild(0);
        assert ("columns".equalsIgnoreCase(columnsNode.getText()));
        ArrayList<String> columns = new ArrayList<String>();
        for (int i2 = 0; i2 < columnsNode.getChildCount(); ++i2) {
            CommonTree child = (CommonTree)columnsNode.getChild(i2);
            columns.add(child.getText());
        }
        this.columns = Collections.unmodifiableList(columns);
        if (ast.getChildCount() > 1) {
            CommonTree child = (CommonTree)ast.getChild(1);
            assert ("conflict".equalsIgnoreCase(child.getText()));
            assert (child.getChildCount() == 1);
            child = (CommonTree)child.getChild(0);
            this.conflictAction = SqlJetConflictAction.decode(child.getText());
        }
    }

    public List<String> getColumns() {
        return this.columns;
    }

    public SqlJetConflictAction getConflictAction() {
        return this.conflictAction;
    }

    protected abstract String getConstraintName();

    public String getIndexName() {
        return this.indexName;
    }

    void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        if (buffer.length() > 0) {
            buffer.append(' ');
        }
        buffer.append(this.getConstraintName());
        buffer.append(" (");
        for (int i2 = 0; i2 < this.getColumns().size(); ++i2) {
            if (i2 > 0) {
                buffer.append(", ");
            }
            buffer.append(this.getColumns().get(i2));
        }
        buffer.append(')');
        if (this.conflictAction != null) {
            buffer.append(" ON CONFLICT ");
            buffer.append((Object)this.conflictAction);
        }
        return buffer.toString();
    }
}

