/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.lang.SqlParser;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnDefault;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnIndexConstraint;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnPrimaryKey;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnUnique;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetSchema;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableCheck;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableConstraint;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableForeignKey;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableIndexConstraint;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTablePrimaryKey;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetTableUnique;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnConstraint;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnNotNull;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnPrimaryKey;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnUnique;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableConstraint;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableDef;
import org.tmatesoft.sqljet.core.schema.ISqlJetTablePrimaryKey;
import org.tmatesoft.sqljet.core.schema.ISqlJetTableUnique;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetTableDef
implements ISqlJetTableDef {
    private final String name;
    private final String quotedName;
    private final String databaseName;
    private final boolean temporary;
    private final boolean ifNotExists;
    private final List<ISqlJetColumnDef> columns;
    private final List<ISqlJetTableConstraint> constraints;
    private int page;
    private long rowId;
    private boolean rowIdPrimaryKey;
    private boolean autoincremented;
    private String primaryKeyIndexName;
    private String rowIdPrimaryKeyColumnName;
    private int rowIdPrimaryKeyColumnIndex = -1;
    private final List<String> primaryKeyColumns = new ArrayList<String>();
    private final Map<String, SqlJetColumnIndexConstraint> columnConstraintsIndexCache = new TreeMap<String, SqlJetColumnIndexConstraint>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, SqlJetTableIndexConstraint> tableConstrainsIndexCache = new TreeMap<String, SqlJetTableIndexConstraint>(String.CASE_INSENSITIVE_ORDER);
    private final List<ISqlJetColumnDef> notNullColumnsCache = new ArrayList<ISqlJetColumnDef>();

    SqlJetTableDef(String name, String databaseName, boolean temporary, boolean ifNotExists, List<ISqlJetColumnDef> columns, List<ISqlJetTableConstraint> constraints, int page, long rowid) throws SqlJetException {
        this.name = SqlParser.unquoteId(name);
        this.quotedName = name;
        this.databaseName = databaseName;
        this.temporary = temporary;
        this.ifNotExists = ifNotExists;
        this.columns = Collections.unmodifiableList(columns);
        this.constraints = Collections.unmodifiableList(constraints);
        this.page = page;
        this.rowId = rowid;
        this.resolveConstraints();
    }

    public SqlJetTableDef(CommonTree ast, int page) throws SqlJetException {
        CommonTree defNode;
        CommonTree optionsNode = (CommonTree)ast.getChild(0);
        this.temporary = SqlJetTableDef.hasOption(optionsNode, "temporary");
        this.ifNotExists = SqlJetTableDef.hasOption(optionsNode, "exists");
        CommonTree nameNode = (CommonTree)ast.getChild(1);
        this.name = nameNode.getText();
        this.quotedName = SqlParser.quotedId(nameNode);
        this.databaseName = nameNode.getChildCount() > 0 ? nameNode.getChild(0).getText() : null;
        ArrayList<SqlJetColumnDef> columns = new ArrayList<SqlJetColumnDef>();
        ArrayList<SqlJetTableConstraint> constraints = new ArrayList<SqlJetTableConstraint>();
        if (ast.getChildCount() > 2 && "columns".equalsIgnoreCase((defNode = (CommonTree)ast.getChild(2)).getText())) {
            for (int i2 = 0; i2 < defNode.getChildCount(); ++i2) {
                columns.add(new SqlJetColumnDef((CommonTree)defNode.getChild(i2)));
            }
            if (ast.getChildCount() > 3) {
                CommonTree constraintsNode = (CommonTree)ast.getChild(3);
                assert ("constraints".equalsIgnoreCase(constraintsNode.getText()));
                for (int i3 = 0; i3 < constraintsNode.getChildCount(); ++i3) {
                    String constraintName;
                    CommonTree constraintRootNode = (CommonTree)constraintsNode.getChild(i3);
                    assert ("table_constraint".equalsIgnoreCase(constraintRootNode.getText()));
                    CommonTree constraintNode = (CommonTree)constraintRootNode.getChild(0);
                    String constraintType = constraintNode.getText();
                    String string = constraintName = constraintRootNode.getChildCount() > 1 ? constraintRootNode.getChild(1).getText() : null;
                    if ("primary".equalsIgnoreCase(constraintType)) {
                        constraints.add(new SqlJetTablePrimaryKey(constraintName, constraintNode));
                        continue;
                    }
                    if ("unique".equalsIgnoreCase(constraintType)) {
                        constraints.add(new SqlJetTableUnique(constraintName, constraintNode));
                        continue;
                    }
                    if ("check".equalsIgnoreCase(constraintType)) {
                        constraints.add(new SqlJetTableCheck(constraintName, constraintNode));
                        continue;
                    }
                    if ("foreign".equalsIgnoreCase(constraintType)) {
                        constraints.add(new SqlJetTableForeignKey(constraintName, constraintNode));
                        continue;
                    }
                    assert (false);
                }
            }
        }
        this.columns = Collections.unmodifiableList(columns);
        this.constraints = Collections.unmodifiableList(constraints);
        this.page = page;
        this.resolveConstraints();
    }

    private void resolveConstraints() throws SqlJetException {
        int columnIndex = 0;
        int autoindexNumber = 0;
        for (ISqlJetColumnDef column : this.columns) {
            ((SqlJetColumnDef)column).setIndex(columnIndex);
            boolean notNull = false;
            for (ISqlJetColumnConstraint constraint : column.getConstraints()) {
                if (constraint instanceof ISqlJetColumnPrimaryKey) {
                    SqlJetColumnPrimaryKey pk = (SqlJetColumnPrimaryKey)constraint;
                    this.primaryKeyColumns.add(column.getName());
                    if (column.hasExactlyIntegerType()) {
                        this.rowIdPrimaryKeyColumnName = column.getName();
                        this.rowIdPrimaryKeyColumnIndex = columnIndex;
                        this.rowIdPrimaryKey = true;
                        this.autoincremented = pk.isAutoincremented();
                        continue;
                    }
                    this.primaryKeyIndexName = SqlJetTableDef.generateAutoIndexName(this.getName(), ++autoindexNumber);
                    pk.setIndexName(this.primaryKeyIndexName);
                    this.columnConstraintsIndexCache.put(pk.getIndexName(), pk);
                    continue;
                }
                if (constraint instanceof ISqlJetColumnUnique) {
                    SqlJetColumnUnique uc = (SqlJetColumnUnique)constraint;
                    uc.setIndexName(SqlJetTableDef.generateAutoIndexName(this.getName(), ++autoindexNumber));
                    this.columnConstraintsIndexCache.put(uc.getIndexName(), uc);
                    continue;
                }
                if (constraint instanceof ISqlJetColumnNotNull) {
                    notNull = true;
                    continue;
                }
                if (!(constraint instanceof SqlJetColumnDefault) || !notNull) continue;
                SqlJetColumnDefault value = (SqlJetColumnDefault)constraint;
                notNull = null == value.getExpression().getValue();
            }
            if (notNull) {
                this.notNullColumnsCache.add(column);
            }
            ++columnIndex;
        }
        for (ISqlJetTableConstraint constraint : this.constraints) {
            if (constraint instanceof ISqlJetTablePrimaryKey) {
                boolean b = false;
                SqlJetTablePrimaryKey pk = (SqlJetTablePrimaryKey)constraint;
                assert (this.primaryKeyColumns.isEmpty());
                this.primaryKeyColumns.addAll(pk.getColumns());
                if (pk.getColumns().size() == 1) {
                    String n = pk.getColumns().get(0);
                    ISqlJetColumnDef c = this.getColumn(n);
                    if (null == c) {
                        throw new SqlJetException(SqlJetErrorCode.ERROR, "Wrong column '" + n + "' in PRIMARY KEY");
                    }
                    if (c.hasExactlyIntegerType()) {
                        this.rowIdPrimaryKeyColumnName = n;
                        this.rowIdPrimaryKeyColumnIndex = this.getColumnNumber(n);
                        this.rowIdPrimaryKey = true;
                        b = true;
                    }
                }
                if (b) continue;
                this.primaryKeyIndexName = SqlJetTableDef.generateAutoIndexName(this.getName(), ++autoindexNumber);
                pk.setIndexName(this.primaryKeyIndexName);
                this.tableConstrainsIndexCache.put(pk.getIndexName(), pk);
                continue;
            }
            if (!(constraint instanceof ISqlJetTableUnique)) continue;
            SqlJetTableUnique uc = (SqlJetTableUnique)constraint;
            uc.setIndexName(SqlJetTableDef.generateAutoIndexName(this.getName(), ++autoindexNumber));
            this.tableConstrainsIndexCache.put(uc.getIndexName(), uc);
        }
    }

    private static String generateAutoIndexName(String tableName, int i2) {
        return SqlJetSchema.generateAutoIndexName(tableName, i2);
    }

    static boolean hasOption(CommonTree optionsNode, String name) {
        for (int i2 = 0; i2 < optionsNode.getChildCount(); ++i2) {
            CommonTree optionNode = (CommonTree)optionsNode.getChild(i2);
            if (!name.equalsIgnoreCase(optionNode.getText())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQuotedName() {
        return this.quotedName;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    public boolean isKeepExisting() {
        return this.ifNotExists;
    }

    @Override
    public List<ISqlJetColumnDef> getColumns() {
        return this.columns;
    }

    @Override
    public ISqlJetColumnDef getColumn(String name) {
        for (ISqlJetColumnDef column : this.getColumns()) {
            if (!column.getName().equalsIgnoreCase(name)) continue;
            return column;
        }
        return null;
    }

    @Override
    public int getColumnNumber(String name) {
        for (ISqlJetColumnDef column : this.getColumns()) {
            if (!column.getName().equalsIgnoreCase(name)) continue;
            return column.getIndex();
        }
        return -1;
    }

    @Override
    public List<ISqlJetTableConstraint> getConstraints() {
        return this.constraints;
    }

    @Override
    public boolean isRowIdPrimaryKey() {
        return this.rowIdPrimaryKey;
    }

    @Override
    public boolean isAutoincremented() {
        return this.autoincremented;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public long getRowId() {
        return this.rowId;
    }

    public void setRowId(long rowId) {
        this.rowId = rowId;
    }

    @Override
    public String getPrimaryKeyIndexName() {
        return this.primaryKeyIndexName;
    }

    public String getRowIdPrimaryKeyColumnName() {
        return this.rowIdPrimaryKeyColumnName;
    }

    public int getRowIdPrimaryKeyColumnIndex() {
        return this.rowIdPrimaryKeyColumnIndex;
    }

    public List<String> getPrimaryKeyColumnNames() {
        return this.primaryKeyColumns;
    }

    public SqlJetColumnIndexConstraint getColumnIndexConstraint(String indexName) {
        return this.columnConstraintsIndexCache.get(indexName);
    }

    public SqlJetTableIndexConstraint getTableIndexConstraint(String indexName) {
        return this.tableConstrainsIndexCache.get(indexName);
    }

    public List<ISqlJetColumnDef> getNotNullColumns() {
        return this.notNullColumnsCache;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getPage());
        buffer.append("/");
        buffer.append(this.getRowId());
        buffer.append(": ");
        buffer.append(this.toSQL(false));
        return buffer.toString();
    }

    @Override
    public String toSQL() {
        return this.toSQL(true);
    }

    public String toSQL(boolean schemaStrict) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("CREATE ");
        if (this.isTemporary()) {
            buffer.append("TEMPORARY ");
        }
        buffer.append("TABLE ");
        if (!schemaStrict) {
            if (this.isKeepExisting()) {
                buffer.append("IF NOT EXISTS ");
            }
            if (this.getDatabaseName() != null) {
                buffer.append(this.getDatabaseName());
                buffer.append('.');
            }
        }
        buffer.append(this.getQuotedName());
        buffer.append(" (");
        List<ISqlJetColumnDef> columns = this.getColumns();
        for (int i2 = 0; i2 < columns.size(); ++i2) {
            if (i2 > 0) {
                buffer.append(", ");
            }
            buffer.append(columns.get(i2).toString());
        }
        List<ISqlJetTableConstraint> constraints = this.getConstraints();
        for (int i3 = 0; i3 < constraints.size(); ++i3) {
            buffer.append(", ");
            buffer.append(constraints.get(i3).toString());
        }
        buffer.append(')');
        return buffer.toString();
    }
}

