/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetForeignKeyDeferrable;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetForeignKeyMatchAction;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetForeignKeyUpdateAction;
import org.tmatesoft.sqljet.core.schema.ISqlJetForeignKey;
import org.tmatesoft.sqljet.core.schema.ISqlJetForeignKeyAction;
import org.tmatesoft.sqljet.core.schema.ISqlJetForeignKeyDeferrable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlJetForeignKey
implements ISqlJetForeignKey {
    private final String foreignTableName;
    private final List<String> columnNames;
    private final List<ISqlJetForeignKeyAction> actions;
    private final ISqlJetForeignKeyDeferrable deferrable;

    public SqlJetForeignKey(CommonTree ast) {
        assert ("references".equalsIgnoreCase(ast.getText()));
        this.foreignTableName = ast.getChild(0).getText();
        CommonTree columnsNode = (CommonTree)ast.getChild(1);
        assert ("columns".equalsIgnoreCase(columnsNode.getText()));
        ArrayList<String> columnNames = new ArrayList<String>();
        for (int i2 = 0; i2 < columnsNode.getChildCount(); ++i2) {
            columnNames.add(columnsNode.getChild(i2).getText());
        }
        this.columnNames = Collections.unmodifiableList(columnNames);
        ArrayList<ISqlJetForeignKeyAction> actions = new ArrayList<ISqlJetForeignKeyAction>();
        SqlJetForeignKeyDeferrable deferrable = null;
        for (int i3 = 2; i3 < ast.getChildCount(); ++i3) {
            CommonTree child = (CommonTree)ast.getChild(i3);
            if ("deferrable".equalsIgnoreCase(child.getText())) {
                assert (deferrable == null);
                deferrable = new SqlJetForeignKeyDeferrable(child);
                continue;
            }
            if ("on".equalsIgnoreCase(child.getText())) {
                actions.add(new SqlJetForeignKeyUpdateAction(child));
                continue;
            }
            if ("match".equalsIgnoreCase(child.getText())) {
                actions.add(new SqlJetForeignKeyMatchAction(child));
                continue;
            }
            assert (false);
        }
        this.actions = Collections.unmodifiableList(actions);
        this.deferrable = deferrable;
    }

    @Override
    public String getForeignTableName() {
        return this.foreignTableName;
    }

    @Override
    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public List<ISqlJetForeignKeyAction> getActions() {
        return this.actions;
    }

    @Override
    public ISqlJetForeignKeyDeferrable getDeferrable() {
        return this.deferrable;
    }

    public String toString() {
        int i2;
        StringBuffer buffer = new StringBuffer("REFERENCES ");
        buffer.append(this.getForeignTableName());
        buffer.append(" (");
        for (i2 = 0; i2 < this.getColumnNames().size(); ++i2) {
            if (i2 > 0) {
                buffer.append(", ");
            }
            buffer.append(this.getColumnNames().get(i2));
        }
        buffer.append(")");
        for (i2 = 0; i2 < this.getActions().size(); ++i2) {
            buffer.append(' ');
            buffer.append(this.getActions().get(i2));
        }
        if (this.getDeferrable() != null) {
            buffer.append(' ');
            buffer.append(this.getDeferrable());
        }
        return buffer.toString();
    }
}

