/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.schema;

import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnDef;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetColumnIndexConstraint;
import org.tmatesoft.sqljet.core.schema.ISqlJetColumnPrimaryKey;
import org.tmatesoft.sqljet.core.schema.SqlJetConflictAction;

public class SqlJetColumnPrimaryKey
extends SqlJetColumnIndexConstraint
implements ISqlJetColumnPrimaryKey {
    private Boolean ascending;
    private boolean autoincremented;
    private SqlJetConflictAction conflictAction;

    public SqlJetColumnPrimaryKey(SqlJetColumnDef column, String name, CommonTree ast) {
        super(column, name);
        assert ("primary".equalsIgnoreCase(ast.getText()));
        for (int i2 = 0; i2 < ast.getChildCount(); ++i2) {
            CommonTree child = (CommonTree)ast.getChild(i2);
            if ("asc".equalsIgnoreCase(child.getText())) {
                this.ascending = Boolean.TRUE;
                continue;
            }
            if ("desc".equalsIgnoreCase(child.getText())) {
                this.ascending = Boolean.FALSE;
                continue;
            }
            if ("autoincrement".equalsIgnoreCase(child.getText())) {
                this.autoincremented = true;
                continue;
            }
            if ("conflict".equalsIgnoreCase(child.getText())) {
                assert (child.getChildCount() == 1);
                child = (CommonTree)child.getChild(0);
                this.conflictAction = SqlJetConflictAction.decode(child.getText());
                continue;
            }
            assert (false);
        }
    }

    public Boolean isAscending() {
        return this.ascending;
    }

    public boolean isAutoincremented() {
        return this.autoincremented;
    }

    public SqlJetConflictAction getConflictAction() {
        return this.conflictAction;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(super.toString());
        if (buffer.length() > 0) {
            buffer.append(' ');
        }
        buffer.append("PRIMARY KEY");
        if (this.ascending == Boolean.TRUE) {
            buffer.append(" ASC");
        }
        if (this.ascending == Boolean.FALSE) {
            buffer.append(" DESC");
        }
        if (this.conflictAction != null) {
            buffer.append(" ON CONFLICT ");
            buffer.append((Object)this.conflictAction);
        }
        if (this.autoincremented) {
            buffer.append(" AUTOINCREMENT");
        }
        return buffer.toString();
    }
}

