/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.lang;

import java.io.InputStream;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.tree.CommonTree;
import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.SqlJetValueType;
import org.tmatesoft.sqljet.core.internal.lang.SqlLexer;
import org.tmatesoft.sqljet.core.internal.lang.SqlParser;
import org.tmatesoft.sqljet.core.internal.table.SqlJetPragmasHandler;
import org.tmatesoft.sqljet.core.table.ISqlJetCursor;
import org.tmatesoft.sqljet.core.table.ISqlJetTable;
import org.tmatesoft.sqljet.core.table.SqlJetDb;

public class SqlJetPreparedStatement {
    private final SqlJetDb db;
    private final String sql;
    private CommonTree ast;
    private ISqlJetTable table;
    private ISqlJetCursor cursor;
    private Object result;

    public SqlJetPreparedStatement(SqlJetDb db, String sql) {
        this.db = db;
        this.sql = sql;
    }

    public void close() throws SqlJetException {
        if (this.table != null) {
            this.table = null;
        }
        if (this.cursor != null) {
            this.cursor.close();
            this.cursor = null;
        }
    }

    public int getParametersCount() throws SqlJetException {
        return 0;
    }

    public void setInteger(int paramIndex, long value) throws SqlJetException {
    }

    public void setFloat(int paramIndex, double value) throws SqlJetException {
    }

    public void setText(int paramIndex, String value) throws SqlJetException {
    }

    public void setBlob(int paramIndex, byte[] value) throws SqlJetException {
    }

    public void setNull(int paramIndex) throws SqlJetException {
    }

    public void setInteger(String paramName, long value) throws SqlJetException {
    }

    public void setFloat(String paramName, double value) throws SqlJetException {
    }

    public void setText(String paramName, String value) throws SqlJetException {
    }

    public void setBlob(String paramName, byte[] value) throws SqlJetException {
    }

    public void setNull(String paramName) throws SqlJetException {
    }

    public void clearBindings() throws SqlJetException {
    }

    public boolean step() throws SqlJetException {
        if (this.ast == null) {
            try {
                this.ast = this.parse();
                String stmtName = this.ast.getText();
                if ("select".equalsIgnoreCase(stmtName)) {
                    this.handleSelect();
                }
                if ("create_table".equalsIgnoreCase(stmtName)) {
                    this.db.createTable(this.sql);
                }
                if ("drop_table".equalsIgnoreCase(stmtName)) {
                    this.handleDropTable();
                }
                if ("create_index".equalsIgnoreCase(stmtName)) {
                    this.db.createIndex(this.sql);
                }
                if ("drop_index".equalsIgnoreCase(stmtName)) {
                    this.handleDropIndex();
                }
                if ("pragma".equalsIgnoreCase(stmtName)) {
                    this.result = new SqlJetPragmasHandler(this.db.getOptions()).pragma(this.ast);
                    return this.result != null;
                }
                throw new SqlJetException(SqlJetErrorCode.ERROR, "Unsupported statement.");
            }
            catch (RecognitionException e) {
                throw new SqlJetException(SqlJetErrorCode.ERROR, (Throwable)e);
            }
        } else if (this.cursor != null) {
            this.cursor.next();
        }
        if (this.cursor != null) {
            return !this.cursor.eof();
        }
        return false;
    }

    private CommonTree parse() throws SqlJetException, RecognitionException {
        ANTLRStringStream chars = new ANTLRStringStream(this.sql);
        SqlLexer lexer = new SqlLexer(chars);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        SqlParser parser = new SqlParser(tokens);
        return (CommonTree)parser.sql_stmt().getTree();
    }

    private void handleSelect() throws SqlJetException {
        CommonTree selectCore = (CommonTree)this.ast.getChild(0);
        if (!"select_core".equalsIgnoreCase(selectCore.getText())) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Compound select is not supported yet.");
        }
        int i2 = 0;
        CommonTree child = (CommonTree)selectCore.getChild(i2++);
        boolean distinct = false;
        if ("distinct".equalsIgnoreCase(child.getText())) {
            distinct = true;
            child = (CommonTree)selectCore.getChild(i2++);
        }
        if (distinct) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Distinct select modifier is not supported yet.");
        }
        assert ("columns".equalsIgnoreCase(child.getText()));
        if (child.getChildCount() != 1 && !"*".equals(child.getChild(0).getText())) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Can select only * for now.");
        }
        if (!"from".equalsIgnoreCase((child = (CommonTree)selectCore.getChild(i2++)).getText())) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Select source should be specified.");
        }
        if (!"alias".equalsIgnoreCase((child = (CommonTree)child.getChild(0)).getText())) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Compound select source is not supported yet.");
        }
        if ("select".equalsIgnoreCase((child = (CommonTree)child.getChild(0)).getText())) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Select as select source is not supported yet.");
        }
        String tableName = child.getText();
        if (selectCore.getChildCount() > i2) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Unsupported select syntax.");
        }
        this.table = this.db.getTable(tableName);
        if (this.table != null) {
            this.cursor = this.table.open();
        }
    }

    private void handleDropTable() throws SqlJetException {
        CommonTree options = (CommonTree)this.ast.getChild(0);
        boolean ifExists = options.getChildCount() > 0 && "exists".equalsIgnoreCase(options.getChild(0).getText());
        String tableName = this.ast.getChild(1).getText();
        if (this.db.getSchema().getTable(tableName) != null) {
            this.db.dropTable(tableName);
        } else if (!ifExists) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Table does not exists.");
        }
    }

    private void handleDropIndex() throws SqlJetException {
        CommonTree options = (CommonTree)this.ast.getChild(0);
        boolean ifExists = options.getChildCount() > 0 && "exists".equalsIgnoreCase(options.getChild(0).getText());
        String indexName = this.ast.getChild(1).getText();
        if (this.db.getSchema().getIndex(indexName) != null) {
            this.db.dropIndex(indexName);
        } else if (!ifExists) {
            throw new SqlJetException(SqlJetErrorCode.ERROR, "Index does not exists.");
        }
    }

    public int getColumnsCount() throws SqlJetException {
        if (this.result != null) {
            return 1;
        }
        return this.cursor.getFieldsCount();
    }

    public SqlJetValueType getColumnType(int columnIndex) throws SqlJetException {
        if (this.result instanceof String) {
            return SqlJetValueType.TEXT;
        }
        if (this.result instanceof Integer) {
            return SqlJetValueType.INTEGER;
        }
        if (this.result instanceof Double) {
            return SqlJetValueType.FLOAT;
        }
        return this.cursor.getFieldType(columnIndex);
    }

    public long getInteger(int columnIndex) throws SqlJetException {
        if (this.result instanceof Integer && columnIndex == 0) {
            return ((Integer)this.result).longValue();
        }
        return this.cursor.getInteger(columnIndex);
    }

    public double getFloat(int columnIndex) throws SqlJetException {
        if (this.result instanceof Double && columnIndex == 0) {
            return (Double)this.result;
        }
        return this.cursor.getFloat(columnIndex);
    }

    public String getText(int columnIndex) throws SqlJetException {
        if (this.result instanceof String && columnIndex == 0) {
            return (String)this.result;
        }
        return this.cursor.getString(columnIndex);
    }

    public byte[] getBlobAsArray(int columnIndex) throws SqlJetException {
        return this.cursor.getBlobAsArray(columnIndex);
    }

    public InputStream getBlobAsStream(int columnIndex) throws SqlJetException {
        return this.cursor.getBlobAsStream(columnIndex);
    }

    public boolean isNull(int columnIndex) throws SqlJetException {
        return this.cursor.isNull(columnIndex);
    }

    public void reset() throws SqlJetException {
    }
}

