/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.lang;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.lang.SqlJetConnection;
import org.tmatesoft.sqljet.core.internal.lang.SqlJetExecCallback;
import org.tmatesoft.sqljet.core.internal.lang.SqlJetPreparedStatement;
import org.tmatesoft.sqljet.core.internal.schema.SqlJetBlobLiteral;

public class SqlJetConsole
implements SqlJetExecCallback {
    private final String fileName;
    private boolean firstRow;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            SqlJetConsole.println("Exactly one database file name should be specified.");
            return;
        }
        SqlJetConnection conn = SqlJetConnection.open(args[0]);
        SqlJetConsole.println("SQLJet version 1.0");
        SqlJetConsole.println("Enter \".help\" for instructions");
        try {
            new SqlJetConsole(args[0]).repl(conn);
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            conn.close();
            throw throwable;
        }
        conn.close();
    }

    private SqlJetConsole(String fileName) {
        this.fileName = fileName;
    }

    private void repl(SqlJetConnection conn) throws Exception {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        StringBuffer buffer = new StringBuffer();
        SqlJetConsole.print("sqljet> ");
        while ((line = in.readLine()) != null) {
            buffer.append(line);
            String cmd = buffer.toString().trim();
            if (".help".equalsIgnoreCase(cmd)) {
                this.printHelp();
            } else if (".databases".equalsIgnoreCase(cmd)) {
                this.printDatabases();
            } else if (".schema".equalsIgnoreCase(cmd)) {
                this.printSchema(conn);
            } else if (".exit".equalsIgnoreCase(cmd) || ".quit".equalsIgnoreCase(cmd)) {
                System.exit(0);
            } else if (line.trim().endsWith(";")) {
                this.firstRow = true;
                try {
                    conn.exec(buffer.toString(), this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                SqlJetConsole.print("   ...> ");
                continue;
            }
            buffer.setLength(0);
            SqlJetConsole.print("sqljet> ");
        }
    }

    public void processRow(SqlJetPreparedStatement stmt) throws SqlJetException {
        int i2;
        StringBuffer buffer = new StringBuffer();
        if (this.firstRow) {
            for (i2 = 0; i2 < 80; ++i2) {
                buffer.append('-');
            }
            SqlJetConsole.println(buffer.toString());
            buffer.setLength(0);
            this.firstRow = false;
        }
        block8: for (i2 = 0; i2 < stmt.getColumnsCount(); ++i2) {
            if (i2 > 0) {
                buffer.append("|");
            }
            switch (stmt.getColumnType(i2)) {
                case INTEGER: {
                    buffer.append(stmt.getInteger(i2));
                    continue block8;
                }
                case FLOAT: {
                    buffer.append(stmt.getFloat(i2));
                    continue block8;
                }
                case TEXT: {
                    buffer.append(String.valueOf(stmt.getText(i2)));
                    continue block8;
                }
                case BLOB: {
                    buffer.append(this.asBlob(stmt.getBlobAsArray(i2)));
                    continue block8;
                }
                case NULL: {
                    buffer.append("NULL");
                }
            }
        }
        SqlJetConsole.println(buffer.toString());
    }

    private String asBlob(byte[] data) {
        if (data == null) {
            return "NULL";
        }
        return SqlJetBlobLiteral.asBlob(data);
    }

    private void printHelp() {
        SqlJetConsole.println(".databases             List names and files of attached databases");
        SqlJetConsole.println(".exit                  Exit this program");
        SqlJetConsole.println(".help                  Show this message");
        SqlJetConsole.println(".quit                  Exit this program");
        SqlJetConsole.println(".schema ?TABLE?        Show the CREATE statements");
    }

    private void printDatabases() {
        SqlJetConsole.println(this.fileName);
    }

    private void printSchema(SqlJetConnection conn) throws SqlJetException {
        SqlJetConsole.println(conn.getSchema("main").toString());
    }

    private static void print(String s) {
        System.out.print(s);
    }

    private static void println(String s) {
        System.out.println(s);
    }
}

