/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.sqljet.core.internal.btree;

import org.tmatesoft.sqljet.core.SqlJetErrorCode;
import org.tmatesoft.sqljet.core.SqlJetException;
import org.tmatesoft.sqljet.core.internal.ISqlJetConfig;
import org.tmatesoft.sqljet.core.internal.ISqlJetMemoryPointer;
import org.tmatesoft.sqljet.core.internal.ISqlJetPage;
import org.tmatesoft.sqljet.core.internal.SqlJetCloneable;
import org.tmatesoft.sqljet.core.internal.SqlJetUtility;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtree;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeCellInfo;
import org.tmatesoft.sqljet.core.internal.btree.SqlJetBtreeShared;

public class SqlJetMemPage
extends SqlJetCloneable {
    public static final byte PTF_INTKEY = 1;
    public static final byte PTF_ZERODATA = 2;
    public static final byte PTF_LEAFDATA = 4;
    public static final byte PTF_LEAF = 8;
    boolean isInit;
    int nOverflow;
    boolean intKey;
    boolean leaf;
    boolean hasData;
    byte hdrOffset;
    byte childPtrSize;
    int maxLocal;
    int minLocal;
    int cellOffset;
    int nFree;
    int nCell;
    int maskPage;
    _OvflCell[] aOvfl = new _OvflCell[]{new _OvflCell(), new _OvflCell(), new _OvflCell(), new _OvflCell(), new _OvflCell()};
    SqlJetBtreeShared pBt;
    ISqlJetMemoryPointer aData;
    ISqlJetPage pDbPage;
    int pgno;

    private boolean ISAUTOVACUUM() {
        return this.pBt.autoVacuum;
    }

    public void decodeFlags(int flagByte) throws SqlJetException {
        assert (this.hdrOffset == (this.pgno == 1 ? (byte)100 : 0));
        assert (this.pBt.mutex.held());
        this.leaf = flagByte >> 3 > 0;
        this.childPtrSize = (byte)(4 - 4 * (this.leaf ? 1 : 0));
        if ((flagByte &= 0xFFFFFFF7) == 5) {
            this.intKey = true;
            this.hasData = this.leaf;
            this.maxLocal = this.pBt.maxLeaf;
            this.minLocal = this.pBt.minLeaf;
        } else if (flagByte == 2) {
            this.intKey = false;
            this.hasData = false;
            this.maxLocal = this.pBt.maxLocal;
            this.minLocal = this.pBt.minLocal;
        } else {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
    }

    public void initPage() throws SqlJetException {
        assert (this.pBt != null);
        assert (this.pBt.mutex.held());
        assert (this.pgno == this.pDbPage.getPageNumber());
        assert (this == this.pDbPage.getExtra());
        assert (this.aData.getBuffer() == this.pDbPage.getData().getBuffer());
        if (!this.isInit) {
            int cellOffset;
            byte hdr = this.hdrOffset;
            this.decodeFlags(SqlJetUtility.getUnsignedByte(this.aData, hdr));
            assert (this.pBt.pageSize >= 512 && this.pBt.pageSize <= 32768);
            this.maskPage = this.pBt.pageSize - 1;
            this.nOverflow = 0;
            int usableSize = this.pBt.usableSize;
            this.cellOffset = cellOffset = hdr + 12 - 4 * (this.leaf ? 1 : 0);
            int top = SqlJetUtility.get2byte(this.aData, hdr + 5);
            this.nCell = SqlJetUtility.get2byte(this.aData, hdr + 3);
            if (this.nCell > this.pBt.MX_CELL()) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            int iCellFirst = cellOffset + 2 * this.nCell;
            int pc = SqlJetUtility.get2byte(this.aData, hdr + 1);
            int nFree = SqlJetUtility.getUnsignedByte(this.aData, hdr + 7) + top;
            while (pc > 0) {
                if (pc > usableSize - 4) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                int next = SqlJetUtility.get2byte(this.aData, pc);
                int size = SqlJetUtility.get2byte(this.aData, pc + 2);
                if (next > 0 && next <= pc + size + 3) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                nFree += size;
                pc = next;
            }
            if (nFree > usableSize) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            this.nFree = nFree - iCellFirst;
            this.isInit = true;
        }
    }

    public static void releasePage(SqlJetMemPage pPage) throws SqlJetException {
        if (pPage != null) {
            assert (pPage.aData != null);
            assert (pPage.pBt != null);
            assert (pPage.pDbPage.getExtra() == pPage);
            assert (pPage.pDbPage.getData().getBuffer() == pPage.aData.getBuffer());
            assert (pPage.pBt.mutex.held());
            pPage.pDbPage.unref();
        }
    }

    public void setChildPtrmaps() throws SqlJetException {
        boolean isInitOrig = this.isInit;
        assert (this.pBt.mutex.held());
        try {
            this.initPage();
            int nCell = this.nCell;
            for (int i2 = 0; i2 < nCell; ++i2) {
                ISqlJetMemoryPointer pCell = this.findCell(i2);
                this.ptrmapPutOvflPtr(pCell);
                if (this.leaf) continue;
                int childPgno = SqlJetUtility.get4byte(pCell);
                this.pBt.ptrmapPut(childPgno, (short)5, this.pgno);
            }
            if (!this.leaf) {
                int childPgno = SqlJetUtility.get4byte(this.aData, this.hdrOffset + 8);
                this.pBt.ptrmapPut(childPgno, (short)5, this.pgno);
            }
        }
        catch (SqlJetException e) {
            this.isInit = isInitOrig;
            throw e;
        }
    }

    public void modifyPagePointer(int iFrom, int iTo, short s) throws SqlJetException {
        assert (this.pBt.mutex.held());
        if (s == 4) {
            if (SqlJetUtility.get4byte(this.aData) != iFrom) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            SqlJetUtility.put4byte(this.aData, iTo);
        } else {
            int i2;
            boolean isInitOrig = this.isInit;
            this.initPage();
            int nCell = this.nCell;
            for (i2 = 0; i2 < nCell; ++i2) {
                ISqlJetMemoryPointer pCell = this.findCell(i2);
                if (s == 3) {
                    SqlJetBtreeCellInfo info = this.parseCellPtr(pCell);
                    if (info.iOverflow <= 0 || iFrom != SqlJetUtility.get4byte(pCell, info.iOverflow)) continue;
                    SqlJetUtility.put4byte(pCell, info.iOverflow, iTo);
                    break;
                }
                if (SqlJetUtility.get4byte(pCell) != iFrom) continue;
                SqlJetUtility.put4byte(pCell, iTo);
                break;
            }
            if (i2 == nCell) {
                if (s != 5 || SqlJetUtility.get4byte(this.aData, this.hdrOffset + 8) != iFrom) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                SqlJetUtility.put4byte(this.aData, this.hdrOffset + 8, iTo);
            }
            this.isInit = isInitOrig;
        }
    }

    public ISqlJetMemoryPointer findCell(int i2) {
        return SqlJetUtility.pointer(this.aData, this.maskPage & SqlJetUtility.get2byte(this.aData, this.cellOffset + 2 * i2));
    }

    public void ptrmapPutOvflPtr(ISqlJetMemoryPointer pCell) throws SqlJetException {
        assert (pCell != null);
        SqlJetBtreeCellInfo info = this.parseCellPtr(pCell);
        assert ((long)info.nData + (this.intKey ? 0L : info.nKey) == (long)info.nPayload);
        if ((long)info.nData + (this.intKey ? 0L : info.nKey) > (long)info.nLocal) {
            int ovfl = SqlJetUtility.get4byte(pCell, info.iOverflow);
            this.pBt.ptrmapPut(ovfl, (short)3, this.pgno);
        }
    }

    SqlJetBtreeCellInfo parseCellPtr(ISqlJetMemoryPointer pCell) {
        int[] nPayload = new int[1];
        assert (this.pBt.mutex.held());
        SqlJetBtreeCellInfo pInfo = new SqlJetBtreeCellInfo();
        pInfo.pCell = pCell;
        int n = this.childPtrSize;
        assert (n == 4 - 4 * (this.leaf ? 1 : 0));
        if (this.intKey) {
            if (this.hasData) {
                n += SqlJetUtility.getVarint32(pCell, n, nPayload);
            } else {
                nPayload[0] = 0;
            }
            long[] pInfo_nKey = new long[1];
            n += SqlJetUtility.getVarint(pCell, n, pInfo_nKey);
            pInfo.nKey = pInfo_nKey[0];
            pInfo.nData = nPayload[0];
        } else {
            pInfo.nData = 0;
            n += SqlJetUtility.getVarint32(pCell, n, nPayload);
            pInfo.nKey = nPayload[0];
        }
        pInfo.nPayload = nPayload[0];
        pInfo.nHeader = n;
        if (nPayload[0] <= this.maxLocal) {
            int nSize = nPayload[0] + n;
            pInfo.nLocal = nPayload[0];
            pInfo.iOverflow = 0;
            if ((nSize & 0xFFFFFFFC) == 0) {
                nSize = 4;
            }
            pInfo.nSize = nSize;
        } else {
            int minLocal = this.minLocal;
            int surplus = minLocal + (nPayload[0] - minLocal) % (this.pBt.usableSize - 4);
            int maxLocal = this.maxLocal;
            pInfo.nLocal = surplus <= maxLocal ? surplus : minLocal;
            pInfo.iOverflow = pInfo.nLocal + n;
            pInfo.nSize = pInfo.iOverflow + 4;
        }
        return pInfo;
    }

    public SqlJetBtreeCellInfo parseCell(int iCell) {
        return this.parseCellPtr(this.findCell(iCell));
    }

    void zeroPage(int flags) throws SqlJetException {
        ISqlJetMemoryPointer data = this.aData;
        byte hdr = this.hdrOffset;
        assert (this.pDbPage.getPageNumber() == this.pgno);
        assert (this.pDbPage.getExtra() == this);
        assert (this.pDbPage.getData().getBuffer() == data.getBuffer());
        assert (this.pBt.mutex.held());
        SqlJetUtility.putUnsignedByte(data, hdr, (short)flags);
        int first = hdr + 8 + 4 * ((flags & 8) == 0 ? 1 : 0);
        SqlJetUtility.put4byte(data, hdr + 1, 0L);
        SqlJetUtility.putUnsignedByte(data, hdr + 7, 0);
        SqlJetUtility.put2byte(data, hdr + 5, this.pBt.usableSize);
        this.nFree = this.pBt.usableSize - first;
        this.decodeFlags(flags);
        this.hdrOffset = hdr;
        this.cellOffset = first;
        this.nOverflow = 0;
        assert (this.pBt.pageSize >= 512 && this.pBt.pageSize <= 32768);
        this.maskPage = this.pBt.pageSize - 1;
        this.nCell = 0;
        this.isInit = true;
    }

    public void freePage() throws SqlJetException {
        SqlJetMemPage pPage1 = this.pBt.pPage1;
        assert (this.pBt.mutex.held());
        assert (this.pgno > 1);
        this.isInit = false;
        pPage1.pDbPage.write();
        int n = SqlJetUtility.get4byte(pPage1.aData, 36);
        SqlJetUtility.put4byte(pPage1.aData, 36, n + 1);
        if (ISqlJetConfig.SECURE_DELETE) {
            this.pDbPage.write();
            SqlJetUtility.memset(this.aData, (byte)0, this.pBt.pageSize);
        }
        if (this.ISAUTOVACUUM()) {
            this.pBt.ptrmapPut(this.pgno, (short)2, 0);
        }
        if (n == 0) {
            this.pDbPage.write();
            SqlJetUtility.memset(this.aData, (byte)0, 8);
            SqlJetUtility.put4byte(pPage1.aData, 32, this.pgno);
            SqlJetBtree.TRACE("FREE-PAGE: %d first\n", this.pgno);
        } else {
            SqlJetMemPage pTrunk = this.pBt.getPage(SqlJetUtility.get4byte(pPage1.aData, 32), false);
            int k = SqlJetUtility.get4byte(pTrunk.aData, 4);
            if (k >= this.pBt.usableSize / 4 - 8) {
                this.pDbPage.write();
                SqlJetUtility.put4byte(this.aData, pTrunk.pgno);
                SqlJetUtility.put4byte(this.aData, 4, 0L);
                SqlJetUtility.put4byte(pPage1.aData, 32, this.pgno);
                SqlJetBtree.TRACE("FREE-PAGE: %d new trunk page replacing %d\n", this.pgno, pTrunk.pgno);
            } else {
                if (k < 0) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                pTrunk.pDbPage.write();
                SqlJetUtility.put4byte(pTrunk.aData, 4, k + 1);
                SqlJetUtility.put4byte(pTrunk.aData, 8 + k * 4, this.pgno);
                if (ISqlJetConfig.SECURE_DELETE) {
                    this.pDbPage.dontWrite();
                }
                SqlJetBtree.TRACE("FREE-PAGE: %d leaf on trunk page %d\n", this.pgno, pTrunk.pgno);
            }
            SqlJetMemPage.releasePage(pTrunk);
        }
    }

    public void clearCell(ISqlJetMemoryPointer pCell) throws SqlJetException {
        int[] ovflPgno = new int[1];
        assert (this.pBt.mutex.held());
        SqlJetBtreeCellInfo info = this.parseCellPtr(pCell);
        if (info.iOverflow == 0) {
            return;
        }
        ovflPgno[0] = SqlJetUtility.get4byte(pCell, info.iOverflow);
        int ovflPageSize = this.pBt.usableSize - 4;
        int nOvfl = (info.nPayload - info.nLocal + ovflPageSize - 1) / ovflPageSize;
        assert (ovflPgno[0] == 0 || nOvfl > 0);
        while (nOvfl-- != 0) {
            SqlJetMemPage[] pOvfl = new SqlJetMemPage[1];
            if (ovflPgno[0] < 2 || ovflPgno[0] > this.pBt.pPager.getPageCount()) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            this.pBt.getOverflowPage(ovflPgno[0], pOvfl, nOvfl == 0 ? null : ovflPgno);
            pOvfl[0].freePage();
            pOvfl[0].pDbPage.unref();
        }
    }

    int cellSize(int iCell) {
        return this.cellSizePtr(this.findCell(iCell));
    }

    int cellSizePtr(ISqlJetMemoryPointer pCell) {
        SqlJetMemPage pPage = this;
        ISqlJetMemoryPointer pIter = pCell.getMoved(pPage.childPtrSize);
        int[] nSize = new int[]{0};
        if (pPage.intKey) {
            if (pPage.hasData) {
                pIter.movePointer(SqlJetUtility.getVarint32(pIter, nSize));
            } else {
                nSize[0] = 0;
            }
            int pEnd = pIter.getPointer() + 9;
            while (pIter.getPointer() < pEnd) {
                int b = pIter.getByteUnsigned();
                pIter.movePointer(1);
                if ((b & 0x80) != 0) continue;
                break;
            }
        } else {
            pIter.movePointer(SqlJetUtility.getVarint32(pIter, nSize));
        }
        if (nSize[0] > pPage.maxLocal) {
            int minLocal = pPage.minLocal;
            nSize[0] = minLocal + (nSize[0] - minLocal) % (pPage.pBt.usableSize - 4);
            if (nSize[0] > pPage.maxLocal) {
                nSize[0] = minLocal;
            }
            nSize[0] = nSize[0] + 4;
        }
        nSize[0] = nSize[0] + (pIter.getPointer() - pCell.getPointer());
        if (nSize[0] < 4) {
            nSize[0] = 4;
        }
        return nSize[0];
    }

    public void dropCell(int idx, int sz) throws SqlJetException {
        SqlJetMemPage pPage = this;
        assert (idx >= 0 && idx < pPage.nCell);
        assert (sz == pPage.cellSize(idx));
        assert (pPage.pBt.mutex.held());
        ISqlJetMemoryPointer data = pPage.aData;
        ISqlJetMemoryPointer ptr = SqlJetUtility.pointer(data, pPage.cellOffset + 2 * idx);
        int pc = SqlJetUtility.get2byte(ptr);
        if (pc < pPage.hdrOffset + 6 + (pPage.leaf ? 0 : 4) || pc + sz > pPage.pBt.usableSize) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        pPage.freeSpace(pc, sz);
        ISqlJetMemoryPointer endPtr = SqlJetUtility.pointer(data, pPage.cellOffset + 2 * pPage.nCell - 2);
        while (ptr.getPointer() < endPtr.getPointer()) {
            SqlJetUtility.put2byte(ptr, SqlJetUtility.get2byte(ptr, 2));
            SqlJetUtility.movePtr(ptr, 2);
        }
        --pPage.nCell;
        SqlJetUtility.put2byte(data, pPage.hdrOffset + 3, pPage.nCell);
        pPage.nFree += 2;
    }

    private void freeSpace(int start, int size) throws SqlJetException {
        int pbegin;
        SqlJetMemPage pPage = this;
        ISqlJetMemoryPointer data = pPage.aData;
        assert (pPage.pBt != null);
        assert (start >= pPage.hdrOffset + 6 + (pPage.leaf ? 0 : 4));
        assert (start + size <= pPage.pBt.usableSize);
        assert (pPage.pBt.mutex.held());
        assert (size >= 0);
        if (ISqlJetConfig.SECURE_DELETE) {
            SqlJetUtility.memset(data, start, (byte)0, size);
        }
        byte hdr = pPage.hdrOffset;
        int addr = hdr + 1;
        while ((pbegin = SqlJetUtility.get2byte(data, addr)) < start && pbegin > 0) {
            assert (pbegin <= pPage.pBt.usableSize - 4);
            if (pbegin <= addr) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            addr = pbegin;
        }
        if (pbegin > pPage.pBt.usableSize - 4) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        assert (pbegin > addr || pbegin == 0);
        SqlJetUtility.put2byte(data, addr, start);
        SqlJetUtility.put2byte(data, start, pbegin);
        SqlJetUtility.put2byte(data, start + 2, size);
        pPage.nFree += size;
        addr = pPage.hdrOffset + 1;
        while ((pbegin = SqlJetUtility.get2byte(data, addr)) > 0) {
            assert (pbegin > addr);
            assert (pbegin <= pPage.pBt.usableSize - 4);
            int pnext = SqlJetUtility.get2byte(data, pbegin);
            int psize = SqlJetUtility.get2byte(data, pbegin + 2);
            if (pbegin + psize + 3 >= pnext && pnext > 0) {
                int frag = pnext - (pbegin + psize);
                if (frag < 0 || frag > SqlJetUtility.getUnsignedByte(data, pPage.hdrOffset + 7)) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                SqlJetUtility.putUnsignedByte(data, pPage.hdrOffset + 7, (byte)(SqlJetUtility.getUnsignedByte(data, pPage.hdrOffset + 7) - (byte)frag));
                int x = SqlJetUtility.get2byte(data, pnext);
                SqlJetUtility.put2byte(data, pbegin, x);
                x = pnext + SqlJetUtility.get2byte(data, pnext + 2) - pbegin;
                SqlJetUtility.put2byte(data, pbegin + 2, x);
                continue;
            }
            addr = pbegin;
        }
        if (SqlJetUtility.getUnsignedByte(data, hdr + 1) == SqlJetUtility.getUnsignedByte(data, hdr + 5) && SqlJetUtility.getUnsignedByte(data, hdr + 2) == SqlJetUtility.getUnsignedByte(data, hdr + 6)) {
            pbegin = SqlJetUtility.get2byte(data, hdr + 1);
            SqlJetUtility.memcpy(data, hdr + 1, data, pbegin, 2);
            int top = SqlJetUtility.get2byte(data, hdr + 5) + SqlJetUtility.get2byte(data, pbegin + 2);
            SqlJetUtility.put2byte(data, hdr + 5, top);
        }
        assert (pPage.pDbPage.isWriteable());
    }

    public void insertCell(int i2, ISqlJetMemoryPointer pCell, int sz, ISqlJetMemoryPointer pTemp, int iChild) throws SqlJetException {
        int nSkip = iChild > 0 ? 4 : 0;
        SqlJetMemPage pPage = this;
        assert (i2 >= 0 && i2 <= pPage.nCell + pPage.nOverflow);
        assert (pPage.nCell <= pPage.pBt.MX_CELL() && pPage.pBt.MX_CELL() <= 5460);
        assert (pPage.nOverflow <= pPage.aOvfl.length);
        assert (sz == pPage.cellSizePtr(pCell) || sz == 8 && iChild > 0);
        assert (pPage.pBt.mutex.held());
        if (pPage.nOverflow != 0 || sz + 2 > pPage.nFree) {
            if (pTemp != null) {
                SqlJetUtility.memcpy(pTemp, nSkip, pCell, nSkip, sz - nSkip);
                pCell = pTemp;
            }
            if (iChild > 0) {
                SqlJetUtility.put4byte(pCell, iChild);
            }
            int j = pPage.nOverflow++;
            pPage.aOvfl[j].pCell = pCell;
            pPage.aOvfl[j].idx = i2;
        } else {
            pPage.pDbPage.write();
            assert (pPage.pDbPage.isWriteable());
            ISqlJetMemoryPointer data = pPage.aData;
            byte hdr = pPage.hdrOffset;
            int top = SqlJetUtility.get2byte(data, hdr + 5);
            int cellOffset = pPage.cellOffset;
            int end = cellOffset + 2 * pPage.nCell + 2;
            int ins = cellOffset + 2 * i2;
            if (end > top - sz) {
                pPage.defragmentPage();
                top = SqlJetUtility.get2byte(data, hdr + 5);
                assert (end + sz <= top);
            }
            int idx = pPage.allocateSpace(sz);
            assert (idx > 0);
            assert (end <= SqlJetUtility.get2byte(data, hdr + 5));
            if (idx + sz > pPage.pBt.usableSize) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            ++pPage.nCell;
            pPage.nFree -= 2 + sz;
            SqlJetUtility.memcpy(data, idx + nSkip, pCell, nSkip, sz - nSkip);
            if (iChild > 0) {
                SqlJetUtility.put4byte(data, idx, iChild);
            }
            for (int j = end - 2; j > ins; j -= 2) {
                SqlJetUtility.putUnsignedByte(data, j, SqlJetUtility.getUnsignedByte(data, j - 2));
                SqlJetUtility.putUnsignedByte(data, j + 1, SqlJetUtility.getUnsignedByte(data, j - 1));
            }
            SqlJetUtility.put2byte(data, ins, idx);
            SqlJetUtility.put2byte(data, hdr + 3, pPage.nCell);
            if (pPage.pBt.autoVacuum) {
                SqlJetBtreeCellInfo info = pPage.parseCellPtr(pCell);
                assert ((long)info.nData + (pPage.intKey ? 0L : info.nKey) == (long)info.nPayload);
                if ((long)info.nData + (pPage.intKey ? 0L : info.nKey) > (long)info.nLocal) {
                    int pgnoOvfl = SqlJetUtility.get4byte(pCell, info.iOverflow);
                    pPage.pBt.ptrmapPut(pgnoOvfl, (short)3, pPage.pgno);
                }
            }
        }
    }

    private int allocateSpace(int nByte) throws SqlJetException {
        SqlJetMemPage pPage = this;
        ISqlJetMemoryPointer data = pPage.aData;
        assert (pPage.pDbPage.isWriteable());
        assert (pPage.pBt != null);
        assert (pPage.pBt.mutex.held());
        assert (nByte >= 0);
        assert (pPage.nFree >= nByte);
        assert (pPage.nOverflow == 0);
        int usableSize = pPage.pBt.usableSize;
        assert (nByte < usableSize - 8);
        byte hdr = pPage.hdrOffset;
        int nFrag = SqlJetUtility.getUnsignedByte(data, hdr + 7);
        assert (pPage.cellOffset == hdr + 12 - 4 * (pPage.leaf ? 1 : 0));
        int gap = pPage.cellOffset + 2 * pPage.nCell;
        int top = SqlJetUtility.get2byte(data.getMoved(hdr + 5));
        if (gap > top) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
        if (nFrag >= 60) {
            pPage.defragmentPage();
            top = SqlJetUtility.get2byte(data.getMoved(hdr + 5));
        } else if (gap + 2 <= top) {
            int pc;
            int addr = hdr + 1;
            while ((pc = SqlJetUtility.get2byte(data, addr)) > 0) {
                if (pc > usableSize - 4 || pc < addr + 4) {
                    throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                }
                int size = SqlJetUtility.get2byte(data, pc + 2);
                if (size >= nByte) {
                    int x = size - nByte;
                    if (x < 4) {
                        SqlJetUtility.memcpy(data, addr, data, pc, 2);
                        SqlJetUtility.putUnsignedByte(data, hdr + 7, nFrag + x);
                    } else {
                        if (size + pc > usableSize) {
                            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
                        }
                        SqlJetUtility.put2byte(data, pc + 2, x);
                    }
                    return pc + x;
                }
                addr = pc;
            }
        }
        if (gap + 2 + nByte > top) {
            pPage.defragmentPage();
            top = SqlJetUtility.get2byte(data, hdr + 5);
            assert (gap + nByte <= top);
        }
        SqlJetUtility.put2byte(data, hdr + 5, top -= nByte);
        assert (top + nByte <= pPage.pBt.usableSize);
        return top;
    }

    private void defragmentPage() throws SqlJetException {
        SqlJetMemPage pPage = this;
        assert (pPage.pDbPage.isWriteable());
        assert (pPage.pBt != null);
        assert (pPage.pBt.usableSize <= 32768);
        assert (pPage.nOverflow == 0);
        assert (pPage.pBt.mutex.held());
        ISqlJetMemoryPointer temp = pPage.pBt.pPager.getTempSpace();
        ISqlJetMemoryPointer data = pPage.aData;
        byte hdr = pPage.hdrOffset;
        int cellOffset = pPage.cellOffset;
        int nCell = pPage.nCell;
        assert (nCell == SqlJetUtility.get2byte(data, hdr + 3));
        int usableSize = pPage.pBt.usableSize;
        int cbrk = SqlJetUtility.get2byte(data, hdr + 5);
        SqlJetUtility.memcpy(temp, cbrk, data, cbrk, usableSize - cbrk);
        cbrk = usableSize;
        int iCellFirst = cellOffset + 2 * nCell;
        int iCellLast = usableSize - 4;
        for (int i2 = 0; i2 < nCell; ++i2) {
            ISqlJetMemoryPointer pAddr = data.getBuffer().getPointer(cellOffset + i2 * 2);
            int pc = SqlJetUtility.get2byte(pAddr);
            if (pc < iCellFirst || pc > iCellLast) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            assert (pc >= iCellFirst && pc <= iCellLast);
            int size = pPage.cellSizePtr(temp.getBuffer().getPointer(pc));
            if ((cbrk -= size) < iCellFirst || pc + size > usableSize) {
                throw new SqlJetException(SqlJetErrorCode.CORRUPT);
            }
            assert (cbrk + size <= usableSize && cbrk >= iCellFirst);
            SqlJetUtility.memcpy(data, cbrk, temp, pc, size);
            SqlJetUtility.put2byte(pAddr, cbrk);
        }
        assert (cbrk >= iCellFirst);
        SqlJetUtility.put2byte(data, hdr + 5, cbrk);
        SqlJetUtility.putUnsignedByte(data, hdr + 1, 0);
        SqlJetUtility.putUnsignedByte(data, hdr + 2, 0);
        SqlJetUtility.putUnsignedByte(data, hdr + 7, 0);
        SqlJetUtility.memset(data, iCellFirst, (byte)0, cbrk - iCellFirst);
        assert (pPage.pDbPage.isWriteable());
        if (cbrk - iCellFirst != pPage.nFree) {
            throw new SqlJetException(SqlJetErrorCode.CORRUPT);
        }
    }

    public ISqlJetMemoryPointer findOverflowCell(int iCell) {
        SqlJetMemPage pPage = this;
        assert (pPage.pBt.mutex.held());
        for (int i2 = pPage.nOverflow - 1; i2 >= 0; --i2) {
            _OvflCell pOvfl = pPage.aOvfl[i2];
            int k = pOvfl.idx;
            if (k > iCell) continue;
            if (k == iCell) {
                return pOvfl.pCell;
            }
            --iCell;
        }
        return pPage.findCell(iCell);
    }

    public void assemblePage(int nCell, ISqlJetMemoryPointer[] apCell, int apCellPos, int[] aSize, int aSizePos) throws SqlJetException {
        SqlJetMemPage pPage = this;
        byte hdr = pPage.hdrOffset;
        ISqlJetMemoryPointer data = pPage.aData;
        int nUsable = pPage.pBt.usableSize;
        assert (pPage.nOverflow == 0);
        assert (pPage.pBt.mutex.held());
        assert (nCell >= 0 && nCell <= pPage.pBt.MX_CELL() && pPage.pBt.MX_CELL() <= 10921);
        assert (pPage.pDbPage.isWriteable());
        assert (pPage.nCell == 0);
        assert (SqlJetUtility.get2byte(data.getMoved(hdr + 5)) == nUsable);
        ISqlJetMemoryPointer pCellPtr = data.getMoved(pPage.cellOffset + nCell * 2);
        int cellbody = nUsable;
        for (int i2 = nCell - 1; i2 >= 0; --i2) {
            int sz = aSize[apCellPos + i2];
            pCellPtr = pCellPtr.getMoved(-2);
            SqlJetUtility.put2byte(pCellPtr, cellbody -= sz);
            SqlJetUtility.memcpy(data.getMoved(cellbody), apCell[apCellPos + i2], sz);
        }
        SqlJetUtility.put2byte(data.getMoved(hdr + 3), nCell);
        SqlJetUtility.put2byte(data.getMoved(hdr + 5), cellbody);
        pPage.nFree -= 2 * nCell + pPage.pBt.usableSize - cellbody;
        pPage.nCell = nCell;
    }

    public void assertParentIndex(int iIdx, int iChild) {
        SqlJetMemPage pParent = this;
        assert (iIdx <= pParent.nCell);
        if (iIdx == pParent.nCell ? !$assertionsDisabled && SqlJetUtility.get4byte(pParent.aData, pParent.hdrOffset + 8) != iChild : !$assertionsDisabled && SqlJetUtility.get4byte(pParent.findCell(iIdx)) != iChild) {
            throw new AssertionError();
        }
    }

    public int fillInCell(ISqlJetMemoryPointer pCell, ISqlJetMemoryPointer pKey, long nKey, ISqlJetMemoryPointer pData, int nData, int nZero) throws SqlJetException {
        int nSrc;
        ISqlJetMemoryPointer pSrc;
        SqlJetMemPage pPage = this;
        int pnSize = 0;
        SqlJetMemPage pOvfl = null;
        SqlJetMemPage pToRelease = null;
        SqlJetBtreeShared pBt = pPage.pBt;
        int[] pgnoOvfl = new int[]{0};
        assert (pPage.pBt.mutex.held());
        assert (pCell.getBuffer() != pPage.aData.getBuffer() || pPage.pDbPage.isWriteable());
        int nHeader = 0;
        if (!pPage.leaf) {
            nHeader += 4;
        }
        if (pPage.hasData) {
            nHeader += SqlJetUtility.putVarint(SqlJetUtility.pointer(pCell, nHeader), nData + nZero);
        } else {
            nZero = 0;
            nData = 0;
        }
        nHeader += SqlJetUtility.putVarint(SqlJetUtility.pointer(pCell, nHeader), nKey);
        SqlJetBtreeCellInfo info = pPage.parseCellPtr(pCell);
        assert (info.nHeader == nHeader);
        assert (info.nKey == nKey);
        assert (info.nData == nData + nZero);
        int nPayload = nData + nZero;
        if (pPage.intKey) {
            pSrc = pData;
            nSrc = nData;
            nData = 0;
        } else {
            nPayload += (int)nKey;
            pSrc = pKey;
            nSrc = (int)nKey;
        }
        pnSize = info.nSize;
        int spaceLeft = info.nLocal;
        ISqlJetMemoryPointer pPayload = SqlJetUtility.pointer(pCell, nHeader);
        ISqlJetMemoryPointer pPrior = SqlJetUtility.pointer(pCell, info.iOverflow);
        while (nPayload > 0) {
            int n;
            if (spaceLeft == 0) {
                int pgnoPtrmap = pgnoOvfl[0];
                if (pBt.autoVacuum) {
                    do {
                        pgnoOvfl[0] = pgnoOvfl[0] + 1;
                    } while (pBt.PTRMAP_ISPAGE(pgnoOvfl[0]) || pgnoOvfl[0] == pBt.PENDING_BYTE_PAGE());
                }
                try {
                    pOvfl = pBt.allocatePage(pgnoOvfl, pgnoOvfl[0], false);
                    if (pBt.autoVacuum) {
                        int eType = pgnoPtrmap != 0 ? 4 : 3;
                        try {
                            pBt.ptrmapPut(pgnoOvfl[0], (short)eType, pgnoPtrmap);
                        }
                        catch (SqlJetException e) {
                            SqlJetMemPage.releasePage(pOvfl);
                        }
                    }
                }
                catch (SqlJetException e) {
                    SqlJetMemPage.releasePage(pToRelease);
                    throw e;
                }
                assert (pToRelease == null || pToRelease.pDbPage.isWriteable());
                assert (pPrior.getBuffer() != pPage.aData.getBuffer() || pPage.pDbPage.isWriteable());
                SqlJetUtility.put4byte(pPrior, pgnoOvfl[0]);
                SqlJetMemPage.releasePage(pToRelease);
                pToRelease = pOvfl;
                pPrior = pOvfl.aData;
                SqlJetUtility.put4byte(pPrior, 0L);
                pPayload = SqlJetUtility.pointer(pOvfl.aData, 4);
                spaceLeft = pBt.usableSize - 4;
            }
            if ((n = nPayload) > spaceLeft) {
                n = spaceLeft;
            }
            assert (pToRelease == null || pToRelease.pDbPage.isWriteable());
            assert (pPayload.getBuffer() != pPage.aData.getBuffer() || pPage.pDbPage.isWriteable());
            if (nSrc > 0) {
                if (n > nSrc) {
                    n = nSrc;
                }
                assert (pSrc != null);
                SqlJetUtility.memcpy(pPayload, pSrc, n);
            } else {
                SqlJetUtility.memset(pPayload, (byte)0, n);
            }
            nPayload -= n;
            SqlJetUtility.movePtr(pPayload, n);
            pSrc = SqlJetUtility.pointer(pSrc, n);
            spaceLeft -= n;
            if ((nSrc -= n) != 0) continue;
            nSrc = nData;
            pSrc = pData;
        }
        SqlJetMemPage.releasePage(pToRelease);
        return pnSize;
    }

    public void ptrmapPutOvfl(int iCell) throws SqlJetException {
        SqlJetMemPage pPage = this;
        assert (pPage.pBt.mutex.held());
        ISqlJetMemoryPointer pCell = pPage.findOverflowCell(iCell);
        pPage.ptrmapPutOvflPtr(pCell);
    }

    public void copyNodeContent(SqlJetMemPage pTo) throws SqlJetException {
        int iToHdr;
        SqlJetMemPage pFrom = this;
        SqlJetBtreeShared pBt = pFrom.pBt;
        ISqlJetMemoryPointer aFrom = pFrom.aData;
        ISqlJetMemoryPointer aTo = pTo.aData;
        byte iFromHdr = pFrom.hdrOffset;
        int n = iToHdr = pTo.pgno == 1 ? 100 : 0;
        assert (pFrom.isInit);
        assert (pFrom.nFree >= iToHdr);
        assert (SqlJetUtility.get2byte(aFrom.getMoved(iFromHdr + 5)) <= pBt.usableSize);
        int iData = SqlJetUtility.get2byte(aFrom.getMoved(iFromHdr + 5));
        SqlJetUtility.memcpy(aTo.getMoved(iData), aFrom.getMoved(iData), pBt.usableSize - iData);
        SqlJetUtility.memcpy(aTo.getMoved(iToHdr), aFrom.getMoved(iFromHdr), pFrom.cellOffset + 2 * pFrom.nCell);
        pTo.isInit = false;
        pTo.initPage();
        if (this.ISAUTOVACUUM()) {
            pTo.setChildPtrmaps();
        }
    }

    public Object clone() throws CloneNotSupportedException {
        SqlJetMemPage clone = (SqlJetMemPage)super.clone();
        clone.aData = SqlJetUtility.allocatePtr(clone.pBt.pageSize);
        clone.aOvfl = (_OvflCell[])this.aOvfl.clone();
        for (int i2 = 0; i2 < this.aOvfl.length; ++i2) {
            clone.aOvfl[i2] = (_OvflCell)this.aOvfl[i2].clone();
        }
        return clone;
    }

    static class _OvflCell
    extends SqlJetCloneable {
        ISqlJetMemoryPointer pCell;
        int idx;

        _OvflCell() {
        }
    }
}

