/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation;

import org.jspecify.annotations.Nullable;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.validation.AbstractPropertyBindingResult;

public class DirectFieldBindingResult
extends AbstractPropertyBindingResult {
    private final @Nullable Object target;
    private final boolean autoGrowNestedPaths;
    private transient @Nullable ConfigurablePropertyAccessor directFieldAccessor;

    public DirectFieldBindingResult(@Nullable Object target, String objectName) {
        this(target, objectName, true);
    }

    public DirectFieldBindingResult(@Nullable Object target, String objectName, boolean autoGrowNestedPaths) {
        super(objectName);
        this.target = target;
        this.autoGrowNestedPaths = autoGrowNestedPaths;
    }

    @Override
    public final @Nullable Object getTarget() {
        return this.target;
    }

    @Override
    public final ConfigurablePropertyAccessor getPropertyAccessor() {
        if (this.directFieldAccessor == null) {
            this.directFieldAccessor = this.createDirectFieldAccessor();
            this.directFieldAccessor.setExtractOldValueForEditor(true);
            this.directFieldAccessor.setAutoGrowNestedPaths(this.autoGrowNestedPaths);
        }
        return this.directFieldAccessor;
    }

    protected ConfigurablePropertyAccessor createDirectFieldAccessor() {
        if (this.target == null) {
            throw new IllegalStateException("Cannot access fields on null target instance '" + this.getObjectName() + "'");
        }
        return PropertyAccessorFactory.forDirectFieldAccess(this.target);
    }
}

