/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting.groovy;

import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Script;
import java.io.IOException;
import java.lang.reflect.InaccessibleObjectException;
import java.lang.reflect.InvocationTargetException;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.scripting.ScriptCompilationException;
import org.springframework.scripting.ScriptFactory;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.groovy.GroovyObjectCustomizer;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public class GroovyScriptFactory
implements ScriptFactory,
BeanFactoryAware,
BeanClassLoaderAware {
    private final String scriptSourceLocator;
    private @Nullable GroovyObjectCustomizer groovyObjectCustomizer;
    private @Nullable CompilerConfiguration compilerConfiguration;
    private @Nullable GroovyClassLoader groovyClassLoader;
    private @Nullable Class<?> scriptClass;
    private @Nullable Class<?> scriptResultClass;
    private @Nullable CachedResultHolder cachedResult;
    private final Object scriptClassMonitor = new Object();
    private boolean wasModifiedForTypeCheck = false;

    public GroovyScriptFactory(String scriptSourceLocator) {
        Assert.hasText(scriptSourceLocator, "'scriptSourceLocator' must not be empty");
        this.scriptSourceLocator = scriptSourceLocator;
    }

    public GroovyScriptFactory(String scriptSourceLocator, @Nullable GroovyObjectCustomizer groovyObjectCustomizer) {
        this(scriptSourceLocator);
        this.groovyObjectCustomizer = groovyObjectCustomizer;
    }

    public GroovyScriptFactory(String scriptSourceLocator, @Nullable CompilerConfiguration compilerConfiguration) {
        this(scriptSourceLocator);
        this.compilerConfiguration = compilerConfiguration;
    }

    public GroovyScriptFactory(String scriptSourceLocator, CompilationCustomizer ... compilationCustomizers) {
        this(scriptSourceLocator);
        if (!ObjectUtils.isEmpty(compilationCustomizers)) {
            this.compilerConfiguration = new CompilerConfiguration();
            this.compilerConfiguration.addCompilationCustomizers(compilationCustomizers);
        }
    }

    @Override
    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            ConfigurableListableBeanFactory clbf = (ConfigurableListableBeanFactory)beanFactory;
            clbf.ignoreDependencyType(MetaClass.class);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        if (classLoader instanceof GroovyClassLoader) {
            GroovyClassLoader gcl = (GroovyClassLoader)classLoader;
            if (this.compilerConfiguration == null || gcl.hasCompatibleConfiguration(this.compilerConfiguration)) {
                this.groovyClassLoader = gcl;
                return;
            }
        }
        this.groovyClassLoader = this.buildGroovyClassLoader(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GroovyClassLoader getGroovyClassLoader() {
        Object object = this.scriptClassMonitor;
        synchronized (object) {
            if (this.groovyClassLoader == null) {
                this.groovyClassLoader = this.buildGroovyClassLoader(ClassUtils.getDefaultClassLoader());
            }
            return this.groovyClassLoader;
        }
    }

    protected GroovyClassLoader buildGroovyClassLoader(@Nullable ClassLoader classLoader) {
        return this.compilerConfiguration != null ? new GroovyClassLoader(classLoader, this.compilerConfiguration) : new GroovyClassLoader(classLoader);
    }

    @Override
    public String getScriptSourceLocator() {
        return this.scriptSourceLocator;
    }

    @Override
    public Class<?> @Nullable [] getScriptInterfaces() {
        return null;
    }

    @Override
    public boolean requiresConfigInterface() {
        return false;
    }

    @Override
    public @Nullable Object getScriptedObject(ScriptSource scriptSource, Class<?> ... actualInterfaces) throws IOException, ScriptCompilationException {
        Object object = this.scriptClassMonitor;
        synchronized (object) {
            try {
                this.wasModifiedForTypeCheck = false;
                if (this.cachedResult != null) {
                    Object result = this.cachedResult.object;
                    this.cachedResult = null;
                    return result;
                }
                if (this.scriptClass == null || scriptSource.isModified()) {
                    this.scriptClass = this.getGroovyClassLoader().parseClass(scriptSource.getScriptAsString(), scriptSource.suggestedClassName());
                    if (Script.class.isAssignableFrom(this.scriptClass)) {
                        Object result = this.executeScript(scriptSource, this.scriptClass);
                        this.scriptResultClass = result != null ? result.getClass() : null;
                        return result;
                    }
                    this.scriptResultClass = this.scriptClass;
                }
                Class<?> scriptClassToExecute = this.scriptClass;
                return this.executeScript(scriptSource, scriptClassToExecute);
            }
            catch (CompilationFailedException ex) {
                this.scriptClass = null;
                this.scriptResultClass = null;
                throw new ScriptCompilationException(scriptSource, (Throwable)ex);
            }
        }
    }

    @Override
    public @Nullable Class<?> getScriptedObjectType(ScriptSource scriptSource) throws IOException, ScriptCompilationException {
        Object object = this.scriptClassMonitor;
        synchronized (object) {
            try {
                if (this.scriptClass == null || scriptSource.isModified()) {
                    this.wasModifiedForTypeCheck = true;
                    this.scriptClass = this.getGroovyClassLoader().parseClass(scriptSource.getScriptAsString(), scriptSource.suggestedClassName());
                    if (Script.class.isAssignableFrom(this.scriptClass)) {
                        Object result = this.executeScript(scriptSource, this.scriptClass);
                        this.scriptResultClass = result != null ? result.getClass() : null;
                        this.cachedResult = new CachedResultHolder(result);
                    } else {
                        this.scriptResultClass = this.scriptClass;
                    }
                }
                return this.scriptResultClass;
            }
            catch (CompilationFailedException ex) {
                this.scriptClass = null;
                this.scriptResultClass = null;
                this.cachedResult = null;
                throw new ScriptCompilationException(scriptSource, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean requiresScriptedObjectRefresh(ScriptSource scriptSource) {
        Object object = this.scriptClassMonitor;
        synchronized (object) {
            return scriptSource.isModified() || this.wasModifiedForTypeCheck;
        }
    }

    protected @Nullable Object executeScript(ScriptSource scriptSource, Class<?> scriptClass) throws ScriptCompilationException {
        try {
            GroovyObject groovyObj = (GroovyObject)ReflectionUtils.accessibleConstructor(scriptClass, new Class[0]).newInstance(new Object[0]);
            if (this.groovyObjectCustomizer != null) {
                this.groovyObjectCustomizer.customize(groovyObj);
            }
            if (groovyObj instanceof Script) {
                Script script = (Script)groovyObj;
                return script.run();
            }
            return groovyObj;
        }
        catch (NoSuchMethodException ex) {
            throw new ScriptCompilationException("No default constructor on Groovy script class: " + scriptClass.getName(), (Throwable)ex);
        }
        catch (InstantiationException ex) {
            throw new ScriptCompilationException(scriptSource, "Unable to instantiate Groovy script class: " + scriptClass.getName(), ex);
        }
        catch (IllegalAccessException | InaccessibleObjectException ex) {
            throw new ScriptCompilationException(scriptSource, "Could not access Groovy script constructor: " + scriptClass.getName(), ex);
        }
        catch (InvocationTargetException ex) {
            throw new ScriptCompilationException("Failed to invoke Groovy script constructor: " + scriptClass.getName(), ex.getTargetException());
        }
    }

    public String toString() {
        return "GroovyScriptFactory: script source locator [" + this.scriptSourceLocator + "]";
    }

    private static class CachedResultHolder {
        public final @Nullable Object object;

        public CachedResultHolder(@Nullable Object object) {
            this.object = object;
        }
    }
}

