/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scheduling.config;

import java.time.Instant;
import org.jspecify.annotations.Nullable;
import org.springframework.scheduling.SchedulingAwareRunnable;
import org.springframework.scheduling.config.TaskExecutionOutcome;
import org.springframework.util.Assert;

public class Task {
    private final Runnable runnable;
    private TaskExecutionOutcome lastExecutionOutcome;

    public Task(Runnable runnable2) {
        Assert.notNull((Object)runnable2, "Runnable must not be null");
        this.runnable = new OutcomeTrackingRunnable(runnable2);
        this.lastExecutionOutcome = TaskExecutionOutcome.create();
    }

    public Runnable getRunnable() {
        return this.runnable;
    }

    public TaskExecutionOutcome getLastExecutionOutcome() {
        return this.lastExecutionOutcome;
    }

    public String toString() {
        return this.runnable.toString();
    }

    private class OutcomeTrackingRunnable
    implements SchedulingAwareRunnable {
        private final Runnable runnable;

        public OutcomeTrackingRunnable(Runnable runnable2) {
            this.runnable = runnable2;
        }

        @Override
        public void run() {
            try {
                Task.this.lastExecutionOutcome = Task.this.lastExecutionOutcome.start(Instant.now());
                this.runnable.run();
                Task.this.lastExecutionOutcome = Task.this.lastExecutionOutcome.success();
            }
            catch (Throwable exc) {
                Task.this.lastExecutionOutcome = Task.this.lastExecutionOutcome.failure(exc);
                throw exc;
            }
        }

        @Override
        public boolean isLongLived() {
            Runnable runnable2 = this.runnable;
            if (runnable2 instanceof SchedulingAwareRunnable) {
                SchedulingAwareRunnable sar = (SchedulingAwareRunnable)runnable2;
                return sar.isLongLived();
            }
            return SchedulingAwareRunnable.super.isLongLived();
        }

        @Override
        public @Nullable String getQualifier() {
            Runnable runnable2 = this.runnable;
            if (runnable2 instanceof SchedulingAwareRunnable) {
                SchedulingAwareRunnable sar = (SchedulingAwareRunnable)runnable2;
                return sar.getQualifier();
            }
            return SchedulingAwareRunnable.super.getQualifier();
        }

        public String toString() {
            return this.runnable.toString();
        }
    }
}

