/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.resilience.annotation;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jspecify.annotations.Nullable;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.aop.framework.autoproxy.AbstractBeanFactoryAwareAdvisingPostProcessor;
import org.springframework.aop.interceptor.ConcurrencyThrottleInterceptor;
import org.springframework.aop.support.ComposablePointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.context.EmbeddedValueResolverAware;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.resilience.annotation.ConcurrencyLimit;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public class ConcurrencyLimitBeanPostProcessor
extends AbstractBeanFactoryAwareAdvisingPostProcessor
implements EmbeddedValueResolverAware {
    private @Nullable StringValueResolver embeddedValueResolver;

    public ConcurrencyLimitBeanPostProcessor() {
        this.setBeforeExistingAdvisors(true);
        AnnotationMatchingPointcut cpc = new AnnotationMatchingPointcut(ConcurrencyLimit.class, true);
        AnnotationMatchingPointcut mpc = new AnnotationMatchingPointcut(null, ConcurrencyLimit.class, true);
        this.advisor = new DefaultPointcutAdvisor(new ComposablePointcut(cpc).union(mpc), new ConcurrencyLimitInterceptor());
    }

    @Override
    public void setEmbeddedValueResolver(StringValueResolver resolver) {
        this.embeddedValueResolver = resolver;
    }

    private class ConcurrencyLimitInterceptor
    implements MethodInterceptor {
        private final Map<Object, ConcurrencyThrottleHolder> holderPerInstance = Collections.synchronizedMap(new IdentityHashMap(16));

        private ConcurrencyLimitInterceptor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public @Nullable Object invoke(MethodInvocation invocation) throws Throwable {
            Class<?> targetClass;
            Method method = invocation.getMethod();
            Object instance = invocation.getThis();
            Class<?> clazz = targetClass = instance != null ? instance.getClass() : method.getDeclaringClass();
            if (invocation instanceof ProxyMethodInvocation) {
                ProxyMethodInvocation methodInvocation = (ProxyMethodInvocation)invocation;
                instance = methodInvocation.getProxy();
            }
            Assert.state(instance != null, "Unique instance required - use a ProxyMethodInvocation");
            ConcurrencyThrottleHolder holder = this.holderPerInstance.computeIfAbsent(instance, k -> new ConcurrencyThrottleHolder());
            MethodInterceptor interceptor = holder.methodInterceptors.get(method);
            if (interceptor == null) {
                ConcurrencyThrottleHolder concurrencyThrottleHolder = holder;
                synchronized (concurrencyThrottleHolder) {
                    interceptor = holder.methodInterceptors.get(method);
                    if (interceptor == null) {
                        boolean perMethod = false;
                        ConcurrencyLimit annotation = AnnotatedElementUtils.getMergedAnnotation(method, ConcurrencyLimit.class);
                        if (annotation != null) {
                            perMethod = true;
                        } else {
                            interceptor = holder.classInterceptor;
                            if (interceptor == null) {
                                annotation = AnnotatedElementUtils.getMergedAnnotation(targetClass, ConcurrencyLimit.class);
                            }
                        }
                        if (interceptor == null) {
                            Assert.state(annotation != null, "No @ConcurrencyLimit annotation found");
                            int concurrencyLimit = this.parseInt(annotation.limit(), annotation.limitString());
                            if (concurrencyLimit < -1) {
                                throw new IllegalStateException(String.valueOf(annotation) + " must be configured with a valid limit");
                            }
                            interceptor = new ConcurrencyThrottleInterceptor(concurrencyLimit);
                            if (!perMethod) {
                                holder.classInterceptor = interceptor;
                            }
                        }
                        holder.methodInterceptors.put(method, interceptor);
                    }
                }
            }
            return interceptor.invoke(invocation);
        }

        private int parseInt(int value, String stringValue) {
            if (StringUtils.hasText(stringValue)) {
                if (ConcurrencyLimitBeanPostProcessor.this.embeddedValueResolver != null) {
                    stringValue = ConcurrencyLimitBeanPostProcessor.this.embeddedValueResolver.resolveStringValue(stringValue);
                }
                if (StringUtils.hasText(stringValue)) {
                    return Integer.parseInt(stringValue);
                }
            }
            return value;
        }
    }

    private static class ConcurrencyThrottleHolder {
        final Map<Method, MethodInterceptor> methodInterceptors = new ConcurrentHashMap<Method, MethodInterceptor>();
        @Nullable MethodInterceptor classInterceptor;

        private ConcurrencyThrottleHolder() {
        }
    }
}

