/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.support;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.jspecify.annotations.Nullable;
import org.springframework.jmx.support.ObjectNameManager;
import org.springframework.util.ObjectUtils;

public class NotificationListenerHolder {
    private @Nullable NotificationListener notificationListener;
    private @Nullable NotificationFilter notificationFilter;
    private @Nullable Object handback;
    protected @Nullable Set<Object> mappedObjectNames;

    public void setNotificationListener(@Nullable NotificationListener notificationListener) {
        this.notificationListener = notificationListener;
    }

    public @Nullable NotificationListener getNotificationListener() {
        return this.notificationListener;
    }

    public void setNotificationFilter(@Nullable NotificationFilter notificationFilter) {
        this.notificationFilter = notificationFilter;
    }

    public @Nullable NotificationFilter getNotificationFilter() {
        return this.notificationFilter;
    }

    public void setHandback(@Nullable Object handback) {
        this.handback = handback;
    }

    public @Nullable Object getHandback() {
        return this.handback;
    }

    public void setMappedObjectName(@Nullable Object mappedObjectName) {
        this.mappedObjectNames = mappedObjectName != null ? new LinkedHashSet<Object>(Collections.singleton(mappedObjectName)) : null;
    }

    public void setMappedObjectNames(Object ... mappedObjectNames) {
        this.mappedObjectNames = new LinkedHashSet<Object>(Arrays.asList(mappedObjectNames));
    }

    public ObjectName @Nullable [] getResolvedObjectNames() throws MalformedObjectNameException {
        if (this.mappedObjectNames == null) {
            return null;
        }
        ObjectName[] resolved = new ObjectName[this.mappedObjectNames.size()];
        int i2 = 0;
        for (Object objectName : this.mappedObjectNames) {
            resolved[i2] = ObjectNameManager.getInstance(objectName);
            ++i2;
        }
        return resolved;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) return true;
        if (!(other instanceof NotificationListenerHolder)) return false;
        NotificationListenerHolder that = (NotificationListenerHolder)other;
        if (!ObjectUtils.nullSafeEquals(this.notificationListener, that.notificationListener)) return false;
        if (!ObjectUtils.nullSafeEquals(this.notificationFilter, that.notificationFilter)) return false;
        if (!ObjectUtils.nullSafeEquals(this.handback, that.handback)) return false;
        if (!ObjectUtils.nullSafeEquals(this.mappedObjectNames, that.mappedObjectNames)) return false;
        return true;
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHash(this.notificationListener, this.notificationFilter, this.handback, this.mappedObjectNames);
    }
}

