/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jmx.access;

import org.jspecify.annotations.Nullable;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jmx.MBeanServerNotFoundException;
import org.springframework.jmx.access.MBeanClientInterceptor;
import org.springframework.jmx.access.MBeanInfoRetrievalException;
import org.springframework.util.ClassUtils;

public class MBeanProxyFactoryBean
extends MBeanClientInterceptor
implements FactoryBean<Object>,
BeanClassLoaderAware,
InitializingBean {
    private @Nullable Class<?> proxyInterface;
    private @Nullable ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private @Nullable Object mbeanProxy;

    public void setProxyInterface(Class<?> proxyInterface) {
        this.proxyInterface = proxyInterface;
    }

    @Override
    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    @Override
    public void afterPropertiesSet() throws MBeanServerNotFoundException, MBeanInfoRetrievalException {
        Class<?> interfaceToUse;
        super.afterPropertiesSet();
        if (this.proxyInterface == null) {
            interfaceToUse = this.getManagementInterface();
            if (interfaceToUse == null) {
                throw new IllegalArgumentException("Property 'proxyInterface' or 'managementInterface' is required");
            }
            this.proxyInterface = interfaceToUse;
        } else {
            interfaceToUse = this.proxyInterface;
            if (this.getManagementInterface() == null) {
                this.setManagementInterface(interfaceToUse);
            }
        }
        this.mbeanProxy = new ProxyFactory(interfaceToUse, this).getProxy(this.beanClassLoader);
    }

    @Override
    public @Nullable Object getObject() {
        return this.mbeanProxy;
    }

    @Override
    public @Nullable Class<?> getObjectType() {
        return this.proxyInterface;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}

