/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.TypeDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public abstract class ReflectionHelper {
    static @Nullable ArgumentsMatchKind compareArguments(List<TypeDescriptor> expectedArgTypes, List<TypeDescriptor> suppliedArgTypes, TypeConverter typeConverter) {
        Assert.isTrue(expectedArgTypes.size() == suppliedArgTypes.size(), "Expected argument types and supplied argument types should be lists of the same size");
        ArgumentsMatchKind match = ArgumentsMatchKind.EXACT;
        for (int i2 = 0; i2 < expectedArgTypes.size() && match != null; ++i2) {
            TypeDescriptor suppliedArg = suppliedArgTypes.get(i2);
            TypeDescriptor expectedArg = expectedArgTypes.get(i2);
            if (suppliedArg == null) {
                if (!expectedArg.isPrimitive()) continue;
                match = null;
                continue;
            }
            if (expectedArg.equals(suppliedArg)) continue;
            if (suppliedArg.isAssignableTo(expectedArg)) {
                if (match == ArgumentsMatchKind.REQUIRES_CONVERSION) continue;
                match = ArgumentsMatchKind.CLOSE;
                continue;
            }
            match = typeConverter.canConvert(suppliedArg, expectedArg) ? ArgumentsMatchKind.REQUIRES_CONVERSION : null;
        }
        return match;
    }

    public static int getTypeDifferenceWeight(List<TypeDescriptor> paramTypes, List<TypeDescriptor> argTypes) {
        int result = 0;
        for (int i2 = 0; i2 < paramTypes.size(); ++i2) {
            TypeDescriptor argType;
            TypeDescriptor paramType = paramTypes.get(i2);
            TypeDescriptor typeDescriptor = argType = i2 < argTypes.size() ? argTypes.get(i2) : null;
            if (argType == null) {
                if (!paramType.isPrimitive()) continue;
                return Integer.MAX_VALUE;
            }
            Class<Object> paramTypeClazz = paramType.getType();
            if (!ClassUtils.isAssignable(paramTypeClazz, argType.getType())) {
                return Integer.MAX_VALUE;
            }
            if (paramTypeClazz.isPrimitive()) {
                paramTypeClazz = Object.class;
            }
            Class<?> superClass = argType.getType().getSuperclass();
            while (superClass != null) {
                if (paramTypeClazz.equals(superClass)) {
                    result += 2;
                    superClass = null;
                    continue;
                }
                if (ClassUtils.isAssignable(paramTypeClazz, superClass)) {
                    result += 2;
                    superClass = superClass.getSuperclass();
                    continue;
                }
                superClass = null;
            }
            if (!paramTypeClazz.isInterface()) continue;
            ++result;
        }
        return result;
    }

    static @Nullable ArgumentsMatchKind compareArgumentsVarargs(List<TypeDescriptor> expectedArgTypes, List<TypeDescriptor> suppliedArgTypes, TypeConverter typeConverter) {
        Assert.isTrue(!CollectionUtils.isEmpty(expectedArgTypes), "Expected arguments must at least include one array (the varargs parameter)");
        Assert.isTrue(expectedArgTypes.get(expectedArgTypes.size() - 1).isArray(), "Final expected argument should be array type (the varargs parameter)");
        ArgumentsMatchKind match = ArgumentsMatchKind.EXACT;
        int argCountUpToVarargs = expectedArgTypes.size() - 1;
        for (int i2 = 0; i2 < argCountUpToVarargs && match != null; ++i2) {
            TypeDescriptor suppliedArg = suppliedArgTypes.get(i2);
            TypeDescriptor expectedArg = expectedArgTypes.get(i2);
            if (suppliedArg == null) {
                if (!expectedArg.isPrimitive()) continue;
                match = null;
                continue;
            }
            if (expectedArg.equals(suppliedArg)) continue;
            if (suppliedArg.isAssignableTo(expectedArg)) {
                if (match == ArgumentsMatchKind.REQUIRES_CONVERSION) continue;
                match = ArgumentsMatchKind.CLOSE;
                continue;
            }
            match = typeConverter.canConvert(suppliedArg, expectedArg) ? ArgumentsMatchKind.REQUIRES_CONVERSION : null;
        }
        if (match == null) {
            return null;
        }
        if (suppliedArgTypes.size() != expectedArgTypes.size() || !expectedArgTypes.get(expectedArgTypes.size() - 1).equals(suppliedArgTypes.get(suppliedArgTypes.size() - 1))) {
            TypeDescriptor varargsDesc = expectedArgTypes.get(expectedArgTypes.size() - 1);
            TypeDescriptor componentTypeDesc = varargsDesc.getElementTypeDescriptor();
            Assert.state(componentTypeDesc != null, "Component type must not be null for a varargs array");
            Class<?> varargsComponentType = componentTypeDesc.getType();
            for (int i3 = expectedArgTypes.size() - 1; i3 < suppliedArgTypes.size(); ++i3) {
                TypeDescriptor suppliedArg = suppliedArgTypes.get(i3);
                if (suppliedArg == null) {
                    if (!varargsComponentType.isPrimitive()) continue;
                    match = null;
                    continue;
                }
                if (varargsComponentType == suppliedArg.getType()) continue;
                if (ClassUtils.isAssignable(varargsComponentType, suppliedArg.getType())) {
                    if (match == ArgumentsMatchKind.REQUIRES_CONVERSION) continue;
                    match = ArgumentsMatchKind.CLOSE;
                    continue;
                }
                match = typeConverter.canConvert(suppliedArg, TypeDescriptor.valueOf(varargsComponentType)) ? ArgumentsMatchKind.REQUIRES_CONVERSION : null;
            }
        }
        return match;
    }

    public static boolean convertAllArguments(TypeConverter converter, @Nullable Object[] arguments, Method method) throws SpelEvaluationException {
        Integer varargsPosition = method.isVarArgs() ? Integer.valueOf(method.getParameterCount() - 1) : null;
        return ReflectionHelper.convertArguments(converter, arguments, method, varargsPosition);
    }

    static boolean convertArguments(TypeConverter converter, @Nullable Object[] arguments, Executable executable, @Nullable Integer varargsPosition) throws EvaluationException {
        boolean conversionOccurred;
        block8: {
            TypeDescriptor componentTypeDesc;
            block9: {
                TypeDescriptor targetType;
                block7: {
                    conversionOccurred = false;
                    if (varargsPosition != null) break block7;
                    for (int i2 = 0; i2 < arguments.length; ++i2) {
                        TypeDescriptor targetType2 = new TypeDescriptor(MethodParameter.forExecutable(executable, i2));
                        Object argument = arguments[i2];
                        TypeDescriptor sourceType = TypeDescriptor.forObject(argument);
                        arguments[i2] = converter.convertValue(argument, sourceType, targetType2);
                        conversionOccurred |= argument != arguments[i2];
                    }
                    break block8;
                }
                for (int i3 = 0; i3 < varargsPosition; ++i3) {
                    targetType = new TypeDescriptor(MethodParameter.forExecutable(executable, i3));
                    Object argument = arguments[i3];
                    TypeDescriptor sourceType = TypeDescriptor.forObject(argument);
                    arguments[i3] = converter.convertValue(argument, sourceType, targetType);
                    conversionOccurred |= argument != arguments[i3];
                }
                MethodParameter methodParam = MethodParameter.forExecutable(executable, varargsPosition);
                targetType = new TypeDescriptor(methodParam);
                componentTypeDesc = targetType.getElementTypeDescriptor();
                Assert.state(componentTypeDesc != null, "Component type must not be null for a varargs array");
                if (varargsPosition != arguments.length - 1) break block9;
                Object argument = arguments[varargsPosition];
                TypeDescriptor sourceType = TypeDescriptor.forObject(argument);
                if (argument == null) {
                    if (componentTypeDesc.getObjectType() == Optional.class) {
                        arguments[varargsPosition.intValue()] = Optional.empty();
                        conversionOccurred = true;
                    }
                } else if (!sourceType.isAssignableTo(componentTypeDesc) || sourceType.isArray() && !sourceType.isAssignableTo(targetType) || argument instanceof List) {
                    TypeDescriptor targetTypeToUse = sourceType.isArray() || argument instanceof List || converter.canConvert(sourceType, targetType) ? targetType : componentTypeDesc;
                    arguments[varargsPosition.intValue()] = converter.convertValue(argument, sourceType, targetTypeToUse);
                }
                if (argument == arguments[varargsPosition] || ReflectionHelper.isFirstEntryInArray(argument, arguments[varargsPosition])) break block8;
                conversionOccurred = true;
                break block8;
            }
            for (int i4 = varargsPosition.intValue(); i4 < arguments.length; ++i4) {
                Object argument = arguments[i4];
                TypeDescriptor sourceType = TypeDescriptor.forObject(argument);
                arguments[i4] = converter.convertValue(argument, sourceType, componentTypeDesc);
                conversionOccurred |= argument != arguments[i4];
            }
        }
        return conversionOccurred;
    }

    public static boolean convertAllMethodHandleArguments(TypeConverter converter, @Nullable Object[] arguments, MethodHandle methodHandle, @Nullable Integer varargsPosition) throws EvaluationException {
        boolean conversionOccurred;
        block8: {
            TypeDescriptor varargsComponentType;
            block9: {
                TypeDescriptor sourceType;
                Object argument;
                MethodType methodHandleType;
                block7: {
                    conversionOccurred = false;
                    methodHandleType = methodHandle.type();
                    if (varargsPosition != null) break block7;
                    for (int i2 = 0; i2 < arguments.length; ++i2) {
                        TypeDescriptor.OfField argumentClass = methodHandleType.parameterType(i2);
                        ResolvableType resolvableType = ResolvableType.forClass(argumentClass);
                        TypeDescriptor targetType = new TypeDescriptor(resolvableType, (Class<?>)argumentClass, null);
                        Object argument2 = arguments[i2];
                        TypeDescriptor sourceType2 = TypeDescriptor.forObject(argument2);
                        arguments[i2] = converter.convertValue(argument2, sourceType2, targetType);
                        conversionOccurred |= argument2 != arguments[i2];
                    }
                    break block8;
                }
                for (int i3 = 0; i3 < varargsPosition; ++i3) {
                    TypeDescriptor.OfField argumentClass = methodHandleType.parameterType(i3);
                    ResolvableType resolvableType = ResolvableType.forClass(argumentClass);
                    TypeDescriptor targetType = new TypeDescriptor(resolvableType, (Class<?>)argumentClass, null);
                    argument = arguments[i3];
                    sourceType = TypeDescriptor.forObject(argument);
                    arguments[i3] = converter.convertValue(argument, sourceType, targetType);
                    conversionOccurred |= argument != arguments[i3];
                }
                Class<?> varargsArrayClass = methodHandleType.lastParameterType();
                Class<?> varargsComponentClass = ClassUtils.resolvePrimitiveIfNecessary(varargsArrayClass.componentType());
                TypeDescriptor varargsArrayType = TypeDescriptor.array(TypeDescriptor.valueOf(varargsComponentClass));
                varargsComponentType = varargsArrayType.getElementTypeDescriptor();
                Assert.state(varargsComponentType != null, "Component type must not be null for a varargs array");
                if (varargsPosition != arguments.length - 1) break block9;
                argument = arguments[varargsPosition];
                sourceType = TypeDescriptor.forObject(argument);
                if (argument == null) {
                    if (varargsComponentType.getObjectType() == Optional.class) {
                        arguments[varargsPosition.intValue()] = Optional.empty();
                        conversionOccurred = true;
                    }
                } else if (!sourceType.isAssignableTo(varargsComponentType) || sourceType.isArray() && !sourceType.isAssignableTo(varargsArrayType) || argument instanceof List) {
                    TypeDescriptor targetTypeToUse = sourceType.isArray() || argument instanceof List || converter.canConvert(sourceType, varargsArrayType) ? varargsArrayType : varargsComponentType;
                    arguments[varargsPosition.intValue()] = converter.convertValue(argument, sourceType, targetTypeToUse);
                }
                if (argument == arguments[varargsPosition] || ReflectionHelper.isFirstEntryInArray(argument, arguments[varargsPosition])) break block8;
                conversionOccurred = true;
                break block8;
            }
            for (int i4 = varargsPosition.intValue(); i4 < arguments.length; ++i4) {
                Object argument = arguments[i4];
                TypeDescriptor sourceType = TypeDescriptor.forObject(argument);
                arguments[i4] = converter.convertValue(argument, sourceType, varargsComponentType);
                conversionOccurred |= argument != arguments[i4];
            }
        }
        return conversionOccurred;
    }

    private static boolean isFirstEntryInArray(@Nullable Object value, @Nullable Object possibleArray) {
        if (possibleArray == null) {
            return false;
        }
        Class<?> type = possibleArray.getClass();
        if (!type.isArray() || Array.getLength(possibleArray) == 0 || !ClassUtils.isAssignableValue(type.componentType(), value)) {
            return false;
        }
        Object arrayValue = Array.get(possibleArray, 0);
        return ((Class)type.componentType()).isPrimitive() ? arrayValue.equals(value) : arrayValue == value;
    }

    public static @Nullable Object[] setupArgumentsForVarargsInvocation(Class<?>[] requiredParameterTypes, Object ... args) {
        Object lastArgument;
        Assert.notEmpty((Object[])requiredParameterTypes, "Required parameter types array must not be empty");
        int parameterCount = requiredParameterTypes.length;
        Class<?> lastRequiredParameterType = requiredParameterTypes[parameterCount - 1];
        Assert.isTrue(lastRequiredParameterType.isArray(), "The last required parameter type must be an array to support varargs invocation");
        int argumentCount = args.length;
        Object object = lastArgument = argumentCount > 0 ? args[argumentCount - 1] : null;
        if (parameterCount != argumentCount || !lastRequiredParameterType.isInstance(lastArgument)) {
            @Nullable Object[] newArgs = new Object[parameterCount];
            System.arraycopy(args, 0, newArgs, 0, newArgs.length - 1);
            int varargsArraySize = 0;
            if (argumentCount >= parameterCount) {
                varargsArraySize = argumentCount - (parameterCount - 1);
            }
            TypeDescriptor.OfField componentType = lastRequiredParameterType.componentType();
            Object varargsArray = Array.newInstance(componentType, varargsArraySize);
            for (int i2 = 0; i2 < varargsArraySize; ++i2) {
                Array.set(varargsArray, i2, args[parameterCount - 1 + i2]);
            }
            newArgs[newArgs.length - 1] = varargsArray;
            return newArgs;
        }
        return args;
    }

    static enum ArgumentsMatchKind {
        EXACT,
        CLOSE,
        REQUIRES_CONVERSION;


        public boolean isExactMatch() {
            return this == EXACT;
        }

        public boolean isCloseMatch() {
            return this == CLOSE;
        }

        public boolean isMatchRequiringConversion() {
            return this == REQUIRES_CONVERSION;
        }
    }
}

