/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.ast.ValueRef;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class Selection
extends SpelNodeImpl {
    public static final int ALL = 0;
    public static final int FIRST = 1;
    public static final int LAST = 2;
    private final int variant;
    private final boolean nullSafe;

    public Selection(boolean nullSafe, int variant, int startPos, int endPos, SpelNodeImpl expression) {
        super(startPos, endPos, expression);
        this.nullSafe = nullSafe;
        this.variant = variant;
    }

    @Override
    public final boolean isNullSafe() {
        return this.nullSafe;
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        return this.getValueRef(state).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ValueRef getValueRef(ExpressionState state) throws EvaluationException {
        TypedValue contextObject = state.getActiveContextObject();
        Object operand = contextObject.getValue();
        if (this.isNullSafe()) {
            if (operand == null) {
                return ValueRef.NullValueRef.INSTANCE;
            }
            if (operand instanceof Optional) {
                Optional optional = (Optional)operand;
                if (optional.isEmpty()) {
                    return ValueRef.NullValueRef.INSTANCE;
                }
                operand = optional.get();
            }
        }
        if (operand == null) {
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INVALID_TYPE_FOR_SELECTION, "null");
        }
        SpelNodeImpl selectionCriteria = this.children[0];
        if (operand instanceof Map) {
            Map mapdata = (Map)operand;
            HashMap result = new HashMap();
            Object lastKey = null;
            for (Map.Entry entry : mapdata.entrySet()) {
                try {
                    TypedValue kvPair = new TypedValue(entry);
                    state.pushActiveContextObject(kvPair);
                    state.enterScope();
                    Object val = selectionCriteria.getValueInternal(state).getValue();
                    if (val instanceof Boolean) {
                        Boolean b = (Boolean)val;
                        if (!b.booleanValue()) continue;
                        result.put(entry.getKey(), entry.getValue());
                        if (this.variant == 1) {
                            ValueRef.TypedValueHolderValueRef typedValueHolderValueRef = new ValueRef.TypedValueHolderValueRef(new TypedValue(result), this);
                            return typedValueHolderValueRef;
                        }
                        lastKey = entry.getKey();
                        continue;
                    }
                    throw new SpelEvaluationException(selectionCriteria.getStartPosition(), SpelMessage.RESULT_OF_SELECTION_CRITERIA_IS_NOT_BOOLEAN, new Object[0]);
                }
                finally {
                    state.popActiveContextObject();
                    state.exitScope();
                }
            }
            if ((this.variant == 1 || this.variant == 2) && result.isEmpty()) {
                return new ValueRef.TypedValueHolderValueRef(TypedValue.NULL, this);
            }
            if (this.variant == 2) {
                HashMap resultMap = new HashMap();
                Object lastValue = result.get(lastKey);
                resultMap.put(lastKey, lastValue);
                return new ValueRef.TypedValueHolderValueRef(new TypedValue(resultMap), this);
            }
            return new ValueRef.TypedValueHolderValueRef(new TypedValue(result), this);
        }
        if (operand instanceof Iterable || ObjectUtils.isArray(operand)) {
            TypeDescriptor elementTypeDesc;
            Iterable<Object> iterable;
            if (operand instanceof Iterable) {
                Iterable iterable2 = (Iterable)operand;
                iterable = iterable2;
            } else {
                iterable = Arrays.asList(ObjectUtils.toObjectArray(operand));
            }
            Iterable<Object> data = iterable;
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object element : data) {
                try {
                    state.pushActiveContextObject(new TypedValue(element));
                    state.enterScope();
                    Object criteria = selectionCriteria.getValueInternal(state).getValue();
                    if (criteria instanceof Boolean) {
                        Boolean match = (Boolean)criteria;
                        if (!match.booleanValue()) continue;
                        if (this.variant == 1) {
                            ValueRef.TypedValueHolderValueRef typedValueHolderValueRef = new ValueRef.TypedValueHolderValueRef(new TypedValue(element), this);
                            return typedValueHolderValueRef;
                        }
                        result.add(element);
                        continue;
                    }
                    throw new SpelEvaluationException(selectionCriteria.getStartPosition(), SpelMessage.RESULT_OF_SELECTION_CRITERIA_IS_NOT_BOOLEAN, new Object[0]);
                }
                finally {
                    state.exitScope();
                    state.popActiveContextObject();
                }
            }
            if ((this.variant == 1 || this.variant == 2) && result.isEmpty()) {
                return ValueRef.NullValueRef.INSTANCE;
            }
            if (this.variant == 2) {
                return new ValueRef.TypedValueHolderValueRef(new TypedValue(CollectionUtils.lastElement(result)), this);
            }
            if (operand instanceof Iterable) {
                return new ValueRef.TypedValueHolderValueRef(new TypedValue(result), this);
            }
            Class<?> elementType = null;
            TypeDescriptor typeDesc = contextObject.getTypeDescriptor();
            if (typeDesc != null && (elementTypeDesc = typeDesc.getElementTypeDescriptor()) != null) {
                elementType = ClassUtils.resolvePrimitiveIfNecessary(elementTypeDesc.getType());
            }
            Assert.state(elementType != null, "Unresolvable element type");
            Object resultArray = Array.newInstance(elementType, result.size());
            System.arraycopy(result.toArray(), 0, resultArray, 0, result.size());
            return new ValueRef.TypedValueHolderValueRef(new TypedValue(resultArray), this);
        }
        throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.INVALID_TYPE_FOR_SELECTION, operand.getClass().getName());
    }

    @Override
    public String toStringAST() {
        return this.prefix() + this.getChild(0).toStringAST() + "]";
    }

    private String prefix() {
        return switch (this.variant) {
            case 0 -> "?[";
            case 1 -> "^[";
            case 2 -> "$[";
            default -> "";
        };
    }
}

