/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import org.jspecify.annotations.Nullable;
import org.springframework.asm.Label;
import org.springframework.asm.MethodVisitor;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.ExpressionInvocationTargetException;
import org.springframework.expression.MethodExecutor;
import org.springframework.expression.MethodResolver;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.CodeFlow;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.expression.spel.ast.FormatHelper;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.ast.ValueRef;
import org.springframework.expression.spel.support.ReflectiveMethodExecutor;
import org.springframework.expression.spel.support.ReflectiveMethodResolver;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class MethodReference
extends SpelNodeImpl {
    private final boolean nullSafe;
    private final String name;
    private @Nullable Character originalPrimitiveExitTypeDescriptor;
    private volatile @Nullable CachedMethodExecutor cachedExecutor;

    public MethodReference(boolean nullSafe, String methodName, int startPos, int endPos, SpelNodeImpl ... arguments) {
        super(startPos, endPos, arguments);
        this.name = methodName;
        this.nullSafe = nullSafe;
    }

    @Override
    public final boolean isNullSafe() {
        return this.nullSafe;
    }

    public final String getName() {
        return this.name;
    }

    @Override
    protected ValueRef getValueRef(ExpressionState state) throws EvaluationException {
        @Nullable Object[] arguments = this.getArguments(state);
        if (state.getActiveContextObject().getValue() == null) {
            if (!this.isNullSafe()) {
                throw this.nullTargetException(this.getArgumentTypes(arguments));
            }
            return ValueRef.NullValueRef.INSTANCE;
        }
        return new MethodValueRef(state, arguments);
    }

    @Override
    public TypedValue getValueInternal(ExpressionState state) throws EvaluationException {
        EvaluationContext evaluationContext = state.getEvaluationContext();
        TypedValue contextObject = state.getActiveContextObject();
        Object target = contextObject.getValue();
        TypeDescriptor targetType = contextObject.getTypeDescriptor();
        @Nullable Object[] arguments = this.getArguments(state);
        TypedValue result = this.getValueInternal(evaluationContext, target, targetType, arguments);
        this.updateExitTypeDescriptor();
        return result;
    }

    private TypedValue getValueInternal(EvaluationContext evaluationContext, @Nullable Object target, @Nullable TypeDescriptor targetType, @Nullable Object[] arguments) {
        Class clazz;
        List<TypeDescriptor> argumentTypes = this.getArgumentTypes(arguments);
        Optional fallbackOptionalTarget = null;
        boolean isEmptyOptional = false;
        if (this.isNullSafe()) {
            if (target == null) {
                return TypedValue.NULL;
            }
            if (target instanceof Optional) {
                Optional optional = (Optional)target;
                if (optional.isPresent()) {
                    target = optional.get();
                    fallbackOptionalTarget = optional;
                } else {
                    isEmptyOptional = true;
                }
            }
        }
        if (target == null) {
            throw this.nullTargetException(argumentTypes);
        }
        MethodExecutor executorToUse = this.getCachedExecutor(evaluationContext, target, targetType, argumentTypes);
        if (executorToUse != null) {
            try {
                return executorToUse.execute(evaluationContext, target, arguments);
            }
            catch (AccessException ex) {
                this.throwSimpleExceptionIfPossible(target, ex);
                this.cachedExecutor = null;
                executorToUse = null;
            }
        }
        Object targetToUse = target;
        MethodExecutorSearchResult searchResult = this.findMethodExecutor(argumentTypes, target, evaluationContext);
        if (searchResult.methodExecutor != null) {
            executorToUse = searchResult.methodExecutor;
        } else if (fallbackOptionalTarget != null) {
            searchResult = this.findMethodExecutor(argumentTypes, fallbackOptionalTarget, evaluationContext);
            if (searchResult.methodExecutor != null) {
                executorToUse = searchResult.methodExecutor;
                targetToUse = fallbackOptionalTarget;
            }
        } else if (isEmptyOptional) {
            return TypedValue.NULL;
        }
        if (executorToUse == null) {
            Class clazz2;
            String method = FormatHelper.formatMethodForMessage(this.name, argumentTypes);
            String className = FormatHelper.formatClassNameForMessage(target instanceof Class ? (clazz2 = (Class)target) : target.getClass());
            if (searchResult.accessException != null) {
                throw new SpelEvaluationException(this.getStartPosition(), (Throwable)searchResult.accessException, SpelMessage.PROBLEM_LOCATING_METHOD, method, className);
            }
            throw new SpelEvaluationException(this.getStartPosition(), SpelMessage.METHOD_NOT_FOUND, method, className);
        }
        this.cachedExecutor = new CachedMethodExecutor(executorToUse, targetToUse instanceof Class ? (clazz = (Class)targetToUse) : null, targetType, argumentTypes);
        try {
            return executorToUse.execute(evaluationContext, targetToUse, arguments);
        }
        catch (AccessException ex) {
            this.throwSimpleExceptionIfPossible(targetToUse, ex);
            throw new SpelEvaluationException(this.getStartPosition(), (Throwable)ex, SpelMessage.EXCEPTION_DURING_METHOD_INVOCATION, this.name, targetToUse.getClass().getName(), ex.getMessage());
        }
    }

    private SpelEvaluationException nullTargetException(List<TypeDescriptor> argumentTypes) {
        return new SpelEvaluationException(this.getStartPosition(), SpelMessage.METHOD_CALL_ON_NULL_OBJECT_NOT_ALLOWED, FormatHelper.formatMethodForMessage(this.name, argumentTypes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private @Nullable Object[] getArguments(ExpressionState state) {
        @Nullable Object[] arguments = new Object[this.getChildCount()];
        for (int i2 = 0; i2 < arguments.length; ++i2) {
            try {
                state.pushActiveContextObject(state.getScopeRootContextObject());
                arguments[i2] = this.children[i2].getValueInternal(state).getValue();
                continue;
            }
            finally {
                state.popActiveContextObject();
            }
        }
        return arguments;
    }

    private List<TypeDescriptor> getArgumentTypes(Object ... arguments) {
        ArrayList<@Nullable TypeDescriptor> descriptors = new ArrayList<TypeDescriptor>(arguments.length);
        for (Object argument : arguments) {
            descriptors.add(TypeDescriptor.forObject(argument));
        }
        return Collections.unmodifiableList(descriptors);
    }

    private @Nullable MethodExecutor getCachedExecutor(EvaluationContext evaluationContext, Object target, @Nullable TypeDescriptor targetType, List<TypeDescriptor> argumentTypes) {
        List<MethodResolver> methodResolvers = evaluationContext.getMethodResolvers();
        if (methodResolvers.size() != 1 || !(methodResolvers.get(0) instanceof ReflectiveMethodResolver)) {
            return null;
        }
        CachedMethodExecutor executorToCheck = this.cachedExecutor;
        if (executorToCheck != null && executorToCheck.isSuitable(target, targetType, argumentTypes)) {
            return executorToCheck.get();
        }
        this.cachedExecutor = null;
        return null;
    }

    private MethodExecutorSearchResult findMethodExecutor(List<TypeDescriptor> argumentTypes, Object target, EvaluationContext evaluationContext) throws SpelEvaluationException {
        AccessException accessException = null;
        for (MethodResolver methodResolver : evaluationContext.getMethodResolvers()) {
            try {
                MethodExecutor methodExecutor = methodResolver.resolve(evaluationContext, target, this.name, argumentTypes);
                if (methodExecutor == null) continue;
                return new MethodExecutorSearchResult(methodExecutor, null);
            }
            catch (AccessException ex) {
                accessException = ex;
                break;
            }
        }
        return new MethodExecutorSearchResult(null, accessException);
    }

    private void throwSimpleExceptionIfPossible(Object target, AccessException ex) {
        Throwable throwable = ex.getCause();
        if (throwable instanceof InvocationTargetException) {
            InvocationTargetException cause = (InvocationTargetException)throwable;
            Throwable rootCause = cause.getCause();
            if (rootCause instanceof RuntimeException) {
                RuntimeException runtimeException = (RuntimeException)rootCause;
                throw runtimeException;
            }
            throw new ExpressionInvocationTargetException(this.getStartPosition(), "A problem occurred when trying to execute method '" + this.name + "' on object of type [" + target.getClass().getName() + "]", rootCause);
        }
    }

    private void updateExitTypeDescriptor() {
        MethodExecutor methodExecutor;
        CachedMethodExecutor executorToCheck = this.cachedExecutor;
        if (executorToCheck != null && (methodExecutor = executorToCheck.get()) instanceof ReflectiveMethodExecutor) {
            ReflectiveMethodExecutor reflectiveMethodExecutor = (ReflectiveMethodExecutor)methodExecutor;
            Method method = reflectiveMethodExecutor.getMethod();
            String descriptor = CodeFlow.toDescriptor(method.getReturnType());
            if (this.isNullSafe() && CodeFlow.isPrimitive(descriptor) && descriptor.charAt(0) != 'V') {
                this.originalPrimitiveExitTypeDescriptor = Character.valueOf(descriptor.charAt(0));
                this.exitTypeDescriptor = CodeFlow.toBoxedDescriptor(descriptor);
            } else {
                this.exitTypeDescriptor = descriptor;
            }
        }
    }

    @Override
    public String toStringAST() {
        StringJoiner sj = new StringJoiner(",", "(", ")");
        for (int i2 = 0; i2 < this.getChildCount(); ++i2) {
            sj.add(this.getChild(i2).toStringAST());
        }
        return this.name + String.valueOf(sj);
    }

    @Override
    public boolean isCompilable() {
        SpelNodeImpl[] spelNodeImplArray;
        CachedMethodExecutor executorToCheck = this.cachedExecutor;
        if (executorToCheck == null || executorToCheck.hasProxyTarget() || !((spelNodeImplArray = executorToCheck.get()) instanceof ReflectiveMethodExecutor)) {
            return false;
        }
        ReflectiveMethodExecutor executor = (ReflectiveMethodExecutor)spelNodeImplArray;
        for (SpelNodeImpl child : this.children) {
            if (child.isCompilable()) continue;
            return false;
        }
        if (executor.didArgumentConversionOccur()) {
            return false;
        }
        Method method = executor.getMethod();
        return Modifier.isPublic(method.getModifiers()) && executor.getPublicDeclaringClass() != null;
    }

    @Override
    public void generateCode(MethodVisitor mv, CodeFlow cf) {
        MethodExecutor methodExecutor;
        CachedMethodExecutor executorToCheck = this.cachedExecutor;
        if (executorToCheck == null || !((methodExecutor = executorToCheck.get()) instanceof ReflectiveMethodExecutor)) {
            throw new IllegalStateException("No applicable cached executor found: " + String.valueOf(executorToCheck));
        }
        ReflectiveMethodExecutor methodExecutor2 = (ReflectiveMethodExecutor)methodExecutor;
        Method method = methodExecutor2.getMethod();
        Class<?> publicDeclaringClass = methodExecutor2.getPublicDeclaringClass();
        Assert.state(publicDeclaringClass != null, () -> "Failed to find public declaring class for method: " + String.valueOf(method));
        String classDesc = publicDeclaringClass.getName().replace('.', '/');
        boolean isStatic = Modifier.isStatic(method.getModifiers());
        String descriptor = cf.lastDescriptor();
        if (descriptor == null && !isStatic) {
            cf.loadTarget(mv);
        }
        Label skipIfNull = null;
        if (this.isNullSafe() && (descriptor != null || !isStatic)) {
            skipIfNull = new Label();
            Label continueLabel = new Label();
            mv.visitInsn(89);
            mv.visitJumpInsn(199, continueLabel);
            CodeFlow.insertCheckCast(mv, this.exitTypeDescriptor);
            mv.visitJumpInsn(167, skipIfNull);
            mv.visitLabel(continueLabel);
        }
        if (descriptor != null && isStatic) {
            mv.visitInsn(87);
        }
        if (CodeFlow.isPrimitive(descriptor)) {
            CodeFlow.insertBoxIfNecessary(mv, descriptor.charAt(0));
        }
        if (!(isStatic || descriptor != null && descriptor.substring(1).equals(classDesc))) {
            CodeFlow.insertCheckCast(mv, "L" + classDesc);
        }
        MethodReference.generateCodeForArguments(mv, cf, method, this.children);
        boolean isInterface = publicDeclaringClass.isInterface();
        int opcode = isStatic ? 184 : (isInterface ? 185 : 182);
        mv.visitMethodInsn(opcode, classDesc, method.getName(), CodeFlow.createSignatureDescriptor(method), isInterface);
        cf.pushDescriptor(this.exitTypeDescriptor);
        if (this.originalPrimitiveExitTypeDescriptor != null) {
            CodeFlow.insertBoxIfNecessary(mv, this.originalPrimitiveExitTypeDescriptor.charValue());
        }
        if (skipIfNull != null) {
            if ("V".equals(this.exitTypeDescriptor)) {
                mv.visitInsn(1);
            }
            mv.visitLabel(skipIfNull);
        }
    }

    private class MethodValueRef
    implements ValueRef {
        private final EvaluationContext evaluationContext;
        private final @Nullable Object target;
        private final @Nullable TypeDescriptor targetType;
        private final @Nullable Object[] arguments;

        public MethodValueRef(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable ExpressionState state, Object[] arguments) {
            this.evaluationContext = state.getEvaluationContext();
            this.target = state.getActiveContextObject().getValue();
            this.targetType = state.getActiveContextObject().getTypeDescriptor();
            this.arguments = arguments;
        }

        @Override
        public TypedValue getValue() {
            TypedValue result = MethodReference.this.getValueInternal(this.evaluationContext, this.target, this.targetType, this.arguments);
            MethodReference.this.updateExitTypeDescriptor();
            return result;
        }

        @Override
        public void setValue(@Nullable Object newValue) {
            throw new IllegalAccessError();
        }

        @Override
        public boolean isWritable() {
            return false;
        }
    }

    private record CachedMethodExecutor(MethodExecutor methodExecutor, @Nullable Class<?> staticClass, @Nullable TypeDescriptor targetType, List<TypeDescriptor> argumentTypes) {
        public boolean isSuitable(Object target, @Nullable TypeDescriptor targetType, List<TypeDescriptor> argumentTypes) {
            return (this.staticClass == null || this.staticClass == target) && ObjectUtils.nullSafeEquals(this.targetType, targetType) && this.argumentTypes.equals(argumentTypes);
        }

        public boolean hasProxyTarget() {
            return this.targetType != null && Proxy.isProxyClass(this.targetType.getType());
        }

        public MethodExecutor get() {
            return this.methodExecutor;
        }
    }

    private record MethodExecutorSearchResult(@Nullable MethodExecutor methodExecutor, @Nullable AccessException accessException) {
    }
}

