/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.ast;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.TypedValue;
import org.springframework.expression.spel.ExpressionState;
import org.springframework.expression.spel.SpelNode;
import org.springframework.expression.spel.ast.InlineList;
import org.springframework.expression.spel.ast.Literal;
import org.springframework.expression.spel.ast.OpMinus;
import org.springframework.expression.spel.ast.PropertyOrFieldReference;
import org.springframework.expression.spel.ast.SpelNodeImpl;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.Assert;

public class InlineMap
extends SpelNodeImpl {
    private final @Nullable TypedValue constant = this.computeConstantValue();

    public InlineMap(int startPos, int endPos, SpelNodeImpl ... args) {
        super(startPos, endPos, args);
    }

    private @Nullable TypedValue computeConstantValue() {
        int max = this.getChildCount();
        for (int c = 0; c < max; ++c) {
            OpMinus opMinus;
            InlineMap inlineMap;
            InlineList inlineList;
            SpelNode child = this.getChild(c);
            if (child instanceof Literal || !(child instanceof InlineList ? !(inlineList = (InlineList)child).isConstant() : (child instanceof InlineMap ? !(inlineMap = (InlineMap)child).isConstant() : !(c % 2 == 0 && child instanceof PropertyOrFieldReference || child instanceof OpMinus && (opMinus = (OpMinus)child).isNegativeNumberLiteral())))) continue;
            return null;
        }
        LinkedHashMap<Object, List<Object>> constantMap = new LinkedHashMap<Object, List<Object>>();
        int childCount = this.getChildCount();
        ExpressionState expressionState = new ExpressionState(new StandardEvaluationContext());
        for (int c = 0; c < childCount; ++c) {
            Object key;
            SpelNode keyChild;
            if ((keyChild = this.getChild(c++)) instanceof Literal) {
                Literal literal = (Literal)keyChild;
                key = literal.getLiteralValue().getValue();
            } else if (keyChild instanceof PropertyOrFieldReference) {
                PropertyOrFieldReference propertyOrFieldReference = (PropertyOrFieldReference)keyChild;
                key = propertyOrFieldReference.getName();
            } else if (keyChild instanceof OpMinus) {
                key = keyChild.getValue(expressionState);
            } else {
                return null;
            }
            SpelNode valueChild = this.getChild(c);
            Object value = null;
            if (valueChild instanceof Literal) {
                Literal literal = (Literal)valueChild;
                value = literal.getLiteralValue().getValue();
            } else if (valueChild instanceof InlineList) {
                InlineList inlineList = (InlineList)valueChild;
                value = inlineList.getConstantValue();
            } else if (valueChild instanceof InlineMap) {
                InlineMap inlineMap = (InlineMap)valueChild;
                value = inlineMap.getConstantValue();
            } else if (valueChild instanceof OpMinus) {
                value = valueChild.getValue(expressionState);
            }
            constantMap.put(key, (List<Object>)value);
        }
        return new TypedValue(Collections.unmodifiableMap(constantMap));
    }

    @Override
    public TypedValue getValueInternal(ExpressionState expressionState) throws EvaluationException {
        if (this.constant != null) {
            return this.constant;
        }
        LinkedHashMap<Object, Object> returnValue = new LinkedHashMap<Object, Object>();
        int childcount = this.getChildCount();
        for (int c = 0; c < childcount; ++c) {
            SpelNode keyChild = this.getChild(c++);
            Object key = null;
            if (keyChild instanceof PropertyOrFieldReference) {
                PropertyOrFieldReference reference = (PropertyOrFieldReference)keyChild;
                key = reference.getName();
            } else {
                key = keyChild.getValue(expressionState);
            }
            Object value = this.getChild(c).getValue(expressionState);
            returnValue.put(key, value);
        }
        return new TypedValue(returnValue);
    }

    @Override
    public String toStringAST() {
        StringBuilder sb = new StringBuilder("{");
        for (int c = 0; c < this.getChildCount(); ++c) {
            if (c > 0) {
                sb.append(',');
            }
            sb.append(this.getChild(c++).toStringAST());
            sb.append(':');
            sb.append(this.getChild(c).toStringAST());
        }
        sb.append('}');
        return sb.toString();
    }

    public boolean isConstant() {
        return this.constant != null;
    }

    public @Nullable Map<Object, Object> getConstantValue() {
        Assert.state(this.constant != null, "No constant");
        return (Map)this.constant.getValue();
    }
}

