/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.retry;

import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;
import org.springframework.core.retry.DefaultRetryPolicy;
import org.springframework.util.Assert;
import org.springframework.util.backoff.BackOff;
import org.springframework.util.backoff.ExponentialBackOff;
import org.springframework.util.backoff.FixedBackOff;

public interface RetryPolicy {
    public boolean shouldRetry(Throwable var1);

    default public Duration getTimeout() {
        return Duration.ZERO;
    }

    default public BackOff getBackOff() {
        return new FixedBackOff(1000L, 3L);
    }

    public static RetryPolicy withDefaults() {
        return throwable -> true;
    }

    public static RetryPolicy withMaxRetries(long maxRetries) {
        RetryPolicy.assertMaxRetriesIsNotNegative(maxRetries);
        return RetryPolicy.builder().backOff(new FixedBackOff(1000L, maxRetries)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static void assertMaxRetriesIsNotNegative(long maxRetries) {
        Assert.isTrue(maxRetries >= 0L, () -> "Invalid maxRetries (%d): must be positive or zero for no retry.".formatted(maxRetries));
    }

    private static void assertIsNotNegative(String name, Duration duration) {
        Assert.isTrue(!duration.isNegative(), () -> "Invalid %s (%dms): must be greater than or equal to zero.".formatted(name, duration.toMillis()));
    }

    private static void assertIsPositive(String name, Duration duration) {
        Assert.isTrue(!duration.isNegative() && !duration.isZero(), () -> "Invalid %s (%dms): must be greater than zero.".formatted(name, duration.toMillis()));
    }

    public static final class Builder {
        public static final long DEFAULT_MAX_RETRIES = 3L;
        public static final long DEFAULT_DELAY = 1000L;
        public static final long DEFAULT_MAX_DELAY = Long.MAX_VALUE;
        public static final double DEFAULT_MULTIPLIER = 1.0;
        private @Nullable BackOff backOff;
        private @Nullable Long maxRetries;
        private Duration timeout = Duration.ZERO;
        private @Nullable Duration delay;
        private @Nullable Duration jitter;
        private @Nullable Double multiplier;
        private @Nullable Duration maxDelay;
        private final Set<Class<? extends Throwable>> includes = new LinkedHashSet<Class<? extends Throwable>>();
        private final Set<Class<? extends Throwable>> excludes = new LinkedHashSet<Class<? extends Throwable>>();
        private @Nullable Predicate<Throwable> predicate;

        private Builder() {
        }

        public Builder backOff(BackOff backOff) {
            Assert.notNull((Object)backOff, "BackOff must not be null");
            this.backOff = backOff;
            return this;
        }

        public Builder maxRetries(long maxRetries) {
            RetryPolicy.assertMaxRetriesIsNotNegative(maxRetries);
            this.maxRetries = maxRetries;
            return this;
        }

        public Builder timeout(Duration timeout2) {
            RetryPolicy.assertIsNotNegative("timeout", timeout2);
            this.timeout = timeout2;
            return this;
        }

        public Builder delay(Duration delay) {
            RetryPolicy.assertIsNotNegative("delay", delay);
            this.delay = delay;
            return this;
        }

        public Builder jitter(Duration jitter) {
            RetryPolicy.assertIsNotNegative("jitter", jitter);
            this.jitter = jitter;
            return this;
        }

        public Builder multiplier(double multiplier) {
            Assert.isTrue(multiplier >= 1.0, () -> "Invalid multiplier '" + multiplier + "': must be greater than or equal to 1. A multiplier of 1 is equivalent to a fixed delay.");
            this.multiplier = multiplier;
            return this;
        }

        public Builder maxDelay(Duration maxDelay) {
            RetryPolicy.assertIsPositive("maxDelay", maxDelay);
            this.maxDelay = maxDelay;
            return this;
        }

        @SafeVarargs
        public final Builder includes(Class<? extends Throwable> ... types) {
            Collections.addAll(this.includes, types);
            return this;
        }

        public Builder includes(Collection<Class<? extends Throwable>> types) {
            this.includes.addAll(types);
            return this;
        }

        @SafeVarargs
        public final Builder excludes(Class<? extends Throwable> ... types) {
            Collections.addAll(this.excludes, types);
            return this;
        }

        public Builder excludes(Collection<Class<? extends Throwable>> types) {
            this.excludes.addAll(types);
            return this;
        }

        public Builder predicate(Predicate<Throwable> predicate) {
            this.predicate = this.predicate != null ? this.predicate.and(predicate) : predicate;
            return this;
        }

        public RetryPolicy build() {
            BackOff backOff = this.backOff;
            if (backOff != null) {
                boolean misconfigured = this.maxRetries != null || this.delay != null || this.jitter != null || this.multiplier != null || this.maxDelay != null;
                Assert.state(!misconfigured, "The following configuration options are not supported with a custom BackOff strategy: maxRetries, delay, jitter, multiplier, or maxDelay.");
            } else {
                ExponentialBackOff exponentialBackOff = new ExponentialBackOff();
                exponentialBackOff.setMaxAttempts(this.maxRetries != null ? this.maxRetries : 3L);
                exponentialBackOff.setInitialInterval(this.delay != null ? this.delay.toMillis() : 1000L);
                exponentialBackOff.setMaxInterval(this.maxDelay != null ? this.maxDelay.toMillis() : Long.MAX_VALUE);
                exponentialBackOff.setMultiplier(this.multiplier != null ? this.multiplier : 1.0);
                if (this.jitter != null) {
                    exponentialBackOff.setJitter(this.jitter.toMillis());
                }
                backOff = exponentialBackOff;
            }
            return new DefaultRetryPolicy(this.includes, this.excludes, this.predicate, this.timeout, backOff);
        }
    }
}

