/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.retry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.springframework.core.retry.RetryState;

public class RetryException
extends Exception
implements RetryState {
    private static final long serialVersionUID = 1L;

    public RetryException(String message, Throwable cause) {
        super(message, Objects.requireNonNull(cause, "cause must not be null"));
    }

    RetryException(String message, RetryState retryState) {
        super(message, retryState.getLastException());
        List<Throwable> exceptions = retryState.getExceptions();
        for (int i2 = 0; i2 < exceptions.size() - 1; ++i2) {
            this.addSuppressed(exceptions.get(i2));
        }
    }

    @Override
    public final Throwable getCause() {
        return Objects.requireNonNull(super.getCause());
    }

    @Override
    public int getRetryCount() {
        return this.getSuppressed().length;
    }

    @Override
    public List<Throwable> getExceptions() {
        Throwable[] suppressed = this.getSuppressed();
        ArrayList<Throwable> exceptions = new ArrayList<Throwable>(suppressed.length + 1);
        Collections.addAll(exceptions, suppressed);
        exceptions.add(this.getCause());
        return Collections.unmodifiableList(exceptions);
    }

    @Override
    public Throwable getLastException() {
        return this.getCause();
    }
}

