/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.jspecify.annotations.Nullable;
import org.springframework.core.annotation.AnnotationConfigurationException;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.annotation.AttributeMethods;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

final class SynthesizedMergedAnnotationInvocationHandler<A extends Annotation>
implements InvocationHandler {
    private final MergedAnnotation<?> annotation;
    private final Class<A> type;
    private final AttributeMethods attributes;
    private final Map<String, Object> valueCache = new ConcurrentHashMap<String, Object>(8);
    private volatile @Nullable Integer hashCode;
    private volatile @Nullable String string;

    private SynthesizedMergedAnnotationInvocationHandler(MergedAnnotation<A> annotation, Class<A> type) {
        Assert.notNull(annotation, "MergedAnnotation must not be null");
        Assert.notNull(type, "Type must not be null");
        Assert.isTrue(type.isAnnotation(), "Type must be an annotation");
        this.annotation = annotation;
        this.type = type;
        this.attributes = AttributeMethods.forAnnotationType(type);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        if (this.attributes.indexOf(method.getName()) != -1) {
            return this.getAttributeValue(method);
        }
        if (method.getParameterCount() == 0) {
            switch (method.getName()) {
                case "annotationType": {
                    return this.type;
                }
                case "hashCode": {
                    return this.annotationHashCode();
                }
                case "toString": {
                    return this.annotationToString();
                }
            }
        }
        if (ReflectionUtils.isEqualsMethod(method)) {
            return this.annotationEquals(args[0]);
        }
        throw new AnnotationConfigurationException(String.format("Method [%s] is unsupported for synthesized annotation type [%s]", method, this.type));
    }

    private boolean annotationEquals(Object other) {
        if (this == other) {
            return true;
        }
        if (!this.type.isInstance(other)) {
            return false;
        }
        for (int i2 = 0; i2 < this.attributes.size(); ++i2) {
            Object otherValue;
            Method attribute = this.attributes.get(i2);
            Object thisValue = this.getAttributeValue(attribute);
            if (ObjectUtils.nullSafeEquals(thisValue, otherValue = AnnotationUtils.invokeAnnotationMethod(attribute, other))) continue;
            return false;
        }
        return true;
    }

    private int annotationHashCode() {
        Integer hashCode = this.hashCode;
        if (hashCode == null) {
            this.hashCode = hashCode = this.computeHashCode();
        }
        return hashCode;
    }

    private Integer computeHashCode() {
        int hashCode = 0;
        for (int i2 = 0; i2 < this.attributes.size(); ++i2) {
            Method attribute = this.attributes.get(i2);
            Object value = this.getAttributeValue(attribute);
            hashCode += 127 * attribute.getName().hashCode() ^ ObjectUtils.nullSafeHashCode(value);
        }
        return hashCode;
    }

    private String annotationToString() {
        String string = this.string;
        if (string == null) {
            StringBuilder builder = new StringBuilder("@").append(SynthesizedMergedAnnotationInvocationHandler.getName(this.type)).append('(');
            for (int i2 = 0; i2 < this.attributes.size(); ++i2) {
                Method attribute = this.attributes.get(i2);
                if (i2 > 0) {
                    builder.append(", ");
                }
                builder.append(attribute.getName());
                builder.append('=');
                builder.append(this.toString(this.getAttributeValue(attribute)));
            }
            builder.append(')');
            this.string = string = builder.toString();
        }
        return string;
    }

    private String toString(Object value) {
        Class<?> type = value.getClass();
        if (type.isArray()) {
            StringBuilder builder = new StringBuilder("{");
            int arrayLength = Array.getLength(value);
            for (int i2 = 0; i2 < arrayLength; ++i2) {
                if (i2 > 0) {
                    builder.append(", ");
                }
                builder.append(this.toString(Array.get(value, i2)));
            }
            builder.append('}');
            return builder.toString();
        }
        if (type == String.class) {
            return "\"" + (String)value + "\"";
        }
        if (type == Character.class) {
            return "'" + value.toString() + "'";
        }
        if (type == Byte.class) {
            return String.format("(byte) 0x%02X", value);
        }
        if (type == Long.class) {
            return Long.toString((Long)value) + "L";
        }
        if (type == Float.class) {
            return Float.toString(((Float)value).floatValue()) + "f";
        }
        if (type == Double.class) {
            return Double.toString((Double)value) + "d";
        }
        if (value instanceof Enum) {
            Enum e = (Enum)value;
            return e.name();
        }
        if (type == Class.class) {
            return SynthesizedMergedAnnotationInvocationHandler.getName((Class)value) + ".class";
        }
        return String.valueOf(value);
    }

    private Object getAttributeValue(Method method) {
        Object value = this.valueCache.computeIfAbsent(method.getName(), attributeName -> {
            Class<?> type = ClassUtils.resolvePrimitiveIfNecessary(method.getReturnType());
            return this.annotation.getValue((String)attributeName, type).orElseThrow(() -> new NoSuchElementException("No value found for attribute named '" + attributeName + "' in merged annotation " + SynthesizedMergedAnnotationInvocationHandler.getName(this.annotation.getType())));
        });
        if (value.getClass().isArray() && Array.getLength(value) > 0) {
            value = this.cloneArray(value);
        }
        return value;
    }

    private Object cloneArray(Object array) {
        Class<?> type = array.getClass();
        if (type == boolean[].class) {
            return ((boolean[])array).clone();
        }
        if (type == byte[].class) {
            return ((byte[])array).clone();
        }
        if (type == char[].class) {
            return ((char[])array).clone();
        }
        if (type == double[].class) {
            return ((double[])array).clone();
        }
        if (type == float[].class) {
            return ((float[])array).clone();
        }
        if (type == int[].class) {
            return ((int[])array).clone();
        }
        if (type == long[].class) {
            return ((long[])array).clone();
        }
        if (type == short[].class) {
            return ((short[])array).clone();
        }
        return ((Object[])array).clone();
    }

    static <A extends Annotation> A createProxy(MergedAnnotation<A> annotation, Class<A> type) {
        ClassLoader classLoader = type.getClassLoader();
        Class[] interfaces = new Class[]{type};
        SynthesizedMergedAnnotationInvocationHandler<A> handler = new SynthesizedMergedAnnotationInvocationHandler<A>(annotation, type);
        return (A)((Annotation)Proxy.newProxyInstance(classLoader, interfaces, handler));
    }

    private static String getName(Class<?> clazz) {
        String canonicalName = clazz.getCanonicalName();
        return canonicalName != null ? canonicalName : clazz.getName();
    }
}

