/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import org.jspecify.annotations.Nullable;
import org.springframework.context.HierarchicalMessageSource;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;
import org.springframework.context.support.DefaultMessageSourceResolvable;
import org.springframework.context.support.MessageSourceSupport;
import org.springframework.util.ObjectUtils;

public abstract class AbstractMessageSource
extends MessageSourceSupport
implements HierarchicalMessageSource {
    private @Nullable MessageSource parentMessageSource;
    private @Nullable Properties commonMessages;
    private boolean useCodeAsDefaultMessage = false;

    @Override
    public void setParentMessageSource(@Nullable MessageSource parent) {
        this.parentMessageSource = parent;
    }

    @Override
    public @Nullable MessageSource getParentMessageSource() {
        return this.parentMessageSource;
    }

    public void setCommonMessages(@Nullable Properties commonMessages) {
        this.commonMessages = commonMessages;
    }

    protected @Nullable Properties getCommonMessages() {
        return this.commonMessages;
    }

    public void setUseCodeAsDefaultMessage(boolean useCodeAsDefaultMessage) {
        this.useCodeAsDefaultMessage = useCodeAsDefaultMessage;
    }

    protected boolean isUseCodeAsDefaultMessage() {
        return this.useCodeAsDefaultMessage;
    }

    @Override
    public final @Nullable String getMessage(String code, Object @Nullable [] args, @Nullable String defaultMessage, @Nullable Locale locale) {
        String msg = this.getMessageInternal(code, args, locale);
        if (msg != null) {
            return msg;
        }
        if (defaultMessage == null) {
            return this.getDefaultMessage(code);
        }
        return this.renderDefaultMessage(defaultMessage, args, locale);
    }

    @Override
    public final String getMessage(String code, Object @Nullable [] args, @Nullable Locale locale) throws NoSuchMessageException {
        String msg = this.getMessageInternal(code, args, locale);
        if (msg != null) {
            return msg;
        }
        String fallback = this.getDefaultMessage(code);
        if (fallback != null) {
            return fallback;
        }
        if (locale == null) {
            throw new NoSuchMessageException(code);
        }
        throw new NoSuchMessageException(code, locale);
    }

    @Override
    public final String getMessage(MessageSourceResolvable resolvable, @Nullable Locale locale) throws NoSuchMessageException {
        String code;
        String defaultMessage;
        Object[] codes = resolvable.getCodes();
        if (codes != null) {
            for (Object code2 : codes) {
                String message = this.getMessageInternal((String)code2, resolvable.getArguments(), locale);
                if (message == null) continue;
                return message;
            }
        }
        if ((defaultMessage = this.getDefaultMessage(resolvable, locale)) != null) {
            return defaultMessage;
        }
        String string = code = !ObjectUtils.isEmpty(codes) ? codes[codes.length - 1] : "";
        if (locale == null) {
            throw new NoSuchMessageException(code);
        }
        throw new NoSuchMessageException(code, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected @Nullable String getMessageInternal(@Nullable String code, Object @Nullable [] args, @Nullable Locale locale) {
        String commonMessage;
        Properties commonMessages;
        if (code == null) {
            return null;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        Object[] argsToUse = args;
        if (!this.isAlwaysUseMessageFormat() && ObjectUtils.isEmpty(args)) {
            String message = this.resolveCodeWithoutArguments(code, locale);
            if (message != null) {
                return message;
            }
        } else {
            argsToUse = this.resolveArguments(args, locale);
            MessageFormat messageFormat = this.resolveCode(code, locale);
            if (messageFormat != null) {
                MessageFormat messageFormat2 = messageFormat;
                synchronized (messageFormat2) {
                    return messageFormat.format(argsToUse);
                }
            }
        }
        if ((commonMessages = this.getCommonMessages()) != null && (commonMessage = commonMessages.getProperty(code)) != null) {
            return this.formatMessage(commonMessage, args, locale);
        }
        return this.getMessageFromParent(code, argsToUse, locale);
    }

    protected @Nullable String getMessageFromParent(String code, Object @Nullable [] args, Locale locale) {
        MessageSource parent = this.getParentMessageSource();
        if (parent != null) {
            if (parent instanceof AbstractMessageSource) {
                AbstractMessageSource abstractMessageSource = (AbstractMessageSource)parent;
                return abstractMessageSource.getMessageInternal(code, args, locale);
            }
            return parent.getMessage(code, args, null, locale);
        }
        return null;
    }

    protected @Nullable String getDefaultMessage(MessageSourceResolvable resolvable, @Nullable Locale locale) {
        String defaultMessage = resolvable.getDefaultMessage();
        Object[] codes = resolvable.getCodes();
        if (defaultMessage != null) {
            DefaultMessageSourceResolvable defaultMessageSourceResolvable;
            if (resolvable instanceof DefaultMessageSourceResolvable && !(defaultMessageSourceResolvable = (DefaultMessageSourceResolvable)resolvable).shouldRenderDefaultMessage()) {
                return defaultMessage;
            }
            if (!ObjectUtils.isEmpty(codes) && defaultMessage.equals(codes[0])) {
                return defaultMessage;
            }
            return this.renderDefaultMessage(defaultMessage, resolvable.getArguments(), locale);
        }
        return !ObjectUtils.isEmpty(codes) ? this.getDefaultMessage((String)codes[0]) : null;
    }

    protected @Nullable String getDefaultMessage(String code) {
        if (this.isUseCodeAsDefaultMessage()) {
            return code;
        }
        return null;
    }

    @Override
    protected Object[] resolveArguments(Object @Nullable [] args, @Nullable Locale locale) {
        if (ObjectUtils.isEmpty(args)) {
            return super.resolveArguments(args, locale);
        }
        ArrayList<Object> resolvedArgs = new ArrayList<Object>(args.length);
        for (Object arg : args) {
            if (arg instanceof MessageSourceResolvable) {
                MessageSourceResolvable messageSourceResolvable = (MessageSourceResolvable)arg;
                resolvedArgs.add(this.getMessage(messageSourceResolvable, locale));
                continue;
            }
            resolvedArgs.add(arg);
        }
        return resolvedArgs.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected @Nullable String resolveCodeWithoutArguments(String code, Locale locale) {
        MessageFormat messageFormat = this.resolveCode(code, locale);
        if (messageFormat != null) {
            MessageFormat messageFormat2 = messageFormat;
            synchronized (messageFormat2) {
                return messageFormat.format(new Object[0]);
            }
        }
        return null;
    }

    protected abstract @Nullable MessageFormat resolveCode(String var1, Locale var2);
}

