/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.annotation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationClassUtils;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.Environment;
import org.springframework.core.env.EnvironmentCapable;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;

class ConditionEvaluator {
    private final ConditionContextImpl context;

    public ConditionEvaluator(@Nullable BeanDefinitionRegistry registry, @Nullable Environment environment2, @Nullable ResourceLoader resourceLoader) {
        this.context = new ConditionContextImpl(registry, environment2, resourceLoader);
    }

    public boolean shouldSkip(AnnotatedTypeMetadata metadata) {
        return this.shouldSkip(metadata, null);
    }

    public boolean shouldSkip(@Nullable AnnotatedTypeMetadata metadata, @Nullable ConfigurationCondition.ConfigurationPhase phase) {
        if (metadata == null || !metadata.isAnnotated(Conditional.class.getName())) {
            return false;
        }
        if (phase == null) {
            AnnotationMetadata annotationMetadata;
            if (metadata instanceof AnnotationMetadata && ConfigurationClassUtils.isConfigurationCandidate(annotationMetadata = (AnnotationMetadata)metadata)) {
                return this.shouldSkip(metadata, ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
            }
            return this.shouldSkip(metadata, ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }
        List<Condition> conditions = this.collectConditions(metadata);
        for (Condition condition : conditions) {
            ConfigurationCondition.ConfigurationPhase requiredPhase = null;
            if (condition instanceof ConfigurationCondition) {
                ConfigurationCondition configurationCondition = (ConfigurationCondition)condition;
                requiredPhase = configurationCondition.getConfigurationPhase();
            }
            if (requiredPhase != null && requiredPhase != phase || condition.matches(this.context, metadata)) continue;
            return true;
        }
        return false;
    }

    List<Condition> collectConditions(@Nullable AnnotatedTypeMetadata metadata) {
        if (metadata == null || !metadata.isAnnotated(Conditional.class.getName())) {
            return Collections.emptyList();
        }
        ArrayList<Condition> conditions = new ArrayList<Condition>();
        for (String[] conditionClasses : this.getConditionClasses(metadata)) {
            for (String conditionClass : conditionClasses) {
                Condition condition = this.getCondition(conditionClass, this.context.getClassLoader());
                conditions.add(condition);
            }
        }
        AnnotationAwareOrderComparator.sort(conditions);
        return conditions;
    }

    private List<String[]> getConditionClasses(AnnotatedTypeMetadata metadata) {
        MultiValueMap<String, @Nullable Object> attributes = metadata.getAllAnnotationAttributes(Conditional.class.getName(), true);
        List<String[]> values2 = attributes != null ? (List<String[]>)attributes.get("value") : null;
        return values2 != null ? values2 : Collections.emptyList();
    }

    private Condition getCondition(String conditionClassName, @Nullable ClassLoader classloader) {
        Class<?> conditionClass = ClassUtils.resolveClassName(conditionClassName, classloader);
        return (Condition)BeanUtils.instantiateClass(conditionClass);
    }

    private static class ConditionContextImpl
    implements ConditionContext {
        private final @Nullable BeanDefinitionRegistry registry;
        private final @Nullable ConfigurableListableBeanFactory beanFactory;
        private final Environment environment;
        private final ResourceLoader resourceLoader;
        private final @Nullable ClassLoader classLoader;

        public ConditionContextImpl(@Nullable BeanDefinitionRegistry registry, @Nullable Environment environment2, @Nullable ResourceLoader resourceLoader) {
            this.registry = registry;
            this.beanFactory = ConditionContextImpl.deduceBeanFactory(registry);
            this.environment = environment2 != null ? environment2 : ConditionContextImpl.deduceEnvironment(registry);
            this.resourceLoader = resourceLoader != null ? resourceLoader : ConditionContextImpl.deduceResourceLoader(registry);
            this.classLoader = ConditionContextImpl.deduceClassLoader(resourceLoader, this.beanFactory);
        }

        private static @Nullable ConfigurableListableBeanFactory deduceBeanFactory(@Nullable BeanDefinitionRegistry source2) {
            if (source2 instanceof ConfigurableListableBeanFactory) {
                ConfigurableListableBeanFactory configurableListableBeanFactory = (ConfigurableListableBeanFactory)((Object)source2);
                return configurableListableBeanFactory;
            }
            if (source2 instanceof ConfigurableApplicationContext) {
                ConfigurableApplicationContext configurableApplicationContext = (ConfigurableApplicationContext)((Object)source2);
                return configurableApplicationContext.getBeanFactory();
            }
            return null;
        }

        private static Environment deduceEnvironment(@Nullable BeanDefinitionRegistry source2) {
            if (source2 instanceof EnvironmentCapable) {
                EnvironmentCapable environmentCapable = (EnvironmentCapable)((Object)source2);
                return environmentCapable.getEnvironment();
            }
            return new StandardEnvironment();
        }

        private static ResourceLoader deduceResourceLoader(@Nullable BeanDefinitionRegistry source2) {
            if (source2 instanceof ResourceLoader) {
                ResourceLoader resourceLoader = (ResourceLoader)((Object)source2);
                return resourceLoader;
            }
            return new DefaultResourceLoader();
        }

        private static @Nullable ClassLoader deduceClassLoader(@Nullable ResourceLoader resourceLoader, @Nullable ConfigurableListableBeanFactory beanFactory) {
            ClassLoader classLoader;
            if (resourceLoader != null && (classLoader = resourceLoader.getClassLoader()) != null) {
                return classLoader;
            }
            if (beanFactory != null) {
                return beanFactory.getBeanClassLoader();
            }
            return ClassUtils.getDefaultClassLoader();
        }

        @Override
        public BeanDefinitionRegistry getRegistry() {
            Assert.state(this.registry != null, "No BeanDefinitionRegistry available");
            return this.registry;
        }

        @Override
        public @Nullable ConfigurableListableBeanFactory getBeanFactory() {
            return this.beanFactory;
        }

        @Override
        public Environment getEnvironment() {
            return this.environment;
        }

        @Override
        public ResourceLoader getResourceLoader() {
            return this.resourceLoader;
        }

        @Override
        public @Nullable ClassLoader getClassLoader() {
            return this.classLoader;
        }
    }
}

