/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.support;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.BeanIsNotAFactoryException;
import org.springframework.beans.factory.BeanNotOfRequiredTypeException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.SmartFactoryBean;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.core.ResolvableType;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class StaticListableBeanFactory
implements ListableBeanFactory {
    private final Map<String, Object> beans;

    public StaticListableBeanFactory() {
        this.beans = new LinkedHashMap<String, Object>();
    }

    public StaticListableBeanFactory(Map<String, Object> beans2) {
        Assert.notNull(beans2, "Beans Map must not be null");
        this.beans = beans2;
    }

    public void addBean(String name, Object bean2) {
        this.beans.put(name, bean2);
    }

    @Override
    public Object getBean(String name) throws BeansException {
        return this.getBean(name, null);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public <T> T getBean(String name, @Nullable Class<T> requiredType) throws BeansException {
        block8: {
            block7: {
                beanName = BeanFactoryUtils.transformedBeanName(name);
                bean = this.obtainBean(beanName);
                if (!BeanFactoryUtils.isFactoryDereference(name)) break block7;
                if (!(bean instanceof FactoryBean)) {
                    throw new BeanIsNotAFactoryException(beanName, bean.getClass());
                }
                break block8;
            }
            if (!(bean instanceof FactoryBean)) break block8;
            factoryBean = (FactoryBean)bean;
            try {
                if (!(factoryBean instanceof SmartFactoryBean)) ** GOTO lbl-1000
                smartFactoryBean = (SmartFactoryBean)factoryBean;
                if (requiredType != null) {
                    v0 = smartFactoryBean.getObject(requiredType);
                } else lbl-1000:
                // 2 sources

                {
                    v0 = exposedObject = factoryBean.getObject();
                }
                if (exposedObject == null) {
                    throw new BeanCreationException(beanName, "FactoryBean exposed null object");
                }
                bean = exposedObject;
            }
            catch (Exception ex) {
                throw new BeanCreationException(beanName, "FactoryBean threw exception on object creation", ex);
            }
        }
        if (requiredType != null && !requiredType.isInstance(bean)) {
            throw new BeanNotOfRequiredTypeException(name, requiredType, bean.getClass());
        }
        return (T)bean;
    }

    @Override
    public Object getBean(String name, Object ... args) throws BeansException {
        if (!ObjectUtils.isEmpty(args)) {
            throw new UnsupportedOperationException("StaticListableBeanFactory does not support explicit bean creation arguments");
        }
        return this.getBean(name);
    }

    private Object obtainBean(String beanName) {
        Object bean2 = this.beans.get(beanName);
        if (bean2 == null) {
            throw new NoSuchBeanDefinitionException(beanName, "Defined beans are [" + StringUtils.collectionToCommaDelimitedString(this.beans.keySet()) + "]");
        }
        return bean2;
    }

    @Override
    public <T> T getBean(Class<T> requiredType) throws BeansException {
        String[] beanNames = this.getBeanNamesForType(requiredType);
        if (beanNames.length == 1) {
            return this.getBean(beanNames[0], requiredType);
        }
        if (beanNames.length > 1) {
            throw new NoUniqueBeanDefinitionException(requiredType, beanNames);
        }
        throw new NoSuchBeanDefinitionException(requiredType);
    }

    @Override
    public <T> T getBean(Class<T> requiredType, Object ... args) throws BeansException {
        if (!ObjectUtils.isEmpty(args)) {
            throw new UnsupportedOperationException("StaticListableBeanFactory does not support explicit bean creation arguments");
        }
        return this.getBean(requiredType);
    }

    @Override
    public <T> ObjectProvider<T> getBeanProvider(Class<T> requiredType) throws BeansException {
        return this.getBeanProvider(ResolvableType.forRawClass(requiredType), true);
    }

    @Override
    public <T> ObjectProvider<T> getBeanProvider(ResolvableType requiredType) {
        return this.getBeanProvider(requiredType, true);
    }

    @Override
    public <T> ObjectProvider<T> getBeanProvider(ParameterizedTypeReference<T> requiredType) {
        return this.getBeanProvider(ResolvableType.forType(requiredType), true);
    }

    @Override
    public boolean containsBean(String name) {
        return this.beans.containsKey(name);
    }

    @Override
    public boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        String beanName = BeanFactoryUtils.transformedBeanName(name);
        Object bean2 = this.obtainBean(beanName);
        if (bean2 instanceof FactoryBean) {
            FactoryBean factoryBean = (FactoryBean)bean2;
            if (!BeanFactoryUtils.isFactoryDereference(name)) {
                return factoryBean.isSingleton();
            }
        }
        return true;
    }

    @Override
    public boolean isPrototype(String name) throws NoSuchBeanDefinitionException {
        FactoryBean factoryBean;
        SmartFactoryBean smartFactoryBean;
        String beanName = BeanFactoryUtils.transformedBeanName(name);
        Object bean2 = this.obtainBean(beanName);
        return !BeanFactoryUtils.isFactoryDereference(name) && (bean2 instanceof SmartFactoryBean && (smartFactoryBean = (SmartFactoryBean)bean2).isPrototype() || bean2 instanceof FactoryBean && !(factoryBean = (FactoryBean)bean2).isSingleton());
    }

    @Override
    public boolean isTypeMatch(String name, ResolvableType typeToMatch) throws NoSuchBeanDefinitionException {
        String beanName = BeanFactoryUtils.transformedBeanName(name);
        Object bean2 = this.obtainBean(beanName);
        if (bean2 instanceof FactoryBean) {
            FactoryBean factoryBean = (FactoryBean)bean2;
            if (!BeanFactoryUtils.isFactoryDereference(name)) {
                return this.isTypeMatch(factoryBean, typeToMatch.toClass());
            }
        }
        return typeToMatch.isInstance(bean2);
    }

    @Override
    public boolean isTypeMatch(String name, Class<?> typeToMatch) throws NoSuchBeanDefinitionException {
        String beanName = BeanFactoryUtils.transformedBeanName(name);
        Object bean2 = this.obtainBean(beanName);
        if (bean2 instanceof FactoryBean) {
            FactoryBean factoryBean = (FactoryBean)bean2;
            if (!BeanFactoryUtils.isFactoryDereference(name)) {
                return this.isTypeMatch(factoryBean, typeToMatch);
            }
        }
        return typeToMatch.isInstance(bean2);
    }

    private boolean isTypeMatch(FactoryBean<?> factoryBean, Class<?> typeToMatch) throws NoSuchBeanDefinitionException {
        if (factoryBean instanceof SmartFactoryBean) {
            SmartFactoryBean smartFactoryBean = (SmartFactoryBean)factoryBean;
            return smartFactoryBean.supportsType(typeToMatch);
        }
        Class<?> objectType = factoryBean.getObjectType();
        return objectType != null && typeToMatch.isAssignableFrom(objectType);
    }

    @Override
    public @Nullable Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        return this.getType(name, true);
    }

    @Override
    public @Nullable Class<?> getType(String name, boolean allowFactoryBeanInit) throws NoSuchBeanDefinitionException {
        String beanName = BeanFactoryUtils.transformedBeanName(name);
        Object bean2 = this.obtainBean(beanName);
        if (bean2 instanceof FactoryBean) {
            FactoryBean factoryBean = (FactoryBean)bean2;
            if (!BeanFactoryUtils.isFactoryDereference(name)) {
                return factoryBean.getObjectType();
            }
        }
        return bean2.getClass();
    }

    @Override
    public String[] getAliases(String name) {
        return new String[0];
    }

    @Override
    public boolean containsBeanDefinition(String name) {
        return this.beans.containsKey(name);
    }

    @Override
    public int getBeanDefinitionCount() {
        return this.beans.size();
    }

    @Override
    public String[] getBeanDefinitionNames() {
        return StringUtils.toStringArray(this.beans.keySet());
    }

    @Override
    public <T> ObjectProvider<T> getBeanProvider(Class<T> requiredType, boolean allowEagerInit) {
        return this.getBeanProvider(ResolvableType.forRawClass(requiredType), allowEagerInit);
    }

    @Override
    public <T> ObjectProvider<T> getBeanProvider(final ResolvableType requiredType, boolean allowEagerInit) {
        return new ObjectProvider<T>(this){
            final /* synthetic */ StaticListableBeanFactory this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public T getObject() throws BeansException {
                String[] beanNames = this.this$0.getBeanNamesForType(requiredType);
                if (beanNames.length == 1) {
                    return this.this$0.getBean(beanNames[0], requiredType.toClass());
                }
                if (beanNames.length > 1) {
                    throw new NoUniqueBeanDefinitionException(requiredType, beanNames);
                }
                throw new NoSuchBeanDefinitionException(requiredType);
            }

            @Override
            public T getObject(Object ... args) throws BeansException {
                String[] beanNames = this.this$0.getBeanNamesForType(requiredType);
                if (beanNames.length == 1) {
                    return this.this$0.getBean(beanNames[0], args);
                }
                if (beanNames.length > 1) {
                    throw new NoUniqueBeanDefinitionException(requiredType, beanNames);
                }
                throw new NoSuchBeanDefinitionException(requiredType);
            }

            @Override
            public @Nullable T getIfAvailable() throws BeansException {
                String[] beanNames = this.this$0.getBeanNamesForType(requiredType);
                if (beanNames.length == 1) {
                    return this.this$0.getBean(beanNames[0], requiredType.toClass());
                }
                if (beanNames.length > 1) {
                    throw new NoUniqueBeanDefinitionException(requiredType, beanNames);
                }
                return null;
            }

            @Override
            public @Nullable T getIfUnique() throws BeansException {
                String[] beanNames = this.this$0.getBeanNamesForType(requiredType);
                if (beanNames.length == 1) {
                    return this.this$0.getBean(beanNames[0], requiredType.toClass());
                }
                return null;
            }

            @Override
            public Stream<T> stream() {
                return Arrays.stream(this.this$0.getBeanNamesForType(requiredType)).map(name -> this.this$0.getBean((String)name, requiredType.toClass()));
            }
        };
    }

    @Override
    public String[] getBeanNamesForType(@Nullable ResolvableType type) {
        return this.getBeanNamesForType(type, true, true);
    }

    @Override
    public String[] getBeanNamesForType(@Nullable ResolvableType type, boolean includeNonSingletons, boolean allowEagerInit) {
        Class<?> resolved = type != null ? type.resolve() : null;
        boolean isFactoryType = resolved != null && FactoryBean.class.isAssignableFrom(resolved);
        ArrayList<String> matches = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : this.beans.entrySet()) {
            String beanName = entry.getKey();
            Object beanInstance = entry.getValue();
            if (beanInstance instanceof FactoryBean) {
                FactoryBean factoryBean = (FactoryBean)beanInstance;
                if (!isFactoryType) {
                    if (!includeNonSingletons && !factoryBean.isSingleton() || type != null && !this.isTypeMatch(factoryBean, type.toClass())) continue;
                    matches.add(beanName);
                    continue;
                }
            }
            if (type != null && !type.isInstance(beanInstance)) continue;
            matches.add(beanName);
        }
        return StringUtils.toStringArray(matches);
    }

    @Override
    public String[] getBeanNamesForType(@Nullable Class<?> type) {
        return this.getBeanNamesForType(ResolvableType.forClass(type));
    }

    @Override
    public String[] getBeanNamesForType(@Nullable Class<?> type, boolean includeNonSingletons, boolean allowEagerInit) {
        return this.getBeanNamesForType(ResolvableType.forClass(type), includeNonSingletons, allowEagerInit);
    }

    @Override
    public <T> Map<String, T> getBeansOfType(@Nullable Class<T> type) throws BeansException {
        return this.getBeansOfType(type, true, true);
    }

    @Override
    public <T> Map<String, T> getBeansOfType(@Nullable Class<T> type, boolean includeNonSingletons, boolean allowEagerInit) throws BeansException {
        boolean isFactoryType = type != null && FactoryBean.class.isAssignableFrom(type);
        LinkedHashMap<Object, Object> matches = new LinkedHashMap<Object, Object>();
        for (Map.Entry<String, Object> entry : this.beans.entrySet()) {
            Object beanName = entry.getKey();
            Object beanInstance = entry.getValue();
            if (beanInstance instanceof FactoryBean) {
                FactoryBean factoryBean = (FactoryBean)beanInstance;
                if (!isFactoryType) {
                    if (!includeNonSingletons && !factoryBean.isSingleton() || type != null && !this.isTypeMatch(factoryBean, type)) continue;
                    matches.put(beanName, this.getBean((String)beanName, type));
                    continue;
                }
            }
            if (type != null && !type.isInstance(beanInstance)) continue;
            if (isFactoryType) {
                beanName = "&" + (String)beanName;
            }
            matches.put(beanName, beanInstance);
        }
        return matches;
    }

    @Override
    public String[] getBeanNamesForAnnotation(Class<? extends Annotation> annotationType) {
        ArrayList<String> results = new ArrayList<String>();
        for (String beanName : this.beans.keySet()) {
            if (this.findAnnotationOnBean(beanName, annotationType) == null) continue;
            results.add(beanName);
        }
        return StringUtils.toStringArray(results);
    }

    @Override
    public Map<String, Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) throws BeansException {
        LinkedHashMap<String, Object> results = new LinkedHashMap<String, Object>();
        for (String beanName : this.beans.keySet()) {
            if (this.findAnnotationOnBean(beanName, annotationType) == null) continue;
            results.put(beanName, this.getBean(beanName));
        }
        return results;
    }

    @Override
    public <A extends Annotation> @Nullable A findAnnotationOnBean(String beanName, Class<A> annotationType) throws NoSuchBeanDefinitionException {
        return this.findAnnotationOnBean(beanName, annotationType, true);
    }

    @Override
    public <A extends Annotation> @Nullable A findAnnotationOnBean(String beanName, Class<A> annotationType, boolean allowFactoryBeanInit) throws NoSuchBeanDefinitionException {
        Class<?> beanType = this.getType(beanName, allowFactoryBeanInit);
        return beanType != null ? (A)AnnotatedElementUtils.findMergedAnnotation(beanType, annotationType) : null;
    }

    @Override
    public <A extends Annotation> Set<A> findAllAnnotationsOnBean(String beanName, Class<A> annotationType, boolean allowFactoryBeanInit) throws NoSuchBeanDefinitionException {
        Class<?> beanType = this.getType(beanName, allowFactoryBeanInit);
        return beanType != null ? AnnotatedElementUtils.findAllMergedAnnotations(beanType, annotationType) : Collections.emptySet();
    }
}

